/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.RestClientFormBodyPart;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.RestClientRequestBuilder;
import com.intellij.httpClient.execution.auth.HttpRequestAuthCredentials;
import com.intellij.httpClient.execution.impl.HttpRequestHandlerHelper;
import com.intellij.httpClient.http.request.HttpHeaderFieldPreprocessor;
import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutionKey;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocComment;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocConnectionTimeoutTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNoCookieJarTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNoLogResponseTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNoRedirectTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocSocketTimeoutTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocTimeoutTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocUseOsCredentialsTag;
import com.intellij.httpClient.http.request.lexer.HttpClientExtensionLexemesDefaultManager;
import com.intellij.httpClient.http.request.psi.HttpFilePath;
import com.intellij.httpClient.http.request.psi.HttpFormUrlencodedBody;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpHeaderFieldValue;
import com.intellij.httpClient.http.request.psi.HttpInputFile;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.psi.HttpMultipartField;
import com.intellij.httpClient.http.request.psi.HttpMultipartMessage;
import com.intellij.httpClient.http.request.psi.HttpOutputFile;
import com.intellij.httpClient.http.request.psi.HttpOutputFilePath;
import com.intellij.httpClient.http.request.psi.HttpQuery;
import com.intellij.httpClient.http.request.psi.HttpQueryParameter;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBody;
import com.intellij.httpClient.http.request.psi.HttpRequestContentDescriptor;
import com.intellij.httpClient.http.request.psi.HttpRequestMessage;
import com.intellij.httpClient.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.HttpVariableBase;
import com.intellij.httpClient.http.request.psi.impl.HttpRequestContentDescriptorImpl;
import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.httpClient.http.request.substitution.HttpRequestVariableSessionSubstitutorImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestPsiConverter {
    private static final String DEFAULT_TMP_INPUT_FILE_NAME = "http_request_input_file";
    private static final String INPUT_SIGN = "< ";
    private static final String REQUEST_SEPARATOR = "###";

    @NotNull
    public static String getSeparator() {
        return REQUEST_SEPARATOR;
    }

    @NotNull
    public static String toPsiHttpRequest(@NotNull RestClientRequest request) {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(0);
        }
        return HttpRequestPsiConverter.toPsiHttpRequest(request, null);
    }

    @NotNull
    public static String toPsiHttpRequest(@NotNull RestClientRequest request, @Nullable String responseFileName) {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(1);
        }
        return HttpRequestPsiConverter.toPsiHttpRequest(request, responseFileName, false);
    }

    @NotNull
    public static String toPsiHttpRequest(@NotNull RestClientRequest request, @Nullable String responseFileName, boolean addCookies) {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(2);
        }
        StringBuilder result2 = new StringBuilder();
        HttpRequestPsiConverter.appendDocComment(result2, request.config);
        if (request.isEmptyCredentials()) {
            result2.append("# ").append("@use-os-credentials").append("\n");
        }
        result2.append(StringUtil.notNullize((String)request.httpMethod));
        result2.append(" ");
        result2.append(request.getURL());
        if (request.parametersEnabled && !request.parameters.isEmpty()) {
            result2.append("?");
            result2.append(StringUtil.join(request.parameters, pair -> pair.getKey() + "=" + pair.getValue(), (String)"&"));
        }
        HashSet<String> alreadyAddedHeaders = new HashSet<String>();
        alreadyAddedHeaders.add("host");
        if (request.authData != null) {
            String scheme = request.authData.getScope().getSchemeName();
            HttpRequestAuthCredentials credentials = request.authData.getAuthCredentials();
            if (StringUtil.isNotEmpty((String)scheme) && credentials instanceof HttpRequestAuthCredentials.UsernamePassword) {
                HttpRequestAuthCredentials.UsernamePassword userCredentials = (HttpRequestAuthCredentials.UsernamePassword)credentials;
                result2.append("\n");
                result2.append("Authorization").append(": ");
                result2.append(StringUtil.capitalize((String)StringUtil.toLowerCase((String)scheme))).append(" ");
                result2.append(userCredentials.getUserName()).append(" ").append(userCredentials.getPassword());
                alreadyAddedHeaders.add("Authorization".toLowerCase(Locale.ROOT));
            }
        }
        if (!request.headers.isEmpty()) {
            result2.append("\n");
            result2.append(StringUtil.join(request.headers, pair -> pair.getKey() + ": " + pair.getValue(), (String)"\n"));
        }
        if (!request.getActualSentHeaders().isEmpty()) {
            for (RestClientRequest.KeyValuePair header2 : request.headers) {
                alreadyAddedHeaders.add(header2.getKey().toLowerCase(Locale.ROOT));
            }
            List newHeaders = ContainerUtil.filter(request.getActualSentHeaders(), header -> !alreadyAddedHeaders.contains(header.getKey().toLowerCase(Locale.ROOT)));
            if (!newHeaders.isEmpty()) {
                result2.append("\n");
                result2.append(StringUtil.join((Collection)newHeaders, pair -> pair.getKey() + ": " + pair.getValue(), (String)"\n"));
            }
        }
        if (addCookies && !request.biscuits.isEmpty()) {
            result2.append("\n");
            result2.append("Cookie: ");
            result2.append(StringUtil.join(request.biscuits, biscuit -> biscuit.getName() + "=" + biscuit.getValue(), (String)"; "));
        }
        if (request.isFileUpload && !request.formBodyPart.isEmpty()) {
            result2.append("\n\n");
            for (RestClientFormBodyPart part : request.formBodyPart) {
                result2.append("--").append(request.multipartBoundary);
                result2.append("\n").append(part.toPsiRepresentation()).append("\n");
            }
            result2.append("--").append(request.multipartBoundary).append("--");
        } else if (request.haveFileToSend && StringUtil.isNotEmpty((String)request.filesToSend)) {
            String inputFiles = Arrays.stream(request.filesToSend.split(File.pathSeparator)).map(path -> INPUT_SIGN + path).collect(Collectors.joining("\n"));
            result2.append("\n\n");
            result2.append(inputFiles);
        } else if (request.haveTextToSend && StringUtil.isNotEmpty((String)request.textToSend)) {
            result2.append("\n\n");
            result2.append(StringUtil.convertLineSeparators((String)request.textToSend));
        }
        if (StringUtil.isNotEmpty((String)responseFileName)) {
            result2.append("\n\n");
            result2.append("<> ").append(responseFileName);
        }
        result2.append("\n\n").append(REQUEST_SEPARATOR).append("\n\n");
        String string = result2.toString();
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void appendDocComment(@NotNull StringBuilder result2, @NotNull HttpRequestConfig config) {
        if (result2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(4);
        }
        if (config == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(5);
        }
        if (!config.isFollowRedirects()) {
            result2.append("# ").append("@no-redirect").append("\n");
        }
        if (!config.isLogResponse()) {
            result2.append("# ").append("@no-log").append("\n");
        }
        if (!config.isSaveCookies()) {
            result2.append("# ").append("@no-cookie-jar").append("\n");
        }
    }

    @NotNull
    @RequiresReadLock
    public static RestClientRequest toRestClientRequest(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor2) throws HttpRequestValidationException {
        if (element == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(6);
        }
        if (substitutor2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.softAssertReadAccess();
        RestClientRequest request = HttpRequestPsiConverter.convertFromHttpRequest(element, substitutor2, new RestClientRequestBuilder());
        HttpRequestExecutionHelperService service = HttpRequestExecutionHelperService.getInstance();
        if (service != null) {
            service.loadCookieToRequest(element.getProject(), request);
        }
        HttpRequestHandlerHelper.convertCookieHeadersToBiscuits(request);
        RestClientRequest restClientRequest = request;
        if (restClientRequest == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(8);
        }
        return restClientRequest;
    }

    @RequiresReadLock
    @NotNull
    public static <T, R extends RequestBuilder.RequestFormBodyPart> T convertFromHttpRequest(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor2, @NotNull RequestBuilder<T, R> requestBuilder) throws HttpRequestValidationException {
        T t;
        if (element == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(9);
        }
        if (substitutor2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(10);
        }
        if (requestBuilder == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.softAssertReadAccess();
        try {
            HttpOutputFilePath outputFilePath;
            HttpOutputFile outputFile;
            boolean useOsCredentials;
            requestBuilder.withMethod(element.getHttpMethod());
            HttpRequestPsiConverter.putUrlToBuilder(element, substitutor2, requestBuilder);
            for (HttpHeaderField field : element.getHeaderFieldList()) {
                String fieldName = field.getHeaderFieldName().getText();
                HttpHeaderFieldPreprocessor.create(fieldName).addHeader(requestBuilder, field, substitutor2);
            }
            HttpRequestPsiConverter.buildBody(element, substitutor2, requestBuilder);
            requestBuilder.withConfig(HttpRequestPsiConverter.toRequestConfig(element));
            HttpDocComment docComment = HttpRequestPsiUtils.findDocComment(element);
            boolean bl = useOsCredentials = docComment != null && ContainerUtil.exists(docComment.getTags(), tag -> tag instanceof HttpDocUseOsCredentialsTag);
            if (useOsCredentials) {
                requestBuilder.withEmptyCredentials();
            }
            if (substitutor2 instanceof HttpRequestVariableSessionSubstitutorImpl) {
                HttpRequestVariableSessionSubstitutorImpl subsImpl = (HttpRequestVariableSessionSubstitutorImpl)substitutor2;
                requestBuilder.withSslConfiguration(Objects.requireNonNull(subsImpl.getEnvironment()).getSslConfiguration());
            }
            if ((outputFile = element.getOutputFile()) != null && (outputFilePath = outputFile.getOutputFilePath()) != null) {
                requestBuilder.withUserDefinedOutputFilePath(outputFilePath.getPresentablePath(substitutor2), outputFile.isForce());
            }
            t = requestBuilder.build();
        }
        catch (HttpRequestVariableSubstitutor.InvalidVariableException e) {
            throw new HttpRequestValidationException(e.getMessage());
        }
        if (t == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(12);
        }
        return t;
    }

    @RequiresReadLock
    public static <T, R extends RequestBuilder.RequestFormBodyPart> void putUrlToBuilder(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor2, @NotNull RequestBuilder<T, R> requestBuilder) throws HttpRequestValidationException {
        HttpQuery query;
        if (element == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(13);
        }
        if (substitutor2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(14);
        }
        if (requestBuilder == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(15);
        }
        ThreadingAssertions.softAssertReadAccess();
        HttpRequestTarget target = element.getRequestTarget();
        String url = element.getHttpUrl(substitutor2);
        if (StringUtil.isEmpty((String)url)) {
            throw new HttpRequestValidationException(HttpClientExecutorBundle.message("rest.client.request.url.is.invalid", new Object[0]));
        }
        requestBuilder.withUrl(url);
        RequestBuilder.HttpProtocol protocol = HttpRequestPsiConverter.getProtocolValue(HttpRequestPsiUtils.getProtocol(element));
        if (protocol != null) {
            requestBuilder.withProtocol(protocol);
        }
        HttpQuery httpQuery = query = target != null ? target.getQuery() : null;
        if (query != null) {
            requestBuilder.withQueryParameters(queryBuilder -> {
                HttpQuery finalQuery;
                HttpVariableBase singleVariable = query.getSingleVariable();
                if (singleVariable != null) {
                    String queryString = substitutor2.getValue((PsiElement)singleVariable);
                    finalQuery = HttpRequestPsiFactory.createHttpQuery(query.getProject(), queryString);
                } else {
                    finalQuery = query;
                }
                for (HttpQueryParameter parameter : finalQuery.getQueryParameterList()) {
                    String key = parameter.getKey(substitutor2);
                    String value2 = parameter.getValue(substitutor2);
                    if (StringUtil.isNotEmpty((String)key)) {
                        queryBuilder.addQueryParameter(key, StringUtil.notNullize((String)value2));
                        continue;
                    }
                    throw new HttpRequestValidationException(HttpClientExecutorBundle.message("rest.client.request.query.is.invalid", parameter.getText()));
                }
            });
        }
    }

    public static <T, R extends RequestBuilder.RequestFormBodyPart> void buildBody(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor2, @NotNull RequestBuilder<T, R> requestBuilder) throws HttpRequestValidationException {
        HttpRequestBody body2;
        if (element == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(16);
        }
        if (substitutor2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(17);
        }
        if (requestBuilder == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(18);
        }
        if ((body2 = element.getRequestBody()) instanceof HttpRequestMessagesGroup) {
            List<HttpRequestMessage> messages = ((HttpRequestMessagesGroup)body2).getRequestMessageList();
            if (!messages.isEmpty()) {
                if (messages.size() == 1 && messages.get(0) instanceof HttpInputFile) {
                    requestBuilder.withFileToSend(HttpRequestPsiConverter.getFileToSend((HttpInputFile)messages.get(0), substitutor2));
                } else {
                    requestBuilder.withTextToSend(HttpRequestPsiConverter.getTextToSend(element.getContainingFile(), messages, substitutor2));
                }
            }
        } else if (body2 instanceof HttpMultipartMessage) {
            requestBuilder.withMultipartBody(HttpRequestPsiConverter.getMultipartBoundary(element), multipartBodyBuilder -> {
                List<HttpMultipartField> fields = ((HttpMultipartMessage)body2).getMultipartFieldList();
                for (int i = 0; i < fields.size(); ++i) {
                    HttpMultipartField field = fields.get(i);
                    Object bodyPart = HttpRequestPsiConverter.newBodyPartBuilder(field, substitutor2, i, multipartBodyBuilder);
                    for (HttpHeaderField header : field.getHeaderFieldList()) {
                        bodyPart.addHeader(header.getName(), header.getValue(substitutor2));
                    }
                    multipartBodyBuilder.addFormBodyPart(bodyPart);
                }
            });
        } else if (body2 instanceof HttpFormUrlencodedBody) {
            HttpFormUrlencodedBody formUrlencodedBody = (HttpFormUrlencodedBody)body2;
            requestBuilder.withTextToSend(HttpRequestPsiConverter.getTextToSend(formUrlencodedBody, substitutor2));
        }
    }

    @NotNull
    private static String getTextToSend(@NotNull HttpFormUrlencodedBody body2, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        if (body2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(19);
        }
        if (substitutor2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(20);
        }
        String string = body2.getFormUrlencodedParameterList().stream().map(parameter -> {
            String result2 = parameter.getKey(substitutor2) + "=";
            String value2 = parameter.getValue(substitutor2);
            if (value2 != null) {
                result2 = result2 + value2;
            }
            return result2;
        }).collect(Collectors.joining("&"));
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(21);
        }
        return string;
    }

    public static boolean shouldSaveCookie(@NotNull HttpRequest request) {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(22);
        }
        HttpDocComment docComment = HttpRequestPsiUtils.findDocComment(request);
        boolean isHttpMethod = HttpClientExtensionLexemesDefaultManager.getMethods().contains(request.getHttpMethod());
        return isHttpMethod && (docComment == null || ContainerUtil.filterIsInstance(docComment.getTags(), HttpDocNoCookieJarTag.class).isEmpty());
    }

    @NotNull
    private static HttpRequestConfig toRequestConfig(@NotNull HttpRequest request) throws HttpRequestValidationException {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(23);
        }
        HttpDocComment docComment = HttpRequestPsiUtils.findDocComment(request);
        boolean isHttpMethod = HttpClientExtensionLexemesDefaultManager.getMethods().contains(request.getHttpMethod());
        boolean followRedirects = isHttpMethod && (docComment == null || ContainerUtil.filterIsInstance(docComment.getTags(), HttpDocNoRedirectTag.class).isEmpty());
        boolean logResponse = docComment == null || ContainerUtil.filterIsInstance(docComment.getTags(), HttpDocNoLogResponseTag.class).isEmpty();
        boolean saveCookies = isHttpMethod && (docComment == null || ContainerUtil.filterIsInstance(docComment.getTags(), HttpDocNoCookieJarTag.class).isEmpty());
        Integer socketTimeout = null;
        Integer connectionTimeout = null;
        if (docComment != null) {
            HttpDocConnectionTimeoutTag connectionTimeoutTag;
            HttpDocSocketTimeoutTag responseTimeoutTag = (HttpDocSocketTimeoutTag)ContainerUtil.getFirstItem((List)ContainerUtil.filterIsInstance(docComment.getTags(), HttpDocSocketTimeoutTag.class));
            if (responseTimeoutTag != null) {
                try {
                    socketTimeout = responseTimeoutTag.getDurationInMillis();
                }
                catch (HttpDocTimeoutTag.InvalidDurationException e) {
                    throw new HttpRequestValidationException(HttpClientExecutorBundle.message("http.client.request.read.timeout.error", e.getMessage()));
                }
            }
            if ((connectionTimeoutTag = (HttpDocConnectionTimeoutTag)ContainerUtil.getFirstItem((List)ContainerUtil.filterIsInstance(docComment.getTags(), HttpDocConnectionTimeoutTag.class))) != null) {
                try {
                    connectionTimeout = connectionTimeoutTag.getDurationInMillis();
                }
                catch (HttpDocTimeoutTag.InvalidDurationException e) {
                    throw new HttpRequestValidationException(HttpClientExecutorBundle.message("http.client.request.connection.timeout.error", e.getMessage()));
                }
            }
        }
        return new HttpRequestConfig(followRedirects, logResponse, saveCookies, socketTimeout, connectionTimeout);
    }

    @Nullable
    private static String getMultipartBoundary(@NotNull HttpRequest request) {
        HttpHeaderField field;
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(24);
        }
        if ((field = request.getHeaderField("Content-Type")) != null) {
            HttpHeaderFieldValue contentType = field.getHeaderFieldValue();
            return contentType != null ? contentType.getHeaderFieldOption("boundary") : null;
        }
        return null;
    }

    @NotNull
    public static <R extends RequestBuilder.RequestFormBodyPart> R newBodyPartBuilder(@NotNull HttpMultipartField field, @NotNull HttpRequestVariableSubstitutor substitutor2, int index, @NotNull RequestBuilder.MultipartBodyBuilder<R> builderFactory) throws HttpRequestValidationException {
        String filename;
        HttpHeaderFieldValue description;
        String name;
        if (field == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(25);
        }
        if (substitutor2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(26);
        }
        if (builderFactory == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(27);
        }
        String string = name = (description = field.getMultipartFieldDescription()) != null ? description.getHeaderFieldOption("name") : String.valueOf(index);
        if (StringUtil.isEmpty((String)name)) {
            name = String.valueOf(index);
        }
        String string2 = filename = description != null ? description.getHeaderFieldOption("filename") : null;
        if (StringUtil.isNotEmpty((String)filename)) {
            File toUpload = HttpRequestPsiConverter.getFileToUpload(field, filename, substitutor2);
            RequestBuilder.RequestFormBodyPart requestFormBodyPart = (RequestBuilder.RequestFormBodyPart)builderFactory.createPartForFile(name, filename, toUpload, HttpRequestPsiConverter.getContentType(field, substitutor2));
            if (requestFormBodyPart == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(28);
            }
            return (R)requestFormBodyPart;
        }
        String text2 = HttpRequestPsiConverter.getTextToSend(field.getContainingFile(), field.getRequestMessages(), substitutor2);
        RequestBuilder.RequestFormBodyPart requestFormBodyPart = (RequestBuilder.RequestFormBodyPart)builderFactory.createPartForString(name, text2, HttpRequestPsiConverter.getContentType(field, substitutor2));
        if (requestFormBodyPart == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(29);
        }
        return (R)requestFormBodyPart;
    }

    @NotNull
    private static RequestBuilder.ContentTypeInfo getContentType(@NotNull HttpRequestContentDescriptor descriptor, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        if (descriptor == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(30);
        }
        if (substitutor2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(31);
        }
        List<HttpHeaderField> fields = descriptor.getHeaderFieldList();
        Pair<String, String> contentTypeAndMime = HttpRequestPsiConverter.parseContentTypeAndMime(descriptor, fields, substitutor2);
        HttpHeaderField charset = HttpRequestContentDescriptorImpl.getHeaderField(fields, "Accept-Charset");
        String charsetValue = charset != null ? charset.getValue(substitutor2) : null;
        return new RequestBuilder.ContentTypeInfo((String)contentTypeAndMime.first, (String)contentTypeAndMime.second, charsetValue);
    }

    @NotNull
    private static Pair<String, String> parseContentTypeAndMime(@NotNull HttpRequestContentDescriptor descriptor, @NotNull List<HttpHeaderField> fields, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        if (descriptor == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(32);
        }
        if (fields == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(33);
        }
        if (substitutor2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(34);
        }
        HttpHeaderField contentTypeField = HttpRequestContentDescriptorImpl.getHeaderField(fields, "Content-Type");
        String mimeType = descriptor.getMimeType();
        if (contentTypeField != null) {
            String value2 = contentTypeField.getValue(substitutor2);
            Pair pair = Pair.create((Object)StringUtil.toLowerCase((String)value2), (Object)(StringUtil.isNotEmpty((String)mimeType) ? mimeType : null));
            if (pair == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(35);
            }
            return pair;
        }
        Pair pair = Pair.create(null, null);
        if (pair == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(36);
        }
        return pair;
    }

    @NotNull
    private static File getFileToUpload(@NotNull HttpMultipartField field, @NotNull String fieldName, @Nullable HttpRequestVariableSubstitutor substitutor2) throws HttpRequestValidationException {
        File file;
        List<HttpRequestMessage> messages;
        if (field == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(37);
        }
        if (fieldName == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(38);
        }
        if ((messages = field.getRequestMessages()).size() == 1 && messages.get(0) instanceof HttpInputFile) {
            return HttpRequestPsiConverter.getFileToSend((HttpInputFile)messages.get(0), substitutor2);
        }
        try {
            File file2 = FileUtil.createTempFile((String)DEFAULT_TMP_INPUT_FILE_NAME, (String)".txt");
            FileUtil.writeToFile((File)file2, (String)HttpRequestPsiConverter.getTextToSend(field.getContainingFile(), messages, substitutor2));
            file = file2;
        }
        catch (IOException e) {
            throw new HttpRequestValidationException(HttpClientExecutorBundle.message("rest.client.request.cannot.create.file", fieldName));
        }
        if (file == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(39);
        }
        return file;
    }

    @NotNull
    private static String getTextToSend(@Nullable PsiFile file, @NotNull List<HttpRequestMessage> messages, @Nullable HttpRequestVariableSubstitutor substitutor2) throws HttpRequestValidationException {
        if (messages == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(40);
        }
        String lineSeparator = file == null || messages.size() < 2 ? LineSeparator.getSystemLineSeparator().getSeparatorString() : FileDocumentManager.getInstance().getLineSeparator(file.getVirtualFile(), file.getProject());
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < messages.size(); ++i) {
            HttpRequestMessage message = messages.get(i);
            if (message instanceof HttpMessageBody) {
                result2.append(HttpRequestPsiConverter.fillVariables(message.getText(), substitutor2, message.getProject(), HttpRequestVariableSubstitutionKey.insideElementKeyFactory((PsiElement)message)));
            } else if (message instanceof HttpInputFile) {
                HttpInputFile inputFile = (HttpInputFile)message;
                String url = HttpRequestPsiConverter.resolveFileUrl(inputFile);
                result2.append(HttpRequestPsiConverter.fillVariables(HttpRequestPsiConverter.loadFileContent(url), substitutor2, message.getProject(), HttpRequestVariableSubstitutionKey.insideExternalFileKeyFactory(url)));
            }
            if (i == messages.size() - 1) continue;
            result2.append(lineSeparator);
        }
        String string = result2.toString();
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public static String fillVariables(@NotNull String messageBody, @Nullable HttpRequestVariableSubstitutor substitutor2, @NotNull Project project, @Nullable HttpRequestVariableSubstitutionKey.KeyFactory keyFactory) {
        List<TextRange> variablesRanges;
        if (messageBody == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(42);
        }
        if (project == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(43);
        }
        if (substitutor2 != null && !(variablesRanges = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(messageBody)).isEmpty()) {
            StringBuilder result2 = new StringBuilder(messageBody.length());
            int lastVariableRangeEndOffset = 0;
            for (TextRange variableRange : variablesRanges) {
                result2.append(messageBody, lastVariableRangeEndOffset, variableRange.getStartOffset());
                String variableValue = substitutor2.getVariableValue(HttpRequestPsiUtils.getVariableExpressionRange(messageBody, variableRange).substring(messageBody), variableRange.substring(messageBody), project, keyFactory != null ? keyFactory.withOffset(variableRange.getStartOffset()) : null);
                result2.append(variableValue);
                lastVariableRangeEndOffset = variableRange.getEndOffset();
            }
            result2.append(messageBody, lastVariableRangeEndOffset, messageBody.length());
            String string = result2.toString();
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(44);
            }
            return string;
        }
        String string = messageBody;
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(45);
        }
        return string;
    }

    private static boolean isTextFile(@NotNull File file) {
        HttpRequestExecutionHelperService service;
        if (file == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(46);
        }
        return (service = HttpRequestExecutionHelperService.getInstance()) == null || service.isTextFile(file);
    }

    @NotNull
    private static File getFileToSend(@NotNull HttpInputFile message, HttpRequestVariableSubstitutor substitutor2) throws HttpRequestValidationException {
        String url;
        if (message == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(47);
        }
        if (!StringUtil.equals((CharSequence)VirtualFileManager.extractProtocol((String)(url = HttpRequestPsiConverter.resolveFileUrl(message))), (CharSequence)"jar")) {
            String path = VfsUtilCore.urlToPath((String)url);
            File file = new File(PathUtil.toSystemDependentName((String)path));
            if (HttpRequestPsiConverter.isTextFile(file)) {
                String fileContent = HttpRequestPsiConverter.loadFileContent(url);
                String extension = PathUtil.getFileExtension((String)file.getName());
                String fileContentWithVariables = HttpRequestPsiConverter.fillVariables(fileContent, substitutor2, message.getProject(), HttpRequestVariableSubstitutionKey.insideExternalFileKeyFactory(url));
                if (extension != null && !StringUtil.equals((CharSequence)fileContent, (CharSequence)fileContentWithVariables)) {
                    return HttpRequestPsiConverter.createTempFile(fileContentWithVariables, extension, FileUtilRt.getNameWithoutExtension((String)file.getName()));
                }
            }
            return new File(path);
        }
        return HttpRequestPsiConverter.createTempFile(HttpRequestPsiConverter.loadFileContent(url), "txt", DEFAULT_TMP_INPUT_FILE_NAME);
    }

    @NotNull
    private static File createTempFile(@NotNull String content2, @NotNull String extension, @NotNull String filename) throws HttpRequestValidationException {
        File file;
        if (content2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(48);
        }
        if (extension == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(49);
        }
        if (filename == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(50);
        }
        try {
            File tmpFile = FileUtil.createTempFile((String)filename, (String)("." + extension));
            FileUtil.writeToFile((File)tmpFile, (String)content2);
            file = tmpFile;
        }
        catch (IOException e) {
            throw new HttpRequestValidationException(HttpClientExecutorBundle.message("rest.client.request.cannot.create.file.post", new Object[0]));
        }
        if (file == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(51);
        }
        return file;
    }

    @NotNull
    private static String resolveFileUrl(@NotNull HttpInputFile message) throws HttpRequestValidationException {
        PsiFile file;
        HttpFilePath filePath;
        if (message == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(52);
        }
        if ((filePath = message.getFilePath()) == null) {
            throw new HttpRequestValidationException(HttpClientExecutorBundle.message("rest.client.request.file.path.is.empty", new Object[0]));
        }
        HttpRequestExecutionHelperService executionHelperService = HttpRequestExecutionHelperService.getInstance();
        PsiFile psiFile = file = executionHelperService != null ? executionHelperService.resolveFilePath(filePath) : null;
        if (file != null) {
            String string = file.getVirtualFile().getUrl();
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(53);
            }
            return string;
        }
        String path = filePath.getPresentablePath();
        if (OSAgnosticPathUtil.isAbsolute((String)path)) {
            String string = VfsUtilCore.pathToUrl((String)path);
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(54);
            }
            return string;
        }
        Document document = PsiDocumentManager.getInstance((Project)message.getProject()).getDocument(filePath.getContainingFile().getOriginalFile());
        VirtualFile vFile = message.getContainingFile().getOriginalFile().getVirtualFile();
        if (document != null && vFile != null) {
            int line = document.getLineNumber(filePath.getTextOffset());
            String errorPath = vFile.getPresentableUrl() + ":" + (line + 1);
            throw new HttpRequestValidationException(HttpClientExecutorBundle.message("rest.client.request.file.path.is.invalid", path, errorPath));
        }
        throw new HttpRequestValidationException(HttpClientExecutorBundle.message("rest.client.request.file.path.is.invalid.fallback", path));
    }

    @NotNull
    private static String loadFileContent(@NotNull String url) throws HttpRequestValidationException {
        block6: {
            String string;
            if (url == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(55);
            }
            try {
                VirtualFile file;
                String protocol = VirtualFileManager.extractProtocol((String)url);
                if (StringUtil.equals((CharSequence)protocol, (CharSequence)"file") || (file = VirtualFileManager.getInstance().findFileByUrl(url)) == null) break block6;
                string = VfsUtilCore.loadText((VirtualFile)file);
            }
            catch (IOException e) {
                throw new HttpRequestValidationException(e.getMessage());
            }
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(56);
            }
            return string;
        }
        String string = FileUtil.loadFile((File)new File(PathUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url))));
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(57);
        }
        return string;
    }

    @Nullable
    public static RequestBuilder.HttpProtocol getProtocolValue(@Nullable PsiElement protocolElement) {
        if (protocolElement == null) {
            return null;
        }
        return switch (protocolElement.getText()) {
            case "HTTP/1.1" -> RequestBuilder.HttpProtocol.HTTP_11;
            case "HTTP/2" -> RequestBuilder.HttpProtocol.HTTP_2;
            case "HTTP/2 (Prior Knowledge)" -> RequestBuilder.HttpProtocol.HTTP_2_PRIOR_KNOWLEDGE;
            default -> null;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 12, 21, 28, 29, 35, 36, 39, 41, 44, 45, 51, 53, 54, 56, 57 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 21: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/HttpRequestPsiConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 26: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestBuilder";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 25: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderFactory";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBody";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/HttpRequestPsiConverter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiHttpRequest";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toRestClientRequest";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromHttpRequest";
                break;
            }
            case 21: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextToSend";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "newBodyPartBuilder";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContentTypeAndMime";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToUpload";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "fillVariables";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFileUrl";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toPsiHttpRequest";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 21: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendDocComment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toRestClientRequest";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertFromHttpRequest";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putUrlToBuilder";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildBody";
                break;
            }
            case 19: 
            case 20: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getTextToSend";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldSaveCookie";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toRequestConfig";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getMultipartBoundary";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "newBodyPartBuilder";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getContentType";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "parseContentTypeAndMime";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFileToUpload";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "fillVariables";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isTextFile";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getFileToSend";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileUrl";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "loadFileContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 12, 21, 28, 29, 35, 36, 39, 41, 44, 45, 51, 53, 54, 56, 57 -> new IllegalStateException(string);
        };
    }
}

