/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeAccessor;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.Objects;

public abstract class BlockNode<T extends Node>
extends Node {
    public static final int NO_ARGUMENT = 0;
    @Node.Children
    private final T[] elements;

    protected BlockNode(T[] elements) {
        this.elements = elements;
        assert (this.getClass().getName().equals("com.oracle.truffle.api.impl.DefaultBlockNode") || this.getClass().getName().equals("org.graalvm.compiler.truffle.runtime.OptimizedBlockNode")) : "Custom block implementations are not allowed.";
    }

    public abstract void executeVoid(VirtualFrame var1, int var2);

    public abstract Object executeGeneric(VirtualFrame var1, int var2);

    public abstract byte executeByte(VirtualFrame var1, int var2) throws UnexpectedResultException;

    public abstract short executeShort(VirtualFrame var1, int var2) throws UnexpectedResultException;

    public abstract int executeInt(VirtualFrame var1, int var2) throws UnexpectedResultException;

    public abstract char executeChar(VirtualFrame var1, int var2) throws UnexpectedResultException;

    public abstract float executeFloat(VirtualFrame var1, int var2) throws UnexpectedResultException;

    public abstract double executeDouble(VirtualFrame var1, int var2) throws UnexpectedResultException;

    public abstract long executeLong(VirtualFrame var1, int var2) throws UnexpectedResultException;

    public abstract boolean executeBoolean(VirtualFrame var1, int var2) throws UnexpectedResultException;

    public final T[] getElements() {
        return this.elements;
    }

    @Override
    public final NodeCost getCost() {
        return NodeCost.NONE;
    }

    public static <T extends Node> BlockNode<T> create(T[] elements, ElementExecutor<T> executor) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(executor);
        if (elements.length == 0) {
            throw new IllegalArgumentException("Empty blocks are not allowed.");
        }
        return NodeAccessor.RUNTIME.createBlockNode((Node[])elements, executor);
    }

    public static interface ElementExecutor<T extends Node> {
        public void executeVoid(VirtualFrame var1, T var2, int var3, int var4);

        default public Object executeGeneric(VirtualFrame frame, T node, int index, int argument) {
            this.executeVoid(frame, node, index, argument);
            return null;
        }

        default public boolean executeBoolean(VirtualFrame frame, T node, int index, int argument) throws UnexpectedResultException {
            Object result2 = this.executeGeneric(frame, node, index, argument);
            if (result2 instanceof Boolean) {
                return (Boolean)result2;
            }
            throw new UnexpectedResultException(result2);
        }

        default public byte executeByte(VirtualFrame frame, T node, int index, int argument) throws UnexpectedResultException {
            Object result2 = this.executeGeneric(frame, node, index, argument);
            if (result2 instanceof Byte) {
                return (Byte)result2;
            }
            throw new UnexpectedResultException(result2);
        }

        default public short executeShort(VirtualFrame frame, T node, int index, int argument) throws UnexpectedResultException {
            Object result2 = this.executeGeneric(frame, node, index, argument);
            if (result2 instanceof Short) {
                return (Short)result2;
            }
            throw new UnexpectedResultException(result2);
        }

        default public char executeChar(VirtualFrame frame, T node, int index, int argument) throws UnexpectedResultException {
            Object result2 = this.executeGeneric(frame, node, index, argument);
            if (result2 instanceof Character) {
                return ((Character)result2).charValue();
            }
            throw new UnexpectedResultException(result2);
        }

        default public int executeInt(VirtualFrame frame, T node, int index, int argument) throws UnexpectedResultException {
            Object result2 = this.executeGeneric(frame, node, index, argument);
            if (result2 instanceof Integer) {
                return (Integer)result2;
            }
            throw new UnexpectedResultException(result2);
        }

        default public long executeLong(VirtualFrame frame, T node, int index, int argument) throws UnexpectedResultException {
            Object result2 = this.executeGeneric(frame, node, index, argument);
            if (result2 instanceof Long) {
                return (Long)result2;
            }
            throw new UnexpectedResultException(result2);
        }

        default public float executeFloat(VirtualFrame frame, T node, int index, int argument) throws UnexpectedResultException {
            Object result2 = this.executeGeneric(frame, node, index, argument);
            if (result2 instanceof Float) {
                return ((Float)result2).floatValue();
            }
            throw new UnexpectedResultException(result2);
        }

        default public double executeDouble(VirtualFrame frame, T node, int index, int argument) throws UnexpectedResultException {
            Object result2 = this.executeGeneric(frame, node, index, argument);
            if (result2 instanceof Double) {
                return (Double)result2;
            }
            throw new UnexpectedResultException(result2);
        }
    }
}

