/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.EditDistance;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.fus.JsonSchemaFusCountedFeature;
import com.jetbrains.jsonSchema.fus.JsonSchemaHighlightingSessionStatisticsCollector;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kotlin.collections.CollectionsKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectValidation
implements JsonSchemaValidation {
    public static final ObjectValidation INSTANCE = new ObjectValidation();
    private static final int MIN_LENGTH_TO_FIX_TYPOS = 3;

    @Override
    public boolean validate(@NotNull JsonValueAdapter propValue, @NotNull JsonSchemaObject schema, @Nullable JsonSchemaType schemaType, @NotNull JsonValidationHost consumer, @NotNull JsonComplianceCheckerOptions options) {
        if (propValue == null) {
            ObjectValidation.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            ObjectValidation.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            ObjectValidation.$$$reportNull$$$0(2);
        }
        if (options == null) {
            ObjectValidation.$$$reportNull$$$0(3);
        }
        JsonSchemaHighlightingSessionStatisticsCollector.getInstance().reportSchemaUsageFeature(JsonSchemaFusCountedFeature.ObjectValidation);
        return ObjectValidation.checkObject(propValue, schema, consumer, options);
    }

    private static boolean checkObject(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        JsonObjectValueAdapter object;
        if (value == null) {
            ObjectValidation.$$$reportNull$$$0(4);
        }
        if (schema == null) {
            ObjectValidation.$$$reportNull$$$0(5);
        }
        if ((object = value.getAsObject()) == null) {
            return true;
        }
        boolean isValid = true;
        List<JsonPropertyAdapter> propertyList = object.getPropertyList();
        HashSet<String> set = new HashSet<String>();
        for (JsonPropertyAdapter property : propertyList) {
            JsonPointerPosition step;
            Pair<ThreeState, JsonSchemaObject> pair;
            JsonValidationHost checker;
            String name = StringUtil.notNullize((String)property.getName());
            JsonSchemaObject jsonSchemaObject = schema.getPropertyNamesSchema();
            JsonValueAdapter nameValueAdapter = property.getNameValueAdapter();
            if (jsonSchemaObject != null && nameValueAdapter != null && (checker = consumer.checkByMatchResult(nameValueAdapter, consumer.resolve(jsonSchemaObject, nameValueAdapter), options)) != null) {
                consumer.addErrorsFrom(checker);
                isValid = false;
                if (options.shouldStopValidationAfterAnyErrorFound()) {
                    return false;
                }
            }
            if (ThreeState.NO.equals((pair = JsonSchemaVariantsTreeBuilder.doSingleStep(step = JsonPointerPosition.createSingleProperty(name), schema)).getFirst()) && !set.contains(name)) {
                Iterator<String> propertyNamesIterator = schema.getPropertyNames();
                List<@NlsSafe String> typoCandidates = CollectionsKt.filter(ObjectValidation.iteratorToList(propertyNamesIterator), s -> EditDistance.optimalAlignment((CharSequence)s, (CharSequence)name, (boolean)false, (int)1) <= 1);
                consumer.error(JsonBundle.message((String)(name.length() < 3 || typoCandidates.isEmpty() ? "json.schema.annotation.not.allowed.property" : "json.schema.annotation.not.allowed.property.possibly.typo"), (Object[])new Object[]{name}), nameValueAdapter != null ? nameValueAdapter.getDelegate() : property.getDelegate(), JsonValidationError.FixableIssueKind.ProhibitedProperty, new JsonValidationError.ProhibitedPropertyIssueData(name, name.length() >= 3 ? typoCandidates : Collections.emptyList()), JsonErrorPriority.LOW_PRIORITY);
                isValid = false;
                if (options.shouldStopValidationAfterAnyErrorFound()) {
                    return false;
                }
            } else if (ThreeState.UNSURE.equals(pair.getFirst()) && ((JsonSchemaObject)pair.second).getConstantSchema() == null) {
                for (JsonValueAdapter propertyValue : property.getValues()) {
                    consumer.checkObjectBySchemaRecordErrors((JsonSchemaObject)pair.getSecond(), propertyValue);
                    if ((isValid &= consumer.getErrors().isEmpty()) || !options.shouldStopValidationAfterAnyErrorFound()) continue;
                    return false;
                }
            }
            set.add(name);
        }
        ObjectValidation.reportMissingOptionalProperties(value, schema, consumer, options);
        if (object.shouldCheckIntegralRequirements() || options.isForceStrict()) {
            Map<String, List<String>> dependencies;
            Set<String> required = schema.getRequired();
            if (required != null) {
                LinkedHashSet<String> requiredNames = new LinkedHashSet<String>(required);
                requiredNames.removeAll(set);
                if (!requiredNames.isEmpty()) {
                    JsonValidationError.MissingMultiplePropsIssueData data = ObjectValidation.createMissingPropertiesData(schema, requiredNames, consumer, value);
                    consumer.error(JsonBundle.message((String)"schema.validation.missing.required.property.or.properties", (Object[])new Object[]{data.getMessage(false)}), value.getDelegate(), JsonValidationError.FixableIssueKind.MissingProperty, data, JsonErrorPriority.MISSING_PROPS);
                    isValid = false;
                    if (options.shouldStopValidationAfterAnyErrorFound()) {
                        return false;
                    }
                }
            }
            if (schema.getMinProperties() != null && propertyList.size() < schema.getMinProperties()) {
                consumer.error(JsonBundle.message((String)"schema.validation.number.of.props.less.than", (Object[])new Object[]{schema.getMinProperties()}), value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
                isValid = false;
                if (options.shouldStopValidationAfterAnyErrorFound()) {
                    return false;
                }
            }
            if (schema.getMaxProperties() != null && propertyList.size() > schema.getMaxProperties()) {
                consumer.error(JsonBundle.message((String)"schema.validation.number.of.props.greater.than", (Object[])new Object[]{schema.getMaxProperties()}), value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
                isValid = false;
                if (options.shouldStopValidationAfterAnyErrorFound()) {
                    return false;
                }
            }
            if ((dependencies = schema.getPropertyDependencies()) != null) {
                for (Map.Entry entry : dependencies.entrySet()) {
                    if (!set.contains(entry.getKey())) continue;
                    List list = (List)entry.getValue();
                    HashSet<String> deps = new HashSet<String>(list);
                    deps.removeAll(set);
                    if (deps.isEmpty()) continue;
                    JsonValidationError.MissingMultiplePropsIssueData data = ObjectValidation.createMissingPropertiesData(schema, deps, consumer, value);
                    consumer.error(JsonBundle.message((String)"schema.validation.violated.dependency", (Object[])new Object[]{data.getMessage(false), entry.getKey()}), value.getDelegate(), JsonValidationError.FixableIssueKind.MissingProperty, data, JsonErrorPriority.MISSING_PROPS);
                    isValid = false;
                    if (!options.shouldStopValidationAfterAnyErrorFound()) continue;
                    return false;
                }
            }
            for (String string : StreamEx.of(schema.getSchemaDependencyNames())) {
                JsonSchemaObject dependency = schema.getSchemaDependencyByName(string);
                if (!set.contains(string) || dependency == null) continue;
                consumer.checkObjectBySchemaRecordErrors(dependency, value);
                if ((isValid &= consumer.getErrors().isEmpty()) || !options.shouldStopValidationAfterAnyErrorFound()) continue;
                return false;
            }
        }
        return ObjectValidation.checkUnevaluatedPropertiesSchemaViolation(consumer, schema, object, options);
    }

    private static @NotNull ArrayList<@NlsSafe String> iteratorToList(final Iterator<String> propertyNamesIterator) {
        ArrayList<String> arrayList = Collections.list(new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return propertyNamesIterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)propertyNamesIterator.next();
            }
        });
        if (arrayList == null) {
            ObjectValidation.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static boolean checkUnevaluatedPropertiesSchemaViolation(@NotNull JsonValidationHost consumer, @NotNull JsonSchemaObject schemaNode, @NotNull JsonObjectValueAdapter inspectedObject, @NotNull JsonComplianceCheckerOptions options) {
        JsonSchemaObject unevaluatedPropertiesSchema;
        if (consumer == null) {
            ObjectValidation.$$$reportNull$$$0(7);
        }
        if (schemaNode == null) {
            ObjectValidation.$$$reportNull$$$0(8);
        }
        if (inspectedObject == null) {
            ObjectValidation.$$$reportNull$$$0(9);
        }
        if (options == null) {
            ObjectValidation.$$$reportNull$$$0(10);
        }
        if ((unevaluatedPropertiesSchema = schemaNode.getUnevaluatedPropertiesSchema()) == null) {
            return true;
        }
        Boolean constantSchemaValue = unevaluatedPropertiesSchema.getConstantSchema();
        if (Boolean.TRUE.equals(constantSchemaValue)) {
            return true;
        }
        boolean isValid = true;
        for (JsonPropertyAdapter childPropertyAdapter : inspectedObject.getPropertyList()) {
            JsonValueAdapter childPropertyNameAdapter;
            if (ObjectValidation.isCoveredByAdjacentSchemas(consumer, childPropertyAdapter, schemaNode) || (childPropertyNameAdapter = childPropertyAdapter.getNameValueAdapter()) == null) continue;
            consumer.checkObjectBySchemaRecordErrors(unevaluatedPropertiesSchema, childPropertyNameAdapter);
            if ((isValid &= consumer.getErrors().isEmpty()) || !options.shouldStopValidationAfterAnyErrorFound()) continue;
            return false;
        }
        return isValid;
    }

    private static boolean isCoveredByAdjacentSchemas(@NotNull JsonValidationHost validationHost, @NotNull JsonPropertyAdapter propertyAdapter, @NotNull JsonSchemaObject schemaNode) {
        String instancePropertyName;
        if (validationHost == null) {
            ObjectValidation.$$$reportNull$$$0(11);
        }
        if (propertyAdapter == null) {
            ObjectValidation.$$$reportNull$$$0(12);
        }
        if (schemaNode == null) {
            ObjectValidation.$$$reportNull$$$0(13);
        }
        if ((instancePropertyName = propertyAdapter.getName()) != null && schemaNode.getPropertyByName(instancePropertyName) != null) {
            return true;
        }
        if (instancePropertyName != null && schemaNode.getMatchingPatternPropertySchema(instancePropertyName) != null) {
            return true;
        }
        if (Boolean.FALSE.equals(schemaNode.getAdditionalPropertiesAllowed())) {
            return true;
        }
        JsonSchemaObject additionalPropertiesSchema = schemaNode.getAdditionalPropertiesSchema();
        if (additionalPropertiesSchema != null && Boolean.TRUE.equals(additionalPropertiesSchema.getConstantSchema())) {
            return true;
        }
        JsonValueAdapter propertyNameAdapter = propertyAdapter.getNameValueAdapter();
        return propertyNameAdapter != null && validationHost.hasRecordedErrorsFor(propertyNameAdapter);
    }

    public static JsonValidationError.MissingMultiplePropsIssueData createMissingPropertiesData(@NotNull JsonSchemaObject schema, Set<String> requiredNames, JsonValidationHost consumer, @NotNull JsonValueAdapter inspectedElementAdapter) {
        if (schema == null) {
            ObjectValidation.$$$reportNull$$$0(14);
        }
        if (inspectedElementAdapter == null) {
            ObjectValidation.$$$reportNull$$$0(15);
        }
        ArrayList<JsonValidationError.MissingPropertyIssueData> allProps = new ArrayList<JsonValidationError.MissingPropertyIssueData>();
        for (String req : requiredNames) {
            Object defaultValue;
            JsonSchemaObject propertySchema = ObjectValidation.resolvePropertySchema(schema, req);
            Object object = defaultValue = propertySchema == null ? null : propertySchema.getDefault();
            if (defaultValue == null) {
                Map<String, Object> example;
                defaultValue = Registry.is((String)"json.schema.object.v2") ? schema.getExampleByName(req) : ((example = schema.getExample()) == null ? null : example.get(req));
            }
            Ref enumCount = Ref.create((Object)0);
            JsonSchemaType type = null;
            if (propertySchema != null) {
                MatchResult result = null;
                Object valueFromEnum = ObjectValidation.getDefaultValueFromEnum(propertySchema, (Ref<Integer>)enumCount);
                if (valueFromEnum != null) {
                    defaultValue = valueFromEnum;
                } else {
                    result = consumer.resolve(propertySchema, inspectedElementAdapter);
                    if (result.mySchemas.size() == 1 && (valueFromEnum = ObjectValidation.getDefaultValueFromEnum(result.mySchemas.get(0), (Ref<Integer>)enumCount)) != null) {
                        defaultValue = valueFromEnum;
                    }
                }
                type = propertySchema.getType();
                if (type == null) {
                    if (result == null) {
                        result = consumer.resolve(propertySchema, inspectedElementAdapter);
                    }
                    if (result.mySchemas.size() == 1) {
                        type = result.mySchemas.get(0).getType();
                    }
                }
            }
            allProps.add(new JsonValidationError.MissingPropertyIssueData(req, type, defaultValue, (Integer)enumCount.get()));
        }
        return new JsonValidationError.MissingMultiplePropsIssueData(allProps);
    }

    private static JsonSchemaObject resolvePropertySchema(@NotNull JsonSchemaObject schema, String req) {
        JsonSchemaObject propOrNull;
        if (schema == null) {
            ObjectValidation.$$$reportNull$$$0(16);
        }
        if ((propOrNull = schema.getPropertyByName(req)) != null) {
            return propOrNull;
        }
        JsonSchemaObject propertySchema = schema.getMatchingPatternPropertySchema(req);
        if (propertySchema != null) {
            return propertySchema;
        }
        JsonSchemaObject additionalPropertiesSchema = schema.getAdditionalPropertiesSchema();
        if (additionalPropertiesSchema != null) {
            return additionalPropertiesSchema;
        }
        JsonSchemaObject unevaluatedPropertiesSchema = schema.getUnevaluatedPropertiesSchema();
        if (unevaluatedPropertiesSchema != null && unevaluatedPropertiesSchema.getConstantSchema() == null) {
            return unevaluatedPropertiesSchema;
        }
        return null;
    }

    @Nullable
    private static Object getDefaultValueFromEnum(@NotNull JsonSchemaObject propertySchema, @NotNull Ref<Integer> enumCount) {
        List<Object> enumValues;
        if (propertySchema == null) {
            ObjectValidation.$$$reportNull$$$0(17);
        }
        if (enumCount == null) {
            ObjectValidation.$$$reportNull$$$0(18);
        }
        if ((enumValues = propertySchema.getEnum()) != null) {
            enumCount.set((Object)enumValues.size());
            if (!enumValues.isEmpty()) {
                Object defaultObject = enumValues.get(0);
                return defaultObject instanceof String ? StringUtil.unquoteString((String)((String)defaultObject)) : defaultObject;
            }
        }
        return null;
    }

    private static void reportMissingOptionalProperties(JsonValueAdapter inspectedValue, JsonSchemaObject schema, JsonValidationHost validationHost, JsonComplianceCheckerOptions options) {
        JsonObjectValueAdapter objectValueAdapter = inspectedValue.getAsObject();
        if (!options.isReportMissingOptionalProperties() || objectValueAdapter == null) {
            return;
        }
        List existingProperties = ContainerUtil.map(objectValueAdapter.getPropertyList(), JsonPropertyAdapter::getName);
        Iterable iter = () -> schema.getPropertyNames();
        Set<String> missingProperties = StreamSupport.stream(iter.spliterator(), false).filter(it -> !existingProperties.contains(it)).collect(Collectors.toSet());
        JsonValidationError.MissingMultiplePropsIssueData missingPropertiesData = ObjectValidation.createMissingPropertiesData(schema, missingProperties, validationHost, objectValueAdapter);
        validationHost.error(JsonBundle.message((String)"schema.validation.missing.not.required.property.or.properties", (Object[])new Object[]{missingPropertiesData.getMessage(false)}), inspectedValue.getDelegate(), JsonValidationError.FixableIssueKind.MissingOptionalProperty, missingPropertiesData, JsonErrorPriority.MISSING_PROPS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propValue";
                break;
            }
            case 1: 
            case 5: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/validations/ObjectValidation";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectedObject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validationHost";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyAdapter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectedElementAdapter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySchema";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumCount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/validations/ObjectValidation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "iteratorToList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkObject";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkUnevaluatedPropertiesSchemaViolation";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCoveredByAdjacentSchemas";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createMissingPropertiesData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertySchema";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValueFromEnum";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

