/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.annotation.RestrictTo;
import androidx.collection.FloatFloatPair;
import androidx.compose.ui.graphics.PathSegment;
import androidx.compose.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b&\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\t\u001a\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0082\b\u001a?\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010\u001b\u001a'\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010\u001e\u001a'\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\u0010\u001e\u001aH\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0000\u001a \u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0018H\u0002\u001a0\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u0018H\u0000\u001a \u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003H\u0007\u001a0\u00103\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003H\u0002\u001a \u00109\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003H\u0002\u001a(\u0010:\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003H\u0002\u001a\u0018\u0010;\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0003H\u0002\u001a\u0018\u0010<\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0003H\u0007\u001a\u0018\u0010=\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u0018H\u0002\u001a(\u0010?\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010@\u001a\u00020A2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a(\u0010B\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0007\u001a\u0019\u0010C\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0082\b\u001a \u0010D\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0002\u001a\u0018\u0010E\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010F\u001a\u00020\u0003H\u0007\u001a+\u0010G\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0082\b\u001a2\u0010H\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002\u001a \u0010I\u001a\u00020A2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0002\u001a \u0010J\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0000\u001a(\u0010K\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010L\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0002\u001a0\u0010M\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010L\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0018H\u0002\u001a\u0018\u0010N\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0018H\u0002\u001a0\u0010P\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u0010Q\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u0018H\u0000\u001a0\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u00182\u0006\u0010U\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u00182\u0006\u0010V\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u0003H\u0002\u001a \u0010W\u001a\u00020S2\u0006\u0010T\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u0003H\u0002\u001a\u0018\u0010X\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0002\u001a \u0010Y\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0015\u0010Z\u001a\u00020A*\u00020\u00012\u0006\u0010[\u001a\u00020\u0001H\u0080\b\u001a\u0015\u0010Z\u001a\u00020A*\u00020\u00032\u0006\u0010[\u001a\u00020\u0003H\u0080\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\u00020\u0003*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0003*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0019\u0010\u000b\u001a\u00020\u0003*\u00020\u00068\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\"\u0019\u0010\r\u001a\u00020\u0003*\u00020\u00068\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\\"}, d2={"Epsilon", "", "FloatEpsilon", "", "Tau", "endX", "Landroidx/compose/ui/graphics/PathSegment;", "getEndX", "(Landroidx/compose/ui/graphics/PathSegment;)F", "endY", "getEndY", "startX", "getStartX", "startY", "getStartY", "clampValidRootInUnitRange", "r", "computeCubicVerticalBounds", "Landroidx/collection/FloatFloatPair;", "p0y", "p1y", "p2y", "p3y", "roots", "", "index", "", "(FFFF[FI)J", "computeHorizontalBounds", "segment", "(Landroidx/compose/ui/graphics/PathSegment;[FI)J", "computeVerticalBounds", "cubicArea", "x0", "y0", "x1", "y1", "x2", "y2", "x3", "y3", "cubicToMonotonicCubics", "cubic", "dst", "tmpRoot", "cubicWinding", "points", "x", "y", "tmpCubics", "tmpRoots", "evaluateCubic", "p1", "p2", "t", "p0", "p3", "evaluateLine", "evaluateQuadratic", "evaluateX", "evaluateY", "findCubicExtremaY", "dstRoots", "findDerivativeRoots", "horizontal", "", "findFirstCubicRoot", "findFirstLineRoot", "findFirstQuadraticRoot", "findFirstRoot", "fraction", "findLineRoot", "findQuadraticRoots", "isQuadraticMonotonic", "lineWinding", "monotonicCubicWinding", "offset", "monotonicQuadraticWinding", "quadraticToMonotonicQuadratics", "quadratic", "quadraticWinding", "tmpQuadratics", "splitCubicAt", "", "src", "srcOffset", "dstOffset", "splitQuadraticAt", "unitDivide", "writeValidRootInUnitRange", "closeTo", "b", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nBezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,1120:1\n230#1:1121\n571#1,7:1122\n571#1,7:1129\n571#1,7:1136\n571#1,7:1143\n571#1,7:1150\n560#1:1157\n560#1:1158\n560#1:1159\n571#1,7:1160\n571#1,7:1167\n571#1,7:1174\n571#1,7:1197\n571#1,7:1204\n571#1,7:1211\n571#1,7:1218\n571#1,7:1225\n571#1,7:1232\n359#1:1239\n359#1:1240\n1094#1:1241\n1094#1:1242\n1108#1:1243\n1108#1:1244\n359#1:1245\n571#1,7:1246\n563#1:1253\n563#1:1256\n97#2,16:1181\n49#2:1254\n60#2:1255\n71#2,16:1257\n*S KotlinDebug\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n*L\n201#1:1121\n201#1:1122,7\n230#1:1129,7\n254#1:1136,7\n257#1:1143,7\n259#1:1150,7\n293#1:1157\n295#1:1158\n297#1:1159\n300#1:1160,7\n305#1:1167,7\n308#1:1174,7\n329#1:1197,7\n332#1:1204,7\n335#1:1211,7\n339#1:1218,7\n342#1:1225,7\n349#1:1232,7\n442#1:1239\n461#1:1240\n484#1:1241\n485#1:1242\n511#1:1243\n512#1:1244\n544#1:1245\n586#1:1246,7\n726#1:1253\n910#1:1256\n325#1:1181,16\n889#1:1254\n892#1:1255\n950#1:1257,16\n*E\n"})
public final class BezierKt {
    private static final double Tau = Math.PI * 2;
    private static final double Epsilon = 1.0E-7;
    private static final float FloatEpsilon = 8.34465E-7f;

    private static final float evaluateX(PathSegment segment, float t) {
        float f;
        float[] points = segment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[segment.getType().ordinal()]) {
            case 1: {
                f = points[0];
                break;
            }
            case 2: {
                f = BezierKt.evaluateLine(points[0], points[2], t);
                break;
            }
            case 3: {
                f = BezierKt.evaluateQuadratic(points[0], points[2], points[4], t);
                break;
            }
            case 4: {
                f = Float.NaN;
                break;
            }
            case 5: {
                f = BezierKt.evaluateCubic(points[0], points[2], points[4], points[6], t);
                break;
            }
            case 6: {
                f = Float.NaN;
                break;
            }
            case 7: {
                f = Float.NaN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final float evaluateY(@NotNull PathSegment segment, float t) {
        float f;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        float[] points = segment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[segment.getType().ordinal()]) {
            case 1: {
                f = points[1];
                break;
            }
            case 2: {
                f = BezierKt.evaluateLine(points[1], points[3], t);
                break;
            }
            case 3: {
                f = BezierKt.evaluateQuadratic(points[1], points[3], points[5], t);
                break;
            }
            case 4: {
                f = Float.NaN;
                break;
            }
            case 5: {
                f = BezierKt.evaluateCubic(points[1], points[3], points[5], points[7], t);
                break;
            }
            case 6: {
                f = Float.NaN;
                break;
            }
            case 7: {
                f = Float.NaN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    private static final float evaluateLine(float p0y, float p1y, float t) {
        return (p1y - p0y) * t + p0y;
    }

    private static final float evaluateQuadratic(float p0, float p1, float p2, float t) {
        float by = 2.0f * (p1 - p0);
        float ay = p2 - 2.0f * p1 + p0;
        return (ay * t + by) * t + p0;
    }

    private static final float evaluateCubic(float p0, float p1, float p2, float p3, float t) {
        float a = p3 + 3.0f * (p1 - p2) - p0;
        float b = 3.0f * (p2 - 2.0f * p1 + p0);
        float c = 3.0f * (p1 - p0);
        return ((a * t + b) * t + c) * t + p0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final float evaluateCubic(float p1, float p2, float t) {
        float a = 0.33333334f + (p1 - p2);
        float b = p2 - 2.0f * p1;
        float c = p1;
        return 3.0f * ((a * t + b) * t + c) * t;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final float findFirstRoot(@NotNull PathSegment segment, float fraction) {
        float f;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        float[] points = segment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[segment.getType().ordinal()]) {
            case 1: {
                f = Float.NaN;
                break;
            }
            case 2: {
                void p1$iv;
                void p0$iv;
                float f2 = points[0] - fraction;
                float f3 = points[2] - fraction;
                boolean $i$f$findFirstLineRoot = false;
                void r$iv$iv = -p0$iv / (p1$iv - p0$iv);
                boolean $i$f$clampValidRootInUnitRange = false;
                if (r$iv$iv < 0.0f) {
                    if (r$iv$iv >= -8.34465E-7f) {
                        f = 0.0f;
                        break;
                    }
                    f = Float.NaN;
                    break;
                }
                if (r$iv$iv > 1.0f) {
                    if (r$iv$iv <= 1.0000008f) {
                        f = 1.0f;
                        break;
                    }
                    f = Float.NaN;
                    break;
                }
                f = r$iv$iv;
                break;
            }
            case 3: {
                f = BezierKt.findFirstQuadraticRoot(points[0] - fraction, points[2] - fraction, points[4] - fraction);
                break;
            }
            case 4: {
                f = Float.NaN;
                break;
            }
            case 5: {
                f = BezierKt.findFirstCubicRoot(points[0] - fraction, points[2] - fraction, points[4] - fraction, points[6] - fraction);
                break;
            }
            case 6: {
                f = Float.NaN;
                break;
            }
            case 7: {
                f = Float.NaN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    private static final float findFirstLineRoot(float p0, float p1) {
        boolean $i$f$findFirstLineRoot = false;
        float r$iv = -p0 / (p1 - p0);
        boolean $i$f$clampValidRootInUnitRange = false;
        return r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
    }

    private static final float findFirstQuadraticRoot(float p0, float p1, float p2) {
        double a = p0;
        double b = p1;
        double c = p2;
        double d = a - 2.0 * b + c;
        if (!(d == 0.0)) {
            double v1 = -Math.sqrt(b * b - a * c);
            double v2 = -a + b;
            float r$iv = (float)(-(v1 + v2) / d);
            boolean $i$f$clampValidRootInUnitRange = false;
            float root = r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = (float)((v1 - v2) / d);
            $i$f$clampValidRootInUnitRange = false;
            return r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
        }
        if (!(b == c)) {
            float r$iv = (float)((2.0 * b - c) / (2.0 * b - 2.0 * c));
            boolean $i$f$clampValidRootInUnitRange = false;
            return r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
        }
        return Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final float findFirstCubicRoot(float p0, float p1, float p2, float p3) {
        double $this$closeTo$iv;
        double d;
        double a = 3.0 * ((double)p0 - 2.0 * (double)p1 + (double)p2);
        double b = 3.0 * (double)(p1 - p0);
        double c = p0;
        double d2 = d = (double)(-p0) + 3.0 * (double)(p1 - p2) + (double)p3;
        double b$iv = 0.0;
        boolean $i$f$closeTo = false;
        if (Math.abs((double)($this$closeTo$iv - b$iv)) < 1.0E-7) {
            $this$closeTo$iv = a;
            b$iv = 0.0;
            $i$f$closeTo = false;
            if (Math.abs($this$closeTo$iv - b$iv) < 1.0E-7) {
                $this$closeTo$iv = b;
                b$iv = 0.0;
                $i$f$closeTo = false;
                if (Math.abs($this$closeTo$iv - b$iv) < 1.0E-7) {
                    return Float.NaN;
                }
                float r$iv = (float)(-c / b);
                boolean $i$f$clampValidRootInUnitRange = false;
                return r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
            }
            double q = Math.sqrt(b * b - 4.0 * a * c);
            double a2 = 2.0 * a;
            float r$iv = (float)((q - b) / a2);
            boolean $i$f$clampValidRootInUnitRange = false;
            float root = r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = (float)((-b - q) / a2);
            $i$f$clampValidRootInUnitRange = false;
            return r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
        }
        double o3 = (3.0 * (b /= d) - (a /= d) * a) / 9.0;
        double q2 = (2.0 * a * a * a - 9.0 * a * b + 27.0 * (c /= d)) / 54.0;
        double discriminant = q2 * q2 + o3 * o3 * o3;
        double a3 = a / 3.0;
        if (discriminant < 0.0) {
            void $this$fastCoerceAtMost$iv$iv;
            void minimumValue$iv;
            void $this$fastCoerceIn$iv;
            double t;
            double mp33 = -(o3 * o3 * o3);
            double r = Math.sqrt(mp33);
            double d3 = t = -q2 / r;
            double d4 = -1.0;
            double maximumValue$iv = 1.0;
            boolean $i$f$fastCoerceIn = false;
            void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
            boolean $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
            boolean $i$f$fastCoerceAtMost = false;
            double cosPhi = $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
            double phi = Math.acos(cosPhi);
            float t1 = 2.0f * MathHelpersKt.fastCbrt((float)r);
            float r$iv = (float)((double)t1 * Math.cos(phi / 3.0) - a3);
            boolean $i$f$clampValidRootInUnitRange = false;
            float root = r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = (float)((double)t1 * Math.cos((phi + Math.PI * 2) / 3.0) - a3);
            $i$f$clampValidRootInUnitRange = false;
            root = r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = (float)((double)t1 * Math.cos((phi + Math.PI * 4) / 3.0) - a3);
            $i$f$clampValidRootInUnitRange = false;
            return r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
        }
        if (discriminant == 0.0) {
            float u1 = -MathHelpersKt.fastCbrt((float)q2);
            float r$iv = 2.0f * u1 - (float)a3;
            boolean $i$f$clampValidRootInUnitRange = false;
            float root = r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = -u1 - (float)a3;
            $i$f$clampValidRootInUnitRange = false;
            return r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
        }
        double sd = Math.sqrt(discriminant);
        float u1 = MathHelpersKt.fastCbrt((float)(-q2 + sd));
        float v1 = MathHelpersKt.fastCbrt((float)(q2 + sd));
        float r$iv = (float)((double)(u1 - v1) - a3);
        boolean $i$f$clampValidRootInUnitRange = false;
        return r$iv < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : r$iv);
    }

    private static final int findLineRoot(float p0, float p1, float[] roots, int index2) {
        boolean $i$f$findLineRoot = false;
        return BezierKt.writeValidRootInUnitRange(-p0 / (p1 - p0), roots, index2);
    }

    static /* synthetic */ int findLineRoot$default(float p0, float p1, float[] roots, int index2, int n, Object object) {
        if ((n & 8) != 0) {
            index2 = 0;
        }
        boolean $i$f$findLineRoot = false;
        return BezierKt.writeValidRootInUnitRange(-p0 / (p1 - p0), roots, index2);
    }

    private static final int findQuadraticRoots(float p0, float p1, float p2, float[] roots, int index2) {
        double a = p0;
        double b = p1;
        double c = p2;
        double d = a - 2.0 * b + c;
        int rootCount = 0;
        if (!(d == 0.0)) {
            double v1 = -Math.sqrt(b * b - a * c);
            double v2 = -a + b;
            rootCount += BezierKt.writeValidRootInUnitRange((float)(-(v1 + v2) / d), roots, index2);
            if ((rootCount += BezierKt.writeValidRootInUnitRange((float)((v1 - v2) / d), roots, index2 + rootCount)) > 1) {
                float s = roots[index2];
                float t = roots[index2 + 1];
                if (s > t) {
                    roots[index2] = t;
                    roots[index2 + 1] = s;
                } else if (s == t) {
                    --rootCount;
                }
            }
        } else if (!(b == c)) {
            rootCount += BezierKt.writeValidRootInUnitRange((float)((2.0 * b - c) / (2.0 * b - 2.0 * c)), roots, index2);
        }
        return rootCount;
    }

    static /* synthetic */ int findQuadraticRoots$default(float f, float f2, float f3, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return BezierKt.findQuadraticRoots(f, f2, f3, fArray, n);
    }

    private static final int findDerivativeRoots(PathSegment segment, boolean horizontal, float[] roots, int index2) {
        int n;
        int offset2 = horizontal ? 0 : 1;
        float[] points = segment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[segment.getType().ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 0;
                break;
            }
            case 3: {
                float d0 = (float)2 * (points[offset2 + 2] - points[offset2 + 0]);
                float d1 = (float)2 * (points[offset2 + 4] - points[offset2 + 2]);
                boolean $i$f$findLineRoot = false;
                n = BezierKt.writeValidRootInUnitRange(-d0 / (d1 - d0), roots, index2);
                break;
            }
            case 4: {
                n = 0;
                break;
            }
            case 5: {
                float d0 = 3.0f * (points[offset2 + 2] - points[offset2 + 0]);
                float d1 = 3.0f * (points[offset2 + 4] - points[offset2 + 2]);
                float d2 = 3.0f * (points[offset2 + 6] - points[offset2 + 4]);
                int count = BezierKt.findQuadraticRoots(d0, d1, d2, roots, index2);
                float dd0 = 2.0f * (d1 - d0);
                float dd1 = 2.0f * (d2 - d1);
                int index$iv = index2 + count;
                boolean $i$f$findLineRoot = false;
                n = count + BezierKt.writeValidRootInUnitRange(-dd0 / (dd1 - dd0), roots, index$iv);
                break;
            }
            case 6: {
                n = 0;
                break;
            }
            case 7: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final long computeHorizontalBounds(@NotNull PathSegment segment, @NotNull float[] roots, int index2) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        int count = BezierKt.findDerivativeRoots(segment, true, roots, index2);
        PathSegment $this$startX$iv22 = segment;
        boolean $i$f$getStartX22 = false;
        float $this$startX$iv22 = $this$startX$iv22.getPoints()[0];
        float $i$f$getStartX22 = BezierKt.getEndX(segment);
        float minX = Math.min($this$startX$iv22, $i$f$getStartX22);
        PathSegment $this$startX$iv32 = segment;
        boolean $i$f$getStartX32 = false;
        float $this$startX$iv32 = $this$startX$iv32.getPoints()[0];
        float $i$f$getStartX32 = BezierKt.getEndX(segment);
        float maxX = Math.max($this$startX$iv32, $i$f$getStartX32);
        for (int i = 0; i < count; ++i) {
            float t = roots[i];
            float x = BezierKt.evaluateX(segment, t);
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
        }
        return FloatFloatPair.constructor-impl(minX, maxX);
    }

    public static /* synthetic */ long computeHorizontalBounds$default(PathSegment pathSegment, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return BezierKt.computeHorizontalBounds(pathSegment, fArray, n);
    }

    public static final long computeVerticalBounds(@NotNull PathSegment segment, @NotNull float[] roots, int index2) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        int count = BezierKt.findDerivativeRoots(segment, false, roots, index2);
        PathSegment $this$startY$iv22 = segment;
        boolean $i$f$getStartY22 = false;
        float $this$startY$iv22 = $this$startY$iv22.getPoints()[1];
        float $i$f$getStartY22 = BezierKt.getEndY(segment);
        float minY = Math.min($this$startY$iv22, $i$f$getStartY22);
        PathSegment $this$startY$iv32 = segment;
        boolean $i$f$getStartY32 = false;
        float $this$startY$iv32 = $this$startY$iv32.getPoints()[1];
        float $i$f$getStartY32 = BezierKt.getEndY(segment);
        float maxY = Math.max($this$startY$iv32, $i$f$getStartY32);
        for (int i = 0; i < count; ++i) {
            float t = roots[i];
            float x = BezierKt.evaluateY(segment, t);
            minY = Math.min(minY, x);
            maxY = Math.max(maxY, x);
        }
        return FloatFloatPair.constructor-impl(minY, maxY);
    }

    public static /* synthetic */ long computeVerticalBounds$default(PathSegment pathSegment, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return BezierKt.computeVerticalBounds(pathSegment, fArray, n);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final long computeCubicVerticalBounds(float p0y, float p1y, float p2y, float p3y, @NotNull float[] roots, int index2) {
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        float d0 = 3.0f * (p1y - p0y);
        float d1 = 3.0f * (p2y - p1y);
        float d2 = 3.0f * (p3y - p2y);
        int count = BezierKt.findQuadraticRoots(d0, d1, d2, roots, index2);
        float dd0 = 2.0f * (d1 - d0);
        float dd1 = 2.0f * (d2 - d1);
        int index$iv = index2 + count;
        boolean $i$f$findLineRoot = false;
        float minY = Math.min(p0y, p3y);
        float maxY = Math.max(p0y, p3y);
        int n = count += BezierKt.writeValidRootInUnitRange(-dd0 / (dd1 - dd0), roots, index$iv);
        for (int i = 0; i < n; ++i) {
            float t = roots[i];
            float y = BezierKt.evaluateCubic(p0y, p1y, p2y, p3y, t);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        return FloatFloatPair.constructor-impl(minY, maxY);
    }

    public static /* synthetic */ long computeCubicVerticalBounds$default(float f, float f2, float f3, float f4, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        return BezierKt.computeCubicVerticalBounds(f, f2, f3, f4, fArray, n);
    }

    public static final boolean closeTo(double $this$closeTo, double b) {
        boolean $i$f$closeTo = false;
        return Math.abs($this$closeTo - b) < 1.0E-7;
    }

    public static final boolean closeTo(float $this$closeTo, float b) {
        boolean $i$f$closeTo = false;
        return Math.abs($this$closeTo - b) < 8.34465E-7f;
    }

    private static final float clampValidRootInUnitRange(float r) {
        boolean $i$f$clampValidRootInUnitRange = false;
        return r < 0.0f ? (r >= -8.34465E-7f ? 0.0f : Float.NaN) : (r > 1.0f ? (r <= 1.0000008f ? 1.0f : Float.NaN) : r);
    }

    private static final int writeValidRootInUnitRange(float r, float[] roots, int index2) {
        float v;
        boolean $i$f$clampValidRootInUnitRange = false;
        roots[index2] = v = r < 0.0f ? (r >= -8.34465E-7f ? 0.0f : Float.NaN) : (r > 1.0f ? (r <= 1.0000008f ? 1.0f : Float.NaN) : r);
        return Float.isNaN(v) ? 0 : 1;
    }

    public static final int lineWinding(@NotNull float[] points, float x, float y) {
        float y0;
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        float x0 = points[0];
        float yo = y0 = points[1];
        float x1 = points[2];
        float y1 = points[3];
        float dy = y1 - y0;
        int direction = 1;
        if (y0 > y1) {
            y0 = y1;
            y1 = yo;
            direction = -1;
        }
        if (y < y0 || y >= y1) {
            return 0;
        }
        float crossProduct = (x1 - x0) * (y - yo) - dy * (x - x0);
        if (crossProduct == 0.0f) {
            direction = 0;
        } else if ((int)Math.signum(crossProduct) == direction) {
            direction = 0;
        }
        return direction;
    }

    private static final boolean isQuadraticMonotonic(float y0, float y1, float y2) {
        return !(Math.signum(y0 - y1) + Math.signum(y1 - y2) == 0.0f);
    }

    public static final int quadraticWinding(@NotNull float[] points, float x, float y, @NotNull float[] tmpQuadratics, @NotNull float[] tmpRoots) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)tmpQuadratics, (String)"tmpQuadratics");
        Intrinsics.checkNotNullParameter((Object)tmpRoots, (String)"tmpRoots");
        float y0 = points[1];
        float y1 = points[3];
        float y2 = points[5];
        if (BezierKt.isQuadraticMonotonic(y0, y1, y2)) {
            return BezierKt.monotonicQuadraticWinding(points, 0, x, y, tmpRoots);
        }
        int rootCount = BezierKt.quadraticToMonotonicQuadratics(points, tmpQuadratics);
        int winding = BezierKt.monotonicQuadraticWinding(tmpQuadratics, 0, x, y, tmpRoots);
        if (rootCount > 0) {
            winding += BezierKt.monotonicQuadraticWinding(tmpQuadratics, 4, x, y, tmpRoots);
        }
        return winding;
    }

    private static final int monotonicQuadraticWinding(float[] points, int offset2, float x, float y, float[] tmpRoots) {
        float xt;
        float y0 = points[offset2 + 1];
        float y2 = points[offset2 + 5];
        int direction = 1;
        if (y0 > y2) {
            float swap = y2;
            y2 = y0;
            y0 = swap;
            direction = -1;
        }
        if (y < y0 || y >= y2) {
            return 0;
        }
        y0 = points[offset2 + 1];
        float y1 = points[offset2 + 3];
        y2 = points[offset2 + 5];
        int rootCount = BezierKt.findQuadraticRoots$default(y0 - 2.0f * y1 + y2, 2.0f * (y1 - y0), y0 - y, tmpRoots, 0, 16, null);
        float $this$closeTo$iv = xt = rootCount == 0 ? points[(1 - direction) * 2] : BezierKt.evaluateQuadratic(points[0], points[2], points[4], tmpRoots[0]);
        boolean $i$f$closeTo = false;
        if (!(!(Math.abs($this$closeTo$iv - x) < 8.34465E-7f) || x == points[4] && y == y2)) {
            return 0;
        }
        return xt < x ? direction : 0;
    }

    private static final int quadraticToMonotonicQuadratics(float[] quadratic, float[] dst) {
        float y0 = quadratic[1];
        float y1 = quadratic[3];
        float y2 = quadratic[5];
        if (!BezierKt.isQuadraticMonotonic(y0, y1, y2)) {
            float t = BezierKt.unitDivide(y0 - y1, y0 - y1 - y1 + y2);
            if (!Float.isNaN(t)) {
                BezierKt.splitQuadraticAt(quadratic, dst, t);
                return 1;
            }
            y1 = Math.abs(y0 - y1) < Math.abs(y1 - y2) ? y0 : y2;
        }
        ArraysKt.copyInto((float[])quadratic, (float[])dst, (int)0, (int)0, (int)6);
        dst[3] = y1;
        return 0;
    }

    private static final void splitQuadraticAt(float[] src, float[] dst, float t) {
        float p0x = src[0];
        float p0y = src[1];
        float p1x = src[2];
        float p1y = src[3];
        float p2x = src[4];
        float p2y = src[5];
        float abx = MathHelpersKt.lerp(p0x, p1x, t);
        float aby = MathHelpersKt.lerp(p0y, p1y, t);
        dst[0] = p0x;
        dst[1] = p0y;
        dst[2] = abx;
        dst[3] = aby;
        float bcx = MathHelpersKt.lerp(p1x, p2x, t);
        float bcy = MathHelpersKt.lerp(p1y, p2y, t);
        float abcx = MathHelpersKt.lerp(abx, bcx, t);
        float abcy = MathHelpersKt.lerp(aby, bcy, t);
        dst[4] = abcx;
        dst[5] = abcy;
        dst[6] = bcx;
        dst[7] = bcy;
        dst[8] = p2x;
        dst[9] = p2y;
    }

    private static final float unitDivide(float x, float y) {
        float n = x;
        float d = y;
        if (n < 0.0f) {
            n = -n;
            d = -d;
        }
        if (d == 0.0f || n == 0.0f || n >= d) {
            return Float.NaN;
        }
        float r = n / d;
        if (r == 0.0f) {
            return Float.NaN;
        }
        return r;
    }

    public static final int cubicWinding(@NotNull float[] points, float x, float y, @NotNull float[] tmpCubics, @NotNull float[] tmpRoots) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)tmpCubics, (String)"tmpCubics");
        Intrinsics.checkNotNullParameter((Object)tmpRoots, (String)"tmpRoots");
        int splits = BezierKt.cubicToMonotonicCubics(points, tmpCubics, tmpRoots);
        int winding = 0;
        int i = 0;
        if (i <= splits) {
            while (true) {
                winding += BezierKt.monotonicCubicWinding(tmpCubics, i * 3 * 2, x, y);
                if (i == splits) break;
                ++i;
            }
        }
        return winding;
    }

    private static final int monotonicCubicWinding(float[] points, int offset2, float x, float y) {
        float xt;
        float y0 = points[offset2 + 1];
        float y3 = points[offset2 + 7];
        int direction = 1;
        if (y0 > y3) {
            float swap = y3;
            y3 = y0;
            y0 = swap;
            direction = -1;
        }
        if (y < y0 || y >= y3) {
            return 0;
        }
        float x0 = points[offset2 + 0];
        float x1 = points[offset2 + 2];
        float x2 = points[offset2 + 4];
        float x3 = points[offset2 + 6];
        boolean $i$f$fastMinOf = false;
        float min = Math.min(x0, Math.min(x1, Math.min(x2, x3)));
        if (x < min) {
            return 0;
        }
        boolean $i$f$fastMaxOf = false;
        float max = Math.max(x0, Math.max(x1, Math.max(x2, x3)));
        if (x > max) {
            return direction;
        }
        y0 = points[offset2 + 1];
        float y1 = points[offset2 + 3];
        float y2 = points[offset2 + 5];
        y3 = points[offset2 + 7];
        float root = BezierKt.findFirstCubicRoot(y0 - y, y1 - y, y2 - y, y3 - y);
        if (Float.isNaN(root)) {
            return 0;
        }
        float $this$closeTo$iv = xt = BezierKt.evaluateCubic(x0, x1, x2, x3, root);
        boolean $i$f$closeTo = false;
        if (!(!(Math.abs($this$closeTo$iv - x) < 8.34465E-7f) || x == x3 && y == y3)) {
            return 0;
        }
        return xt < x ? direction : 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final int cubicToMonotonicCubics(float[] cubic, float[] dst, float[] tmpRoot) {
        int rootCount = BezierKt.findCubicExtremaY(cubic, tmpRoot);
        if (rootCount == 0) {
            ArraysKt.copyInto((float[])cubic, (float[])dst, (int)0, (int)0, (int)8);
        } else {
            float lastT = 0.0f;
            int dstOffset = 0;
            float[] src = cubic;
            for (int i = 0; i < rootCount; ++i) {
                void $this$fastCoerceAtMost$iv$iv;
                void minimumValue$iv;
                void $this$fastCoerceIn$iv;
                float t = tmpRoot[i];
                float f = (t - lastT) / (1.0f - lastT);
                float f2 = 0.0f;
                float maximumValue$iv = 1.0f;
                boolean $i$f$fastCoerceIn = false;
                void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
                boolean $i$f$fastCoerceAtLeast = false;
                $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
                boolean $i$f$fastCoerceAtMost = false;
                lastT = t = $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
                BezierKt.splitCubicAt(src, dstOffset, dst, dstOffset, t);
                src = dst;
                dstOffset += 6;
            }
        }
        return rootCount;
    }

    private static final int findCubicExtremaY(float[] cubic, float[] dstRoots) {
        float a = cubic[1];
        float b = cubic[3];
        float c = cubic[5];
        float d = cubic[7];
        float A = d - a + 3.0f * (b - c);
        float B = 2.0f * (a - b - b - c);
        float C = b - a;
        return BezierKt.findQuadraticRoots(A, B, C, dstRoots, 0);
    }

    private static final void splitCubicAt(float[] src, int srcOffset, float[] dst, int dstOffset, float t) {
        if (t >= 1.0f) {
            ArraysKt.copyInto((float[])src, (float[])dst, (int)dstOffset, (int)srcOffset, (int)8);
            float x = src[srcOffset + 6];
            float y = src[srcOffset + 7];
            dst[dstOffset + 8] = x;
            dst[dstOffset + 9] = y;
            dst[dstOffset + 10] = x;
            dst[dstOffset + 11] = y;
            dst[dstOffset + 12] = x;
            dst[dstOffset + 13] = y;
            return;
        }
        float p0x = src[srcOffset + 0];
        float p0y = src[srcOffset + 1];
        dst[dstOffset + 0] = p0x;
        dst[dstOffset + 1] = p0y;
        float p1x = src[srcOffset + 2];
        float p1y = src[srcOffset + 3];
        float abx = MathHelpersKt.lerp(p0x, p1x, t);
        float aby = MathHelpersKt.lerp(p0y, p1y, t);
        dst[dstOffset + 2] = abx;
        dst[dstOffset + 3] = aby;
        float p2x = src[srcOffset + 4];
        float p2y = src[srcOffset + 5];
        float bcx = MathHelpersKt.lerp(p1x, p2x, t);
        float bcy = MathHelpersKt.lerp(p1y, p2y, t);
        float abcx = MathHelpersKt.lerp(abx, bcx, t);
        float abcy = MathHelpersKt.lerp(aby, bcy, t);
        dst[dstOffset + 4] = abcx;
        dst[dstOffset + 5] = abcy;
        float p3x = src[srcOffset + 6];
        float p3y = src[srcOffset + 7];
        float cdx = MathHelpersKt.lerp(p2x, p3x, t);
        float cdy = MathHelpersKt.lerp(p2y, p3y, t);
        float bcdx = MathHelpersKt.lerp(bcx, cdx, t);
        float bcdy = MathHelpersKt.lerp(bcy, cdy, t);
        float abcdx = MathHelpersKt.lerp(abcx, bcdx, t);
        float abcdy = MathHelpersKt.lerp(abcy, bcdy, t);
        dst[dstOffset + 6] = abcdx;
        dst[dstOffset + 7] = abcdy;
        dst[dstOffset + 8] = bcdx;
        dst[dstOffset + 9] = bcdy;
        dst[dstOffset + 10] = cdx;
        dst[dstOffset + 11] = cdy;
        dst[dstOffset + 12] = p3x;
        dst[dstOffset + 13] = p3y;
    }

    public static final float cubicArea(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        return ((y3 - y0) * (x1 + x2) - (x3 - x0) * (y1 + y2) + y1 * (x0 - x2) - x1 * (y0 - y2) + y3 * (x2 + x0 / 3.0f) - x3 * (y2 + y0 / 3.0f)) * 3.0f / 20.0f;
    }

    private static final float getStartX(PathSegment $this$startX) {
        boolean $i$f$getStartX = false;
        return $this$startX.getPoints()[0];
    }

    private static final float getEndX(PathSegment $this$endX) {
        int n;
        float[] fArray = $this$endX.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[$this$endX.getType().ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 0;
                break;
            }
            case 7: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fArray[n];
    }

    private static final float getStartY(PathSegment $this$startY) {
        boolean $i$f$getStartY = false;
        return $this$startY.getPoints()[1];
    }

    private static final float getEndY(PathSegment $this$endY) {
        int n;
        float[] fArray = $this$endY.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[$this$endY.getType().ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 7;
                break;
            }
            case 6: {
                n = 0;
                break;
            }
            case 7: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fArray[n];
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathSegment.Type.values().length];
            try {
                nArray[PathSegment.Type.Move.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Line.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Quadratic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Conic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Cubic.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Close.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Done.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

