/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.services.uiContext;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.ide.model.uicontext.UiContextModel;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.services.uiContext.UiContextListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015J$\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014J\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00112\u0006\u0010!\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/jetbrains/rdclient/services/uiContext/DefaultUiContextListener;", "Lcom/jetbrains/rdclient/services/uiContext/UiContextListener;", "project", "Lcom/intellij/openapi/project/Project;", "uiContext", "Lcom/jetbrains/ide/model/uicontext/UiContextModel;", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/ide/model/uicontext/UiContextModel;Lcom/intellij/openapi/fileEditor/FileDocumentManager;Lcom/intellij/openapi/diagnostic/Logger;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "selectionChanged", "", "e", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "caretPositionChanged", "Lcom/intellij/openapi/editor/event/CaretEvent;", "increaseProperty", "property", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "", "lazyMessage", "Lkotlin/Function0;", "", "focusGained", "editor", "Lcom/intellij/openapi/editor/Editor;", "focusLost", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "beforeDocumentChange", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "dispose", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nUiContextListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiContextListener.kt\ncom/jetbrains/rdclient/services/uiContext/DefaultUiContextListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n68#2,4:72\n*S KotlinDebug\n*F\n+ 1 UiContextListener.kt\ncom/jetbrains/rdclient/services/uiContext/DefaultUiContextListener\n*L\n50#1:72,4\n*E\n"})
public class DefaultUiContextListener
implements UiContextListener {
    @NotNull
    private final Project project;
    @NotNull
    private final UiContextModel uiContext;
    @NotNull
    private final FileDocumentManager fileDocumentManager;
    @NotNull
    private final Logger logger;

    public DefaultUiContextListener(@NotNull Project project, @NotNull UiContextModel uiContext, @NotNull FileDocumentManager fileDocumentManager, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        Intrinsics.checkNotNullParameter((Object)fileDocumentManager, (String)"fileDocumentManager");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.project = project;
        this.uiContext = uiContext;
        this.fileDocumentManager = fileDocumentManager;
        this.logger = logger;
        MessageBusConnection connection = this.project.getMessageBus().connect();
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        connection.subscribe(topic, (Object)this);
        Topic topic2 = FileEditorManagerListener.Before.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"FILE_EDITOR_MANAGER");
        connection.subscribe(topic2, (Object)this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void selectionChanged(@NotNull SelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getSelection(), (Function0<String>)((Function0)DefaultUiContextListener::selectionChanged$lambda$0));
    }

    public final void caretPositionChanged(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)e.getNewPosition(), (Object)e.getOldPosition())) {
            return;
        }
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getCaret(), (Function0<String>)((Function0)() -> DefaultUiContextListener.caretPositionChanged$lambda$1(e)));
    }

    protected void increaseProperty(@NotNull IOptProperty<Integer> property, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        property.set((Object)(((Number)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)property))).intValue() + 1));
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            $this$trace$iv.trace((String)lazyMessage.invoke());
        }
    }

    public final void focusGained(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getFocus(), (Function0<String>)((Function0)DefaultUiContextListener::focusGained$lambda$2));
    }

    public final void focusLost(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getFocus(), (Function0<String>)((Function0)DefaultUiContextListener::focusLost$lambda$3));
    }

    public final void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getTextControl(), (Function0<String>)((Function0)DefaultUiContextListener::selectionChanged$lambda$4));
    }

    public final void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.fileDocumentManager.getFile(event.getDocument()) instanceof LightVirtualFile) {
            return;
        }
        this.increaseProperty((IOptProperty<Integer>)this.uiContext.getDocument(), (Function0<String>)((Function0)DefaultUiContextListener::beforeDocumentChange$lambda$5));
    }

    public final void dispose() {
    }

    private static final String selectionChanged$lambda$0() {
        return "selection's changed.";
    }

    private static final String caretPositionChanged$lambda$1(CaretEvent $e) {
        Editor editor = $e.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        TextControlId textControlId = DocumentExKt.getTextControlId(editor);
        return "caret position's changed into editor with id:" + (textControlId != null ? UtilKt.toDebugString((TextControlId)textControlId) : null) + ".";
    }

    private static final String focusGained$lambda$2() {
        return "Focus's gained.";
    }

    private static final String focusLost$lambda$3() {
        return "Focus's lost.";
    }

    private static final String selectionChanged$lambda$4() {
        return "TextControls selection's changed.";
    }

    private static final String beforeDocumentChange$lambda$5() {
        return "Documents content's changed.";
    }
}

