/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class DatabaseObjectsPreparer {
    @NotNull
    public abstract Result prepare(@NotNull Collection<DbElement> var1);

    @NotNull
    public DatabaseObjectsPreparer onlyIf(@NotNull Condition<Collection<DbElement>> condition) {
        if (condition == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(0);
        }
        return new ConditionP(condition, this);
    }

    @NotNull
    public DatabaseObjectsPreparer onlyIfSingleElement(@NotNull Condition<DbElement> condition) {
        if (condition == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(1);
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.onlyIf((Condition<Collection<DbElement>>)((Condition)c2 -> ContainerUtil.count((Iterable)c2, (Condition)condition) == 1));
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(2);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer onlyIfMoreThanOnce(@NotNull Condition<DbElement> condition) {
        if (condition == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(3);
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.onlyIf((Condition<Collection<DbElement>>)((Condition)c2 -> ContainerUtil.count((Iterable)c2, (Condition)condition) > 1));
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(4);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer then(@NotNull DatabaseObjectsPreparer preparer) {
        if (preparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(5);
        }
        return new TunnelP(this, preparer);
    }

    @NotNull
    public DatabaseObjectsPreparer mapAppend(@NotNull Function<DbElement, DbElement> mapper) {
        if (mapper == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(6);
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new FunP((Function<Collection<DbElement>, Collection<DbElement>>)((Function)c2 -> JBIterable.from((Iterable)c2).filterMap(mapper).append((Iterable)c2).unique().toList())));
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(7);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer filter(@NotNull ObjectKind kind) {
        if (kind == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(8);
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.filter(DasUtil.byKind(kind));
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(9);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer endIf() {
        DatabaseObjectsPreparer databaseObjectsPreparer = this;
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(10);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer filter(@NotNull Condition<DbElement> condition) {
        if (condition == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(11);
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new FunP((Function<Collection<DbElement>, Collection<DbElement>>)((Function)c2 -> ContainerUtil.filter((Collection)c2, (Condition)condition))));
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(12);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer requireNotEmpty() {
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new DatabaseObjectsPreparer(){

            @Override
            @NotNull
            public Result prepare(@NotNull Collection<DbElement> elements) {
                if (elements == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new ResultImpl(elements, false, !elements.isEmpty());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$1", "prepare"));
            }
        });
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(13);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer requireSingle() {
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new DatabaseObjectsPreparer(){

            @Override
            @NotNull
            public Result prepare(@NotNull Collection<DbElement> elements) {
                if (elements == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new ResultImpl(elements, false, elements.size() == 1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$2", "prepare"));
            }
        });
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(14);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer finish() {
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new Last());
        if (databaseObjectsPreparer == null) {
            DatabaseObjectsPreparer.$$$reportNull$$$0(15);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public static DatabaseObjectsPreparer idle() {
        return new DatabaseObjectsPreparer(){

            @Override
            @NotNull
            public Result prepare(@NotNull Collection<DbElement> elements) {
                if (elements == null) {
                    3.$$$reportNull$$$0(0);
                }
                return new ResultImpl(elements, false, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$3", "prepare"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 7, 9, 10, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preparer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyIfSingleElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyIfMoreThanOnce";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mapAppend";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "endIf";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotEmpty";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "requireSingle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "finish";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onlyIf";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onlyIfSingleElement";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onlyIfMoreThanOnce";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "then";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mapAppend";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 7, 9, 10, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    private static final class ConditionP
    extends DatabaseObjectsPreparer {
        private static final Result INVALID_RESULT = new ResultImpl(ContainerUtil.emptyList(), false, false);
        private static final DatabaseObjectsPreparer INVALID = new DatabaseObjectsPreparer(){

            @Override
            @NotNull
            public Result prepare(@NotNull Collection<DbElement> elements) {
                if (elements == null) {
                    1.$$$reportNull$$$0(0);
                }
                Result result2 = INVALID_RESULT;
                if (result2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elements";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prepare";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepare";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        private final Condition<Collection<DbElement>> myCondition;
        private final DatabaseObjectsPreparer myBase;
        private DatabaseObjectsPreparer myOnTrue;

        private ConditionP(@NotNull Condition<Collection<DbElement>> condition, @NotNull DatabaseObjectsPreparer base) {
            if (condition == null) {
                ConditionP.$$$reportNull$$$0(0);
            }
            if (base == null) {
                ConditionP.$$$reportNull$$$0(1);
            }
            this(condition, base, INVALID);
        }

        private ConditionP(@NotNull Condition<Collection<DbElement>> condition, @NotNull DatabaseObjectsPreparer base, @NotNull DatabaseObjectsPreparer onTrue) {
            if (condition == null) {
                ConditionP.$$$reportNull$$$0(2);
            }
            if (base == null) {
                ConditionP.$$$reportNull$$$0(3);
            }
            if (onTrue == null) {
                ConditionP.$$$reportNull$$$0(4);
            }
            this.myCondition = condition;
            this.myBase = base;
            this.myOnTrue = onTrue;
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            Result base;
            if (elements == null) {
                ConditionP.$$$reportNull$$$0(5);
            }
            Collection<DbElement> nextElements = (base = this.myBase.prepare(elements)).isValid() ? base.get() : elements;
            Result result2 = base.isFinal() || !base.isValid() || !this.myCondition.value(nextElements) ? base : this.myOnTrue.prepare(nextElements);
            if (result2 == null) {
                ConditionP.$$$reportNull$$$0(6);
            }
            return result2;
        }

        @Override
        @NotNull
        public DatabaseObjectsPreparer then(@NotNull DatabaseObjectsPreparer preparer) {
            if (preparer == null) {
                ConditionP.$$$reportNull$$$0(7);
            }
            this.myOnTrue = this.myOnTrue == INVALID ? preparer : new TunnelP(this.myOnTrue, preparer);
            ConditionP conditionP = this;
            if (conditionP == null) {
                ConditionP.$$$reportNull$$$0(8);
            }
            return conditionP;
        }

        @Override
        @NotNull
        public DatabaseObjectsPreparer endIf() {
            DatabaseObjectsPreparer databaseObjectsPreparer = this.myBase.then(new ConditionP(this.myCondition, ConditionP.idle(), this.myOnTrue));
            if (databaseObjectsPreparer == null) {
                ConditionP.$$$reportNull$$$0(9);
            }
            return databaseObjectsPreparer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onTrue";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preparer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepare";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "then";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "endIf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "then";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static final class TunnelP
    extends DatabaseObjectsPreparer {
        private final DatabaseObjectsPreparer myBase;
        private final DatabaseObjectsPreparer myNext;

        private TunnelP(@NotNull DatabaseObjectsPreparer base, @NotNull DatabaseObjectsPreparer next) {
            if (base == null) {
                TunnelP.$$$reportNull$$$0(0);
            }
            if (next == null) {
                TunnelP.$$$reportNull$$$0(1);
            }
            this.myBase = base;
            this.myNext = next;
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            Result result2;
            if (elements == null) {
                TunnelP.$$$reportNull$$$0(2);
            }
            Result result3 = (result2 = this.myBase.prepare(elements)).isFinal() || !result2.isValid() ? result2 : this.myNext.prepare(result2.get());
            if (result3 == null) {
                TunnelP.$$$reportNull$$$0(3);
            }
            return result3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "next";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/DatabaseObjectsPreparer$TunnelP";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer$TunnelP";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FunP
    extends DatabaseObjectsPreparer {
        private final Function<Collection<DbElement>, Collection<DbElement>> myFun;

        private FunP(@NotNull Function<Collection<DbElement>, Collection<DbElement>> fun) {
            if (fun == null) {
                FunP.$$$reportNull$$$0(0);
            }
            this.myFun = fun;
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            if (elements == null) {
                FunP.$$$reportNull$$$0(1);
            }
            return new ResultImpl((Collection)this.myFun.fun(elements), false, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fun";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/cli/DatabaseObjectsPreparer$FunP";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepare";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Last
    extends DatabaseObjectsPreparer {
        private Last() {
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            if (elements == null) {
                Last.$$$reportNull$$$0(0);
            }
            return new ResultImpl(elements, true, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$Last", "prepare"));
        }
    }

    public static class ResultImpl
    implements Result {
        private final Collection<DbElement> myElements;
        private final boolean myFinal;
        private final boolean myValid;

        public ResultImpl(@NotNull Collection<DbElement> elements, boolean aFinal, boolean valid) {
            if (elements == null) {
                ResultImpl.$$$reportNull$$$0(0);
            }
            this.myElements = elements;
            this.myFinal = aFinal;
            this.myValid = valid;
        }

        @Override
        public boolean isValid() {
            return this.myValid;
        }

        @Override
        public Collection<DbElement> get() {
            return this.myElements;
        }

        @Override
        public boolean isFinal() {
            return this.myFinal;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$ResultImpl", "<init>"));
        }
    }

    static interface Result {
        public boolean isFinal();

        public boolean isValid();

        public Collection<DbElement> get();
    }
}

