/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.PatternBuilder;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.TextDecompositionUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextDecompositionNodes {
    @NotNull
    public static SNode create(@NotNull StatelessTextDecomposition.Node stateless) {
        if (stateless == null) {
            TextDecompositionNodes.$$$reportNull$$$0(0);
        }
        if (stateless.getClass() == StatelessTextDecomposition.TextNode.class) {
            return TextDecompositionNodes.create((StatelessTextDecomposition.TextNode)stateless);
        }
        if (stateless.getClass() == StatelessTextDecomposition.AntiNode.class) {
            return TextDecompositionNodes.create((StatelessTextDecomposition.AntiNode)stateless);
        }
        if (stateless.getClass() == StatelessTextDecomposition.ParameterNode.class) {
            return TextDecompositionNodes.create((StatelessTextDecomposition.ParameterNode)stateless);
        }
        if (stateless.getClass() == StatelessTextDecomposition.CompositeNode.class) {
            return TextDecompositionNodes.create((StatelessTextDecomposition.CompositeNode)stateless);
        }
        if (stateless.getClass() == StatelessTextDecomposition.OptionalNode.class) {
            return TextDecompositionNodes.create((StatelessTextDecomposition.OptionalNode)stateless);
        }
        if (stateless.getClass() == StatelessTextDecomposition.ListNode.class) {
            return TextDecompositionNodes.create((StatelessTextDecomposition.ListNode)stateless);
        }
        if (stateless.getClass() == StatelessTextDecomposition.ListChoiceNode.class) {
            return TextDecompositionNodes.create((StatelessTextDecomposition.ListChoiceNode)stateless);
        }
        assert (false);
        if (null == null) {
            TextDecompositionNodes.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    public static TextSNode create(@NotNull StatelessTextDecomposition.TextNode stateless) {
        if (stateless == null) {
            TextDecompositionNodes.$$$reportNull$$$0(2);
        }
        return new TextSNode(stateless);
    }

    @NotNull
    public static AntiSNode create(@NotNull StatelessTextDecomposition.AntiNode stateless) {
        if (stateless == null) {
            TextDecompositionNodes.$$$reportNull$$$0(3);
        }
        return new AntiSNode(stateless, TextDecompositionNodes.create(stateless.getChildren()[0]));
    }

    @NotNull
    public static ParameterSNode create(@NotNull StatelessTextDecomposition.ParameterNode stateless) {
        if (stateless == null) {
            TextDecompositionNodes.$$$reportNull$$$0(4);
        }
        return new ParameterSNode(stateless);
    }

    @NotNull
    public static ListChoiceSNode create(@NotNull StatelessTextDecomposition.ListChoiceNode stateless) {
        if (stateless == null) {
            TextDecompositionNodes.$$$reportNull$$$0(5);
        }
        return new ListChoiceSNode(stateless, TextDecompositionNodes.create(stateless.getChildren()[0]));
    }

    @NotNull
    public static OptionalSNode create(@NotNull StatelessTextDecomposition.OptionalNode stateless) {
        if (stateless == null) {
            TextDecompositionNodes.$$$reportNull$$$0(6);
        }
        return new OptionalSNode(stateless, TextDecompositionNodes.create(stateless.getChildren()[0]));
    }

    @NotNull
    public static CompositeSNode create(@NotNull StatelessTextDecomposition.CompositeNode stateless) {
        if (stateless == null) {
            TextDecompositionNodes.$$$reportNull$$$0(7);
        }
        SNode[] children2 = new SNode[stateless.getChildren().length];
        for (int i2 = 0; i2 < children2.length; ++i2) {
            children2[i2] = TextDecompositionNodes.create(stateless.getChildren()[i2]);
        }
        return new CompositeSNode(stateless, children2);
    }

    @NotNull
    public static ListSNode create(@NotNull StatelessTextDecomposition.ListNode stateless) {
        if (stateless == null) {
            TextDecompositionNodes.$$$reportNull$$$0(8);
        }
        StatelessTextDecomposition.Node[] statelessChoices = stateless.getChoice().getChildren();
        ListChoiceSNode[] choices = new ListChoiceSNode[statelessChoices.length];
        for (int i2 = 0; i2 < statelessChoices.length; ++i2) {
            choices[i2] = TextDecompositionNodes.create((StatelessTextDecomposition.ListChoiceNode)statelessChoices[i2]);
        }
        return new ListSNode(stateless, choices);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateless";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static class TextSNode
    extends AbstractMatchable
    implements LeafSNode {
        private final StatelessTextDecomposition.TextNode myNode;
        private BadGroup myBadGroup;
        private String myMatchedText;

        TextSNode(@NotNull StatelessTextDecomposition.TextNode stateless) {
            if (stateless == null) {
                TextSNode.$$$reportNull$$$0(0);
            }
            this.myMatchedText = "";
            this.myNode = stateless;
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor<?> visitor2) {
            if (visitor2 == null) {
                TextSNode.$$$reportNull$$$0(1);
            }
        }

        @Override
        @NotNull
        public JBIterable<? extends SNode> children() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                TextSNode.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Override
        public void setBadGroup(@Nullable BadGroup bad) {
            this.myBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getBadGroup() {
            return this.myBadGroup;
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.myNode.getText();
            if (string == null) {
                TextSNode.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getMatchedText() {
            String string = this.myMatchedText;
            if (string == null) {
                TextSNode.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.TextNode getStateless() {
            StatelessTextDecomposition.TextNode textNode = this.myNode;
            if (textNode == null) {
                TextSNode.$$$reportNull$$$0(5);
            }
            return textNode;
        }

        @Override
        public void setMatch(@Nullable CharSequence text2) {
            super.setMatch(text2);
            this.myMatchedText = text2 == null ? "" : text2.toString();
            this.setBadGroup(null);
        }

        public void setMatchedText(@NotNull String matchedText) {
            if (matchedText == null) {
                TextSNode.$$$reportNull$$$0(6);
            }
            this.myMatchedText = matchedText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stateless";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$TextSNode";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchedText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$TextSNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "children";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatchedText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateless";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitChildren";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setMatchedText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    static class AntiSNode
    extends AbstractMatchable
    implements SNode,
    Badable {
        private final StatelessTextDecomposition.AntiNode myNode;
        private final SNode mySNode;
        private boolean myEnabled;
        private BadGroup myBadGroup;

        AntiSNode(@NotNull StatelessTextDecomposition.AntiNode node, @NotNull SNode snode) {
            if (node == null) {
                AntiSNode.$$$reportNull$$$0(0);
            }
            if (snode == null) {
                AntiSNode.$$$reportNull$$$0(1);
            }
            this.myNode = node;
            this.mySNode = snode;
            this.myEnabled = false;
        }

        @Override
        public void setBadGroup(@Nullable BadGroup bad) {
            this.myBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getBadGroup() {
            return this.myBadGroup;
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.AntiNode getStateless() {
            StatelessTextDecomposition.AntiNode antiNode = this.myNode;
            if (antiNode == null) {
                AntiSNode.$$$reportNull$$$0(2);
            }
            return antiNode;
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor<?> visitor2) {
            if (visitor2 == null) {
                AntiSNode.$$$reportNull$$$0(3);
            }
            visitor2.visit(this.mySNode);
        }

        @Override
        @NotNull
        public JBIterable<? extends SNode> children() {
            JBIterable jBIterable = JBIterable.of((Object)this.mySNode);
            if (jBIterable == null) {
                AntiSNode.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        public SNode getNode() {
            return this.mySNode;
        }

        @Override
        public void setMatch(@Nullable CharSequence text2) {
            super.setMatch(text2);
            this.setBadGroup(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "snode";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$AntiSNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$AntiSNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateless";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "children";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitChildren";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    static class ParameterSNode
    extends AbstractMatchable
    implements Parameter,
    LeafSNode {
        private final StatelessTextDecomposition.ParameterNode myNode;
        private String myText;
        private BadGroup myBadGroup;

        ParameterSNode(@NotNull StatelessTextDecomposition.ParameterNode stateless) {
            if (stateless == null) {
                ParameterSNode.$$$reportNull$$$0(0);
            }
            this.myText = "";
            this.myNode = stateless;
        }

        public void setText(@NotNull String text2) {
            if (text2 == null) {
                ParameterSNode.$$$reportNull$$$0(1);
            }
            this.myText = text2;
        }

        @Override
        public void setValue(@NotNull String text2) {
            StatelessTextDecomposition.QuoteHandler handler2;
            if (text2 == null) {
                ParameterSNode.$$$reportNull$$$0(2);
            }
            if ((handler2 = this.myNode.getQuote()) == null || text2.isEmpty() || !handler2.forceQuote(text2) && this.myNode.isValueValid(text2)) {
                this.setText(text2);
            } else {
                this.setText(handler2.quote(text2));
            }
        }

        @Override
        public boolean isValueValid(@NotNull String text2) {
            if (text2 == null) {
                ParameterSNode.$$$reportNull$$$0(3);
            }
            return this.myNode.getQuote() != null || this.myNode.isValueValid(text2);
        }

        @Override
        public void setBadGroup(@Nullable BadGroup bad) {
            this.myBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getBadGroup() {
            return this.myBadGroup;
        }

        @Override
        @Nullable
        public String getName() {
            return this.myNode.getName();
        }

        @Override
        @NotNull
        public String getType() {
            String string = this.myNode.getType();
            if (string == null) {
                ParameterSNode.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ParameterSNode.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        public String getValue() {
            StatelessTextDecomposition.QuoteHandler handler2 = this.myNode.getQuote();
            String text2 = this.getText();
            String string = handler2 == null || !handler2.isQuoted(text2) ? text2 : handler2.unquote(text2);
            if (string == null) {
                ParameterSNode.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor<?> visitor2) {
            if (visitor2 == null) {
                ParameterSNode.$$$reportNull$$$0(7);
            }
        }

        @Override
        @NotNull
        public JBIterable<? extends SNode> children() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ParameterSNode.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.ParameterNode getStateless() {
            StatelessTextDecomposition.ParameterNode parameterNode = this.myNode;
            if (parameterNode == null) {
                ParameterSNode.$$$reportNull$$$0(9);
            }
            return parameterNode;
        }

        @Override
        public void setMatch(@Nullable CharSequence text2) {
            super.setMatch(text2);
            this.setBadGroup(null);
            this.setText(text2 == null ? "" : text2.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stateless";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ParameterSNode";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ParameterSNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "children";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateless";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isValueValid";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitChildren";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    static class CompositeSNode
    extends AbstractMatchable
    implements SNode,
    StartEndBadable {
        private final StatelessTextDecomposition.CompositeNode myNode;
        private final SNode[] myChildren;
        private BadGroup myStartBadGroup;
        private BadGroup myEndBadGroup;

        @Override
        public void setStartBadGroup(@Nullable BadGroup bad) {
            this.myStartBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getStartBadGroup() {
            return this.myStartBadGroup;
        }

        @Override
        public void setEndBadGroup(@Nullable BadGroup bad) {
            this.myEndBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getEndBadGroup() {
            return this.myEndBadGroup;
        }

        CompositeSNode(@NotNull StatelessTextDecomposition.CompositeNode stateless, SNode @NotNull [] children2) {
            if (stateless == null) {
                CompositeSNode.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                CompositeSNode.$$$reportNull$$$0(1);
            }
            this.myNode = stateless;
            this.myChildren = children2;
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.CompositeNode getStateless() {
            StatelessTextDecomposition.CompositeNode compositeNode = this.myNode;
            if (compositeNode == null) {
                CompositeSNode.$$$reportNull$$$0(2);
            }
            return compositeNode;
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor<?> visitor2) {
            if (visitor2 == null) {
                CompositeSNode.$$$reportNull$$$0(3);
            }
            for (SNode c2 : this.myChildren) {
                visitor2.visit(c2);
            }
        }

        @Override
        @NotNull
        public JBIterable<? extends SNode> children() {
            JBIterable jBIterable = JBIterable.of((Object[])this.myChildren);
            if (jBIterable == null) {
                CompositeSNode.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        public SNode[] getChildren() {
            return this.myChildren;
        }

        @Override
        public void setMatch(@Nullable CharSequence text2) {
            super.setMatch(text2);
            this.myStartBadGroup = null;
            this.myEndBadGroup = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stateless";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$CompositeSNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$CompositeSNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateless";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "children";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitChildren";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    static class OptionalSNode
    extends AbstractMatchable
    implements SNode,
    Badable {
        private final StatelessTextDecomposition.OptionalNode myNode;
        private final SNode mySNode;
        private boolean myEnabled;
        private BadGroup myBadGroup;

        OptionalSNode(@NotNull StatelessTextDecomposition.OptionalNode node, @NotNull SNode snode) {
            if (node == null) {
                OptionalSNode.$$$reportNull$$$0(0);
            }
            if (snode == null) {
                OptionalSNode.$$$reportNull$$$0(1);
            }
            this.myNode = node;
            this.mySNode = snode;
            this.myEnabled = false;
        }

        @Override
        public void setBadGroup(@Nullable BadGroup bad) {
            this.myBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getBadGroup() {
            return this.myBadGroup;
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.OptionalNode getStateless() {
            StatelessTextDecomposition.OptionalNode optionalNode = this.myNode;
            if (optionalNode == null) {
                OptionalSNode.$$$reportNull$$$0(2);
            }
            return optionalNode;
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor<?> visitor2) {
            if (visitor2 == null) {
                OptionalSNode.$$$reportNull$$$0(3);
            }
            visitor2.visit(this.mySNode);
        }

        @Override
        @NotNull
        public JBIterable<? extends SNode> children() {
            JBIterable jBIterable = JBIterable.of((Object)this.mySNode);
            if (jBIterable == null) {
                OptionalSNode.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        public SNode getNode() {
            return this.mySNode;
        }

        @Override
        public void setMatch(@Nullable CharSequence text2) {
            super.setMatch(text2);
            this.setBadGroup(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "snode";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$OptionalSNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$OptionalSNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateless";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "children";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitChildren";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    static class ListSNode
    extends AbstractMatchable
    implements SNode {
        private final StatelessTextDecomposition.ListNode myNode;
        private final List<ListChoiceSNode> myMatched;
        private final ListChoiceSNode[] myKnownChoices;

        ListSNode(@NotNull StatelessTextDecomposition.ListNode stateless, ListChoiceSNode @NotNull [] choices) {
            if (stateless == null) {
                ListSNode.$$$reportNull$$$0(0);
            }
            if (choices == null) {
                ListSNode.$$$reportNull$$$0(1);
            }
            this.myMatched = new ArrayList<ListChoiceSNode>(0);
            this.myNode = stateless;
            this.myKnownChoices = choices;
            StatelessTextDecomposition.ListChoicesNode sp = stateless.getChoice();
            int g = 1;
            for (int i2 = 0; i2 < this.myKnownChoices.length; ++i2) {
                ListChoiceSNode choice = this.myKnownChoices[i2];
                if (choice.getStateless() != sp.getChildren()[i2]) {
                    throw new AssertionError((Object)"children mismatch");
                }
                choice.setGroupNumber(g + sp.getChildGroupOffset(i2, 0));
            }
            this.addMissingChoices();
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor<?> visitor2) {
            if (visitor2 == null) {
                ListSNode.$$$reportNull$$$0(2);
            }
            for (SNode sNode : this.myMatched) {
                visitor2.visit(sNode);
            }
        }

        @Override
        @NotNull
        public JBIterable<? extends SNode> children() {
            JBIterable jBIterable = JBIterable.from(this.myMatched);
            if (jBIterable == null) {
                ListSNode.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.ListNode getStateless() {
            StatelessTextDecomposition.ListNode listNode2 = this.myNode;
            if (listNode2 == null) {
                ListSNode.$$$reportNull$$$0(4);
            }
            return listNode2;
        }

        @Override
        public void setMatch(@Nullable CharSequence text2) {
            super.setMatch(text2);
            this.myMatched.clear();
            for (ListChoiceSNode c2 : this.myKnownChoices) {
                c2.setMatch(null);
            }
            int matched = this.subMatch(text2 == null ? "" : text2);
            assert (text2 == null || matched <= text2.length()) : "Match differs: " + text2;
            this.addMissingChoices();
        }

        private int subMatch(@NotNull CharSequence text2) {
            if (text2 == null) {
                ListSNode.$$$reportNull$$$0(5);
            }
            int matched = 0;
            Matcher m = this.myNode.getChoice().compileIncrementalPattern().matcher(text2);
            Matcher subMatcher = PatternBuilder.compile(this.myNode.getSeparatorPattern()).matcher(text2);
            while (m.lookingAt()) {
                matched = m.end();
                this.processMatch(m);
                subMatcher.region(matched, text2.length());
                if (!subMatcher.lookingAt()) break;
                m.region(subMatcher.end(), text2.length());
            }
            return matched;
        }

        private int recover(@NotNull CharSequence text2) {
            Matcher matcher;
            if (text2 == null) {
                ListSNode.$$$reportNull$$$0(6);
            }
            if (!(matcher = this.myNode.getChoice().compileRecoverPattern().matcher(text2)).lookingAt()) {
                return 0;
            }
            return matcher.end();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        private RecoverableMatch matchIncremental(@NotNull CharSequence text2, @Nullable BadGroup badness) {
            if (text2 == null) {
                ListSNode.$$$reportNull$$$0(7);
            }
            super.setMatch(text2);
            RecoverableMatch res2 = new RecoverableMatch();
            this.myMatched.clear();
            for (ListChoiceSNode c2 : this.myKnownChoices) {
                c2.setMatch(null);
            }
            ListChoiceSNode[] pending = (ListChoiceSNode[])this.myKnownChoices.clone();
            ArrayList<CharSequenceSubSequence> matchedStrings = new ArrayList<CharSequenceSubSequence>();
            ArrayList<void> matchResults = new ArrayList<void>();
            Matcher subMatcher = PatternBuilder.compile(this.myNode.getSeparatorPattern()).matcher(text2);
            int offset = 0;
            boolean extraSeparator = false;
            while (offset != text2.length() || this.myMatched.isEmpty()) {
                void var10_12;
                Object var10_13 = null;
                int maxIdx = -1;
                Object current = new CharSequenceSubSequence(text2, offset, text2.length());
                int recovered = this.recover((CharSequence)current);
                current = current.subSequence(0, recovered);
                for (int i2 = 0; i2 < pending.length; ++i2) {
                    String prevBadText;
                    String string = prevBadText = badness == null ? "" : badness.getBadText();
                    if (badness != null) {
                        badness.setBadText("");
                    }
                    RecoverableMatch curMatched = pending[i2].matchIncrementally((CharSequence)current, this.myMatched.isEmpty() ? badness : null);
                    if (var10_12 == null || curMatched.compareTo((RecoverableMatch)var10_12) > 0) {
                        RecoverableMatch recoverableMatch = curMatched;
                        maxIdx = i2;
                        continue;
                    }
                    if (badness == null) continue;
                    badness.setBadText(prevBadText);
                }
                assert (var10_12 != null);
                this.myMatched.add(pending[maxIdx]);
                matchedStrings.add((CharSequenceSubSequence)current);
                matchResults.add(var10_12);
                pending[maxIdx] = TextDecompositionNodes.create(pending[maxIdx].getStateless());
                res2.add((RecoverableMatch)var10_12);
                for (ListChoiceSNode node : pending) {
                    node.setMatch(null);
                }
                subMatcher.region(offset += recovered, text2.length());
                if (!subMatcher.lookingAt()) break;
                offset = subMatcher.end();
                res2.matched = subMatcher.end();
                extraSeparator = offset == text2.length();
            }
            for (ListChoiceSNode choice : this.myKnownChoices) {
                int mini = -1;
                int myi = -1;
                RecoverableMatch maxMatch = null;
                for (int i3 = 0; i3 < this.myMatched.size(); ++i3) {
                    ListChoiceSNode m = this.myMatched.get(i3);
                    if (m != choice && m.getStateless() == choice.getStateless() && (maxMatch == null || ((RecoverableMatch)matchResults.get(i3)).compareTo(maxMatch) > 0)) {
                        maxMatch = (RecoverableMatch)matchResults.get(i3);
                        mini = i3;
                        continue;
                    }
                    if (m != choice) continue;
                    myi = i3;
                }
                if (mini == -1 || myi == -1) continue;
                Collections.swap(this.myMatched, mini, myi);
                if ((mini == 0 || myi == 0) && badness != null) {
                    badness.setBadText("");
                }
                this.myMatched.get(mini).matchIncrementally((CharSequence)matchedStrings.get(mini), mini == 0 ? badness : null);
                this.myMatched.get(myi).matchIncrementally((CharSequence)matchedStrings.get(myi), myi == 0 ? badness : null);
            }
            if (extraSeparator) {
                ListChoiceSNode listChoiceSNode = (ListChoiceSNode)ContainerUtil.getLastItem(this.myMatched);
                assert (listChoiceSNode != null);
                BadGroup bg = listChoiceSNode.getEndBadGroup();
                if (bg == null) {
                    bg = new BadGroup();
                    listChoiceSNode.setEndBadGroup(bg);
                }
                bg.setBadText(bg.getBadText() + this.getStateless().getSeparatorText());
            }
            assert (offset == text2.length()) : "Match differs: " + text2;
            this.addMissingChoices();
            RecoverableMatch recoverableMatch = res2;
            if (recoverableMatch == null) {
                ListSNode.$$$reportNull$$$0(8);
            }
            return recoverableMatch;
        }

        private static boolean contains(@NotNull CharSequence text2, int offset, @NotNull CharSequence other) {
            int matched;
            if (text2 == null) {
                ListSNode.$$$reportNull$$$0(9);
            }
            if (other == null) {
                ListSNode.$$$reportNull$$$0(10);
            }
            for (matched = 0; offset + matched < text2.length() && matched < other.length() && text2.charAt(matched + offset) == other.charAt(matched); ++matched) {
            }
            return matched == other.length();
        }

        public void processMatch(@NotNull MatchResult m) {
            if (m == null) {
                ListSNode.$$$reportNull$$$0(11);
            }
            for (ListChoiceSNode choice : this.myKnownChoices) {
                String text2 = m.group(choice.getGroupNumber());
                ListChoiceSNode matched = null;
                if (!StringUtil.isEmpty((String)text2)) {
                    matched = choice.isMatched() ? TextDecompositionNodes.create(choice.getStateless()) : choice;
                    matched.setMatch(text2);
                }
                if (matched == null) continue;
                this.myMatched.add(matched);
            }
        }

        private void addMissingChoices() {
            HashSet<ListChoiceSNode> props = new HashSet<ListChoiceSNode>(this.myMatched);
            for (ListChoiceSNode c2 : this.myKnownChoices) {
                if (props.contains(c2)) continue;
                this.myMatched.add(c2);
            }
        }

        public List<ListChoiceSNode> getMatches() {
            return this.myMatched;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stateless";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "choices";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "m";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListSNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "children";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateless";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "matchIncremental";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitChildren";
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "subMatch";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "recover";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "matchIncremental";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "processMatch";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 8 -> new IllegalStateException(string);
            };
        }
    }

    static class ListChoiceSNode
    extends MatchableRoot
    implements SNode {
        private final StatelessTextDecomposition.ListChoiceNode myNode;
        private boolean myEnabled;

        ListChoiceSNode(@NotNull StatelessTextDecomposition.ListChoiceNode stateless, @NotNull SNode node) {
            if (stateless == null) {
                ListChoiceSNode.$$$reportNull$$$0(0);
            }
            if (node == null) {
                ListChoiceSNode.$$$reportNull$$$0(1);
            }
            super(node);
            this.myNode = stateless;
        }

        @Override
        public void visitChildren(@NotNull NodeVisitor<?> visitor2) {
            if (visitor2 == null) {
                ListChoiceSNode.$$$reportNull$$$0(2);
            }
            visitor2.visit(this.getRoot());
        }

        @Override
        @NotNull
        public JBIterable<? extends SNode> children() {
            JBIterable jBIterable = JBIterable.of((Object)this.getRoot());
            if (jBIterable == null) {
                ListChoiceSNode.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public StatelessTextDecomposition.ListChoiceNode getStateless() {
            StatelessTextDecomposition.ListChoiceNode listChoiceNode = this.myNode;
            if (listChoiceNode == null) {
                ListChoiceSNode.$$$reportNull$$$0(4);
            }
            return listChoiceNode;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled || this.myNode.isMandatory();
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stateless";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListChoiceSNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$ListChoiceSNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "children";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateless";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitChildren";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    static interface SNode
    extends Matchable {
        public void visitChildren(@NotNull NodeVisitor<?> var1);

        @NotNull
        public JBIterable<? extends SNode> children();

        @NotNull
        public StatelessTextDecomposition.Node getStateless();
    }

    static class MatchableRoot
    extends AbstractMatchable
    implements StartEndBadable {
        private final Matchable[] myMatchables;
        private final SNode myRoot;
        private BadGroup myStartBadGroup;
        private BadGroup myEndBadGroup;

        MatchableRoot(@NotNull SNode root) {
            if (root == null) {
                MatchableRoot.$$$reportNull$$$0(0);
            }
            this.myRoot = root;
            this.myMatchables = TextDecompositionUtil.collectMatchables(this.myRoot);
            TextDecompositionUtil.assignGroups(this.myRoot);
        }

        @Override
        public void setStartBadGroup(@Nullable BadGroup bad) {
            this.myStartBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getStartBadGroup() {
            return this.myStartBadGroup;
        }

        @Override
        public void setEndBadGroup(@Nullable BadGroup bad) {
            this.myEndBadGroup = bad;
        }

        @Override
        @Nullable
        public BadGroup getEndBadGroup() {
            return this.myEndBadGroup;
        }

        @NotNull
        public SNode getRoot() {
            SNode sNode = this.myRoot;
            if (sNode == null) {
                MatchableRoot.$$$reportNull$$$0(1);
            }
            return sNode;
        }

        @Override
        public void setMatch(@Nullable CharSequence text2) {
            super.setMatch(text2);
            this.myStartBadGroup = null;
            this.myEndBadGroup = null;
            if (text2 == null) {
                for (Matchable matchable : this.myMatchables) {
                    matchable.setMatch(null);
                }
                return;
            }
            Matcher matcher = this.myRoot.getStateless().compilePattern().matcher(text2);
            boolean check = matcher.matches();
            assert (check);
            for (Matchable matchable : this.myMatchables) {
                matchable.setMatch(matcher.group(matchable.getGroupNumber()));
            }
        }

        @NotNull
        public RecoverableMatch matchIncrementally(final @NotNull CharSequence unmatched, final @Nullable BadGroup badness) {
            if (unmatched == null) {
                MatchableRoot.$$$reportNull$$$0(2);
            }
            RecoverableMatch recoverableMatch = new TextDecompositionUtil.SimpleNodeVisitor<Void>(){
                private RecoverableMatchState state = new RecoverableMatchState();
                private boolean myOpt = false;

                @NotNull
                private BadGroup currentBadGroup() {
                    if (this.state.myRecovery == null) {
                        this.state.myRecovery = new BadGroup();
                        ++this.state.myRecoveries;
                        if (this.state.myOffset == 0) {
                            myStartBadGroup = this.state.myRecovery;
                        }
                    }
                    BadGroup badGroup = this.state.myRecovery;
                    if (badGroup == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return badGroup;
                }

                @Override
                public Void visit(@NotNull SNode node) {
                    int matched;
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (node.getStateless().isEarlyMatchable() && !(node instanceof OptionalSNode) && (matched = this.matchLength(node)) != -1) {
                        this.state.myOffset += matched;
                        this.myOpt = false;
                        assert (this.state.myRecovery == null);
                        return null;
                    }
                    super.visit(node);
                    return null;
                }

                @Override
                public Void visit(@NotNull ParameterSNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    node.setMatch(null);
                    node.setBadGroup(this.currentBadGroup());
                    return null;
                }

                @Override
                public Void visit(@NotNull TextSNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    node.setMatch(null);
                    node.setBadGroup(this.currentBadGroup());
                    if (this.myOpt) {
                        this.state.myOptTextSkipped += node.getText().length();
                    } else {
                        this.state.myTextSkipped += node.getText().length();
                    }
                    return null;
                }

                @Override
                public Void visit(@NotNull CompositeSNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    node.setMatch(null);
                    node.setStartBadGroup(this.state.myRecovery);
                    node.visitChildren(this);
                    node.setEndBadGroup(this.state.myRecovery);
                    return null;
                }

                @Override
                public Void visit(@NotNull OptionalSNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    boolean prevOpt = this.myOpt;
                    this.myOpt = true;
                    RecoverableMatchState prevState = new RecoverableMatchState(this.state);
                    node.visitChildren(this);
                    CharSequenceSubSequence segment = new CharSequenceSubSequence(unmatched, prevState.myOffset, unmatched.length());
                    Matcher matcher = node.getStateless().compileRecoverPattern().matcher((CharSequence)segment);
                    boolean shouldRecover = false;
                    if (matcher.lookingAt()) {
                        if (this.state.myRecovered - prevState.myRecovered > matcher.end() || matcher.end() == 0 && this.state.myRecoveries > prevState.myRecoveries) {
                            shouldRecover = true;
                        }
                    } else {
                        shouldRecover = true;
                    }
                    if (shouldRecover) {
                        this.state = prevState;
                        TextDecompositionUtil.nullizeMatch(node);
                        if (this.state.myRecovery != null) {
                            this.state.myRecovery.setBadText("");
                        }
                        node.setBadGroup(this.currentBadGroup());
                        this.myOpt = true;
                    } else {
                        if (!this.myOpt) {
                            this.state.myTextSkipped += this.state.myOptTextSkipped;
                        }
                        this.state.myOptTextSkipped = 0;
                        node.setMatch(unmatched.subSequence(prevState.myOffset, this.state.myOffset));
                    }
                    if (this.myOpt) {
                        this.myOpt = prevOpt;
                    }
                    return null;
                }

                @Override
                public Void visit(@NotNull AntiSNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    CharSequenceSubSequence segment = new CharSequenceSubSequence(unmatched, this.state.myOffset, unmatched.length());
                    Matcher matcher = node.getNode().getStateless().compilePattern().matcher((CharSequence)segment);
                    if (matcher.lookingAt()) {
                        BadGroup bg = this.currentBadGroup();
                        node.setBadGroup(bg);
                        if (this.myOpt) {
                            this.state.myOptTextSkipped += matcher.end();
                        } else {
                            this.state.myTextSkipped += matcher.end();
                        }
                        this.state.myOffset += matcher.end();
                        bg.setBadText(bg.getBadText() + matcher.group());
                        TextDecompositionUtil.nullizeMatch(node);
                    }
                    return null;
                }

                @Override
                public Void visit(@NotNull ListSNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    CharSequenceSubSequence segment = new CharSequenceSubSequence(unmatched, this.state.myOffset, unmatched.length());
                    Pattern p2 = node.getStateless().compileRecoverPattern();
                    Matcher matcher = p2.matcher((CharSequence)segment);
                    if (matcher.lookingAt()) {
                        RecoverableMatch res2 = node.matchIncremental(matcher.group(), this.state.myRecovery);
                        this.state.myOffset += matcher.group().length();
                        this.state.myRecovered = matcher.group().length() - res2.matched;
                        this.state.myRecoveries += res2.numRecoveries;
                        this.state.myTextSkipped += res2.textSkipped;
                        this.state.myRecovery = null;
                    } else {
                        node.setMatch(null);
                    }
                    return null;
                }

                @Override
                public Void visit(@NotNull ListChoiceSNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    node.visitChildren(this);
                    return null;
                }

                private int matchLength(@NotNull SNode node) {
                    Matcher matcher;
                    boolean matched;
                    if (node == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    CharSequenceSubSequence segment = new CharSequenceSubSequence(unmatched, this.state.myOffset, unmatched.length());
                    Pattern p2 = node.getStateless().compileIncrementalPattern();
                    int recoveryAddition = 0;
                    if (this.state.myRecovery != null) {
                        p2 = PatternBuilder.build("(.*?)").push().append(p2).group().pop().compile();
                        recoveryAddition = 1;
                    }
                    if (!(matched = (matcher = p2.matcher((CharSequence)segment)).lookingAt()) && this.state.myRecovery == null && node instanceof ParameterSNode) {
                        matcher = node.getStateless().compilePattern().matcher((CharSequence)segment);
                        matched = matcher.lookingAt();
                    }
                    if (matched) {
                        for (Matchable m : myMatchables) {
                            int g = m.getGroupNumber() - node.getGroupNumber() + 1 + recoveryAddition;
                            if (g <= recoveryAddition || g > matcher.groupCount() || g > recoveryAddition + node.getStateless().getContainingGroups()) continue;
                            1.setMatchedText(m, matcher.group(g));
                        }
                        if (this.state.myRecovery != null) {
                            this.state.myRecovery.setBadText(matcher.group(1));
                            this.state.myRecovered = this.state.myRecovery.getBadText().length();
                            this.state.myRecovery = null;
                        }
                        return matcher.end();
                    }
                    return -1;
                }

                private static void setMatchedText(@NotNull Matchable node, @Nullable CharSequence text2) {
                    if (node == null) {
                        1.$$$reportNull$$$0(10);
                    }
                    node.setMatch(text2);
                }

                RecoverableMatch getResult(@NotNull SNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(11);
                    }
                    this.state.myRecovery = badness;
                    myStartBadGroup = badness;
                    this.visit(node);
                    RecoverableMatch res2 = new RecoverableMatch();
                    res2.matched = this.state.myOffset - this.state.myRecovered;
                    res2.numRecoveries = this.state.myRecoveries;
                    res2.textSkipped = this.state.myTextSkipped;
                    myEndBadGroup = this.state.myRecovery;
                    if (myEndBadGroup == null && unmatched.length() != this.state.myOffset) {
                        myEndBadGroup = this.currentBadGroup();
                    }
                    if (myEndBadGroup != null) {
                        myEndBadGroup.setBadText(unmatched.subSequence(this.state.myOffset, unmatched.length()).toString());
                    }
                    return res2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "currentBadGroup";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            objectArray = objectArray;
                            objectArray[2] = "visit";
                            break;
                        }
                        case 9: {
                            objectArray = objectArray;
                            objectArray[2] = "matchLength";
                            break;
                        }
                        case 10: {
                            objectArray = objectArray;
                            objectArray[2] = "setMatchedText";
                            break;
                        }
                        case 11: {
                            objectArray = objectArray;
                            objectArray[2] = "getResult";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
                    };
                }
            }.getResult(this.myRoot);
            if (recoverableMatch == null) {
                MatchableRoot.$$$reportNull$$$0(3);
            }
            return recoverableMatch;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmatched";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "matchIncrementally";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "matchIncrementally";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }

        static class RecoverableMatchState {
            int myOffset;
            BadGroup myRecovery;
            int myRecovered;
            int myRecoveries;
            int myTextSkipped;
            int myOptTextSkipped;

            RecoverableMatchState() {
                this.myOffset = 0;
                this.myRecovery = null;
                this.myRecovered = 0;
                this.myRecoveries = 0;
                this.myTextSkipped = 0;
                this.myOptTextSkipped = 0;
            }

            RecoverableMatchState(@NotNull RecoverableMatchState other) {
                if (other == null) {
                    RecoverableMatchState.$$$reportNull$$$0(0);
                }
                this.myOffset = 0;
                this.myRecovery = null;
                this.myRecovered = 0;
                this.myRecoveries = 0;
                this.myTextSkipped = 0;
                this.myOptTextSkipped = 0;
                this.myOffset = other.myOffset;
                this.myRecovery = other.myRecovery;
                this.myRecovered = other.myRecovered;
                this.myRecoveries = other.myRecoveries;
                this.myTextSkipped = other.myTextSkipped;
                this.myOptTextSkipped = other.myOptTextSkipped;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/dataSource/url/template/TextDecompositionNodes$MatchableRoot$RecoverableMatchState", "<init>"));
            }
        }
    }

    static class RecoverableMatch
    implements Comparable<RecoverableMatch> {
        int matched = 0;
        int numRecoveries = 0;
        int textSkipped = 0;

        RecoverableMatch() {
        }

        @Override
        public int compareTo(@NotNull RecoverableMatch o) {
            int res2;
            if (o == null) {
                RecoverableMatch.$$$reportNull$$$0(0);
            }
            if ((res2 = -Integer.compare(this.textSkipped, o.textSkipped)) != 0) {
                return res2;
            }
            res2 = Integer.compare(this.matched, o.matched);
            if (res2 != 0) {
                return res2;
            }
            res2 = -Integer.compare(this.numRecoveries, o.numRecoveries);
            return res2;
        }

        public void add(@NotNull RecoverableMatch o) {
            if (o == null) {
                RecoverableMatch.$$$reportNull$$$0(1);
            }
            this.matched += o.matched;
            this.textSkipped += o.textSkipped;
            this.numRecoveries += o.numRecoveries;
        }

        public boolean equals(Object obj2) {
            return obj2 instanceof RecoverableMatch && this.compareTo((RecoverableMatch)obj2) == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "o";
            objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$RecoverableMatch";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class AbstractMatchable
    implements Matchable {
        private int myGroupNumber;
        private int myFrom = -1;
        private int myTo = -1;
        private boolean myMatched = false;

        AbstractMatchable() {
        }

        @Override
        public int getGroupNumber() {
            return this.myGroupNumber;
        }

        public void setGroupNumber(int groupNumber) {
            this.myGroupNumber = groupNumber;
        }

        @Override
        public int getFrom() {
            return this.myFrom;
        }

        @Override
        public int getTo() {
            return this.myTo;
        }

        @Override
        public void setMatch(@Nullable CharSequence text2) {
            this.setMatchRange(-1, -1);
            this.myMatched = text2 != null;
        }

        @Override
        public void setMatchRange(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }

        @Override
        public boolean isMatched() {
            return this.myMatched || this.myFrom != -1 || this.myTo != -1;
        }
    }

    static interface LeafSNode
    extends SNode,
    Badable {
        @NotNull
        public String getText();
    }

    static interface StartEndBadable {
        public void setStartBadGroup(@Nullable BadGroup var1);

        @Nullable
        public BadGroup getStartBadGroup();

        public void setEndBadGroup(@Nullable BadGroup var1);

        @Nullable
        public BadGroup getEndBadGroup();
    }

    static interface Badable {
        public void setBadGroup(@Nullable BadGroup var1);

        @Nullable
        public BadGroup getBadGroup();
    }

    static interface Matchable {
        public int getGroupNumber();

        public int getFrom();

        public int getTo();

        public boolean isMatched();

        public void setMatch(@Nullable CharSequence var1);

        public void setMatchRange(int var1, int var2);
    }

    static class BadGroup {
        private String myBadText;
        private int myFrom;
        private int myTo;

        BadGroup() {
            this("");
        }

        BadGroup(@NotNull String text2) {
            if (text2 == null) {
                BadGroup.$$$reportNull$$$0(0);
            }
            this.myFrom = -1;
            this.myTo = -1;
            this.myBadText = text2;
        }

        void setBadText(@NotNull String text2) {
            if (text2 == null) {
                BadGroup.$$$reportNull$$$0(1);
            }
            this.myBadText = text2;
        }

        @NotNull
        String getBadText() {
            String string = this.myBadText;
            if (string == null) {
                BadGroup.$$$reportNull$$$0(2);
            }
            return string;
        }

        public int getTo() {
            return this.myTo;
        }

        public int getFrom() {
            return this.myFrom;
        }

        public void setRange(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$BadGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionNodes$BadGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBadText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setBadText";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static interface NodeVisitor<R> {
        public R visit(@NotNull SNode var1);
    }

    static interface Parameter {
        @NotNull
        public String getValue();

        public void setValue(@NotNull String var1);

        public boolean isValueValid(@NotNull String var1);

        @Nullable
        public String getName();

        @NotNull
        public String getType();
    }
}

