/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.database;

import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DbGridDataHookUpUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportPanel;
import com.intellij.database.dbimport.ui.component.DataPreviewComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponent;
import com.intellij.database.dbimport.ui.database.DatabaseTableEditorComponent;
import com.intellij.database.model.DasObject;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDataPreviewComponent
extends DataPreviewComponent<TableEditorComponent.TableEditorComponentInfo, TableEditorComponent.TableEditorComponentInfo> {
    public static final int PAGE_SIZE = 500;
    private final List<? extends ColumnDescriptor> myInitialProducers;
    private final LocalDataSource myProducerDataSource;
    private final SearchPath myPath;
    private final String myQueryText;
    private final DasObject myTable;
    private final CheckedDisposable myDisposable;
    private ImportPanel myImportPanel;
    private GraphObservable.ObserverListener<?> myListener;

    public DatabaseDataPreviewComponent(@Nullable List<? extends ColumnDescriptor> producers, @NotNull LocalDataSource producerDataSource, @Nullable SearchPath path, @NotNull String queryText, @Nullable DasObject table, @NotNull CheckedDisposable disposable) {
        if (producerDataSource == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(0);
        }
        if (queryText == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(2);
        }
        this.myInitialProducers = producers;
        this.myProducerDataSource = producerDataSource;
        this.myPath = path;
        this.myQueryText = queryText;
        this.myTable = table;
        this.myDisposable = disposable;
    }

    @Override
    public void setImportPanel(@NotNull ImportPanel importPanel) {
        if (importPanel == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(3);
        }
        this.myImportPanel = importPanel;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener2) {
        if (listener2 == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(4);
        }
        this.myListener = listener2;
    }

    @Override
    @NotNull
    public CompletionStage<TableEditorComponent.TableEditorComponentInfo> notifyChanged(@NotNull TableEditorComponent.TableEditorComponentInfo object) {
        ImportEditorContext context;
        if (object == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(5);
        }
        if (object.myContext == null) {
            throw new IllegalArgumentException(DatabaseDataPreviewComponent.class.getName() + " cannot be initialized with null");
        }
        this.myCurrentContext = context = object.myContext;
        if (this.getGrid() != null) {
            CompletableFuture<TableEditorComponent.TableEditorComponentInfo> completableFuture = CompletableFuture.completedFuture(this.myDataLoaded ? TableEditorComponent.TableEditorComponentInfo.create(this.getGrid(), context) : TableEditorComponent.TableEditorComponentInfo.create(this.myInitialProducers, null, this.myCurrentContext));
            if (completableFuture == null) {
                DatabaseDataPreviewComponent.$$$reportNull$$$0(6);
            }
            return completableFuture;
        }
        Project project = context.getProject();
        final DatabaseGridDataHookUp hookUp = DbGridDataHookUpUtil.createReadOnlyDatabaseHookUp(project, this.myProducerDataSource, (Disposable)this.myDisposable, this.myQueryText, this.myTable, DGDepartment.DATA_IMPORT);
        if (this.myPath != null) {
            hookUp.getMessageBus().getDataProducer().processRequest(DataRequest.newSchemaSwitchRequest(hookUp, this.myPath, false));
        }
        final DataGrid grid = DataGridUtil.createPreviewDataGrid(Objects.requireNonNull(project), hookUp);
        Disposer.register((Disposable)this.myDisposable, (Disposable)grid);
        CompletableFuture<TableEditorComponent.TableEditorComponentInfo> future = this.myInitialProducers == null ? new CompletableFuture<TableEditorComponent.TableEditorComponentInfo>() : null;
        hookUp.addRequestListener(new MyRequestListener(future), (Disposable)this.myDisposable);
        hookUp.getPageModel().setPageSize(500);
        UiNotifyConnector.Once.installOn((Component)((Component)((Object)Objects.requireNonNull(this.myImportPanel))), (Activatable)new Activatable(){

            public void showNotify() {
                hookUp.getLoader().loadFirstPage(new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)grid)));
            }
        });
        this.setGrid(grid);
        CompletableFuture<TableEditorComponent.TableEditorComponentInfo> completableFuture = future != null ? future : CompletableFuture.completedFuture(TableEditorComponent.TableEditorComponentInfo.create(this.myInitialProducers, null, this.myCurrentContext));
        if (completableFuture == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    @Override
    public boolean isParentFor(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(8);
        }
        return observer instanceof DatabaseTableEditorComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerDataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyChanged";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setImportPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyChanged";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isParentFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    private final class MyRequestListener
    implements GridDataHookUp.RequestListener<GridRow, GridColumn> {
        private final CompletableFuture<TableEditorComponent.TableEditorComponentInfo> myFuture;

        private MyRequestListener(CompletableFuture<TableEditorComponent.TableEditorComponentInfo> future) {
            this.myFuture = future;
        }

        public void error(@NotNull GridRequestSource source, @NotNull ErrorInfo errorInfo) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(0);
            }
            if (errorInfo == null) {
                MyRequestListener.$$$reportNull$$$0(1);
            }
            this.complete();
        }

        public void requestFinished(@NotNull GridRequestSource source, boolean success) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(2);
            }
            this.complete();
        }

        private void complete() {
            DatabaseDataPreviewComponent.this.myDataLoaded = true;
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!DatabaseDataPreviewComponent.this.myDisposable.isDisposed()) {
                    if (this.myFuture != null) {
                        this.myFuture.complete(TableEditorComponent.TableEditorComponentInfo.create(DatabaseDataPreviewComponent.this.getGrid(), DatabaseDataPreviewComponent.this.myCurrentContext, false));
                    } else {
                        DatabaseDataPreviewComponent.this.myListener.changed(DatabaseDataPreviewComponent.this, TableEditorComponent.TableEditorComponentInfo.create(DatabaseDataPreviewComponent.this.getGrid(), DatabaseDataPreviewComponent.this.myCurrentContext, false));
                    }
                }
            }, ModalityState.current());
        }

        public void updateCountReceived(@NotNull GridRequestSource source, int updateCount2) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent$MyRequestListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

