/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.JdbcIntrospectorNoEscapingOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ResultSetWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.RoutineArgumentIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.RoutineIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableFKeyColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableIndexColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableKeyColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableVersionColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TypeIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.UserDefinedTypeAttributeIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.UserDefinedTypeIt;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseMetaDataWrapper {
    public static final DbmsExtension<MDFactory> EP = new DbmsExtension("com.intellij.database.jdbcMetadataWrapper");
    protected static final Logger LOG = Logger.getInstance(DatabaseMetaDataWrapper.class);
    protected final DatabaseConnectionCore myConnection;
    private final RemoteDatabaseMetaData myMetaData;
    private final java.util.logging.Logger myDbLogger;
    private String myQuote;
    private String myPatternEscape;
    private BiConsumer<@Nullable String, @Nullable Throwable> myErrorSink;

    @NotNull
    public DatabaseMetaDataWrapper withErrorSink(BiConsumer<@Nullable String, @Nullable Throwable> errorSink) {
        this.myErrorSink = errorSink;
        DatabaseMetaDataWrapper databaseMetaDataWrapper = this;
        if (databaseMetaDataWrapper == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(0);
        }
        return databaseMetaDataWrapper;
    }

    @Nullable
    public @Nullable BiConsumer<@Nullable String, @Nullable Throwable> getErrorSink() {
        return this.myErrorSink;
    }

    public void onError(String title, Throwable e) {
        this.myErrorSink.accept(title, e);
    }

    public DatabaseConnectionCore getConnection() {
        return this.myConnection;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myConnection.getDbms();
        if (dbms == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @NotNull
    public static DatabaseMetaDataWrapper create(@NotNull DatabaseConnectionCore connection2, @NotNull RemoteDatabaseMetaData metaData) {
        if (connection2 == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(2);
        }
        if (metaData == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(3);
        }
        Dbms dbms = connection2.getDbms();
        DatabaseMetaDataWrapper databaseMetaDataWrapper = EP.forDbms(dbms).create(connection2, metaData);
        if (databaseMetaDataWrapper == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(4);
        }
        return databaseMetaDataWrapper;
    }

    public DatabaseMetaDataWrapper(@NotNull DatabaseConnectionCore connection2, @NotNull RemoteDatabaseMetaData data) {
        if (connection2 == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(5);
        }
        if (data == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(6);
        }
        this.myConnection = connection2;
        this.myDbLogger = DatabaseGlobalAuditService.logger(connection2.getAuditService().getProject(), connection2);
        this.myMetaData = this.myDbLogger.isLoggable(Level.FINE) ? this.tracingProxy(data) : data;
    }

    private RemoteDatabaseMetaData tracingProxy(final RemoteDatabaseMetaData data) {
        return (RemoteDatabaseMetaData)ReflectionUtil.proxy((ClassLoader)this.getClass().getClassLoader(), RemoteDatabaseMetaData.class, (InvocationHandler)new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
                String invocationSignature = method.getName() + "(" + Arrays.deepToString(args2) + ")";
                DatabaseMetaDataWrapper.this.myDbLogger.fine(invocationSignature);
                try {
                    Object res2 = method.invoke((Object)data, args2);
                    if (!(res2 instanceof Remote)) {
                        DatabaseMetaDataWrapper.this.myDbLogger.fine("result: " + res2);
                    }
                    return res2;
                }
                catch (InvocationTargetException e) {
                    String msg = "Failed to invoke " + invocationSignature + ": " + e.getMessage();
                    DatabaseMetaDataWrapper.this.myDbLogger.log(Level.FINE, msg, e);
                    throw e.getCause();
                }
            }
        });
    }

    public <U, T extends ClosableIt.ResultSetDelegateIt<U>> T setUp(T it) {
        it.withDbLogger(this.myDbLogger);
        it.withErrorSink(this.getErrorSink());
        return it;
    }

    @NotNull
    public ClosableIt<String> databases() throws SQLException {
        ClosableIt<String> res2 = this.catalogs();
        res2.map(StringUtil::notNullize);
        ClosableIt<String> closableIt = res2;
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(7);
        }
        return closableIt;
    }

    protected ClosableIt<String> catalogs() throws SQLException {
        try {
            RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.getMetaData().getCatalogs());
            return this.setUp(new ClosableIt.ResultSetDelegateIt<String>(rs, null){

                @Override
                protected String calcValue() throws SQLException {
                    return this.myRs.getString("TABLE_CAT", 1);
                }
            });
        }
        catch (RuntimeException | SQLException e) {
            String catalog = (String)JdbcNativeUtil.computeRemote(() -> this.getConnection().getRemoteConnection().getCatalog());
            return ClosableIt.from(JBIterable.of((Object)catalog).iterator());
        }
    }

    @NotNull
    public ClosableIt<Schema> schemas(@NotNull JBIterable<String> databases) throws SQLException {
        if (databases == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(8);
        }
        final String current = (String)JdbcNativeUtil.computeRemote(() -> this.myConnection.getRemoteConnection().getCatalog());
        return new ClosableIt.DelegateIt<Schema, Schema>(this.schemas(databases, current)){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    if (current != null) {
                        JdbcNativeUtil.performSafe(() -> DatabaseMetaDataWrapper.this.myConnection.getRemoteConnection().setCatalog(current));
                    }
                }
            }

            @Override
            protected Schema calcValue(Schema cur) {
                return cur;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ClosableIt<Schema> schemas(@NotNull JBIterable<String> catalogs, @Nullable String current) {
        ClosableIt.AutoCloseableGuard<ClosableIt<Schema>> it;
        if (catalogs == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(9);
        }
        if (catalogs.isEmpty()) {
            catalogs = JBIterable.from(Collections.singletonList(current));
        }
        try (ClosableIt.AutoCloseableGuard<ClosableIt<Schema>> it2222 = ClosableIt.AutoCloseableGuard.guarded(DatabaseMetaDataWrapper.eachCatalogs((Iterable<String>)catalogs, (Function<String, ? extends ClosableIt<Schema>>)((Function)c2 -> this.jdbcSchemasInCatalog1((String)c2))));){
            if (it2222.get().hasNext()) {
                ClosableIt<Schema> closableIt = it2222.release();
                return closableIt;
            }
        }
        catch (AbstractMethodError | UnsupportedOperationException it2222) {
            // empty catch block
        }
        if (current != null) {
            it = ClosableIt.AutoCloseableGuard.guarded(DatabaseMetaDataWrapper.eachCatalogs((Iterable<String>)catalogs, (Function<String, ? extends ClosableIt<Schema>>)((Function)c2 -> this.jdbcSchemasInCatalog2((String)c2))));
            try {
                if (it.get().hasNext()) {
                    ClosableIt<Schema> closableIt = it.release();
                    return closableIt;
                }
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        it = ClosableIt.AutoCloseableGuard.guarded(this.jdbcSchemas3((JBIterable<String>)catalogs, current));
        try {
            if (it.get().hasNext()) {
                ClosableIt<Schema> closableIt = it.release();
                return closableIt;
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
        Object cats = catalogs;
        if (!catalogs.isEmpty()) return (ClosableIt)ClosableIt.from(cats.iterator()).map(catalog -> new Schema("", (String)catalog));
        cats = Collections.singleton(null);
        return (ClosableIt)ClosableIt.from(cats.iterator()).map(catalog -> new Schema("", (String)catalog));
    }

    private ClosableIt<Schema> jdbcSchemas3(final JBIterable<String> catalogs, final String current) {
        try {
            RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.getMetaData().getSchemas());
            return this.setUp(new ClosableIt.ResultSetDelegateIt<Schema>(rs, null){
                private Iterator<String> myCats;
                private Schema myCur;
                {
                    super(rs, hook);
                    this.myCats = null;
                    this.myCur = null;
                }

                @Override
                protected Schema calcValue() throws SQLException {
                    String schema = this.myRs.getString("TABLE_SCHEM", 1);
                    String catalog = this.myRs.getString("TABLE_CATALOG", 2);
                    return new Schema(DbUtil.intern(schema), catalog == null ? null : DbUtil.intern(catalog));
                }

                @Override
                protected Schema nextImpl() {
                    if (this.myCats != null && this.myCats.hasNext() && this.myCur != null) {
                        return new Schema(this.myCur.schema, this.myCats.next());
                    }
                    Schema schema = (Schema)super.nextImpl();
                    if (schema == null) {
                        return null;
                    }
                    if (schema.database == null && !catalogs.isEmpty()) {
                        this.myCur = schema;
                        this.myCats = catalogs.iterator();
                        return (Schema)this.skip();
                    }
                    if (schema.database == null) {
                        schema.database = current;
                    }
                    return schema;
                }
            });
        }
        catch (SQLException e) {
            this.onError(null, e);
            return ClosableIt.empty();
        }
    }

    private static ClosableIt<Schema> eachCatalogs(Iterable<String> catalogs, Function<String, ? extends ClosableIt<Schema>> action) {
        Iterator<String> cats = catalogs.iterator();
        if (!cats.hasNext()) {
            return ClosableIt.empty();
        }
        return ClosableIt.generate(() -> cats.hasNext() ? (ClosableIt)action.fun((Object)((String)cats.next())) : null);
    }

    private ClosableIt<Schema> jdbcSchemasInCatalog2(final String catalog) {
        if (catalog == null) {
            return ClosableIt.empty();
        }
        String q = this.getDbms().isTransactSql() ? null : this.getQuote();
        String dbName = q != null ? q + catalog + q : catalog;
        try {
            this.getConnection().getRemoteConnection().setCatalog(dbName);
        }
        catch (Exception ignore) {
            return ClosableIt.empty();
        }
        try {
            return this.setUp(new ClosableIt.ResultSetDelegateIt<Schema>(this.getMetaData().getSchemas(), null){

                @Override
                protected Schema calcValue() throws SQLException {
                    String schema = this.myRs.getString("TABLE_SCHEM", 1);
                    String cat = this.myRs.getString("TABLE_CATALOG", 2);
                    if (cat != null && !cat.equals(catalog)) {
                        return (Schema)this.skip();
                    }
                    return new Schema(DbUtil.intern(schema), catalog);
                }
            });
        }
        catch (Exception ex) {
            this.onError(null, ex);
            return ClosableIt.empty();
        }
    }

    private ClosableIt<Schema> jdbcSchemasInCatalog1(final String catalog) {
        RemoteResultSet rs = DatabaseMetaDataWrapper.getSchemas(catalog, this);
        if (rs == null) {
            return ClosableIt.empty();
        }
        ClosableIt.AutoCloseableGuard<AutoCloseable> g = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteResultSet)rs).close());
        try {
            6 res2 = this.setUp(new ClosableIt.ResultSetDelegateIt<Schema>(rs, null){

                @Override
                protected Schema calcValue() throws SQLException {
                    return new Schema(DbUtil.intern(this.myRs.getString("TABLE_SCHEM", 1)), catalog);
                }
            });
            g.release();
            6 var5_7 = res2;
            if (g != null) {
                g.close();
            }
            return var5_7;
        }
        catch (Throwable throwable) {
            try {
                if (g != null) {
                    try {
                        g.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOG.warn((Throwable)e);
                return ClosableIt.empty();
            }
        }
    }

    private static RemoteResultSet getSchemas(String catalog, DatabaseMetaDataWrapper meta) {
        try {
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> meta.getMetaData().getSchemas(catalog, "%"));
        }
        catch (SQLException ex) {
            try {
                String q = meta.getQuote();
                return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> meta.getMetaData().getSchemas(q + catalog + q, "%"));
            }
            catch (SQLException ex2) {
                return null;
            }
        }
    }

    @NotNull
    public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String name2, String @Nullable [] types) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(10);
        }
        ClosableIt<? extends Table> tableIt = this.tablesInner(schema, name2, types);
        tableIt.filter(tab -> tab.type == null || !StringUtil.containsIgnoreCase((String)tab.type, (String)"TEMPORARY"));
        ClosableIt<? extends Table> closableIt = tableIt;
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(11);
        }
        return closableIt;
    }

    @NotNull
    public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String name2) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(12);
        }
        boolean noCatalog = StringUtil.isEmpty((String)((String)JdbcNativeUtil.computeRemote(() -> ((RemoteDatabaseMetaData)this.myMetaData).getCatalogTerm())));
        String requestCatalog = noCatalog ? pkg : StringUtil.notNullize((String)schema.database);
        ClosableIt<Routine> closableIt = this.append(this.getProceduresInner(requestCatalog, schema, name2, noCatalog), () -> this.getFunctionsInner(requestCatalog, schema, name2, noCatalog));
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(13);
        }
        return closableIt;
    }

    @NotNull
    private ClosableIt<Routine> getProceduresInner(@Nullable String requestCatalog, @NotNull Schema schema, @Nullable String name2, boolean noCatalog) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(14);
        }
        ClosableIt<Routine> closableIt = this.computeMetaDataOr(() -> {
            RemoteResultSet rs = this.myMetaData.getProcedures(requestCatalog, this.escapePattern(schema.schema), this.escapePattern(name2));
            return new RoutineIt(rs, this.getDbms(), schema, noCatalog, true);
        }, ClosableIt::empty);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(15);
        }
        return closableIt;
    }

    @Nullable
    private ClosableIt<Routine> getFunctionsInner(@Nullable String requestCatalog, @NotNull Schema schema, @Nullable String name2, boolean noCatalog) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(16);
        }
        return this.computeMetaDataOr(() -> {
            RemoteResultSet rs = this.myMetaData.getFunctions(requestCatalog, this.getDbms() == Dbms.HIVE ? "" : this.escapePattern(schema.schema), StringUtil.notNullize((String)this.escapePattern(name2), (String)"%"));
            return new RoutineIt(rs, this.getDbms(), schema, noCatalog, false);
        }, null);
    }

    @SafeVarargs
    protected final <T> ClosableIt<T> append(ClosableIt<T> head, ThrowableComputable<ClosableIt<T>, SQLException> ... tail) {
        ClosableIt<T> res2 = head;
        for (ThrowableComputable<ClosableIt<T>, SQLException> fac : tail) {
            if (fac == null) continue;
            res2 = ClosableIt.lazyAppend(res2, this.handleExceptions(fac));
        }
        return res2;
    }

    private <T> Factory<T> handleExceptions(ThrowableComputable<T, SQLException> fac) {
        return () -> {
            try {
                return fac.compute();
            }
            catch (SQLException e) {
                this.onError(null, e);
                return null;
            }
        };
    }

    @NotNull
    public ClosableIt.GroupingIt<TableKey, TableKeyColumn> tableKeys(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(17);
        }
        return new TableKeyColumnIt.Grouping(this.computeMetaDataOr(() -> {
            RemoteResultSet rs = this.myMetaData.getPrimaryKeys(table.schema.database, table.schema.schema, table.name);
            return new TableKeyColumnIt(rs, table);
        }, ClosableIt::empty));
    }

    @Contract(value="_,!null->!null")
    private <T, E extends Exception> ClosableIt<T> computeMetaDataOr(@NotNull ThrowableComputable<ClosableIt.ResultSetDelegateIt<T>, E> comp, @Nullable Computable<ClosableIt<T>> elseVal) throws SQLException {
        if (comp == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(18);
        }
        try {
            ClosableIt.ResultSetDelegateIt it = (ClosableIt.ResultSetDelegateIt)JdbcNativeUtil.computeRemote(comp);
            if (it != null) {
                return this.setUp(it);
            }
        }
        catch (SQLException e) {
            if (!this.isUnimplemented(e)) {
                throw e;
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        return elseVal == null ? null : (ClosableIt)elseVal.compute();
    }

    @NotNull
    public ClosableIt.GroupingIt<Table, TableColumn> tableColumns(@NotNull Schema schema, @Nullable String tableName, @Nullable Iterable<String> expectedTables) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(19);
        }
        return new TableColumnIt.Grouping(this.getTableColumnsInner(schema, tableName, expectedTables));
    }

    @NotNull
    protected ClosableIt<TableColumn> getTableColumnsInner(@NotNull Schema schema, @Nullable String tableName, @Nullable Iterable<String> expectedTables) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(20);
        }
        if (tableName != null || expectedTables == null) {
            assert (expectedTables == null);
            ClosableIt<TableColumn> closableIt = this.getTableColumnsInner2(schema, tableName);
            if (closableIt == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(21);
            }
            return closableIt;
        }
        ClosableIt<TableColumn> it = this.getAllTablesColumns(schema);
        ClosableIt<TableColumn> closableIt = ClosableIt.lazyAppendIfEmpty(it != null ? it : ClosableIt.empty(), () -> this.getTableColumnsFromExpectedTables(schema, expectedTables));
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(22);
        }
        return closableIt;
    }

    protected ClosableIt<TableColumn> getAllTablesColumns(@NotNull Schema schema) {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(23);
        }
        try {
            return this.getTableColumnsInner2(schema, null);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    @NotNull
    protected ClosableIt<TableColumn> getTableColumnsFromExpectedTables(@NotNull Schema schema, @NotNull Iterable<String> expectedTables) {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(24);
        }
        if (expectedTables == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(25);
        }
        Iterator<String> tableIt = expectedTables.iterator();
        ClosableIt<TableColumn> closableIt = ClosableIt.generate(() -> {
            Application app = ApplicationManager.getApplication();
            while (tableIt.hasNext()) {
                String table = (String)tableIt.next();
                try {
                    return this.getTableColumnsInner2(schema, table);
                }
                catch (Exception e) {
                    boolean ignore = (app == null || app.isUnitTestMode()) && e.getMessage() != null && e.getMessage().contains("no such table");
                    if (ignore) continue;
                    this.onError("failed to retrieve columns for " + table, e);
                }
            }
            return null;
        });
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(26);
        }
        return closableIt;
    }

    @NotNull
    protected ClosableIt<TableColumn> getTableColumnsInner2(@NotNull Schema schema, @Nullable String tableName) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(27);
        }
        ClosableIt<TableColumn> closableIt = this.computeMetaDataOr(() -> {
            RemoteResultSet rs = this.myMetaData.getColumns(StringUtil.notNullize((String)schema.database), this.escapePattern(schema.schema), StringUtil.notNullize((String)this.escapePattern(tableName), (String)"%"), "%");
            return new TableColumnIt(rs, this.getDbms(), schema);
        }, ClosableIt::empty);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(28);
        }
        return closableIt;
    }

    @NotNull
    public ClosableIt.GroupingIt<Routine, RoutineArgument> routineArguments(@NotNull Schema schema, @Nullable String routineName, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(29);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(30);
        }
        return new RoutineArgumentIt.Grouping(this.routineArgumentsInner(schema, routineName, kindProvider));
    }

    @NotNull
    public ClosableIt<RoutineArgument> routineArgumentsInner(@NotNull Schema schema, @Nullable String routineName, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
        boolean noCatalog;
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(31);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(32);
        }
        String requestCatalog = (noCatalog = StringUtil.isEmpty((String)((String)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getCatalogTerm())))) ? schema.database : StringUtil.notNullize((String)schema.database);
        ClosableIt<RoutineArgument> closableIt = this.append(this.getProcedureArgumentsInner(requestCatalog, schema, routineName, kindProvider, noCatalog), () -> this.getFunctionArgumentsInner(requestCatalog, schema, routineName, kindProvider, noCatalog));
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(33);
        }
        return closableIt;
    }

    @NotNull
    private ClosableIt<RoutineArgument> getProcedureArgumentsInner(String requestCatalog, @NotNull Schema schema, @Nullable String routineName, @NotNull Function<Routine, DasRoutine.Kind> kindProvider, boolean noCatalog) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(34);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(35);
        }
        ClosableIt<RoutineArgument> closableIt = this.computeMetaDataOr(() -> {
            RemoteResultSet wrapper = this.getRoutineArgumentsWrapper(new Schema(schema.schema, requestCatalog), routineName);
            return wrapper == null ? null : new RoutineArgumentIt(wrapper, this.getDbms(), schema, noCatalog, kindProvider, true);
        }, ClosableIt::empty);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(36);
        }
        return closableIt;
    }

    @Nullable
    private ClosableIt<RoutineArgument> getFunctionArgumentsInner(String requestCatalog, @NotNull Schema schema, @Nullable String functionName, @NotNull Function<Routine, DasRoutine.Kind> kindProvider, boolean noCatalog) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(37);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(38);
        }
        return this.computeMetaDataOr(() -> {
            RemoteResultSet rs = this.myMetaData.getFunctionColumns(requestCatalog, this.escapePattern(schema.schema), this.escapePattern(functionName), null);
            return new RoutineArgumentIt(rs, this.getDbms(), schema, noCatalog, kindProvider, false);
        }, null);
    }

    protected boolean isUnimplemented(SQLException e) {
        String message = e.getMessage();
        if ((this.getDbms().isSqlite() || this.getDbms() == Dbms.SNOWFLAKE) && message == null && e.getCause() == null) {
            return true;
        }
        return message != null && (StringUtil.containsIgnoreCase((String)message, (String)"implemented") || StringUtil.containsIgnoreCase((String)message, (String)"unsupported") || StringUtil.containsIgnoreCase((String)message, (String)"not support") || StringUtil.containsIgnoreCase((String)message, (String)"not yet supported"));
    }

    @NotNull
    public ClosableIt.GroupingIt<TableFKey, TableFKeyColumn> tableFKeyColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(39);
        }
        return new TableFKeyColumnIt.Grouping(this.computeMetaDataOr(() -> {
            RemoteResultSet rs = this.myMetaData.getImportedKeys(table.schema.database, table.schema.schema, table.name);
            return new TableFKeyColumnIt(rs, table);
        }, ClosableIt::empty));
    }

    @NotNull
    public ClosableIt.GroupingIt<TableIndex, TableIndexColumn> tableIndexColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(40);
        }
        return new TableIndexColumnIt.Grouping(this.computeMetaDataOr(() -> {
            RemoteResultSet rs = this.getTableIndexColumnsWrapper(table);
            return new TableIndexColumnIt(rs, table, this.getDbms());
        }, ClosableIt::empty));
    }

    @NotNull
    public ClosableIt<TableColumn> tableVersionColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(41);
        }
        ClosableIt<TableColumn> closableIt = this.computeMetaDataOr(() -> {
            RemoteResultSet rs = this.myMetaData.getVersionColumns(table.schema.database, table.schema.schema, table.name);
            return new TableVersionColumnIt(rs, table);
        }, ClosableIt::empty);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(42);
        }
        return closableIt;
    }

    @Nullable
    private RemoteResultSet getRoutineArgumentsWrapper(@NotNull Schema schema, @Nullable String routineName) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(43);
        }
        try {
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getProcedureColumns(schema.database, this.escapePattern(schema.schema), StringUtil.notNullize((String)this.escapePattern(routineName), (String)"%"), null));
        }
        catch (NullPointerException e) {
            if (this.getDbms().isSqlite()) {
                LOG.debug((Throwable)e);
                return null;
            }
            throw e;
        }
        catch (SQLException e) {
            if (this.isUnimplemented(e)) {
                return null;
            }
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getProcedureColumns(schema.database, this.escapePattern(schema.schema), "%", null));
        }
    }

    private RemoteResultSet getTableIndexColumnsWrapper(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(44);
        }
        try {
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getIndexInfo(table.schema.database, table.schema.schema, table.name, false, true));
        }
        catch (SQLException ex) {
            try {
                String q = this.getQuote();
                return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getIndexInfo(q + table.schema.database + q, q + table.schema.schema + q, q + table.name + q, false, true));
            }
            catch (SQLException ex2) {
                throw ex;
            }
        }
    }

    public String getQuote() {
        if (this.myQuote == null) {
            try {
                this.myQuote = (String)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getIdentifierQuoteString());
            }
            catch (SQLException e) {
                this.myQuote = "\"";
                this.onError(null, e);
            }
        }
        return this.myQuote;
    }

    public String getPatternEscape() {
        if (this.myPatternEscape == null) {
            try {
                boolean dontEscape;
                LocalDataSource dataSource = this.myConnection.getConnectionPoint().getDataSource();
                boolean bl = dontEscape = this.isBrokenEscaping() || Boolean.TRUE.equals(DbOptionProvider.getOptionValue(dataSource, JdbcIntrospectorNoEscapingOptionProvider.class));
                if (!dontEscape) {
                    this.myPatternEscape = (String)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getSearchStringEscape());
                }
                if (this.myPatternEscape == null) {
                    this.myPatternEscape = "";
                }
            }
            catch (SQLException e) {
                this.myPatternEscape = "";
                this.onError(null, e);
            }
        }
        return this.myPatternEscape;
    }

    protected boolean isBrokenEscaping() {
        return false;
    }

    private String escapePattern(String p2) {
        if (p2 == null) {
            return null;
        }
        String e = this.getPatternEscape();
        if (StringUtil.isEmpty((String)e)) {
            return p2;
        }
        return p2.replace("_", e + "_").replace("%", e + "%");
    }

    public String[] getAllTableTypes() throws SQLException {
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getTableTypes());
        if (rs == null) {
            return null;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        try {
            while (JdbcNativeUtil.getBooleanSafe(() -> rs.next())) {
                result2.add(StringUtil.trim((String)((String)JdbcNativeUtil.computeRemote(() -> rs.getString("TABLE_TYPE")))));
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception e) {
            this.myErrorSink.accept(null, e);
        }
        return result2.isEmpty() ? null : ArrayUtilRt.toStringArray(result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ClosableIt<? extends Table> tablesInner(@NotNull Schema schema, @Nullable String name2, String @Nullable [] types) {
        boolean hasNext;
        ResultSetWrapper rs;
        block10: {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(45);
            }
            rs = null;
            try {
                try {
                    RemoteResultSet resultSet = this.myMetaData.getTables(schema.database, this.escapePattern(schema.schema), StringUtil.notNullize((String)this.escapePattern(name2), (String)"%"), types);
                    rs = new ResultSetWrapper(resultSet);
                    hasNext = rs.next();
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    ClosableIt closableIt = types == null ? ClosableIt.empty() : this.tablesInner(schema, name2, null);
                    ResultSetWrapper.close(rs);
                    ClosableIt closableIt2 = closableIt;
                    if (closableIt2 == null) {
                        DatabaseMetaDataWrapper.$$$reportNull$$$0(46);
                    }
                    return closableIt2;
                }
            }
            catch (Throwable throwable) {
                ResultSetWrapper.close(rs);
                throw throwable;
            }
            if (hasNext || types == null || types.length == 1) break block10;
            ClosableIt<? extends Table> e = this.tablesInner(schema, name2, null);
            ResultSetWrapper.close(rs);
            ClosableIt<? extends Table> closableIt = e;
            if (closableIt == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(47);
            }
            return closableIt;
        }
        TableIt it = this.setUp(this.createTableIt(schema, rs, hasNext));
        rs = null;
        TableIt tableIt = it;
        ResultSetWrapper.close(rs);
        TableIt tableIt2 = tableIt;
        if (tableIt2 == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(48);
        }
        return tableIt2;
    }

    @NotNull
    protected TableIt createTableIt(@NotNull Schema schema, ResultSetWrapper rs, boolean hasNext) {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(49);
        }
        return new TableIt(rs, hasNext, schema);
    }

    @NotNull
    public ClosableIt<? extends UserDefinedType> userDefinedTypes(@NotNull Schema schema, @Nullable String typeName) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(50);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getUDTs(schema.database, this.escapePattern(schema.schema), StringUtil.notNullize((String)this.escapePattern(typeName), (String)"%"), null));
        return new UserDefinedTypeIt(rs, schema);
    }

    @NotNull
    public ClosableIt<? extends Type> types() throws SQLException {
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getTypeInfo());
        return new TypeIt(rs);
    }

    @NotNull
    public ClosableIt.GroupingIt<UserDefinedType, UserDefinedTypeAttribute> userDefinedTypeAttributes(@NotNull Schema schema, @Nullable String attrName, @Nullable Set<String> types) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(51);
        }
        UserDefinedTypeAttributeIt.Grouping res2 = new UserDefinedTypeAttributeIt.Grouping(this.userDefinedTypeAttributesInner(schema, attrName));
        ClosableIt.GroupingIt groupingIt = types != null ? (ClosableIt.GroupingIt)res2.filter(t -> types.contains(t.name)) : res2;
        if (groupingIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(52);
        }
        return groupingIt;
    }

    @NotNull
    protected ClosableIt<UserDefinedTypeAttribute> userDefinedTypeAttributesInner(@NotNull Schema schema, @Nullable String attrName) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(53);
        }
        try {
            RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getAttributes(schema.database, this.escapePattern(schema.schema), "%", StringUtil.notNullize((String)this.escapePattern(attrName), (String)"%")));
            return new UserDefinedTypeAttributeIt(rs, this.getDbms(), schema);
        }
        catch (SQLException e) {
            if (this.isUnimplemented(e)) {
                ClosableIt<UserDefinedTypeAttribute> closableIt = ClosableIt.empty();
                if (closableIt == null) {
                    DatabaseMetaDataWrapper.$$$reportNull$$$0(54);
                }
                return closableIt;
            }
            throw e;
        }
    }

    @NotNull
    public RemoteDatabaseMetaData getMetaData() {
        RemoteDatabaseMetaData remoteDatabaseMetaData = this.myMetaData;
        if (remoteDatabaseMetaData == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(55);
        }
        return remoteDatabaseMetaData;
    }

    @Nullable
    public Casing getCasing() {
        return DataSourceInfo.getCasing(this.getDbms(), this.myMetaData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6, 8, 9, 10, 12, 14, 16, 17, 18, 19, 20, 23, 24, 25, 27, 29, 30, 31, 32, 34, 35, 37, 38, 39, 40, 41, 43, 44, 45, 49, 50, 51, 53 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databases";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogs";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 37: 
            case 43: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 17: 
            case 39: 
            case 40: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTables";
                break;
            }
            case 30: 
            case 32: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withErrorSink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "databases";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "tables";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "routines";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProceduresInner";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableColumnsInner";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableColumnsFromExpectedTables";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableColumnsInner2";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "routineArgumentsInner";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcedureArgumentsInner";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "tableVersionColumns";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "tablesInner";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "userDefinedTypeAttributes";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "userDefinedTypeAttributesInner";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "schemas";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tables";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "routines";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getProceduresInner";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionsInner";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tableKeys";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeMetaDataOr";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tableColumns";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumnsInner";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAllTablesColumns";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumnsFromExpectedTables";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumnsInner2";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "routineArguments";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "routineArgumentsInner";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getProcedureArgumentsInner";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionArgumentsInner";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "tableFKeyColumns";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "tableIndexColumns";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "tableVersionColumns";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getRoutineArgumentsWrapper";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getTableIndexColumnsWrapper";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "tablesInner";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createTableIt";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypes";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypeAttributes";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypeAttributesInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6, 8, 9, 10, 12, 14, 16, 17, 18, 19, 20, 23, 24, 25, 27, 29, 30, 31, 32, 34, 35, 37, 38, 39, 40, 41, 43, 44, 45, 49, 50, 51, 53 -> new IllegalArgumentException(string);
        };
    }

    public static class MDFactory {
        @NotNull
        public DatabaseMetaDataWrapper create(@NotNull DatabaseConnectionCore connection2, @NotNull RemoteDatabaseMetaData metaData) {
            if (connection2 == null) {
                MDFactory.$$$reportNull$$$0(0);
            }
            if (metaData == null) {
                MDFactory.$$$reportNull$$$0(1);
            }
            return new DatabaseMetaDataWrapper(connection2, metaData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "metaData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$MDFactory";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Schema
    implements Assignable<Schema> {
        @NotNull
        public String schema;
        @Nullable
        public String database;

        public Schema(@NotNull String schema, @Nullable String database) {
            if (schema == null) {
                Schema.$$$reportNull$$$0(0);
            }
            this.schema = schema;
            this.database = database;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Schema", "<init>"));
        }
    }

    public static class Table
    implements Assignable<Table> {
        public final Schema schema;
        @NotNull
        public String name;
        @Nullable
        public String type;
        @Nullable
        public String comment;

        public Table(@NotNull Schema schema, @NotNull String name2) {
            if (schema == null) {
                Table.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                Table.$$$reportNull$$$0(1);
            }
            this.schema = schema;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "schema";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Table";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UserDefinedType
    implements Assignable<UserDefinedType> {
        public final Schema schema;
        @Nullable
        public String name;
        @Nullable
        public String comment;

        public UserDefinedType(@NotNull Schema schema) {
            if (schema == null) {
                UserDefinedType.$$$reportNull$$$0(0);
            }
            this.schema = schema;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$UserDefinedType", "<init>"));
        }
    }

    public static class RoutineArgument
    extends TypedElement {
        public final Routine routine;
        public int position;
        @Nullable
        public String name;
        @Nullable
        public String def;
        public ArgumentDirection direction;
        @Nullable
        public String comment;

        public RoutineArgument(@NotNull Routine routine2) {
            if (routine2 == null) {
                RoutineArgument.$$$reportNull$$$0(0);
            }
            this.routine = routine2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$RoutineArgument", "<init>"));
        }
    }

    public static class Routine
    implements Assignable<Routine> {
        public final Schema schema;
        @Nullable
        public String pkg;
        @NotNull
        public String name;
        public short number;
        @NotNull
        public String specificName;
        @Nullable
        public String comment;
        @NotNull
        public DasRoutine.Kind kind;

        public Routine(@NotNull Schema schema, @Nullable String pkg, @NotNull String name2) {
            if (schema == null) {
                Routine.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                Routine.$$$reportNull$$$0(1);
            }
            this.number = 0;
            this.specificName = "";
            this.kind = DasRoutine.Kind.NONE;
            this.schema = schema;
            this.pkg = pkg;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "schema";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Routine";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UserDefinedTypeAttribute
    implements Assignable<UserDefinedTypeAttribute> {
        public final UserDefinedType userDefinedType;
        @Nullable
        public String name;
        public int type;
        @Nullable
        public String typeName;
        @Nullable
        public String comment;
        public int length;
        public int scale;
        public boolean nullable;
        @Nullable
        public String def;
        public int position;

        public UserDefinedTypeAttribute(@NotNull UserDefinedType userDefinedType) {
            if (userDefinedType == null) {
                UserDefinedTypeAttribute.$$$reportNull$$$0(0);
            }
            this.userDefinedType = userDefinedType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userDefinedType", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$UserDefinedTypeAttribute", "<init>"));
        }
    }

    public static class Type
    implements Assignable<Type> {
        @Nullable
        public String name;
    }

    public static class TableIndexColumn
    implements Assignable<TableIndexColumn> {
        public final TableIndex index;
        @Nullable
        public String name;
        public short position;
        public DasIndex.Sorting sorting;

        public TableIndexColumn(@NotNull TableIndex index) {
            if (index == null) {
                TableIndexColumn.$$$reportNull$$$0(0);
            }
            this.index = index;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableIndexColumn", "<init>"));
        }
    }

    public static class TableFKeyColumn
    implements Assignable<TableFKeyColumn> {
        public final TableFKey fk;
        @Nullable
        public String name;
        @Nullable
        public String targetName;
        public short position;

        public TableFKeyColumn(@NotNull TableFKey fk) {
            if (fk == null) {
                TableFKeyColumn.$$$reportNull$$$0(0);
            }
            this.fk = fk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableFKeyColumn", "<init>"));
        }
    }

    public static class TableKeyColumn
    implements Assignable<TableKeyColumn> {
        public final TableKey key;
        @Nullable
        public String name;
        public short position;

        public TableKeyColumn(@NotNull TableKey key2) {
            if (key2 == null) {
                TableKeyColumn.$$$reportNull$$$0(0);
            }
            this.key = key2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableKeyColumn", "<init>"));
        }
    }

    public static class TableIndex
    implements Assignable<TableIndex> {
        public final Table table;
        @Nullable
        public String name;
        public boolean nonUnique;
        @Nullable
        public String qualifier;
        public short type;
        @Nullable
        public String condition;

        public TableIndex(@NotNull Table table, @Nullable String name2) {
            if (table == null) {
                TableIndex.$$$reportNull$$$0(0);
            }
            this.table = table;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableIndex", "<init>"));
        }
    }

    public static class TableFKey
    implements Assignable<TableFKey> {
        public final Table table;
        public final Table targetTable;
        @Nullable
        public String name;
        public boolean surrogateName;
        public short updateRule;
        public short deleteRule;
        public short deferrability;

        public TableFKey(@NotNull Table table, @NotNull Table targetTable, @Nullable String name2) {
            if (table == null) {
                TableFKey.$$$reportNull$$$0(0);
            }
            if (targetTable == null) {
                TableFKey.$$$reportNull$$$0(1);
            }
            this.table = table;
            this.targetTable = targetTable;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetTable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableFKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TableKey
    implements Assignable<TableKey> {
        public final Table table;
        @Nullable
        public String name;
        public boolean primary;

        public TableKey(@NotNull Table table, @Nullable String name2) {
            if (table == null) {
                TableKey.$$$reportNull$$$0(0);
            }
            this.table = table;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableKey", "<init>"));
        }
    }

    public static class TableColumn
    extends TypedElement {
        public final Table table;
        public int position;
        @Nullable
        public String name;
        @Nullable
        public String def;
        public boolean autoIncrement;
        @Nullable
        public String comment;

        public TableColumn(@NotNull Table table) {
            if (table == null) {
                TableColumn.$$$reportNull$$$0(0);
            }
            this.table = table;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableColumn", "<init>"));
        }
    }

    public static class TypedElement
    extends JdbcHelper.Type
    implements Assignable<TypedElement> {
    }

    public static interface Assignable<T extends Assignable<T>> {
        default public void assign(T val) {
            try {
                for (Field field : this.getClass().getFields()) {
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    Object o = field.get(val);
                    if (Assignable.class.isAssignableFrom(field.getType())) {
                        ((Assignable)field.get(this)).assign((Assignable)o);
                        continue;
                    }
                    field.set(this, o);
                }
            }
            catch (IllegalAccessException e) {
                ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }
}

