/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.bigquery.BigQueryTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BigQueryDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public BigQueryDialect() {
        super(new TypeHelper.BQTypeHelper());
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "BigQuery";
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.BIGQUERY;
        if (dbms == null) {
            BigQueryDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    public boolean supportsEmptyTables() {
        return true;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return ObjectKind.DATABASE;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            BigQueryDialect.$$$reportNull$$$0(1);
        }
        if (identifier == null) {
            BigQueryDialect.$$$reportNull$$$0(2);
        }
        if (qualifier == null) {
            BigQueryDialect.$$$reportNull$$$0(3);
        }
        DasObject schema = BigQueryDialect.getSchema(qualifier);
        DasObject database = BigQueryDialect.getDatabase(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName(schema), database, DasUtil.getName(database), null, null);
        if (ddlBuilder == null) {
            BigQueryDialect.$$$reportNull$$$0(4);
        }
        return ddlBuilder;
    }

    @Nullable
    private static DasObject getSchema(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            BigQueryDialect.$$$reportNull$$$0(5);
        }
        return (schema = DasUtil.getSchemaObject(qualifier)) == null || StringUtil.isEmpty((String)schema.getName()) ? null : schema;
    }

    @Nullable
    private static DasObject getDatabase(@NotNull DasObject qualifier) {
        DasObject database;
        if (qualifier == null) {
            BigQueryDialect.$$$reportNull$$$0(6);
        }
        return (database = DasUtil.getCatalogObject(qualifier)) == null || StringUtil.isEmpty((String)database.getName()) ? null : database;
    }

    @Override
    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection2) throws SQLException {
        String s;
        if (connection2 == null) {
            BigQueryDialect.$$$reportNull$$$0(7);
        }
        return StringUtil.isEmpty((String)(s = (String)JdbcNativeUtil.computeRemote(() -> connection2.getRemoteConnection().getCatalog()))) ? null : SearchPath.of(ObjectPath.create(s, ObjectKind.DATABASE));
    }

    @Override
    public boolean triggersIntrospection(@NotNull PsiElement element) {
        if (element == null) {
            BigQueryDialect.$$$reportNull$$$0(8);
        }
        return !BigQueryDialect.isTempElement(element) && super.triggersIntrospection(element);
    }

    private static boolean isTempElement(@NotNull PsiElement element) {
        if (element == null) {
            BigQueryDialect.$$$reportNull$$$0(9);
        }
        return (element instanceof SqlCreateProcedureStatement || element instanceof SqlCreateTableStatement) && SqlImplUtil.getChildOfType(element, BigQueryTypes.BQ_TEMP) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/bigquery/BigQueryDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/bigquery/BigQueryDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSchema";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDatabase";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTempElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

