/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.redis.RedisDbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlDmlStatement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedisDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    private RedisDialect() {
        super(new TypeHelper(){

            @Override
            public String getTypeName(int code, int length, int precision, int scale) {
                return null;
            }
        });
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = RedisDbms.REDIS;
        if (dbms == null) {
            RedisDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Redis";
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            RedisDialect.$$$reportNull$$$0(1);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("SELECT %s", current.getDisplayName());
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection2) {
        if (connection2 == null) {
            RedisDialect.$$$reportNull$$$0(2);
        }
        RemoteConnection remoteConnection = connection2.getRemoteConnection();
        String schema = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)remoteConnection).getSchema());
        return schema == null ? null : SearchPath.of(ObjectPath.create(StringUtil.notNullize((String)schema), ObjectKind.SCHEMA));
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return false;
    }

    @Override
    public boolean triggersIntrospection(@NotNull PsiElement element) {
        if (element == null) {
            RedisDialect.$$$reportNull$$$0(3);
        }
        return element instanceof SqlDmlStatement || super.triggersIntrospection(element);
    }

    @Override
    public boolean supportsQualificationBySchema() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            RedisDialect.$$$reportNull$$$0(4);
        }
        if (identifier == null) {
            RedisDialect.$$$reportNull$$$0(5);
        }
        if (qualifier == null) {
            RedisDialect.$$$reportNull$$$0(6);
        }
        DdlBuilder ddlBuilder = builder.identifier(object, identifier);
        if (ddlBuilder == null) {
            RedisDialect.$$$reportNull$$$0(7);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/redis/RedisDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/redis/RedisDialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

