/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.applier.DbCollectionModelApplier;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbKeyColumnsModelApplier<E extends BasicModColumniation, C extends KeyColumn>
extends DbCollectionModelApplier<E, C> {
    public DbKeyColumnsModelApplier() {
        super(BasicModColumniation.COL_NAMES);
    }

    @Override
    public C createItem(@Nullable C src) {
        return (C)new KeyColumn((KeyColumn)src);
    }

    @Override
    public final void applyImpl(@NotNull DbEditorModel<E, DbCollectionModelState<C>> model, @NotNull ElementOwner owner, @NotNull E e) {
        if (model == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(1);
        }
        if (e == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(2);
        }
        this.applyItems(owner, e, model.getState().getItems());
    }

    protected void applyItems(@NotNull ElementOwner owner, @NotNull E e, @NotNull List<C> items) {
        if (owner == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(3);
        }
        if (e == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(4);
        }
        if (items == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(5);
        }
        e.setColNames(ContainerUtil.map(items, c2 -> this.getColName(owner, c2)));
    }

    @NotNull
    protected String getColName(@NotNull ElementOwner owner, C c2) {
        if (owner == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(6);
        }
        String string = ColumnApplyHelper.getReferenceValue(((KeyColumn)c2).name, owner);
        if (string == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public final void resetImpl(@NotNull DbEditorModel<E, DbCollectionModelState<C>> model, @NotNull ElementOwner owner, @NotNull E e) {
        if (model == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(8);
        }
        if (owner == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(9);
        }
        if (e == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(10);
        }
        model.getState().setItems(this.extractColumns(model, owner, e));
    }

    @NotNull
    protected List<C> extractColumns(@NotNull DbEditorModel<E, DbCollectionModelState<C>> model, @NotNull ElementOwner owner, @NotNull E e) {
        if (model == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(11);
        }
        if (owner == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(12);
        }
        if (e == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(13);
        }
        List<String> names = e.getColNames();
        ArrayList<Object> columns = new ArrayList<Object>(names.size());
        ElementIdentity<?> tableId = model.getController().getMatcher().getParent(model.getIdentity());
        for (String name2 : names) {
            Object c2 = this.createItem((C)null);
            ColumnApplyHelper.identifyAndSetTargetId(owner, tableId, this.sanitizeColName(name2), false, ((KeyColumn)c2).name, model);
            columns.add(c2);
        }
        ArrayList<Object> arrayList = columns;
        if (arrayList == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    protected String sanitizeColName(String name2) {
        return name2;
    }

    @Override
    public void resolveImpl(@NotNull DbEditorModel<E, DbCollectionModelState<C>> model, @NotNull ElementOwner owner, @NotNull E e) {
        if (model == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(15);
        }
        if (owner == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(16);
        }
        if (e == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(17);
        }
        List copy = ContainerUtil.map(model.getState().getItems(), this::createItem);
        this.resolveItems(model, owner, e, copy);
        model.getState().setItems(copy);
    }

    protected void resolveItems(@NotNull DbEditorModel<E, DbCollectionModelState<C>> model, @NotNull ElementOwner owner, @NotNull E e, List<C> items) {
        if (model == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(18);
        }
        if (owner == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(19);
        }
        if (e == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(20);
        }
        ElementIdentity<?> tableId = model.getController().getMatcher().getParent(model.getIdentity());
        for (KeyColumn item : items) {
            ColumnApplyHelper.resolve(owner, tableId, ColumnApplyHelper.getReferenceValue(item.name, owner), item.name, model);
        }
    }

    @Override
    public boolean differsFromImpl(@NotNull DbEditorModel<E, DbCollectionModelState<C>> model, @NotNull ElementOwner owner, @NotNull E e) {
        if (model == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(21);
        }
        if (owner == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(22);
        }
        if (e == null) {
            DbKeyColumnsModelApplier.$$$reportNull$$$0(23);
        }
        return !this.extractColumns(model, owner, e).equals(model.getState().getItems());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/applier/DbKeyColumnsModelApplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbKeyColumnsModelApplier";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyItems";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getColName";
                break;
            }
            case 7: 
            case 14: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractColumns";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveImpl";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveItems";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "differsFromImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 14 -> new IllegalStateException(string);
        };
    }

    public static class KeyColumn {
        @NotNull
        public final ColumnNameState name;

        public KeyColumn(@Nullable KeyColumn src) {
            this.name = new ColumnNameState(src == null ? null : src.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyColumn)) {
                return false;
            }
            KeyColumn column2 = (KeyColumn)o;
            return this.name.equals(column2.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static final class ColumnNameState {
        private String myValue = "";
        private String myCheckName = "";
        private ElementIdentity<?> myTargetId;

        public ColumnNameState(@Nullable ColumnNameState src) {
            this.myValue = src == null ? "" : src.myValue;
            this.myCheckName = src == null ? "" : src.myCheckName;
            this.myTargetId = src == null ? null : src.myTargetId;
        }

        @NlsSafe
        @NotNull
        public String getValue() {
            String string = this.myValue;
            if (string == null) {
                ColumnNameState.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void setValue(@NotNull String value, @NotNull NamingService ns) {
            if (value == null) {
                ColumnNameState.$$$reportNull$$$0(1);
            }
            if (ns == null) {
                ColumnNameState.$$$reportNull$$$0(2);
            }
            if (Objects.equals(value, this.myValue)) {
                return;
            }
            this.myTargetId = null;
            this.myCheckName = ns.unquoteIdentifier(value);
            this.myValue = value;
        }

        @Nullable
        public ElementIdentity<?> getTargetId() {
            return this.myTargetId;
        }

        @NotNull
        public String getActualName() {
            String string = this.myCheckName;
            if (string == null) {
                ColumnNameState.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean setTargetId(@Nullable ElementIdentity<?> targetId, @NotNull String checkName, @NotNull String storedRef) {
            if (checkName == null) {
                ColumnNameState.$$$reportNull$$$0(4);
            }
            if (storedRef == null) {
                ColumnNameState.$$$reportNull$$$0(5);
            }
            if (Objects.equals(checkName, this.myCheckName) && Objects.equals(this.myValue, storedRef) && this.myTargetId == targetId) {
                return false;
            }
            this.myTargetId = targetId;
            this.myCheckName = checkName;
            this.myValue = storedRef;
            return true;
        }

        public boolean updateRef(@NotNull String checkName, @NotNull String storedRef) {
            if (checkName == null) {
                ColumnNameState.$$$reportNull$$$0(6);
            }
            if (storedRef == null) {
                ColumnNameState.$$$reportNull$$$0(7);
            }
            if (checkName.equals(this.myCheckName)) {
                return false;
            }
            this.myCheckName = checkName;
            this.myValue = storedRef;
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ColumnNameState)) {
                return false;
            }
            ColumnNameState state = (ColumnNameState)o;
            return Objects.equals(this.myValue, state.myValue) && Objects.equals(this.myCheckName, state.myCheckName) && Objects.equals(this.myTargetId, state.myTargetId);
        }

        public int hashCode() {
            return Objects.hash(this.myValue, this.myCheckName, this.myTargetId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/model/applier/DbKeyColumnsModelApplier$ColumnNameState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ns";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "checkName";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storedRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbKeyColumnsModelApplier$ColumnNameState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActualName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setTargetId";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "updateRef";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class ColumnApplyHelper {
        @NotNull
        public static String getReferenceValue(@NotNull ColumnNameState state, @Nullable ElementOwner owner) {
            BasicElement target2;
            if (state == null) {
                ColumnApplyHelper.$$$reportNull$$$0(0);
            }
            if ((target2 = ColumnApplyHelper.getTarget(owner, state.getTargetId())) == null) {
                String string = state.getActualName();
                if (string == null) {
                    ColumnApplyHelper.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = target2.getName();
            if (string == null) {
                ColumnApplyHelper.$$$reportNull$$$0(2);
            }
            return string;
        }

        public static boolean resolve(@Nullable ElementOwner owner, @Nullable ElementIdentity<?> tableId, @NotNull String name2, @NotNull ColumnNameState state, @NotNull DbEditorModel<?, ?> context) {
            String ref2;
            ElementIdentity<?> targetId;
            if (name2 == null) {
                ColumnApplyHelper.$$$reportNull$$$0(3);
            }
            if (state == null) {
                ColumnApplyHelper.$$$reportNull$$$0(4);
            }
            if (context == null) {
                ColumnApplyHelper.$$$reportNull$$$0(5);
            }
            if ((targetId = state.getTargetId()) == null) {
                NamingService ns = NamingServices.getNamingService(context.getDbms());
                String unquotedName = ns.unquoteIdentifier(name2);
                return ColumnApplyHelper.setTargetId(owner, ColumnApplyHelper.identifyColumn(owner, tableId, unquotedName), ns, unquotedName, true, state, context);
            }
            BasicElement target2 = ColumnApplyHelper.getTarget(owner, targetId);
            String string = ref2 = target2 == null ? null : target2.getName();
            if (ref2 != null) {
                return state.updateRef(ref2, ColumnApplyHelper.getText(NamingServices.getNamingService(context.getDbms()), ref2, targetId));
            }
            return false;
        }

        private static BasicElement getTarget(@Nullable ElementOwner owner, @Nullable ElementIdentity<?> targetId) {
            if (owner == null || targetId == null) {
                return null;
            }
            Object target2 = owner.find(targetId);
            if (target2 != null) {
                return target2;
            }
            ElementOwner original = owner.getOriginal();
            if (original == null) {
                return null;
            }
            return original.find(targetId);
        }

        public static void identifyAndSetTargetId(@Nullable ElementOwner owner, @Nullable ElementIdentity<?> tableId, @NotNull String name2, boolean keepText, @NotNull ColumnNameState state, @NotNull DbEditorModel<?, ?> context) {
            if (name2 == null) {
                ColumnApplyHelper.$$$reportNull$$$0(6);
            }
            if (state == null) {
                ColumnApplyHelper.$$$reportNull$$$0(7);
            }
            if (context == null) {
                ColumnApplyHelper.$$$reportNull$$$0(8);
            }
            NamingService ns = NamingServices.getNamingService(context.getDbms());
            String unquotedName = ns.unquoteIdentifier(name2);
            ColumnApplyHelper.setTargetId(owner, ColumnApplyHelper.identifyColumn(owner, tableId, unquotedName), ns, unquotedName, keepText, state, context);
        }

        private static boolean setTargetId(@Nullable ElementOwner owner, @Nullable ElementIdentity<?> targetId, @NotNull NamingService ns, @NotNull String name2, boolean keepText, @NotNull ColumnNameState state, @NotNull DbEditorModel<?, ?> context) {
            BasicElement target2;
            if (ns == null) {
                ColumnApplyHelper.$$$reportNull$$$0(9);
            }
            if (name2 == null) {
                ColumnApplyHelper.$$$reportNull$$$0(10);
            }
            if (state == null) {
                ColumnApplyHelper.$$$reportNull$$$0(11);
            }
            if (context == null) {
                ColumnApplyHelper.$$$reportNull$$$0(12);
            }
            String targetRef = (target2 = ColumnApplyHelper.getTarget(owner, targetId)) == null ? name2 : target2.getName();
            return state.setTargetId(targetId, targetRef, keepText ? state.getValue() : ColumnApplyHelper.getText(ns, targetRef, targetId));
        }

        @NotNull
        private static String getText(@NotNull NamingService ns, @NotNull String targetRef, @Nullable ElementIdentity<?> targetId) {
            if (ns == null) {
                ColumnApplyHelper.$$$reportNull$$$0(13);
            }
            if (targetRef == null) {
                ColumnApplyHelper.$$$reportNull$$$0(14);
            }
            String string = targetId == null ? targetRef : ns.catToScript(targetRef, ObjectKind.COLUMN, true);
            if (string == null) {
                ColumnApplyHelper.$$$reportNull$$$0(15);
            }
            return string;
        }

        @Nullable
        private static ElementIdentity<?> identifyColumn(@Nullable ElementOwner owner, @Nullable ElementIdentity<?> tableId, @NotNull String name2) {
            BasicMixinElement table;
            if (name2 == null) {
                ColumnApplyHelper.$$$reportNull$$$0(16);
            }
            BasicMixinElement basicMixinElement = table = owner == null || tableId == null ? null : (BasicMixinElement)owner.find(tableId);
            if (table == null) {
                return null;
            }
            BasicElement column2 = (BasicElement)table.getDasChildren(ObjectKind.COLUMN).find(o -> o.getName().equals(name2));
            return column2 == null ? null : owner.identify(column2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: 
                case 2: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/model/applier/DbKeyColumnsModelApplier$ColumnApplyHelper";
                    break;
                }
                case 3: 
                case 6: 
                case 10: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: 
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ns";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbKeyColumnsModelApplier$ColumnApplyHelper";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceValue";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferenceValue";
                    break;
                }
                case 1: 
                case 2: 
                case 15: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "identifyAndSetTargetId";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setTargetId";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "identifyColumn";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 15 -> new IllegalStateException(string);
            };
        }
    }
}

