/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.statistic.SessionsUsagesCollectorsKt;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.NullableEnumEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/statistic/SwitchSessionUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nSessionsUsagesCollectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionsUsagesCollectors.kt\ncom/intellij/database/statistic/SwitchSessionUsagesCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,50:1\n262#2,3:51\n262#2,3:54\n302#2,4:57\n*S KotlinDebug\n*F\n+ 1 SessionsUsagesCollectors.kt\ncom/intellij/database/statistic/SwitchSessionUsagesCollector\n*L\n19#1:51,3\n20#1:54,3\n21#1:57,4\n*E\n"})
public final class SwitchSessionUsagesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final EventId3<Companion.ClientType, Companion.ClientCount, Companion.ClientType> SWITCH_SESSION_EVENT;

    @NotNull
    public EventLogGroup getGroup() {
        return SessionsUsagesCollectorsKt.access$getGROUP$p();
    }

    static {
        EventFields $this$iv;
        Companion = new Companion(null);
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "new_client_type";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        EnumEventField enumEventField = new EnumEventField(name$iv, Companion.ClientType.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "cur_client_count";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        EnumEventField enumEventField2 = new EnumEventField(name$iv, Companion.ClientCount.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "cur_single_client_type";
        String nullValue$iv = null;
        Function1 transform$iv2 = $this$iv.getDefaultEnumTransform();
        boolean $i$f$NullableEnum = false;
        SWITCH_SESSION_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)SessionsUsagesCollectorsKt.access$getGROUP$p(), (String)"switched", (EventField)((EventField)enumEventField), (EventField)((EventField)enumEventField2), (EventField)((EventField)new NullableEnumEventField(name$iv, Companion.ClientType.class, nullValue$iv, null, transform$iv2)), null, (int)16, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/statistic/SwitchSessionUsagesCollector$Companion;", "", "<init>", "()V", "SWITCH_SESSION_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "Lcom/intellij/database/statistic/SwitchSessionUsagesCollector$Companion$ClientType;", "Lcom/intellij/database/statistic/SwitchSessionUsagesCollector$Companion$ClientCount;", "clientCount", "clients", "", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "([Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;)Lcom/intellij/database/statistic/SwitchSessionUsagesCollector$Companion$ClientCount;", "clientType", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "log", "", "oldSession", "Lcom/intellij/database/console/session/DatabaseSession;", "newSession", "ClientCount", "ClientType", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nSessionsUsagesCollectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionsUsagesCollectors.kt\ncom/intellij/database/statistic/SwitchSessionUsagesCollector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ClientCount clientCount(DatabaseSessionClientWithFile[] clients) {
            return switch (clients.length) {
                case 0 -> ClientCount.ZERO;
                case 1 -> ClientCount.ONE;
                default -> ClientCount.MANY;
            };
        }

        private final ClientType clientType(VirtualFile virtualFile) {
            return DbVFSUtils.isConsoleFile(virtualFile) ? ClientType.CONSOLE : (DatabaseEditorUtil.isTableFile(virtualFile) ? ClientType.GRID : (DbImplUtil.isDatabaseVirtualFile(virtualFile) ? null : ClientType.FILE));
        }

        public final void log(@NotNull VirtualFile virtualFile, @Nullable DatabaseSession oldSession, @Nullable DatabaseSession newSession) {
            ClientType clientType;
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            if (oldSession == null || newSession == null) {
                return;
            }
            if (!Intrinsics.areEqual((Object)((DatabaseConnectionPoint)oldSession.getTarget()).getDataSource(), (Object)((DatabaseConnectionPoint)newSession.getTarget()).getDataSource())) {
                return;
            }
            ClientType clientType2 = this.clientType(virtualFile);
            if (clientType2 == null) {
                return;
            }
            ClientType newClientType = clientType2;
            Object[] clients = newSession.getClientsWithFile();
            ClientCount curClientCount = this.clientCount((DatabaseSessionClientWithFile[])clients);
            DatabaseSessionClientWithFile databaseSessionClientWithFile = (DatabaseSessionClientWithFile)ArraysKt.singleOrNull((Object[])clients);
            if (databaseSessionClientWithFile != null) {
                DatabaseSessionClientWithFile it = databaseSessionClientWithFile;
                boolean bl = false;
                clientType = Companion.clientType(it.getVirtualFile());
            } else {
                clientType = null;
            }
            ClientType curSingleClientType = clientType;
            SWITCH_SESSION_EVENT.log((Object)newClientType, (Object)curClientCount, (Object)curSingleClientType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/statistic/SwitchSessionUsagesCollector$Companion$ClientCount;", "", "<init>", "(Ljava/lang/String;I)V", "ZERO", "ONE", "MANY", "intellij.database.impl"})
        private static final class ClientCount
        extends Enum<ClientCount> {
            public static final /* enum */ ClientCount ZERO = new ClientCount();
            public static final /* enum */ ClientCount ONE = new ClientCount();
            public static final /* enum */ ClientCount MANY = new ClientCount();
            private static final /* synthetic */ ClientCount[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ClientCount[] values() {
                return (ClientCount[])$VALUES.clone();
            }

            public static ClientCount valueOf(String value) {
                return Enum.valueOf(ClientCount.class, value);
            }

            @NotNull
            public static EnumEntries<ClientCount> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = clientCountArray = new ClientCount[]{ClientCount.ZERO, ClientCount.ONE, ClientCount.MANY};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/statistic/SwitchSessionUsagesCollector$Companion$ClientType;", "", "<init>", "(Ljava/lang/String;I)V", "GRID", "CONSOLE", "FILE", "intellij.database.impl"})
        private static final class ClientType
        extends Enum<ClientType> {
            public static final /* enum */ ClientType GRID = new ClientType();
            public static final /* enum */ ClientType CONSOLE = new ClientType();
            public static final /* enum */ ClientType FILE = new ClientType();
            private static final /* synthetic */ ClientType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ClientType[] values() {
                return (ClientType[])$VALUES.clone();
            }

            public static ClientType valueOf(String value) {
                return Enum.valueOf(ClientType.class, value);
            }

            @NotNull
            public static EnumEntries<ClientType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = clientTypeArray = new ClientType[]{ClientType.GRID, ClientType.CONSOLE, ClientType.FILE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

