/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.Dbms;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DbExtractorConfig;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.SqlInsertsExtractorFactory;
import com.intellij.database.extractors.SqlUpdatesExtractorFactory;
import com.intellij.database.extractors.XlsxExtractorFactory;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.run.actions.DbTablesSource;
import com.intellij.database.run.actions.DumpAction;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.settings.CsvSettings;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.ui.DumpDataDialog;
import com.intellij.database.view.ui.DumpDataForm;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDumpDataForm
extends DumpDataForm {
    private static final List<DataConsumer.Column> MONGO_PREVIEW_COLUMNS = Arrays.asList(new DataConsumer.Column(0, "_id", 1111, "objectId", "org.bson.types.ObjectId"), new DataConsumer.Column(1, "first_name", 12, "string", "java.lang.String"), new DataConsumer.Column(2, "last_name", 12, "string", "java.lang.String"), new DataConsumer.Column(3, "gender", 12, "string", "java.lang.String"), new DataConsumer.Column(4, "phones", 1111, "array", "java.lang.List"));
    private static final List<DataConsumer.Row> MONGO_PREVIEW_ROWS = Arrays.asList(DataConsumer.Row.create((int)0, (Object[])new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5e5e7711f704714f53ebf2af"), "Georgi", "Facello", "M", Arrays.asList("136-73018", "458-97405")}), DataConsumer.Row.create((int)1, (Object[])new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6a"), "Bezalel", "Simmel", "F", Collections.singletonList("869-28540")}), DataConsumer.Row.create((int)2, (Object[])new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5e580fcbbdfc015d7d5d401e"), "Parto", "Bamford", "M", Arrays.asList("752-48018", "752-25445")}), DataConsumer.Row.create((int)3, (Object[])new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5e580fcbbdfc015d7d5d401f"), "Chirstian", "Koblick", "M", Collections.emptyList()}), DataConsumer.Row.create((int)4, (Object[])new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a70"), "Kyoichi", "Maliniak", "M", Collections.singletonList("985-85742")}), DataConsumer.Row.create((int)5, (Object[])new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6e"), "Anneke", "Preusig", "F", Collections.emptyList()}), DataConsumer.Row.create((int)6, (Object[])new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6c"), "Tzvetan", "Zielinski", "F", Collections.singletonList("574-76427")}), DataConsumer.Row.create((int)7, (Object[])new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a79"), "Saniya", "Kalloufi", "M", Collections.singletonList("362-98543")}), DataConsumer.Row.create((int)8, (Object[])new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a7a"), "Sumant", "Peac", "F", Arrays.asList("462-24753", "324524")}), DataConsumer.Row.create((int)9, (Object[])new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a7c"), "Duangkaew", "Piveteau", "F", Collections.singletonList("356-08750")}));

    public DbDumpDataForm(@NotNull DumpDataDialog dialog, @NotNull Project project, @NotNull DumpSource<?> source) {
        if (dialog == null) {
            DbDumpDataForm.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DbDumpDataForm.$$$reportNull$$$0(1);
        }
        if (source == null) {
            DbDumpDataForm.$$$reportNull$$$0(2);
        }
        super(project, source, () -> dialog.getWindow(), (CsvFormatsSettings)CsvSettings.getSettings(), dialog.getDisposable(), true);
    }

    @Nullable
    protected String getSourceText(@Nullable DumpSource<?> source) {
        if (source instanceof DumpSource.DataGridSource) {
            DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)((DumpSource.DataGridSource)source).getGrid());
            return table == null ? null : QNameUtil.getQualifiedName(table);
        }
        if (source instanceof DbTablesSource) {
            StringBuilder sb = new StringBuilder();
            for (DbElement target2 : ((DbTablesSource)source).getSources()) {
                if (sb.length() != 0) {
                    sb.append("\n");
                }
                sb.append(QNameUtil.getQualifiedName(target2));
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        return null;
    }

    protected boolean supportsAddComputedOrGeneratedColumns(DataExtractorFactory factory) {
        return factory instanceof SqlInsertsExtractorFactory;
    }

    protected boolean supportsTranspose(DataExtractorFactory factory) {
        return super.supportsTranspose(factory) || !(factory instanceof SqlInsertsExtractorFactory) && !(factory instanceof SqlUpdatesExtractorFactory) && !(factory instanceof XlsxExtractorFactory);
    }

    protected boolean supportsAddTableDefinition(DataExtractorFactory factory) {
        return factory instanceof SqlInsertsExtractorFactory;
    }

    @NotNull
    protected ExtractorConfig createConfig(@NotNull Project project, @NotNull DumpSource<?> source) {
        if (project == null) {
            DbDumpDataForm.$$$reportNull$$$0(3);
        }
        if (source == null) {
            DbDumpDataForm.$$$reportNull$$$0(4);
        }
        DataGrid grid = source instanceof DumpSource.DataGridSource ? ((DumpSource.DataGridSource)source).getGrid() : null;
        DasObject table = grid != null ? DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)grid) : null;
        Dbms dbms = DumpAction.getDbms(source);
        Object formatter = grid != null ? grid.getObjectFormatter() : new DbObjectFormatter(dbms);
        DbDataSource system = DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)grid);
        return new DbExtractorConfig(project, dbms, (ObjectFormatter)formatter, table, system == null ? null : system.getVersion());
    }

    protected List<? extends GridRow> getRows(@NotNull DumpSource<?> source) {
        Dbms dbms;
        if (source == null) {
            DbDumpDataForm.$$$reportNull$$$0(5);
        }
        return (dbms = DumpAction.getDbms(source)).isMongo() ? MONGO_PREVIEW_ROWS : super.getRows(source);
    }

    protected List<? extends GridColumn> getColumns(@NotNull DumpSource<?> source) {
        Dbms dbms;
        if (source == null) {
            DbDumpDataForm.$$$reportNull$$$0(6);
        }
        return (dbms = DumpAction.getDbms(source)).isMongo() ? MONGO_PREVIEW_COLUMNS : super.getColumns(source);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/view/DbDumpDataForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRows";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getColumns";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

