/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.Dbms;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.util.common.MapFun;
import com.intellij.database.util.common.TreeFun;
import com.intellij.database.view.structure.DvTreeAbstractLayer;
import com.intellij.database.view.structure.DvTreeCacheLayer;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeDsFoldersLayer;
import com.intellij.database.view.structure.DvTreeFundamentLayer;
import com.intellij.database.view.structure.DvTreeImplantingLayer;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeModelLayer;
import com.intellij.database.view.structure.DvTreeOptimizationLayer;
import com.intellij.database.view.structure.DvTreeRootLayer;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.database.view.structure.DvTreeTransformLayer;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010*\u001a\u00020(J\u0016\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0,2\u0006\u0010*\u001a\u00020(J\u000e\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020(J\u000e\u0010/\u001a\u00020.2\u0006\u0010*\u001a\u00020(J\u000e\u00100\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020(J\u0013\u00101\u001a\u000702\u00a2\u0006\u0002\b32\u0006\u0010*\u001a\u00020(J\u000e\u00104\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020(J\u0019\u00105\u001a\b\u0012\u0004\u0012\u00020(0\u000f2\u0006\u0010*\u001a\u00020(\u00a2\u0006\u0002\u00106J#\u00107\u001a\b\u0012\u0004\u0012\u00020(0\u000f2\u0006\u0010*\u001a\u00020(2\u0006\u00108\u001a\u00020.H\u0002\u00a2\u0006\u0002\u00109J\u0006\u0010:\u001a\u00020\u001cJ\u0006\u0010;\u001a\u00020\u001eJ\u0010\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u0019H\u0002J\u0010\u0010>\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u0019H\u0002J$\u0010?\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u00192\b\u0010@\u001a\u0004\u0018\u00010A2\b\u0010B\u001a\u0004\u0018\u00010AH\u0002J\u0010\u0010C\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u0019H\u0002J\u0018\u0010D\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u001aH\u0002J\u000e\u0010F\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020\u0019J\u0018\u0010F\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u001aH\u0002J\u000e\u0010H\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020\u0019J\"\u0010I\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u00192\b\u0010@\u001a\u0004\u0018\u00010A2\b\u0010B\u001a\u0004\u0018\u00010AJ\u000e\u0010J\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020\u0019J\u000e\u0010K\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020\u0019J\u0018\u0010K\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u001aH\u0002J\u0010\u0010L\u001a\u00020\u001e2\u0006\u0010E\u001a\u00020\u001aH\u0002J\u0006\u0010M\u001a\u00020\u001eJ\u0010\u0010N\u001a\u00020\u00162\u0006\u0010O\u001a\u00020PH\u0007J\u0013\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0007\u00a2\u0006\u0002\u0010RJ\u0006\u0010S\u001a\u000202R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fX\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001c0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001e\u0010$\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#\u00a8\u0006T"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructure;", "", "project", "Lcom/intellij/openapi/project/Project;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/view/structure/DvViewOptions;)V", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "getContext", "()Lcom/intellij/database/view/structure/DvTreeContext;", "fundamentLayer", "Lcom/intellij/database/view/structure/DvTreeFundamentLayer;", "storeyLayers", "", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "[Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "activeLayers", "Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "[Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "upperLayer", "Lcom/intellij/database/view/structure/DvTreeLayer;", "dsDbms", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/database/model/RawDataSource;", "Lcom/intellij/database/Dbms;", "actualDbms", "", "setupLayers", "", "layoutLayer", "getLayoutLayer", "()Lcom/intellij/database/view/structure/DvTreeLayer;", "setLayoutLayer", "(Lcom/intellij/database/view/structure/DvTreeLayer;)V", "foldersLayer", "getFoldersLayer", "setFoldersLayer", "getRootNode", "Lcom/intellij/database/model/basic/BasicNode;", "parentOf", "node", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "countAllChildrenOf", "", "countRealChildrenOf", "isAlwaysLeaf", "presentableNameOf", "", "Lcom/intellij/openapi/util/NlsSafe;", "isValid", "getPath", "(Lcom/intellij/database/model/basic/BasicNode;)[Lcom/intellij/database/model/basic/BasicNode;", "getPathArray", "depth", "(Lcom/intellij/database/model/basic/BasicNode;I)[Lcom/intellij/database/model/basic/BasicNode;", "hasDataSourcesThatSupportMultilevel", "onViewOptionsChanged", "onDataSourceAdded", "dataSource", "onDataSourcePathChanged", "onDataSourceModelReplaced", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "onDataSourceChanged", "onDataSourceRemoved", "dbms", "dataSourceAdded", "ds", "notifyDataSourcePathChanged", "dataSourceModelReplaced", "dataSourceChanged", "dataSourceRemoved", "recheckDbms", "clearAll", "layer", "level", "", "getActiveLayers", "()[Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "dumpTheTree", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeStructure.kt\ncom/intellij/database/view/structure/DvTreeStructure\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArrayFun.kt\ncom/intellij/database/util/common/ArrayFun\n*L\n1#1,225:1\n37#2,2:226\n13409#3,2:228\n13409#3,2:230\n13409#3,2:232\n13409#3,2:234\n13409#3,2:236\n10#4,2:238\n10#4,2:240\n*S KotlinDebug\n*F\n+ 1 DvTreeStructure.kt\ncom/intellij/database/view/structure/DvTreeStructure\n*L\n63#1:226,2\n113#1:228,2\n117#1:230,2\n121#1:232,2\n125#1:234,2\n129#1:236,2\n133#1:238,2\n203#1:240,2\n*E\n"})
public class DvTreeStructure {
    @NotNull
    private final DvTreeContext context;
    @NotNull
    private final DvTreeFundamentLayer fundamentLayer;
    @NotNull
    private final DvTreeStoreyLayer[] storeyLayers;
    private DvTreeAbstractLayer[] activeLayers;
    private DvTreeLayer upperLayer;
    @NotNull
    private final ConcurrentHashMap<RawDataSource, Dbms> dsDbms;
    @NotNull
    private final ConcurrentHashMap<Dbms, Boolean> actualDbms;
    @ApiStatus.Internal
    public DvTreeLayer layoutLayer;
    @ApiStatus.Internal
    public DvTreeLayer foldersLayer;

    public DvTreeStructure(@NotNull Project project, @NotNull DvViewOptions viewOptions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        this.context = new DvTreeContext(project, viewOptions);
        this.fundamentLayer = new DvTreeRootLayer();
        DvTreeStoreyLayer[] dvTreeStoreyLayerArray = new DvTreeStoreyLayer[]{new DvTreeModelLayer(), new DvTreeDsFoldersLayer(), new DvTreeImplantingLayer(), new DvTreeLayoutLayer(), new DvTreeTransformLayer(), new DvTreeOptimizationLayer(), new DvTreeCacheLayer()};
        this.storeyLayers = dvTreeStoreyLayerArray;
        this.dsDbms = new ConcurrentHashMap();
        this.actualDbms = new ConcurrentHashMap();
        this.setupLayers();
    }

    @NotNull
    public final DvTreeContext getContext() {
        return this.context;
    }

    private final void setupLayers() {
        ArrayList layers = new ArrayList();
        this.fundamentLayer.setup$intellij_database_core_impl(this.context);
        ((Collection)layers).add(this.fundamentLayer);
        DvTreeAbstractLayer currentLayer = this.fundamentLayer;
        for (DvTreeStoreyLayer layer : this.storeyLayers) {
            layer.setup$intellij_database_core_impl(currentLayer);
            ((Collection)layers).add(layer);
            currentLayer = layer;
            DvTreeStoreyLayer dvTreeStoreyLayer = layer;
            if (dvTreeStoreyLayer instanceof DvTreeDsFoldersLayer) {
                this.setFoldersLayer(layer);
                continue;
            }
            if (!(dvTreeStoreyLayer instanceof DvTreeLayoutLayer)) continue;
            this.setLayoutLayer(layer);
        }
        this.upperLayer = currentLayer;
        Collection $this$toTypedArray$iv = layers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.activeLayers = thisCollection$iv.toArray(new DvTreeAbstractLayer[0]);
    }

    @NotNull
    public final DvTreeLayer getLayoutLayer() {
        DvTreeLayer dvTreeLayer = this.layoutLayer;
        if (dvTreeLayer != null) {
            return dvTreeLayer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"layoutLayer");
        return null;
    }

    public final void setLayoutLayer(@NotNull DvTreeLayer dvTreeLayer) {
        Intrinsics.checkNotNullParameter((Object)dvTreeLayer, (String)"<set-?>");
        this.layoutLayer = dvTreeLayer;
    }

    @NotNull
    public final DvTreeLayer getFoldersLayer() {
        DvTreeLayer dvTreeLayer = this.foldersLayer;
        if (dvTreeLayer != null) {
            return dvTreeLayer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"foldersLayer");
        return null;
    }

    public final void setFoldersLayer(@NotNull DvTreeLayer dvTreeLayer) {
        Intrinsics.checkNotNullParameter((Object)dvTreeLayer, (String)"<set-?>");
        this.foldersLayer = dvTreeLayer;
    }

    @NotNull
    public final BasicNode getRootNode() {
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.getRoot();
    }

    @Nullable
    public final BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.parentOf(node);
    }

    @NotNull
    public final JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.childrenOf(node);
    }

    public final int countAllChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.countAllChildrenOf(node);
    }

    public final int countRealChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.countRealChildrenOf(node);
    }

    public final boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.isAlwaysLeaf(node);
    }

    @NotNull
    public final String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.presentableNameOf(node);
    }

    public final boolean isValid(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.isValid(node);
    }

    @NotNull
    public final BasicNode[] getPath(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getPathArray(node, 1);
    }

    private final BasicNode[] getPathArray(BasicNode node, int depth) {
        BasicNode p2 = this.parentOf(node);
        if (p2 == node) {
            throw new InternalError("The method DvTreeStructureService.parentOf() works incorrectly for node: " + node + " (node class: " + node.getClass().getSimpleName() + ")");
        }
        if (p2 == null) {
            BasicNode[] result2 = new BasicNode[depth];
            result2[0] = node;
            return result2;
        }
        BasicNode[] result3 = this.getPathArray(p2, depth + 1);
        result3[result3.length - depth] = node;
        return result3;
    }

    public final boolean hasDataSourcesThatSupportMultilevel() {
        return MapFun.containsKeys((Map)this.actualDbms, DvTreeStructure::hasDataSourcesThatSupportMultilevel$lambda$0);
    }

    public final void onViewOptionsChanged() {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it.onViewOptionsChanged$intellij_database_core_impl();
        }
    }

    private final void onDataSourceAdded(RawDataSource dataSource) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it.onDataSourceAdded$intellij_database_core_impl(dataSource);
        }
    }

    private final void onDataSourcePathChanged(RawDataSource dataSource) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it.onDataSourcePathChanged$intellij_database_core_impl(dataSource);
        }
    }

    private final void onDataSourceModelReplaced(RawDataSource dataSource, BasicModel oldModel, BasicModel newModel) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it.onDataSourceModelReplaced$intellij_database_core_impl(dataSource, oldModel, newModel);
        }
    }

    private final void onDataSourceChanged(RawDataSource dataSource) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it.onDataSourceChanged$intellij_database_core_impl(dataSource);
        }
    }

    private final void onDataSourceRemoved(RawDataSource dataSource, Dbms dbms) {
        Object[] objectArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            objectArray = null;
        }
        Object[] $this$forEachReversed$iv = objectArray;
        boolean $i$f$forEachReversed = false;
        for (int i$iv = ArraysKt.getLastIndex((Object[])$this$forEachReversed$iv); -1 < i$iv; --i$iv) {
            Object it = $this$forEachReversed$iv[i$iv];
            boolean bl = false;
            ((DvTreeAbstractLayer)it).onDataSourceRemoved$intellij_database_core_impl(dataSource, dbms);
        }
    }

    public final void dataSourceAdded(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Dbms dbms = ds.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        this.dataSourceAdded(ds, dbms);
    }

    private final void dataSourceAdded(RawDataSource ds, Dbms dbms) {
        ((Map)this.dsDbms).put(ds, dbms);
        ((Map)this.actualDbms).put(dbms, true);
        this.onDataSourceAdded(ds);
    }

    public final void notifyDataSourcePathChanged(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        this.onDataSourcePathChanged(ds);
    }

    public final void dataSourceModelReplaced(@NotNull RawDataSource dataSource, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.onDataSourceModelReplaced(dataSource, oldModel, newModel);
    }

    public final void dataSourceChanged(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Dbms dbms = ds.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms newDbms = dbms;
        Dbms oldDbms = this.dsDbms.get(ds);
        if (oldDbms == null) {
            this.dataSourceAdded(ds, newDbms);
        } else if (!Intrinsics.areEqual((Object)oldDbms, (Object)newDbms)) {
            this.dataSourceRemoved(ds, oldDbms);
            this.dataSourceAdded(ds, newDbms);
        } else {
            this.onDataSourceChanged(ds);
        }
    }

    public final void dataSourceRemoved(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Dbms dbms = ds.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        this.dataSourceRemoved(ds, dbms);
    }

    private final void dataSourceRemoved(RawDataSource ds, Dbms dbms) {
        this.dsDbms.remove(ds);
        this.onDataSourceRemoved(ds, dbms);
        if (this.actualDbms.containsKey(dbms)) {
            this.recheckDbms(dbms);
        }
    }

    private final void recheckDbms(Dbms dbms) {
        boolean exists = this.dsDbms.containsValue(dbms);
        if (exists) {
            ((Map)this.actualDbms).put(dbms, true);
        } else {
            this.actualDbms.remove(dbms);
        }
    }

    public final void clearAll() {
        Object[] objectArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            objectArray = null;
        }
        Object[] $this$forEachReversed$iv = objectArray;
        boolean $i$f$forEachReversed = false;
        for (int i$iv = ArraysKt.getLastIndex((Object[])$this$forEachReversed$iv); -1 < i$iv; --i$iv) {
            Object it = $this$forEachReversed$iv[i$iv];
            boolean bl = false;
            ((DvTreeAbstractLayer)it).clearAll();
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public final DvTreeLayer layer(byte level) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        for (DvTreeAbstractLayer layer : dvTreeAbstractLayerArray) {
            if (layer.getLevel() != level) continue;
            return layer;
        }
        throw new IllegalArgumentException("No layer with level " + level);
    }

    @ApiStatus.Internal
    @NotNull
    public final DvTreeAbstractLayer[] getActiveLayers() {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        return (DvTreeAbstractLayer[])dvTreeAbstractLayerArray.clone();
    }

    @NotNull
    public final String dumpTheTree() {
        BasicNode root = this.getRootNode();
        String text2 = TreeFun.dumpTree(root, (Function1)new Function1<BasicNode, JBIterable<? extends BasicNode>>((Object)this){

            public final JBIterable<? extends BasicNode> invoke(BasicNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DvTreeStructure)this.receiver).childrenOf(p0);
            }
        }, "    ", DvTreeStructure::dumpTheTree$lambda$8);
        return text2;
    }

    private static final boolean hasDataSourcesThatSupportMultilevel$lambda$0(Dbms d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return DBIntrospectorFeatures.supportsMultilevelIntrospection(d);
    }

    private static final String dumpTheTree$lambda$8(BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }
}

