/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.util.containers.JBIterable;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001b\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/editor/SqlBreadcrumbsProvider;", "Lcom/intellij/ui/breadcrumbs/BreadcrumbsProvider;", "<init>", "()V", "isShownByDefault", "", "getLanguages", "", "Lcom/intellij/sql/psi/SqlLanguage;", "kotlin.jvm.PlatformType", "()[Lcom/intellij/sql/psi/SqlLanguage;", "acceptElement", "element", "Lcom/intellij/psi/PsiElement;", "getElementInfo", "", "getElementIcon", "Ljavax/swing/Icon;", "getElementTooltip", "Companion", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlBreadcrumbsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlBreadcrumbsProvider.kt\ncom/intellij/sql/editor/SqlBreadcrumbsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class SqlBreadcrumbsProvider
implements BreadcrumbsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_LENGTH = 50;

    public boolean isShownByDefault() {
        return false;
    }

    @NotNull
    public SqlLanguage[] getLanguages() {
        SqlLanguage[] sqlLanguageArray = new SqlLanguage[]{SqlLanguage.INSTANCE};
        return sqlLanguageArray;
    }

    public boolean acceptElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PsiObject;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiObject) {
            String string = StringUtil.shortenTextWithEllipsis((String)((PsiObject)element).getName(), (int)50, (int)0, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            String text2 = string;
            return element instanceof DasRoutine ? text2 + "()" : text2;
        }
        throw new IllegalStateException(("Incorrect element: " + element).toString());
    }

    @Nullable
    public Icon getElementIcon(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = element instanceof PsiObject ? (PsiObject)element : null;
        if (object == null || (object = object.getKind()) == null) {
            return null;
        }
        Object kind = object;
        return DbPresentation.getIcon((ObjectKind)kind);
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement element) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof PsiObject)) {
            return null;
        }
        Dbms dbms = SqlImplUtil.getSqlDialectSafe(element).getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        String string = DbPresentation.getPresentableName((DasObject)element, true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
        String name2 = string;
        StringBuilder $this$getElementTooltip_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (element instanceof DasRoutine) {
            String string2;
            String it = string2 = (switch (WhenMappings.$EnumSwitchMapping$0[((DasRoutine)element).getRoutineKind().ordinal()]) {
                case 1 -> "procedure";
                case 2 -> "function";
                default -> "routine";
            });
            boolean bl2 = false;
            $this$getElementTooltip_u24lambda_u245.append(it);
            $this$getElementTooltip_u24lambda_u245.append(" " + name2);
            JBIterable jBIterable = JBIterable.from(((DasRoutine)element).getArguments()).filter(arg_0 -> SqlBreadcrumbsProvider.getElementTooltip$lambda$5$lambda$2(SqlBreadcrumbsProvider::getElementTooltip$lambda$5$lambda$1, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            CollectionsKt.joinTo$default((Iterable)((Iterable)jBIterable), (Appendable)$this$getElementTooltip_u24lambda_u245, null, (CharSequence)"(", (CharSequence)")", (int)0, null, SqlBreadcrumbsProvider::getElementTooltip$lambda$5$lambda$3, (int)50, null);
            DasArgument dasArgument = ((DasRoutine)element).getReturnArgument();
            if (dasArgument != null) {
                DasArgument it2 = dasArgument;
                boolean bl3 = false;
                $this$getElementTooltip_u24lambda_u245.append(": ");
                $this$getElementTooltip_u24lambda_u245.append(it2.getDasType().getSpecification());
            }
        } else {
            $this$getElementTooltip_u24lambda_u245.append(DbPresentation.getPresentableName(((PsiObject)element).getKind(), dbms2));
            $this$getElementTooltip_u24lambda_u245.append(" " + name2);
            if (element instanceof DasTypedObject) {
                $this$getElementTooltip_u24lambda_u245.append(": ");
                $this$getElementTooltip_u24lambda_u245.append(((DasTypedObject)element).getDasType().getSpecification());
            }
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    private static final boolean getElementTooltip$lambda$5$lambda$1(DasArgument it) {
        return it.getArgumentDirection().isIn() || it.getArgumentDirection().isOut();
    }

    private static final boolean getElementTooltip$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence getElementTooltip$lambda$5$lambda$3(DasArgument it) {
        return it.getName() + ": " + it.getDasType().getSpecification();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/editor/SqlBreadcrumbsProvider$Companion;", "", "<init>", "()V", "MAX_LENGTH", "", "intellij.database.sql.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasRoutine.Kind.values().length];
            try {
                nArray[DasRoutine.Kind.PROCEDURE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasRoutine.Kind.FUNCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

