/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewDiffPreviewProcessorKt;
import com.intellij.openapi.vcs.changes.ChangesViewUserObjectTag;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDiffPreviewHandler;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewDiffPreviewHandler;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDiffPreviewHandler;", "<init>", "()V", "iterateSelectedChanges", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "iterateAllChanges", "selectChange", "", "change", "intellij.platform.vcs.impl"})
public final class ChangesViewDiffPreviewHandler
extends ChangesTreeDiffPreviewHandler {
    @NotNull
    public static final ChangesViewDiffPreviewHandler INSTANCE = new ChangesViewDiffPreviewHandler();

    private ChangesViewDiffPreviewHandler() {
    }

    @NotNull
    public JBIterable<ChangeViewDiffRequestProcessor.Wrapper> iterateSelectedChanges(@NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        ChangesListView changesListView = tree instanceof ChangesListView ? (ChangesListView)tree : null;
        if (changesListView == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        ChangesListView changesView = changesListView;
        Project project = ((ChangesListView)tree).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JBIterable<ChangesBrowserNode<?>> jBIterable = changesView.getSelectedChangesNodes();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getSelectedChangesNodes(...)");
        Iterable iterable = (Iterable)jBIterable;
        JBIterable<FilePath> jBIterable2 = changesView.getSelectedUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"getSelectedUnversionedFiles(...)");
        return ChangesViewDiffPreviewProcessorKt.access$wrap(project, iterable, (Iterable)jBIterable2);
    }

    @NotNull
    public JBIterable<ChangeViewDiffRequestProcessor.Wrapper> iterateAllChanges(@NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        ChangesListView changesListView = tree instanceof ChangesListView ? (ChangesListView)tree : null;
        if (changesListView == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        ChangesListView changesView = changesListView;
        Project project = ((ChangesListView)tree).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JBIterable<ChangesBrowserChangeNode> jBIterable = changesView.getChangesNodes();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getChangesNodes(...)");
        Iterable iterable = (Iterable)jBIterable;
        JBIterable<FilePath> jBIterable2 = changesView.getUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"getUnversionedFiles(...)");
        return ChangesViewDiffPreviewProcessorKt.access$wrap(project, iterable, (Iterable)jBIterable2);
    }

    @Override
    public void selectChange(@NotNull ChangesTree tree, @NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ChangesBrowserNode.Tag tag = change.getTag();
        ChangesViewUserObjectTag changesViewUserObjectTag = tag instanceof ChangesViewUserObjectTag ? (ChangesViewUserObjectTag)tag : null;
        Object tag2 = changesViewUserObjectTag != null ? changesViewUserObjectTag.getUserObject() : null;
        ChangesListView changesListView = tree instanceof ChangesListView ? (ChangesListView)tree : null;
        if (changesListView == null) {
            return;
        }
        ChangesListView changesView = changesListView;
        TreePath treePath = changesView.findNodePathInTree(change.getUserObject(), tag2);
        if (treePath == null) {
            return;
        }
        TreePath treePath2 = treePath;
        TreeUtil.selectPath((JTree)((JTree)((Object)changesView)), (TreePath)treePath2, (boolean)false);
    }
}

