/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ModuleVcsDetector;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0003J \u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0003J\"\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017J\b\u0010\u001d\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "vcsManager", "Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "kotlin.jvm.PlatformType", "getVcsManager", "()Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "vcsManager$delegate", "Lkotlin/Lazy;", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "dirtyContentRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "startDetection", "", "autoDetectDefaultRoots", "autoDetectForContentRoots", "contentRoots", "", "isInitialDetection", "", "scheduleScanForNewContentRoots", "removed", "added", "runScanForNewContentRoots", "MyStartUpActivity", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nModuleVcsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleVcsDetector.kt\ncom/intellij/openapi/vcs/impl/ModuleVcsDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 startUpMeasurer.kt\ncom/intellij/diagnostic/StartUpMeasurerKt\n*L\n1#1,154:1\n774#2:155\n865#2,2:156\n774#2:158\n865#2,2:159\n1863#2,2:161\n1557#2:163\n1628#2,3:164\n1557#2:167\n1628#2,3:168\n774#2:171\n865#2,2:172\n1863#2,2:174\n9#3,4:176\n*S KotlinDebug\n*F\n+ 1 ModuleVcsDetector.kt\ncom/intellij/openapi/vcs/impl/ModuleVcsDetector\n*L\n60#1:155\n60#1:156,2\n61#1:158\n61#1:159,2\n62#1:161,2\n70#1:163\n70#1:164,3\n123#1:167\n123#1:168,3\n124#1:171\n124#1:172,2\n125#1:174,2\n37#1:176,4\n*E\n"})
public final class ModuleVcsDetector {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy vcsManager$delegate;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final Set<VirtualFile> dirtyContentRoots;

    /*
     * WARNING - void declaration
     */
    public ModuleVcsDetector(@NotNull Project project) {
        void it;
        MergingUpdateQueue mergingUpdateQueue;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.vcsManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> ModuleVcsDetector.vcsManager_delegate$lambda$0(this));
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue = new MergingUpdateQueue("ModuleVcsDetector", 1000, true, null, (Disposable)this.project, null, Alarm.ThreadToUse.POOLED_THREAD, null, 128, null);
        ModuleVcsDetector moduleVcsDetector = this;
        boolean bl = false;
        it.setRestartTimerOnAdd(true);
        moduleVcsDetector.queue = mergingUpdateQueue;
        this.dirtyContentRoots = new LinkedHashSet();
    }

    private final ProjectLevelVcsManagerImpl getVcsManager() {
        Lazy lazy = this.vcsManager$delegate;
        return (ProjectLevelVcsManagerImpl)((Object)lazy.getValue());
    }

    private final void startDetection() {
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.startDetection");
        if (this.getVcsManager().needAutodetectMappings() && this.getVcsManager().haveDefaultMapping() == null && VcsUtil.shouldDetectVcsMappingsFor((Project)this.project)) {
            DisposableUpdate disposableUpdate = DisposableUpdate.createDisposable((Disposable)((Disposable)this.queue), (Object)"initial scan", () -> ModuleVcsDetector.startDetection$lambda$3(this));
            Intrinsics.checkNotNullExpressionValue((Object)disposableUpdate, (String)"createDisposable(...)");
            this.queue.queue((Update)disposableUpdate);
        }
    }

    @RequiresBackgroundThread
    private final void autoDetectDefaultRoots() {
        Collection<VirtualFile> collection = DefaultVcsRootPolicy.getInstance(this.project).getDefaultVcsRoots();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getDefaultVcsRoots(...)");
        Collection<VirtualFile> contentRoots = collection;
        Object[] objectArray = new Object[]{contentRoots};
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.autoDetectDefaultRoots - contentRoots", objectArray);
        this.autoDetectForContentRoots(contentRoots, true);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private final void autoDetectForContentRoots(Collection<? extends VirtualFile> contentRoots, boolean isInitialDetection) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        void $this$forEach$iv;
        VirtualFile it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object[] objectArray = new Object[]{contentRoots};
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.autoDetectForContentRoots - contentRoots", objectArray);
        if (this.getVcsManager().haveDefaultMapping() != null) {
            return;
        }
        Set usedVcses = new LinkedHashSet();
        Set detectedRoots = new LinkedHashSet();
        Iterable iterable = contentRoots;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!it.isInLocalFileSystem()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            VirtualFile root = (VirtualFile)element$iv2;
            boolean bl = false;
            AbstractVcs foundVcs = this.getVcsManager().findVersioningVcs(root);
            if (foundVcs == null || foundVcs == this.getVcsManager().getVcsFor(root)) continue;
            detectedRoots.add(new Pair((Object)root, (Object)foundVcs));
            usedVcses.add(foundVcs);
        }
        Object[] $this$map$iv = detectedRoots;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Pair bl = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((VirtualFile)it2.getFirst());
        }
        Set directMappings = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
        for (VcsRootChecker rootChecker : VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()) {
            AbstractVcs vcs;
            Iterator iterator2;
            if (this.getVcsManager().findVcsByName(rootChecker.getSupportedVcs().getName()) == null) continue;
            try {
                if (rootChecker.detectProjectMappings(this.project, contentRoots, directMappings) == null) continue;
            }
            catch (VcsException e) {
                ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.autoDetectForContentRoots - exception while detecting mapping", (Throwable)e);
                continue;
            }
            Object detectedMappings = iterator2;
            if (detectedMappings.isEmpty()) continue;
            usedVcses.add(vcs);
            iterator2 = detectedMappings.iterator();
            while (iterator2.hasNext()) {
                VirtualFile file = (VirtualFile)iterator2.next();
                detectedRoots.add(new Pair((Object)file, (Object)vcs));
            }
        }
        if (detectedRoots.isEmpty()) {
            return;
        }
        $this$map$iv = new Object[]{detectedRoots};
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.autoDetectForContentRoots - detectedRoots", $this$map$iv);
        AbstractVcs commonVcs = (AbstractVcs)CollectionsKt.singleOrNull((Iterable)usedVcses);
        if (commonVcs != null) {
            if (isInitialDetection) {
                ProjectLevelVcsManagerImpl projectLevelVcsManagerImpl = this.getVcsManager();
                List<VcsDirectoryMapping> list = this.getVcsManager().getDirectoryMappings();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getDirectoryMappings(...)");
                projectLevelVcsManagerImpl.setAutoDirectoryMappings(CollectionsKt.plus((Collection)list, (Object)VcsDirectoryMapping.createDefault((String)commonVcs.getName())));
                return;
            }
            if (!this.getVcsManager().hasAnyMappings()) {
                this.getVcsManager().setAutoDirectoryMappings(CollectionsKt.listOf((Object)VcsDirectoryMapping.createDefault((String)commonVcs.getName())));
                return;
            }
        }
        this.getVcsManager().registerNewDirectMappings(detectedRoots);
    }

    static /* synthetic */ void autoDetectForContentRoots$default(ModuleVcsDetector moduleVcsDetector, Collection collection, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        moduleVcsDetector.autoDetectForContentRoots(collection, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void scheduleScanForNewContentRoots(@NotNull Collection<? extends VirtualFile> removed, @NotNull Collection<? extends VirtualFile> added) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(removed, (String)"removed");
        Intrinsics.checkNotNullParameter(added, (String)"added");
        if (!VcsUtil.shouldDetectVcsMappingsFor((Project)this.project)) {
            return;
        }
        if (!added.isEmpty()) {
            objectArray = new Object[]{added};
            ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.contentRootsChanged - roots added", objectArray);
            if (this.getVcsManager().haveDefaultMapping() == null) {
                Set<VirtualFile> set = this.dirtyContentRoots;
                synchronized (set) {
                    boolean bl = false;
                    this.dirtyContentRoots.addAll(added);
                    bl = this.dirtyContentRoots.removeAll(CollectionsKt.toSet((Iterable)removed));
                }
                DisposableUpdate disposableUpdate = DisposableUpdate.createDisposable((Disposable)((Disposable)this.queue), (Object)"modules scan", () -> ModuleVcsDetector.scheduleScanForNewContentRoots$lambda$9(this));
                Intrinsics.checkNotNullExpressionValue((Object)disposableUpdate, (String)"createDisposable(...)");
                this.queue.queue((Update)disposableUpdate);
            }
        }
        if (!removed.isEmpty()) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            objectArray = new Object[]{removed};
            ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.contentRootsChanged - roots removed", objectArray);
            Iterable $this$map$iv = removed;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPath());
            }
            Set remotedPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            List<VcsDirectoryMapping> list = this.getVcsManager().getDirectoryMappings();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDirectoryMappings(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VcsDirectoryMapping it = (VcsDirectoryMapping)element$iv$iv;
                boolean bl = false;
                if (!remotedPaths.contains(it.getDirectory())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List removedMappings = (List)destination$iv$iv2;
            Iterable $this$forEach$iv = removedMappings;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VcsDirectoryMapping mapping = (VcsDirectoryMapping)element$iv;
                boolean bl = false;
                this.getVcsManager().removeDirectoryMapping(mapping);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runScanForNewContentRoots() {
        List contentRoots = null;
        Set<VirtualFile> set = this.dirtyContentRoots;
        synchronized (set) {
            boolean bl = false;
            contentRoots = CollectionsKt.toList((Iterable)this.dirtyContentRoots);
            this.dirtyContentRoots.clear();
            Unit unit = Unit.INSTANCE;
        }
        ModuleVcsDetector.autoDetectForContentRoots$default(this, contentRoots, false, 2, null);
    }

    private static final ProjectLevelVcsManagerImpl vcsManager_delegate$lambda$0(ModuleVcsDetector this$0) {
        return ProjectLevelVcsManagerImpl.getInstanceImpl(this$0.project);
    }

    private static final void startDetection$lambda$3(ModuleVcsDetector this$0) {
        block0: {
            String name$iv = "ModuleVcsDetector.autoDetectDefaultRoots";
            boolean $i$f$runActivity = false;
            Activity activity$iv = StartUpMeasurer.isEnabled() ? StartUpMeasurer.startActivity((String)name$iv) : null;
            boolean bl = false;
            this$0.autoDetectDefaultRoots();
            Unit result$iv = Unit.INSTANCE;
            Activity activity = activity$iv;
            if (activity == null) break block0;
            activity.end();
        }
    }

    private static final void scheduleScanForNewContentRoots$lambda$9(ModuleVcsDetector this$0) {
        this$0.runScanForNewContentRoots();
    }

    public static final /* synthetic */ void access$startDetection(ModuleVcsDetector $this) {
        $this.startDetection();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyStartUpActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "<init>", "()V", "order", "", "getOrder", "()I", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nModuleVcsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleVcsDetector.kt\ncom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyStartUpActivity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,154:1\n72#2:155\n*S KotlinDebug\n*F\n+ 1 ModuleVcsDetector.kt\ncom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyStartUpActivity\n*L\n150#1:155\n*E\n"})
    public static final class MyStartUpActivity
    implements VcsStartupActivity {
        public MyStartUpActivity() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw ExtensionNotApplicableException.create();
            }
        }

        @Override
        public int getOrder() {
            return VcsInitObject.MAPPINGS.getOrder() + 10;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object execute(@NotNull Project var1_1, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var6_3 = $completion;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ MyStartUpActivity this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$serviceAsync$iv = (ComponentManager)project;
                    $i$f$serviceAsync = false;
                    Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                    $continuation.label = 1;
                    v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(ModuleVcsDetector.class, (Continuation)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl25
                }
                case 1: {
                    $i$f$serviceAsync = false;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    ModuleVcsDetector.access$startDetection((ModuleVcsDetector)v0);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }
}

