/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtilRt;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsVirtualFile
extends AbstractVcsVirtualFile {
    private static final Logger LOG = Logger.getInstance(VcsVirtualFile.class);
    private final VcsFileRevision myFileRevision;
    private volatile byte[] myContent;
    private volatile boolean myContentLoadFailed;
    private volatile Charset myCharset;
    private final Object LOCK;

    public VcsVirtualFile(@NotNull String path, @Nullable VcsFileRevision revision, @NotNull VirtualFileSystem fileSystem) {
        if (path == null) {
            VcsVirtualFile.$$$reportNull$$$0(0);
        }
        if (fileSystem == null) {
            VcsVirtualFile.$$$reportNull$$$0(1);
        }
        super(path, fileSystem);
        this.LOCK = new Object();
        this.myFileRevision = revision;
    }

    public VcsVirtualFile(@NotNull VirtualFile parent, @NotNull String name, @Nullable VcsFileRevision revision, VirtualFileSystem fileSystem) {
        if (parent == null) {
            VcsVirtualFile.$$$reportNull$$$0(2);
        }
        if (name == null) {
            VcsVirtualFile.$$$reportNull$$$0(3);
        }
        super(parent, name, fileSystem);
        this.LOCK = new Object();
        this.myFileRevision = revision;
    }

    public VcsVirtualFile(@NotNull String path, byte @NotNull [] content, @Nullable String revision, @NotNull VirtualFileSystem fileSystem) {
        if (path == null) {
            VcsVirtualFile.$$$reportNull$$$0(4);
        }
        if (fileSystem == null) {
            VcsVirtualFile.$$$reportNull$$$0(5);
        }
        if (content == null) {
            VcsVirtualFile.$$$reportNull$$$0(6);
        }
        this(path, null, fileSystem);
        this.myContent = content;
        this.setRevision(revision);
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        if (this.myContentLoadFailed) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                VcsVirtualFile.$$$reportNull$$$0(7);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        if (this.myContent == null) {
            this.loadContent();
        }
        if (this.myContent == null) {
            VcsVirtualFile.$$$reportNull$$$0(8);
        }
        return this.myContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadContent() throws IOException {
        assert (this.myFileRevision != null);
        if (this.myContent != null) {
            return;
        }
        try {
            byte[] content = this.myFileRevision.loadContent();
            Object object = this.LOCK;
            synchronized (object) {
                this.setRevision(VcsUtil.getShortRevisionString((VcsRevisionNumber)this.myFileRevision.getRevisionNumber()));
                this.myContent = content;
                this.myContentLoadFailed = false;
                if (this.myContent != null && this.myContent.length != 0) {
                    this.myCharset = new CharsetToolkit(this.myContent, Charset.defaultCharset(), false).guessEncoding(this.myContent.length);
                }
            }
        }
        catch (VcsException e) {
            Object object = this.LOCK;
            synchronized (object) {
                this.myContentLoadFailed = true;
                this.myContent = ArrayUtilRt.EMPTY_BYTE_ARRAY;
                this.setRevision("0");
            }
            this.showLoadingContentFailedMessage(e);
        }
    }

    @Nullable
    public VcsFileRevision getFileRevision() {
        return this.myFileRevision;
    }

    @NotNull
    public Charset getCharset() {
        if (this.myCharset != null) {
            Charset charset = this.myCharset;
            if (charset == null) {
                VcsVirtualFile.$$$reportNull$$$0(9);
            }
            return charset;
        }
        Charset charset = super.getCharset();
        if (charset == null) {
            VcsVirtualFile.$$$reportNull$$$0(10);
        }
        return charset;
    }

    public boolean isDirectory() {
        return false;
    }

    public String getRevision() {
        if (this.myRevision == null) {
            try {
                this.loadContent();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return this.myRevision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/vfs/VcsVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/vfs/VcsVirtualFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

