/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization.markerRenderers;

import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.ui.visualization.markerRenderers.NotebookLineMarkerRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookTextCellBackgroundLineMarkerRenderer;", "Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookLineMarkerRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "<init>", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "intellij.notebooks.ui"})
public final class NotebookTextCellBackgroundLineMarkerRenderer
extends NotebookLineMarkerRenderer {
    @NotNull
    private final RangeHighlighter highlighter;

    public NotebookTextCellBackgroundLineMarkerRenderer(@NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        super(null, 1, null);
        this.highlighter = highlighter;
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            EditorImpl cfr_ignored_0 = (EditorImpl)editor;
            IntRange lines = new IntRange(((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getStartOffset()), ((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getEndOffset()));
            int top = editor.offsetToXY((int)((EditorImpl)editor).getDocument().getLineStartOffset((int)lines.getFirst())).y;
            int height = editor.offsetToXY((int)((EditorImpl)editor).getDocument().getLineEndOffset((int)lines.getLast())).y + ((EditorImpl)editor).getLineHeight() - top;
            NotebookUtil.INSTANCE.paintCaretRow((EditorImpl)editor, g, lines);
            if (Intrinsics.areEqual((Object)((EditorImpl)editor).getUserData(NotebookEditorUiUtilKt.isFoldingEnabledKey()), (Object)true)) break block1;
            NotebookEditorAppearance appearance = NotebookUtil.INSTANCE.getNotebookAppearance(editor);
            Color color = appearance.getCellStripeColor((EditorImpl)editor, lines);
            if (color != null) {
                Color it = color;
                boolean bl = false;
                NotebookUtil.INSTANCE.paintCellStripe(appearance, g, r, it, top, height, editor);
            }
        }
    }
}

