/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.visualization.EditorNotebookExtension;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellEventListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0014\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001b0\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u001bH\u0016J\u0006\u0010%\u001a\u00020\u001bJ\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(J+\u0010)\u001a\u00020\u001b\"\b\b\u0000\u0010\u0017*\u00020\u00152\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00142\u0006\u0010+\u001a\u0002H\u0017\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorNotebook;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "_cells", "", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "cells", "", "getCells", "()Ljava/util/List;", "cellEventListeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/notebooks/visualization/ui/EditorCellEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "extensions", "", "Lkotlin/reflect/KClass;", "Lcom/intellij/notebooks/visualization/EditorNotebookExtension;", "getExtension", "T", "cls", "(Lkotlin/reflect/KClass;)Lcom/intellij/notebooks/visualization/EditorNotebookExtension;", "forEachExtension", "", "action", "Lkotlin/Function1;", "addCellEventsListener", "disposable", "listener", "addCell", "interval", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "dispose", "clear", "removeCell", "index", "", "addExtension", "type", "extension", "(Lkotlin/reflect/KClass;Lcom/intellij/notebooks/visualization/EditorNotebookExtension;)V", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorNotebook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorNotebook.kt\ncom/intellij/notebooks/visualization/ui/EditorNotebook\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1863#2,2:80\n1863#2,2:82\n1863#2,2:84\n*S KotlinDebug\n*F\n+ 1 EditorNotebook.kt\ncom/intellij/notebooks/visualization/ui/EditorNotebook\n*L\n31#1:80,2\n50#1:82,2\n58#1:84,2\n*E\n"})
public final class EditorNotebook
implements Disposable {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private List<EditorCell> _cells;
    @NotNull
    private final EventDispatcher<EditorCellEventListener> cellEventListeners;
    @NotNull
    private final Map<KClass<?>, EditorNotebookExtension> extensions;

    public EditorNotebook(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this._cells = new ArrayList();
        EventDispatcher eventDispatcher = EventDispatcher.create(EditorCellEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.cellEventListeners = eventDispatcher;
        this.extensions = new LinkedHashMap();
    }

    @NotNull
    public final List<EditorCell> getCells() {
        return CollectionsKt.toList((Iterable)this._cells);
    }

    @Nullable
    public final <T extends EditorNotebookExtension> T getExtension(@NotNull KClass<T> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        EditorNotebookExtension editorNotebookExtension = this.extensions.get(cls);
        return (T)(editorNotebookExtension instanceof EditorNotebookExtension ? editorNotebookExtension : null);
    }

    private final void forEachExtension(Function1<? super EditorNotebookExtension, Unit> action2) {
        Iterable $this$forEach$iv = this.extensions.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorNotebookExtension it = (EditorNotebookExtension)element$iv;
            boolean bl = false;
            action2.invoke((Object)it);
        }
    }

    public final void addCellEventsListener(@NotNull Disposable disposable, @NotNull EditorCellEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.cellEventListeners.addListener((EventListener)listener2, disposable);
    }

    public final void addCell(@NotNull NotebookIntervalPointer interval) {
        EditorCell editorCell;
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        EditorCell it = editorCell = new EditorCell(this, interval, this.editor);
        boolean bl = false;
        this.forEachExtension((Function1<? super EditorNotebookExtension, Unit>)((Function1)arg_0 -> EditorNotebook.addCell$lambda$2$lambda$1(it, arg_0)));
        Disposer.register((Disposable)this, (Disposable)it);
        EditorCell editorCell2 = editorCell;
        NotebookCellLines.Interval interval2 = interval.get();
        Intrinsics.checkNotNull((Object)interval2);
        this._cells.add(interval2.getOrdinal(), editorCell2);
        ((EditorCellEventListener)this.cellEventListeners.getMulticaster()).onEditorCellEvents(CollectionsKt.listOf((Object)new EditorCellEventListener.CellCreated(editorCell2)));
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.extensions.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorNotebookExtension it = (EditorNotebookExtension)element$iv;
            boolean bl = false;
            if (!(it instanceof Disposable)) continue;
            Disposer.dispose((Disposable)((Disposable)it));
        }
    }

    public final void clear() {
        Iterable $this$forEach$iv = this._cells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell cell = (EditorCell)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)cell);
        }
        this._cells.clear();
    }

    public final void removeCell(int index) {
        EditorCell cell = this._cells.get(index);
        cell.onBeforeRemove();
        EditorCell removed = this._cells.remove(index);
        Disposer.dispose((Disposable)removed);
        ((EditorCellEventListener)this.cellEventListeners.getMulticaster()).onEditorCellEvents(CollectionsKt.listOf((Object)new EditorCellEventListener.CellRemoved(removed)));
    }

    public final <T extends EditorNotebookExtension> void addExtension(@NotNull KClass<T> type, @NotNull T extension) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        this.extensions.put(type, extension);
    }

    private static final Unit addCell$lambda$2$lambda$1(EditorCell $it, EditorNotebookExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        extension.onCellCreated($it);
        return Unit.INSTANCE;
    }
}

