/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Functions;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class LockFreeCopyOnWriteArrayList<E>
extends AtomicReference<Object[]>
implements List<E>,
RandomAccess,
ConcurrentList<E> {
    LockFreeCopyOnWriteArrayList() {
        this.clear();
    }

    LockFreeCopyOnWriteArrayList(@NotNull Collection<? extends E> c) {
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(0);
        }
        this.set(c.isEmpty() ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : c.toArray());
    }

    @TestOnly
    Object @NotNull [] getArray() {
        Object[] objectArray = (Object[])this.get();
        if (objectArray == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    private boolean replaceArray(Object @NotNull [] oldArray, Object @NotNull [] newArray) {
        if (oldArray == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(2);
        }
        if (newArray == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(3);
        }
        return this.compareAndSet(oldArray, newArray);
    }

    @Override
    public int size() {
        return ((Object[])this.get()).length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static int indexOf(Object o, Object @NotNull [] elements, int index, int fence) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(4);
        }
        return ArrayUtilRt.indexOf((Object[])elements, (Object)o, (int)index, (int)fence);
    }

    private static int lastIndexOf(Object o, Object @NotNull [] elements, int index) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(5);
        }
        if (o == null) {
            for (int i = index; i >= 0; --i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        Object[] elements = (Object[])this.get();
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        Object[] elements = (Object[])this.get();
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length);
    }

    public int indexOf(E e, int index) {
        Object[] elements = (Object[])this.get();
        return LockFreeCopyOnWriteArrayList.indexOf(e, elements, index, elements.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] elements = (Object[])this.get();
        return LockFreeCopyOnWriteArrayList.lastIndexOf(o, elements, elements.length - 1);
    }

    public int lastIndexOf(E e, int index) {
        Object[] elements = (Object[])this.get();
        return LockFreeCopyOnWriteArrayList.lastIndexOf(e, elements, index);
    }

    @Override
    public Object @NotNull [] toArray() {
        Object[] elements = (Object[])this.get();
        if (elements.length == 0) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(6);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = Arrays.copyOf(elements, elements.length, Object[].class);
        if (objectArray == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        Object[] elements;
        int len;
        if (a == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(8);
        }
        if (a.length < (len = (elements = (Object[])this.get()).length)) {
            T[] TArray = Arrays.copyOf(elements, len, a.getClass());
            if (TArray == null) {
                LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(9);
            }
            return TArray;
        }
        System.arraycopy(elements, 0, a, 0, len);
        if (a.length > len) {
            a[len] = null;
        }
        if (a == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(10);
        }
        return a;
    }

    private E get(Object @NotNull [] a, int index) {
        if (a == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(11);
        }
        return (E)a[index];
    }

    @Override
    public E get(int index) {
        return this.get((Object[])this.get(), index);
    }

    @Override
    public E set(int index, E element) throws IndexOutOfBoundsException {
        E oldValue;
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements, newElements = (oldValue = this.get(elements = (Object[])this.get(), index)) == element ? elements : LockFreeCopyOnWriteArrayList.createArraySet(elements, index, element))) {
        }
        return oldValue;
    }

    private static Object @NotNull [] createArraySet(Object @NotNull [] elements, int index, Object element) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(12);
        }
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len, Object[].class);
        newElements[index] = element;
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(13);
        }
        return newElements;
    }

    @Override
    public boolean add(E e) {
        return this.changeAndReplace(elements -> LockFreeCopyOnWriteArrayList.createArrayAdd(elements, e));
    }

    private static <E> Object @NotNull [] createArrayAdd(Object @NotNull [] elements, E e) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(14);
        }
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len + 1);
        newElements[len] = e;
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(15);
        }
        return newElements;
    }

    @Override
    public void add(int index, E element) throws IndexOutOfBoundsException {
        this.changeAndReplace(elements -> LockFreeCopyOnWriteArrayList.createArrayAdd(elements, index, element));
    }

    private static <E> Object @NotNull [] createArrayAdd(Object @NotNull [] elements, int index, E element) {
        int numMoved;
        int len;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(16);
        }
        if (index > (len = elements.length) || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        Object[] newElements = new Object[len + 1];
        if (index != 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if ((numMoved = len - index) != 0) {
            System.arraycopy(elements, index, newElements, index + 1, numMoved);
        }
        newElements[index] = element;
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(17);
        }
        return newElements;
    }

    @Override
    public E remove(int index) throws IndexOutOfBoundsException {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = (Object[])this.get(), newElements = LockFreeCopyOnWriteArrayList.createArrayRemove(elements, index))) {
        }
        E oldValue = this.get(elements, index);
        return oldValue;
    }

    private static Object @NotNull [] createArrayRemove(Object @NotNull [] elements, int index) {
        int numMoved;
        int len;
        Object[] newElements;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(18);
        }
        Object[] objectArray = newElements = (len = elements.length) == 1 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[len - 1];
        if (index != 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if ((numMoved = len - index - 1) != 0) {
            System.arraycopy(elements, index + 1, newElements, index, numMoved);
        }
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(19);
        }
        return newElements;
    }

    @Override
    public boolean remove(Object o) {
        return this.changeAndReplace(elements -> LockFreeCopyOnWriteArrayList.createArrayRemove(elements, o));
    }

    private static Object @Nullable [] createArrayRemove(Object @NotNull [] elements, Object o) {
        int i;
        int len;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(20);
        }
        if ((len = elements.length) == 0) {
            return null;
        }
        int newLen = len - 1;
        Object[] newElements = newLen == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[newLen];
        for (i = newLen; i != 0; --i) {
            Object element = elements[i];
            if (Objects.equals(o, element)) {
                System.arraycopy(elements, 0, newElements, 0, i);
                break;
            }
            newElements[i - 1] = element;
        }
        if (i == 0 && !Objects.equals(o, elements[0])) {
            return null;
        }
        return newElements;
    }

    @Override
    public boolean addIfAbsent(E e) {
        return this.changeAndReplace(elements -> LockFreeCopyOnWriteArrayList.createArrayAddIfAbsent(elements, e));
    }

    private static <E> Object @Nullable [] createArrayAddIfAbsent(Object @NotNull [] elements, E e) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(21);
        }
        int len = elements.length;
        Object[] newElements = new Object[len + 1];
        for (int i = 0; i < len; ++i) {
            if (Objects.equals(e, elements[i])) {
                return null;
            }
            newElements[i] = elements[i];
        }
        newElements[len] = e;
        return newElements;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(22);
        }
        Object[] elements = (Object[])this.get();
        int len = elements.length;
        for (Object e : c) {
            if (LockFreeCopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(23);
        }
        return this.changeAndReplace(elements -> LockFreeCopyOnWriteArrayList.createArrayRemoveAll(elements, c));
    }

    private static Object @Nullable [] createArrayRemoveAll(Object @NotNull [] elements, @NotNull Collection<?> c) {
        int len;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(24);
        }
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(25);
        }
        if ((len = elements.length) == 0) {
            return null;
        }
        int newLen = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (c.contains(element)) continue;
            temp[newLen++] = element;
        }
        if (newLen == len) {
            return null;
        }
        return Arrays.copyOf(temp, newLen, Object[].class);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(26);
        }
        return this.changeAndReplace(elements -> LockFreeCopyOnWriteArrayList.createArrayRetainAll(elements, c));
    }

    private static Object @Nullable [] createArrayRetainAll(Object @NotNull [] elements, @NotNull Collection<?> c) {
        int len;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(27);
        }
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(28);
        }
        if ((len = elements.length) == 0) {
            return null;
        }
        int newLength = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (!c.contains(element)) continue;
            temp[newLength++] = element;
        }
        if (newLength == len) {
            return null;
        }
        return Arrays.copyOf(temp, newLength, Object[].class);
    }

    @Override
    public int addAllAbsent(@NotNull Collection<? extends E> c) {
        int added;
        ArrayList<E> toAddList;
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(29);
        }
        if (c.isEmpty()) {
            return 0;
        }
        do {
            elements = (Object[])this.get();
            Set existing = ContainerUtil.map2Set(elements, Functions.identity());
            toAddList = new ArrayList<E>(c.size());
            for (E e : c) {
                if (existing.contains(e)) continue;
                toAddList.add(e);
            }
            added = toAddList.size();
            if (added != 0) continue;
            return 0;
        } while (!this.replaceArray(elements, newElements = ArrayUtil.mergeArrays(elements, toAddList.toArray())));
        return added;
    }

    @Override
    public void clear() {
        this.set(ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(30);
        }
        this.changeAndReplace(elements -> LockFreeCopyOnWriteArrayList.createArrayAddAll(elements, c));
        return true;
    }

    private static Object @Nullable [] createArrayAddAll(Object @NotNull [] elements, @NotNull Collection c) {
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(31);
        }
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(32);
        }
        if (c.isEmpty()) {
            return null;
        }
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return null;
        }
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        System.arraycopy(cs, 0, newElements, len, cs.length);
        return newElements;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> c) throws IndexOutOfBoundsException {
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(33);
        }
        return this.changeAndReplace(elements -> LockFreeCopyOnWriteArrayList.createArrayAddAll(elements, index, c));
    }

    private static Object @Nullable [] createArrayAddAll(Object @NotNull [] elements, int index, @NotNull Collection c) {
        Object[] newElements;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(34);
        }
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(35);
        }
        if (c.isEmpty()) {
            return null;
        }
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return null;
        }
        int len = elements.length;
        if (index > len || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        int numMoved = len - index;
        if (numMoved == 0) {
            newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        } else {
            newElements = new Object[len + cs.length];
            System.arraycopy(elements, 0, newElements, 0, index);
            System.arraycopy(elements, index, newElements, index + cs.length, numMoved);
        }
        System.arraycopy(cs, 0, newElements, index, cs.length);
        return newElements;
    }

    @Override
    @NotNull
    public String toString() {
        String string = Arrays.toString((Object[])this.get());
        if (string == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        Iterator it = list.iterator();
        for (Object element : (Object[])this.get()) {
            if (it.hasNext() && Objects.equals(element, it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object obj : (Object[])this.get()) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Object[] elements = (Object[])this.get();
        return elements.length == 0 ? Collections.emptyIterator() : new COWIterator(elements, 0);
    }

    @Override
    public void forEach(@NotNull Consumer<? super E> action) {
        Object[] snapshot;
        if (action == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(37);
        }
        for (Object element : snapshot = (Object[])this.get()) {
            action.accept(element);
        }
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        ListIterator<E> listIterator2 = this.listIterator(0);
        if (listIterator2 == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(38);
        }
        return listIterator2;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        Object[] elements = (Object[])this.get();
        int len = elements.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return elements.length == 0 ? Collections.emptyListIterator() : new COWIterator(elements, index);
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Arrays.spliterator((Object[])this.get());
    }

    @Override
    public void replaceAll(@NotNull UnaryOperator<E> operator) {
        if (operator == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(39);
        }
        this.changeAndReplace(elements -> this.createArrayMap((Object[])elements, (UnaryOperator<? super E>)operator));
    }

    private Object @NotNull [] createArrayMap(Object @NotNull [] elements, @NotNull UnaryOperator<? super E> operator) {
        if (operator == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(40);
        }
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(41);
        }
        Object[] newElements = ArrayUtil.newObjectArray(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            Object element = elements[i];
            newElements[i] = operator.apply(element);
        }
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(42);
        }
        return newElements;
    }

    @Override
    public void sort(Comparator<? super E> c) {
        this.changeAndReplace(elements -> {
            Object[] sorted2 = (Object[])elements.clone();
            Arrays.sort(sorted2, c);
            return sorted2;
        });
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super E> filter2) {
        if (filter2 == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(43);
        }
        return this.changeAndReplace(elements -> LockFreeCopyOnWriteArrayList.createArrayRemoveIf(elements, filter2));
    }

    boolean changeAndReplace(@NotNull UnaryOperator<Object[]> change) {
        Object[] newArray;
        Object[] elements;
        if (change == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(44);
        }
        do {
            if ((newArray = (Object[])change.apply(elements = (Object[])this.get())) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newArray));
        return true;
    }

    private static Object @Nullable [] createArrayRemoveIf(Object @NotNull [] elements, @NotNull Predicate filter2) {
        Object element;
        int i;
        if (filter2 == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(45);
        }
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(46);
        }
        for (i = 0; i < elements.length && !filter2.test(element = elements[i]); ++i) {
        }
        if (i == elements.length) {
            return null;
        }
        Object[] newElements = (Object[])elements.clone();
        int o = i;
        for (int j = i + 1; j < elements.length; ++j) {
            Object element2 = elements[j];
            if (filter2.test(element2)) continue;
            newElements[o++] = element2;
        }
        return ArrayUtil.realloc(newElements, o, ArrayUtil.OBJECT_ARRAY_FACTORY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 36: 
            case 38: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 36: 
            case 38: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 36: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/LockFreeCopyOnWriteArrayList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArray";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newArray";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/LockFreeCopyOnWriteArrayList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArray";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createArraySet";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayAdd";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayRemove";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "listIterator";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 36: 
            case 38: 
            case 42: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceArray";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createArraySet";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createArrayAdd";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createArrayRemove";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createArrayAddIfAbsent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createArrayRemoveAll";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createArrayRetainAll";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addAllAbsent";
                break;
            }
            case 30: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createArrayAddAll";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "replaceAll";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createArrayMap";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeIf";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "changeAndReplace";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createArrayRemoveIf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 36: 
            case 38: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class COWIterator
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;
        private int lastRet;

        private COWIterator(Object[] elements, int initialCursor) {
            if (elements == null) {
                COWIterator.$$$reportNull$$$0(0);
            }
            this.lastRet = -1;
            this.cursor = initialCursor;
            this.snapshot = elements;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastRet = --this.cursor;
            return this.snapshot[this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new NoSuchElementException();
            }
            Object e = this.snapshot[this.lastRet];
            this.lastRet = -1;
            LockFreeCopyOnWriteArrayList.this.remove(e);
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList$COWIterator", "<init>"));
        }
    }
}

