/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.inline;

import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.InlineCompletionFontUtils;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElementManipulator;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionSkipTextElement;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionTextElement;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionVirtualLineEndingElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ml.inline.completion.impl.MLCompletionParameters;
import com.intellij.ml.inline.completion.impl.MLCompletionRequest;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionCustomInlineEventsKt;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionExtractedFirstLine;
import com.intellij.ml.inline.completion.impl.inline.MultiLineApplicabilityResult;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultilineSupporter;
import com.intellij.ml.inline.completion.impl.kit.MultilinePolicyType;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.EnclosureLexeme;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexemeUtilsKt;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionProposalsContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0086@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0018\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J2\u0010\u0011\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0012*\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001a\u0010\u001a\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\f\u0010\u001c\u001a\u00020\n*\u00020\fH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/MLCompletionMultilineUtils;", "", "<init>", "()V", "isMultiLineSuitable", "Lcom/intellij/ml/inline/completion/impl/inline/MultiLineApplicabilityResult;", "request", "Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;", "(Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isMultiline", "", "", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement;", "extractFirstLine", "Lcom/intellij/ml/inline/completion/impl/inline/MLCompletionExtractedFirstLine;", "context", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionProposalsContext;", "split", "Lkotlin/Pair;", "firstPartLength", "", "getAttributesForLineEnding", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "editor", "Lcom/intellij/openapi/editor/Editor;", "prefix", "isSkipped", "offset", "isTextElement", "intellij.ml.inline.completion"})
@SourceDebugExtension(value={"SMAP\nMLCompletionMultilineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionMultilineUtils.kt\ncom/intellij/ml/inline/completion/impl/inline/MLCompletionMultilineUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1755#2,3:173\n543#2,6:176\n1#3:182\n*S KotlinDebug\n*F\n+ 1 MLCompletionMultilineUtils.kt\ncom/intellij/ml/inline/completion/impl/inline/MLCompletionMultilineUtils\n*L\n52#1:173,3\n148#1:176,6\n*E\n"})
public final class MLCompletionMultilineUtils {
    @NotNull
    public static final MLCompletionMultilineUtils INSTANCE = new MLCompletionMultilineUtils();

    private MLCompletionMultilineUtils() {
    }

    @Nullable
    public final Object isMultiLineSuitable(@NotNull MLCompletionRequest<?> request, @NotNull Continuation<? super MultiLineApplicabilityResult> $completion) {
        MLCompletionParameters parameters = request.getParameters();
        InlineCompletionEvent event = parameters.getInlineRequest().getEvent();
        if (request.getLanguageKit().getLanguageSettings().getMultilinePolicy() == MultilinePolicyType.DISABLED) {
            return MultiLineApplicabilityResult.DISABLED_BY_LANGUAGE_KIT;
        }
        if (event instanceof InlineCompletionEvent.DirectCall) {
            return MultiLineApplicabilityResult.ENABLED_DIRECT_CALL;
        }
        if (MLCompletionCustomInlineEventsKt.isShowRemainingMultilineEvent(event)) {
            return MultiLineApplicabilityResult.ENABLED_SHOW_REST;
        }
        if (event instanceof InlineCompletionEvent.SuggestionInserted) {
            return MultiLineApplicabilityResult.ENABLED_AFTER_SUGGESTION_INSERTED;
        }
        if (LookupManager.getInstance((Project)parameters.getFile().getProject()).getActiveLookup() != null) {
            return MultiLineApplicabilityResult.DISABLED_BY_LOOKUP;
        }
        MLCompletionMultilineSupporter scopeSupporter = request.getLanguageKit().getMultilineSupporter();
        return CoroutinesKt.readAction(() -> MLCompletionMultilineUtils.isMultiLineSuitable$lambda$0(scopeSupporter, parameters), $completion);
    }

    public final boolean isMultiline(@NotNull List<? extends InlineCompletionElement> $this$isMultiline) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$isMultiline, (String)"<this>");
            Iterable $this$any$iv = $this$isMultiline;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    InlineCompletionElement it = (InlineCompletionElement)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)it.getText(), (char)'\n', (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final MLCompletionExtractedFirstLine extractFirstLine(@NotNull List<? extends InlineCompletionElement> $this$extractFirstLine, @NotNull MLCompletionProposalsContext context) {
        List list;
        boolean isPairEnclosureSkipped;
        Integer lastEnclosureIndexInFirstLine;
        Iterator iterator;
        List<Integer> enclosurePairs;
        List<EnclosureLexeme> enclosures;
        int lengthOfFirstLine;
        block9: {
            Integer n;
            Intrinsics.checkNotNullParameter($this$extractFirstLine, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String suggestion = CollectionsKt.joinToString$default((Iterable)$this$extractFirstLine, (CharSequence)"", null, null, (int)0, null, MLCompletionMultilineUtils::extractFirstLine$lambda$2, (int)30, null);
            lengthOfFirstLine = StringsKt.indexOf$default((CharSequence)suggestion, (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (lengthOfFirstLine == -1) {
                return new MLCompletionExtractedFirstLine($this$extractFirstLine, CollectionsKt.emptyList(), CollectionsKt.emptyList());
            }
            enclosures = MLCompletionLexemeUtilsKt.enclosures(context.lexemesOf(new RawMLCompletionProposal(suggestion, 0.99, null, 4, null)));
            enclosurePairs = MLCompletionLexemeUtilsKt.findPairIndices(enclosures, context.getKit().getEnclosures().getDefinition());
            iterator = ((Iterable)CollectionsKt.getIndices((Collection)enclosurePairs)).iterator();
            while (iterator.hasNext()) {
                Integer n2;
                int index = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                if (enclosures.get(index).getOffset() >= lengthOfFirstLine || !(enclosures.get(index) instanceof EnclosureLexeme.Open)) {
                    n2 = null;
                } else {
                    Integer pair = enclosurePairs.get(index);
                    Integer n3 = index;
                    int it = ((Number)n3).intValue();
                    boolean bl2 = false;
                    n2 = pair != null && enclosures.get(pair).getOffset() >= lengthOfFirstLine ? n3 : null;
                }
                if ((index = n2) == null) continue;
                n = index;
                break block9;
            }
            n = lastEnclosureIndexInFirstLine = null;
        }
        if (lastEnclosureIndexInFirstLine == null) {
            Pair<List<InlineCompletionElement>, List<InlineCompletionElement>> pair = this.split($this$extractFirstLine, lengthOfFirstLine);
            List prefix = (List)pair.component1();
            List otherLines = (List)pair.component2();
            return new MLCompletionExtractedFirstLine(prefix, otherLines, CollectionsKt.emptyList());
        }
        int splitOffset = enclosures.get(lastEnclosureIndexInFirstLine).getOffset() + 1;
        iterator = this.split($this$extractFirstLine, splitOffset);
        List prefix = (List)iterator.component1();
        List otherLines = (List)iterator.component2();
        Integer n = enclosurePairs.get(lastEnclosureIndexInFirstLine);
        Intrinsics.checkNotNull((Object)n);
        EnclosureLexeme pairEnclosure = enclosures.get(((Number)n).intValue());
        int pairEnclosureOffset = pairEnclosure.getOffset() - splitOffset;
        boolean bl = isPairEnclosureSkipped = this.isSkipped(otherLines, pairEnclosureOffset);
        if (bl) {
            list = prefix;
        } else if (!bl) {
            list = CollectionsKt.plus((Collection)prefix, (Object)new InlineCompletionVirtualLineEndingElement(pairEnclosure.getText(), this.getAttributesForLineEnding(context.getEditor(), prefix)));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List finalPrefix = list;
        return new MLCompletionExtractedFirstLine(finalPrefix, otherLines, isPairEnclosureSkipped ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)pairEnclosureOffset));
    }

    private final Pair<List<InlineCompletionElement>, List<InlineCompletionElement>> split(List<? extends InlineCompletionElement> $this$split, int firstPartLength) {
        List left = new ArrayList();
        List right = new ArrayList();
        int done = 0;
        Iterator iterator = ((Iterable)$this$split).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            InlineCompletionElement element = (InlineCompletionElement)iterator.next();
            if (done + element.getText().length() <= firstPartLength) {
                done += element.getText().length();
                ((Collection)left).add(element);
                continue;
            }
            int splitIndex = firstPartLength - done;
            if (element instanceof InlineCompletionSkipTextElement) {
                String string = ((InlineCompletionSkipTextElement)element).getText().substring(0, splitIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String stringBefore = string;
                if (((CharSequence)stringBefore).length() > 0) {
                    ((Collection)left).add(new InlineCompletionSkipTextElement(stringBefore));
                }
                String string2 = ((InlineCompletionSkipTextElement)element).getText().substring(splitIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String stringAfter = string2;
                if (((CharSequence)stringAfter).length() > 0) {
                    ((Collection)right).add(new InlineCompletionSkipTextElement(stringAfter));
                }
            } else {
                InlineCompletionElementManipulator inlineCompletionElementManipulator = InlineCompletionElementManipulator.Companion.getApplicable(element);
                Intrinsics.checkNotNull((Object)inlineCompletionElementManipulator);
                InlineCompletionElementManipulator manipulator = inlineCompletionElementManipulator;
                UtilKt.addIfNotNull((List)left, (Object)manipulator.substring(element, 0, splitIndex));
                UtilKt.addIfNotNull((List)right, (Object)manipulator.substring(element, splitIndex, element.getText().length()));
            }
            for (InlineCompletionElement nextElement : CollectionsKt.drop((Iterable)$this$split, (int)(index + 1))) {
                if (this.isTextElement(nextElement)) {
                    ((Collection)right).add(nextElement);
                    continue;
                }
                ((Collection)left).add(nextElement);
            }
        }
        return TuplesKt.to((Object)left, (Object)right);
    }

    private final TextAttributes getAttributesForLineEnding(Editor editor, List<? extends InlineCompletionElement> prefix) {
        TextAttributes textAttributes;
        InlineCompletionElement inlineCompletionElement;
        Function0 fallback;
        block4: {
            fallback = () -> MLCompletionMultilineUtils.getAttributesForLineEnding$lambda$7(editor);
            List<? extends InlineCompletionElement> $this$lastOrNull$iv = prefix;
            boolean $i$f$lastOrNull = false;
            ListIterator<? extends InlineCompletionElement> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                InlineCompletionElement element$iv;
                InlineCompletionElement it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!INSTANCE.isTextElement(it)) continue;
                inlineCompletionElement = element$iv;
                break block4;
            }
            inlineCompletionElement = null;
        }
        InlineCompletionElement inlineCompletionElement2 = inlineCompletionElement;
        if (inlineCompletionElement2 == null) {
            Object object = fallback.invoke();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
            return (TextAttributes)object;
        }
        InlineCompletionElement lastElement = inlineCompletionElement2;
        if (lastElement instanceof InlineCompletionTextElement) {
            textAttributes = (TextAttributes)((InlineCompletionTextElement)lastElement).getGetAttributes().invoke((Object)editor);
        } else {
            Object object = fallback.invoke();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
            textAttributes = (TextAttributes)object;
        }
        return textAttributes;
    }

    private final boolean isSkipped(List<? extends InlineCompletionElement> $this$isSkipped, int offset) {
        int done = 0;
        for (InlineCompletionElement inlineCompletionElement : $this$isSkipped) {
            if ((done += inlineCompletionElement.getText().length()) <= offset) continue;
            return inlineCompletionElement instanceof InlineCompletionSkipTextElement;
        }
        return false;
    }

    private final boolean isTextElement(InlineCompletionElement $this$isTextElement) {
        return $this$isTextElement instanceof InlineCompletionTextElement || $this$isTextElement instanceof InlineCompletionSkipTextElement;
    }

    private static final MultiLineApplicabilityResult isMultiLineSuitable$lambda$0(MLCompletionMultilineSupporter $scopeSupporter, MLCompletionParameters $parameters) {
        PsiElement psiElement = $parameters.getPosition();
        Document document = $parameters.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return !$scopeSupporter.isMultilineSuitable(psiElement, document, $parameters.getOffset()) ? MultiLineApplicabilityResult.DISABLED_BY_LANGUAGE_SUPPORTER : MultiLineApplicabilityResult.ENABLED;
    }

    private static final CharSequence extractFirstLine$lambda$2(InlineCompletionElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    private static final TextAttributes getAttributesForLineEnding$lambda$7(Editor $editor) {
        TextAttributes textAttributes;
        TextAttributes $this$getAttributesForLineEnding_u24lambda_u247_u24lambda_u246 = InlineCompletionFontUtils.INSTANCE.attributes($editor);
        boolean bl = false;
        TextAttributes $this$getAttributesForLineEnding_u24lambda_u247_u24lambda_u246_u24lambda_u245 = textAttributes = $this$getAttributesForLineEnding_u24lambda_u247_u24lambda_u246.clone();
        boolean bl2 = false;
        $this$getAttributesForLineEnding_u24lambda_u247_u24lambda_u246_u24lambda_u245.setFontType(0);
        return textAttributes;
    }
}

