/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.vcs.log.Hash;
import git4idea.GitDisposable;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.ignore.GitRepositoryIgnoredFilesHolder;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfig;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitModulesFileReader;
import git4idea.repo.GitRecentCheckoutBranches;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitRepositoryReader;
import git4idea.repo.GitRepositoryUpdater;
import git4idea.repo.GitSubmoduleInfo;
import git4idea.repo.GitTagHolder;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.status.GitStagingAreaHolder;
import git4idea.telemetry.GitTelemetrySpan;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.ExceptionAttributes;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB)\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010 \u001a\u00020\u0006H\u0017J\b\u0010!\u001a\u00020\u0010H\u0016J\b\u0010\"\u001a\u00020\u0014H\u0016J\b\u0010#\u001a\u00020\u0016H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0018H\u0016J\b\u0010'\u001a\u00020\u001fH\u0016J\b\u0010(\u001a\u00020\u001aH\u0016J\n\u0010)\u001a\u0004\u0018\u00010\u001dH\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\n\u0010.\u001a\u0004\u0018\u00010+H\u0016J\b\u0010/\u001a\u00020\rH\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0016J\b\u00103\u001a\u000204H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020601H\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020801H\u0016J\u0012\u00109\u001a\u0004\u0018\u0001082\u0006\u0010:\u001a\u00020+H\u0016J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020<H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020\u001aH\u0002J\b\u0010A\u001a\u00020?H\u0016J\b\u0010B\u001a\u00020+H\u0016R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lgit4idea/repo/GitRepositoryImpl;", "Lcom/intellij/dvcs/repo/RepositoryImpl;", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "rootDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "gitDir", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/Disposable;)V", "vcs", "Lgit4idea/GitVcs;", "Lorg/jetbrains/annotations/NotNull;", "repositoryFiles", "Lgit4idea/repo/GitRepositoryFiles;", "repositoryReader", "Lgit4idea/repo/GitRepositoryReader;", "stagingAreaHolder", "Lgit4idea/status/GitStagingAreaHolder;", "untrackedFilesHolder", "Lgit4idea/repo/GitUntrackedFilesHolder;", "tagHolder", "Lgit4idea/repo/GitTagHolder;", "repoInfo", "Lgit4idea/repo/GitRepoInfo;", "recentCheckoutBranches", "", "Lgit4idea/GitLocalBranch;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getGitDir", "getRepositoryFiles", "getStagingAreaHolder", "getUntrackedFilesHolder", "getIgnoredFilesHolder", "Lgit4idea/ignore/GitRepositoryIgnoredFilesHolder;", "getTagHolder", "getCoroutineScope", "getInfo", "getCurrentBranch", "getCurrentRevision", "", "getState", "Lcom/intellij/dvcs/repo/Repository$State;", "getCurrentBranchName", "getVcs", "getSubmodules", "", "Lgit4idea/repo/GitSubmoduleInfo;", "getBranches", "Lgit4idea/branch/GitBranchesCollection;", "getRemotes", "Lgit4idea/repo/GitRemote;", "getBranchTrackInfos", "Lgit4idea/repo/GitBranchTrackInfo;", "getBranchTrackInfo", "localBranchName", "isRebaseInProgress", "", "isOnBranch", "update", "", "readRepoInfo", "dispose", "toLogString", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryImpl.kt\ngit4idea/repo/GitRepositoryImpl\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,276:1\n28#2:277\n88#2,2:278\n29#2,3:280\n101#2:283\n91#2,8:284\n*S KotlinDebug\n*F\n+ 1 GitRepositoryImpl.kt\ngit4idea/repo/GitRepositoryImpl\n*L\n166#1:277\n166#1:278,2\n166#1:280,3\n166#1:283\n166#1:284,8\n*E\n"})
public final class GitRepositoryImpl
extends RepositoryImpl
implements GitRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile gitDir;
    @NotNull
    private final GitVcs vcs;
    @NotNull
    private final GitRepositoryFiles repositoryFiles;
    @NotNull
    private final GitRepositoryReader repositoryReader;
    @NotNull
    private final GitStagingAreaHolder stagingAreaHolder;
    @NotNull
    private final GitUntrackedFilesHolder untrackedFilesHolder;
    @NotNull
    private final GitTagHolder tagHolder;
    @NotNull
    private volatile GitRepoInfo repoInfo;
    @NotNull
    private volatile List<GitLocalBranch> recentCheckoutBranches;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final Logger LOG;

    private GitRepositoryImpl(Project project, VirtualFile rootDir, VirtualFile gitDir, Disposable parentDisposable) {
        super(project, rootDir, parentDisposable);
        this.gitDir = gitDir;
        GitVcs gitVcs = GitVcs.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"getInstance(...)");
        this.vcs = gitVcs;
        GitRepositoryFiles gitRepositoryFiles = GitRepositoryFiles.createInstance(rootDir, this.gitDir);
        Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryFiles, (String)"createInstance(...)");
        this.repositoryFiles = gitRepositoryFiles;
        this.repositoryReader = new GitRepositoryReader(project, this.repositoryFiles);
        this.recentCheckoutBranches = CollectionsKt.emptyList();
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)GitDisposable.Companion.getInstance(project).getCoroutineScope(), (String)"GitRepositoryImpl", null, (boolean)false, (int)6, null);
        this.stagingAreaHolder = new GitStagingAreaHolder(this);
        this.untrackedFilesHolder = new GitUntrackedFilesHolder(this);
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.untrackedFilesHolder);
        this.tagHolder = new GitTagHolder(this);
        this.repoInfo = this.readRepoInfo();
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    @NotNull
    public VirtualFile getGitDir() {
        return this.gitDir;
    }

    @Override
    @NotNull
    public GitRepositoryFiles getRepositoryFiles() {
        return this.repositoryFiles;
    }

    @Override
    @NotNull
    public GitStagingAreaHolder getStagingAreaHolder() {
        return this.stagingAreaHolder;
    }

    @Override
    @NotNull
    public GitUntrackedFilesHolder getUntrackedFilesHolder() {
        return this.untrackedFilesHolder;
    }

    @Override
    @NotNull
    public GitRepositoryIgnoredFilesHolder getIgnoredFilesHolder() {
        GitRepositoryIgnoredFilesHolder gitRepositoryIgnoredFilesHolder = this.untrackedFilesHolder.getIgnoredFilesHolder();
        Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryIgnoredFilesHolder, (String)"getIgnoredFilesHolder(...)");
        return gitRepositoryIgnoredFilesHolder;
    }

    @Override
    @NotNull
    public GitTagHolder getTagHolder() {
        return this.tagHolder;
    }

    @Override
    @NotNull
    public CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @Override
    @NotNull
    public GitRepoInfo getInfo() {
        return this.repoInfo;
    }

    @Override
    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.repoInfo.getCurrentBranch();
    }

    @Nullable
    public String getCurrentRevision() {
        return this.repoInfo.getCurrentRevision();
    }

    @NotNull
    public Repository.State getState() {
        return this.repoInfo.getState();
    }

    @Nullable
    public String getCurrentBranchName() {
        GitLocalBranch currentBranch;
        GitLocalBranch gitLocalBranch = currentBranch = this.getCurrentBranch();
        return gitLocalBranch != null ? gitLocalBranch.getName() : null;
    }

    @Override
    @NotNull
    public GitVcs getVcs() {
        return this.vcs;
    }

    @Override
    @NotNull
    public Collection<GitSubmoduleInfo> getSubmodules() {
        return this.repoInfo.getSubmodules();
    }

    @Override
    @NotNull
    public GitBranchesCollection getBranches() {
        GitRepoInfo info = this.repoInfo;
        return new GitBranchesCollection(info.getLocalBranchesWithHashes(), info.getRemoteBranchesWithHashes(), this.recentCheckoutBranches);
    }

    @Override
    @NotNull
    public Collection<GitRemote> getRemotes() {
        return this.repoInfo.getRemotes();
    }

    @Override
    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        return this.repoInfo.getBranchTrackInfos();
    }

    @Override
    @Nullable
    public GitBranchTrackInfo getBranchTrackInfo(@NotNull String localBranchName) {
        Intrinsics.checkNotNullParameter((Object)localBranchName, (String)"localBranchName");
        return this.repoInfo.getBranchTrackInfosMap().get(localBranchName);
    }

    @Override
    public boolean isRebaseInProgress() {
        return this.getState() == Repository.State.REBASING;
    }

    @Override
    public boolean isOnBranch() {
        return this.repoInfo.isOnBranch();
    }

    public void update() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        GitRepoInfo previousInfo = this.repoInfo;
        this.repoInfo = this.readRepoInfo();
        GitRepositoryImpl.Companion.notifyIfRepoChanged(this, previousInfo, this.repoInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GitRepoInfo readRepoInfo() {
        GitRepoInfo gitRepoInfo;
        SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(GitTelemetrySpan.Repository.ReadGitRepositoryInfo.getName());
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            GitRepoInfo gitRepoInfo2;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span span2 = span$iv;
                boolean bl3 = false;
                span2.setAttribute("repository", DvcsUtil.getShortRepositoryName((Repository)this));
                File file = this.repositoryFiles.getConfigFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getConfigFile(...)");
                File configFile = file;
                GitConfig gitConfig = GitConfig.read(configFile);
                Intrinsics.checkNotNullExpressionValue((Object)gitConfig, (String)"read(...)");
                GitConfig config = gitConfig;
                this.repositoryFiles.updateCustomPaths(config.parseCore());
                Set<GitRemote> set = config.parseRemotes();
                Intrinsics.checkNotNullExpressionValue(set, (String)"parseRemotes(...)");
                Set<GitRemote> remotes = set;
                GitBranchState state2 = this.repositoryReader.readState((Collection<GitRemote>)remotes);
                boolean isShallow = this.repositoryReader.hasShallowCommits();
                Map<GitRemoteBranch, Hash> remoteBranches2 = state2.getRemoteBranches();
                Map<GitLocalBranch, Hash> localBranches2 = state2.getLocalBranches();
                Set<GitBranchTrackInfo> set2 = config.parseTrackInfos((Collection<? extends GitLocalBranch>)state2.getLocalBranches().keySet(), (Collection<? extends GitRemoteBranch>)state2.getRemoteBranches().keySet());
                Intrinsics.checkNotNullExpressionValue(set2, (String)"parseTrackInfos(...)");
                Set<GitBranchTrackInfo> trackInfos = set2;
                GitHooksInfo hooksInfo = this.repositoryReader.readHooksInfo();
                File submoduleFile = new File(VfsUtilCore.virtualToIoFile((VirtualFile)this.getRoot()), ".gitmodules");
                Collection<GitSubmoduleInfo> submodules = new GitModulesFileReader().read(submoduleFile);
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                VirtualFile virtualFile = this.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                this.recentCheckoutBranches = GitRecentCheckoutBranches.collectRecentCheckoutBranches(project, virtualFile, (Function1<? super GitLocalBranch, Boolean>)((Function1)arg_0 -> GitRepositoryImpl.readRepoInfo$lambda$1$lambda$0(localBranches2, arg_0)));
                gitRepoInfo2 = new GitRepoInfo(state2.getCurrentBranch(), state2.getCurrentRevision(), state2.getState(), (Collection<GitRemote>)remotes, localBranches2, remoteBranches2, (Collection<? extends GitBranchTrackInfo>)trackInfos, submodules, hooksInfo, isShallow);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            gitRepoInfo = gitRepoInfo2;
        }
        catch (CancellationException e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.recordException((Throwable)e$iv$iv, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.recordException(e$iv$iv, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
        return gitRepoInfo;
    }

    public void dispose() {
        super.dispose();
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    @NotNull
    public String toLogString() {
        return "GitRepository " + this.getRoot() + " : " + this.repoInfo;
    }

    private static final boolean readRepoInfo$lambda$1$lambda$0(Map $localBranches, GitLocalBranch branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return $localBranches.containsKey(branch);
    }

    @JvmStatic
    @Deprecated(message="Use {@link GitRepositoryManager#getRepositoryForRoot} to obtain an instance of a Git repository.")
    @NotNull
    public static final GitRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, boolean listenToRepoChanges) {
        return Companion.getInstance(root, project, listenToRepoChanges);
    }

    @JvmStatic
    @Deprecated(message="Use {@link #createInstance(VirtualFile, Project, Disposable)}")
    @ApiStatus.Internal
    @NotNull
    public static final GitRepository createInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable, boolean listenToRepoChanges) {
        return Companion.createInstance(root, project, parentDisposable, listenToRepoChanges);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final GitRepository createInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable) {
        return Companion.createInstance(root, project, parentDisposable);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final GitRepository createInstance(@NotNull VirtualFile root, @NotNull VirtualFile gitDir, @NotNull Project project, @NotNull Disposable parentDisposable) {
        return Companion.createInstance(root, gitDir, project, parentDisposable);
    }

    public /* synthetic */ GitRepositoryImpl(Project project, VirtualFile rootDir, VirtualFile gitDir, Disposable parentDisposable, DefaultConstructorMarker $constructor_marker) {
        this(project, rootDir, gitDir, parentDisposable);
    }

    static {
        Logger logger = Logger.getInstance(GitRepositoryImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J(\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgit4idea/repo/GitRepositoryImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lgit4idea/repo/GitRepository;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "listenToRepoChanges", "", "createInstance", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "gitDir", "notifyIfRepoChanged", "", "repository", "previousInfo", "Lgit4idea/repo/GitRepoInfo;", "info", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Deprecated(message="Use {@link GitRepositoryManager#getRepositoryForRoot} to obtain an instance of a Git repository.")
        @NotNull
        public final GitRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, boolean listenToRepoChanges) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root);
            GitRepository gitRepository = repository;
            if (gitRepository == null) {
                gitRepository = this.createInstance(root, project, GitDisposable.Companion.getInstance(project));
            }
            return gitRepository;
        }

        @JvmStatic
        @Deprecated(message="Use {@link #createInstance(VirtualFile, Project, Disposable)}")
        @ApiStatus.Internal
        @NotNull
        public final GitRepository createInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable, boolean listenToRepoChanges) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            return this.createInstance(root, project, parentDisposable);
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final GitRepository createInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            VirtualFile virtualFile = GitUtil.findGitDir(root);
            if (virtualFile == null) {
                throw new IllegalStateException(("Git directory not found for " + root).toString());
            }
            VirtualFile gitDir = virtualFile;
            return this.createInstance(root, gitDir, project, parentDisposable);
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final GitRepository createInstance(@NotNull VirtualFile root, @NotNull VirtualFile gitDir, @NotNull Project project, @NotNull Disposable parentDisposable) {
            GitRepositoryImpl gitRepositoryImpl;
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)gitDir, (String)"gitDir");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            ProgressManager.checkCanceled();
            GitRepositoryImpl $this$createInstance_u24lambda_u240 = gitRepositoryImpl = new GitRepositoryImpl(project, root, gitDir, parentDisposable, null);
            boolean bl = false;
            GitRepoInfo initialRepoInfo = $this$createInstance_u24lambda_u240.repoInfo;
            GitRepositoryUpdater updater = new GitRepositoryUpdater($this$createInstance_u24lambda_u240, $this$createInstance_u24lambda_u240.repositoryFiles);
            updater.installListeners((Disposable)$this$createInstance_u24lambda_u240);
            Companion.notifyIfRepoChanged($this$createInstance_u24lambda_u240, null, initialRepoInfo);
            $this$createInstance_u24lambda_u240.untrackedFilesHolder.invalidate();
            return gitRepositoryImpl;
        }

        private final void notifyIfRepoChanged(GitRepository repository, GitRepoInfo previousInfo, GitRepoInfo info) {
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            if (!project2.isDisposed() && !Intrinsics.areEqual((Object)info, (Object)previousInfo)) {
                GitRepositoryManager.getInstance(project2).notifyListenersAsync(repository, previousInfo, info);
                LOG.debug("Repository " + repository + " changed");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

