/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/JSLanguageLevelGuesser;", "Lcom/intellij/platform/DirectoryProjectConfigurator$AsyncDirectoryProjectConfigurator;", "<init>", "()V", "configure", "", "project", "Lcom/intellij/openapi/project/Project;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleRef", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/openapi/module/Module;", "isProjectCreatedWithWizard", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/util/Ref;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.javascript.impl"})
public final class JSLanguageLevelGuesser
extends DirectoryProjectConfigurator.AsyncDirectoryProjectConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Object configure(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.readAction(() -> JSLanguageLevelGuesser.configure$lambda$0(project, baseDir), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit configure$lambda$0(Project $project, VirtualFile $baseDir) {
        Companion.configureProject($project, $baseDir);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @RequiresReadLock(generateAssertion=false)
    public static final void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir) {
        Companion.configureProject(project, baseDir);
    }

    @JvmStatic
    public static final void applyGuessedLanguageLevel(@NotNull Project project, @Nullable JSLanguageLevel guessedLevel) {
        Companion.applyGuessedLanguageLevel(project, guessedLevel);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/JSLanguageLevelGuesser$Companion;", "", "<init>", "()V", "configureProject", "", "project", "Lcom/intellij/openapi/project/Project;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "applyGuessedLanguageLevel", "guessedLevel", "Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @RequiresReadLock(generateAssertion=false)
        public final void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            JSLanguageLevel guessedLevel = null;
            VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(baseDir);
            if (packageJson != null) {
                PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
                Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
                PackageJsonData data = packageJsonData;
                for (String dep : data.getAllDependencies()) {
                    if (Intrinsics.areEqual((Object)"react", (Object)dep)) {
                        guessedLevel = JSLanguageLevel.getLevelForJSX();
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)"flow-bin", (Object)dep)) continue;
                    guessedLevel = JSLanguageLevel.FLOW;
                    break;
                }
            }
            if (guessedLevel != JSLanguageLevel.FLOW && baseDir.findChild(".flowconfig") != null) {
                guessedLevel = JSLanguageLevel.FLOW;
            }
            this.applyGuessedLanguageLevel(project, guessedLevel);
        }

        @JvmStatic
        public final void applyGuessedLanguageLevel(@NotNull Project project, @Nullable JSLanguageLevel guessedLevel) {
            JSRootConfiguration rootConfiguration;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (guessedLevel != null && guessedLevel.isAtLeast((rootConfiguration = JSRootConfiguration.getInstance(project)).getLanguageLevel()) && guessedLevel != rootConfiguration.getLanguageLevel()) {
                rootConfiguration.storeLanguageLevelAndUpdateCaches(guessedLevel);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

