/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.documentation;

import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.CustomNpmRegistryService;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.SwingHelper;
import java.awt.Color;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsPackageDocumentation {
    @NotNull
    private final Project myProject;
    @Nullable
    private final VirtualFile myContextFile;
    @Nls
    private final String myPackageName;
    @Nls
    private final String myDescription;
    @Nls
    private final String myReadmeHtml;
    private final VirtualFile myPackageDir;
    private PsiElement myContextElement;

    public NodeJsPackageDocumentation(@NotNull Project project, @Nullable VirtualFile contextFile, @NotNull @Nls String packageName, @Nullable @Nls String description, @Nullable @Nls String readmeHtml, @Nullable VirtualFile packageDir) {
        if (project == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myContextFile = contextFile;
        this.myPackageName = packageName;
        this.myDescription = description;
        this.myReadmeHtml = readmeHtml;
        this.myPackageDir = packageDir;
    }

    @NotNull
    @Nls
    public String getQuickInfoHtml() {
        return this.getQuickInfoHtml(this.myDescription, false, true);
    }

    @NotNull
    @Nls
    private String getQuickInfoHtml(@Nullable @Nls String description, boolean showInstalledVersion, boolean showLatestVersion) {
        if (showInstalledVersion) {
            return NodeJsPackageDocumentation.html(this.myPackageName, true, this.getInstalledVersion(), false, null, description);
        }
        Ref<SemVer> latestRef = showLatestVersion ? this.getLatest(description) : null;
        return NodeJsPackageDocumentation.html(this.myPackageName, false, null, showLatestVersion, latestRef != null ? (SemVer)latestRef.get() : null, description);
    }

    @Nullable
    private Ref<SemVer> getLatest(@Nullable @Nls String description) {
        return NodeJsPackageDocumentation.getLatest(this.myProject, this.myContextFile, this.myPackageName, latestVersion -> {
            if (this.myContextElement != null) {
                String html = NodeJsPackageDocumentation.html(this.myPackageName, false, null, true, latestVersion, description);
                QuickDocUtil.updateQuickDoc((Project)this.myContextElement.getProject(), (PsiElement)this.myContextElement, (String)html);
            }
        });
    }

    @Nullable
    public static Ref<SemVer> getLatest(@NotNull Project project, @Nullable VirtualFile packageJson, @NotNull String packageName, @Nullable Consumer<SemVer> nonCachedLatestVersionConsumer) {
        if (project == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(2);
        }
        if (packageName == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(3);
        }
        if (packageJson == null) {
            return NodeJsPackageDocumentation.getLatestFromNpmPublicRegistry(project, packageName, nonCachedLatestVersionConsumer);
        }
        CustomNpmRegistryService customNpmRegistryService = CustomNpmRegistryService.getInstance(project);
        Ref<AvailablePackageVersions> versionsRef = customNpmRegistryService.getCachedPackageVersions(packageJson, packageName);
        if (versionsRef != null) {
            AvailablePackageVersions versions = (AvailablePackageVersions)versionsRef.get();
            if (versions != null) {
                return Ref.create((Object)versions.findVersionByLatestDistTag());
            }
            return NodeJsPackageDocumentation.getLatestFromNpmPublicRegistry(project, packageName, nonCachedLatestVersionConsumer);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!project.isDisposed()) {
                Ref<SemVer> fromPublicRegistryRef;
                AvailablePackageVersions versions = customNpmRegistryService.getPackageVersions((ProgressIndicator)new EmptyProgressIndicator(), packageJson, packageName);
                if (versions != null) {
                    if (nonCachedLatestVersionConsumer != null) {
                        nonCachedLatestVersionConsumer.accept(versions.findVersionByLatestDistTag());
                    }
                } else if (!project.isDisposed() && (fromPublicRegistryRef = NodeJsPackageDocumentation.getLatestFromNpmPublicRegistry(project, packageName, nonCachedLatestVersionConsumer)) != null && nonCachedLatestVersionConsumer != null) {
                    nonCachedLatestVersionConsumer.accept((SemVer)fromPublicRegistryRef.get());
                }
            }
        });
        return null;
    }

    @Nullable
    private static Ref<SemVer> getLatestFromNpmPublicRegistry(@NotNull Project project, @NotNull String packageName, @Nullable Consumer<SemVer> nonCachedLatestVersionConsumer) {
        AvailablePackageVersions availableVersions;
        if (project == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(4);
        }
        if (packageName == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(5);
        }
        if ((availableVersions = NpmRegistryService.getInstance().getCachedPackageVersions(packageName)) != null) {
            return Ref.create((Object)availableVersions.findVersionByLatestDistTag());
        }
        NpmRegistryService.getInstance().asyncUpdateAndGetPackageVersions(packageName).onProcessed(versions -> ApplicationManager.getApplication().invokeLater(() -> {
            if (nonCachedLatestVersionConsumer != null) {
                nonCachedLatestVersionConsumer.accept(versions != null ? versions.findVersionByLatestDistTag() : null);
            }
            PsiManager.getInstance((Project)project).dropPsiCaches();
        }));
        return null;
    }

    @Nullable
    private SemVer getInstalledVersion() {
        VirtualFile packageJson;
        VirtualFile virtualFile = packageJson = this.myPackageDir != null ? PackageJsonUtil.findChildPackageJsonFile(this.myPackageDir) : null;
        if (packageJson != null) {
            return PackageJsonData.getOrCreate(packageJson).getVersion();
        }
        return null;
    }

    @NotNull
    @Nls
    private static String html(@NotNull @Nls String packageName, boolean showInstalledVersion, @Nullable SemVer installedVersion, boolean showLatestVersion, @Nullable SemVer latestVersion, @Nullable @Nls String description) {
        if (packageName == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(6);
        }
        String versionStr = null;
        if (showInstalledVersion) {
            if (installedVersion != null) {
                versionStr = JavaScriptBundle.message("node.package_documentation.installed_version.text", installedVersion.getRawVersion());
            }
        } else if (showLatestVersion) {
            if (latestVersion == null) {
                versionStr = IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]);
            } else {
                versionStr = latestVersion.getRawVersion();
                if (StringUtil.isEmptyOrSpaces((String)versionStr)) {
                    versionStr = IdeBundle.message((String)"label.category.n.a", (Object[])new Object[0]);
                }
            }
            versionStr = JavaScriptBundle.message("node.package_documentation.latest_version.text", versionStr);
        }
        HtmlChunk htmlChunk = NodeJsPackageDocumentation.createHtml(packageName, description, versionStr, (Color)new JBColor((Color)Gray.get((int)96), (Color)Gray.get((int)160)));
        String string = htmlChunk.toString();
        if (string == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static HtmlChunk createHtml(@NotNull @Nls String packageName, @Nullable @Nls String description, @Nullable @Nls String versionStr, @NotNull Color versionColor) {
        if (packageName == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(8);
        }
        if (versionColor == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(9);
        }
        HtmlChunk.Element tr1 = NodeJsPackageDocumentation.tr();
        tr1 = tr1.child((HtmlChunk)NodeJsPackageDocumentation.td().style("text-align:left").children(new HtmlChunk[]{HtmlChunk.tag((String)"b").addText(packageName)}));
        if (versionStr != null) {
            tr1 = tr1.child((HtmlChunk)NodeJsPackageDocumentation.td().style("width:20px"));
            tr1 = tr1.child((HtmlChunk)NodeJsPackageDocumentation.td().style("text-align:right").child((HtmlChunk)HtmlChunk.div((String)("color:#" + ColorUtil.toHex((Color)versionColor))).addText(versionStr)));
        }
        HtmlChunk.Element table = HtmlChunk.tag((String)"table").attr("cellspacing", 0).attr("cellpadding", 0).style("border: none");
        table = table.child((HtmlChunk)tr1);
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            table = table.child((HtmlChunk)NodeJsPackageDocumentation.tr().child((HtmlChunk)NodeJsPackageDocumentation.td().attr("colspan", 3).style("white-space:nowrap").addText(description)));
        }
        HtmlChunk.Element element = table;
        if (element == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(10);
        }
        return element;
    }

    @NotNull
    private static HtmlChunk.Element td() {
        HtmlChunk.Element element = HtmlChunk.tag((String)"td");
        if (element == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(11);
        }
        return element;
    }

    @NotNull
    private static HtmlChunk.Element tr() {
        HtmlChunk.Element element = HtmlChunk.tag((String)"tr");
        if (element == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(12);
        }
        return element;
    }

    @NotNull
    @Nls
    private String getBodyHtml() {
        if (this.myReadmeHtml != null) {
            String prefix = HtmlChunk.tag((String)"h1").addText(this.myPackageName).toString();
            if (StringUtil.startsWithIgnoreCase((String)this.myReadmeHtml, (String)prefix)) {
                String string = this.getQuickInfoHtml(null, true, false) + this.myReadmeHtml.substring(prefix.length());
                if (string == null) {
                    NodeJsPackageDocumentation.$$$reportNull$$$0(13);
                }
                return string;
            }
            String string = this.myReadmeHtml;
            if (string == null) {
                NodeJsPackageDocumentation.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = this.getQuickInfoHtml();
        if (string == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getFullDocHtml() {
        String html = this.getBodyHtml();
        String string = SwingHelper.buildHtml((String)"", (String)html);
        if (string == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public NodeJsPackageDocumentation setContextElement(@Nullable PsiElement contextElement) {
        this.myContextElement = contextElement;
        NodeJsPackageDocumentation nodeJsPackageDocumentation = this;
        if (nodeJsPackageDocumentation == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(17);
        }
        return nodeJsPackageDocumentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 11, 12, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocumentation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocumentation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "html";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtml";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "td";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "tr";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyHtml";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullDocHtml";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setContextElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLatest";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLatestFromNpmPublicRegistry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "html";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createHtml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

