/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRefList;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpretersDialog
extends DialogWrapper {
    private static final String DIMENSION_SERVICE_KEY = "jetbrains.nodejs.interpreters-dialog";
    private final Project myProject;
    private final NodeJsInterpreterField myInterpreterField;
    private final DefaultListModel<NodeJsInterpreterRef> myListModel;
    private final JBList<NodeJsInterpreterRef> myList;
    private final JComponent myCenterPanelComponent;
    private final boolean myProjectDefaultField;
    private final NodeJsInterpreterRef myPrevProjectInterpreterRef;
    private final Map<NodeJsInterpreterRef, NodeJsInterpreter> myChangesMap;

    public NodeJsInterpretersDialog(@NotNull NodeJsInterpreterField interpreterField) {
        if (interpreterField == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(0);
        }
        super(interpreterField.getProject(), true);
        this.myChangesMap = new HashMap<NodeJsInterpreterRef, NodeJsInterpreter>();
        this.myProject = interpreterField.getProject();
        this.myInterpreterField = interpreterField;
        this.myListModel = new DefaultListModel();
        this.myList = new JBList(this.myListModel);
        this.myList.setSelectionMode(2);
        this.myList.getEmptyText().setText(NodeJsInterpretersDialog.getEmptyText());
        this.myList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row;
                if (e.isPopupTrigger() && (row = NodeJsInterpretersDialog.this.myList.locationToIndex(e.getPoint())) >= 0) {
                    NodeJsInterpretersDialog.this.myList.setSelectedIndex(row);
                }
            }
        });
        this.myProjectDefaultField = interpreterField.isDefaultProjectInterpreterField();
        this.myPrevProjectInterpreterRef = this.myProjectDefaultField ? null : NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef();
        this.myList.setCellRenderer((ListCellRenderer)new NodeJsInterpreterRenderer(this.myProject, false));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).setPanelBorder((Border)JBUI.Borders.empty()).setAddAction(button -> this.performAddAction((AnActionButton)button)).setRemoveAction(button -> ListUtil.removeSelectedItems(this.myList, interpreterRef -> interpreterRef != null && interpreterRef.isConstantRef())).setRemoveActionUpdater(e -> {
            NodeJsInterpreterRef ref2 = (NodeJsInterpreterRef)this.myList.getSelectedValue();
            return ref2 != null && ref2.isConstantRef();
        }).setEditAction(button -> this.editSelected()).setEditActionUpdater(e -> this.isEditAvailable()).disableUpDownActions();
        JPanel decoratorPanel = decorator.createPanel();
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (NodeJsInterpretersDialog.this.isEditAvailable()) {
                    NodeJsInterpretersDialog.this.editSelected();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$2", "onDoubleClick"));
            }
        }.installOn(this.myList);
        decoratorPanel.setPreferredSize((Dimension)JBUI.size((int)550, (int)300));
        JScrollPane pane = ComponentUtil.getScrollPane(this.myList);
        if (pane != null) {
            pane.setHorizontalScrollBarPolicy(31);
        }
        this.myCenterPanelComponent = decoratorPanel;
        this.setTitle(JavaScriptBundle.message("node.js.interpreters", new Object[0]));
        this.init();
        this.configurePopupHandler();
        this.fillList();
    }

    private void configurePopupHandler() {
        ArrayList<SetAsProjectDefaultInterpreterAction> actionList = new ArrayList<SetAsProjectDefaultInterpreterAction>();
        if (!this.myProjectDefaultField) {
            actionList.add(new SetAsProjectDefaultInterpreterAction());
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup(actionList);
        for (AnAction anAction : actionList) {
            anAction.registerCustomShortcutSet(anAction.getShortcutSet(), this.myList);
        }
        PopupHandler.installPopupMenu(this.myList, (ActionGroup)actionGroup, (String)"NodeJSInterpreterListPopup");
    }

    @Nullable
    private NodeJsInterpreterRef getSingleSelectedInterpreterRef() {
        if (this.myList.getMinSelectionIndex() != this.myList.getMaxSelectionIndex()) {
            return null;
        }
        return (NodeJsInterpreterRef)this.myList.getSelectedValue();
    }

    private boolean isEditAvailable() {
        NodeJsInterpreterRef interpreterRef = this.getSingleSelectedInterpreterRef();
        return interpreterRef != null && interpreterRef.isConstantRef();
    }

    private void editSelected() {
        NodeJsInterpreterRef interpreterRef;
        int selectedInd = this.myList.getSelectedIndex();
        if (selectedInd >= 0 && (interpreterRef = this.myListModel.getElementAt(selectedInd)) != null && interpreterRef.isConstantRef()) {
            NodeJsInterpreter interpreter2 = interpreterRef.resolve(this.myProject);
            if (interpreter2 == null) {
                return;
            }
            NodeJsInterpreterType<? extends NodeJsInterpreter> interpreterType = interpreter2.getType();
            NodeJsInterpreter newInterpreter = interpreterType.edit(this.myProject, interpreter2);
            if (newInterpreter != null) {
                NodeJsInterpreterRef newInterpreterRef = newInterpreter.toRef();
                int index = this.myListModel.indexOf(newInterpreterRef);
                if (index != -1 && index != selectedInd) {
                    this.myList.setSelectedIndex(index);
                    selectedInd = index;
                }
                this.myListModel.set(selectedInd, newInterpreterRef);
                this.myChangesMap.put(newInterpreterRef, newInterpreter);
            } else {
                NodeUIUtil.balloonInfo(this.myProject, JavaScriptBundle.message("popup.content.cannot.edit.selected.node.js.interpreter", new Object[0]), this.myList.getLocationOnScreen(), MessageType.ERROR);
            }
        }
    }

    private void fillList() {
        NodeJsInterpreterRefList list = this.myInterpreterField.createInterpreterRefList();
        List<NodeJsInterpreterRef> refs = list.getAllAvailableAsRefs(!this.myProjectDefaultField);
        for (NodeJsInterpreterRef ref2 : refs) {
            this.myListModel.addElement(ref2);
        }
    }

    @NotNull
    @NlsContexts.StatusText
    private static String getEmptyText() {
        ShortcutSet shortcutSet = CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD);
        Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcutSet.getShortcuts());
        if (shortcut != null) {
            String string = JavaScriptBundle.message("status.text.add.interpreter.with", KeymapUtil.getShortcutText((Shortcut)shortcut));
            if (string == null) {
                NodeJsInterpretersDialog.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = JavaScriptBundle.message("status.text.no.interpreters.added", new Object[0]);
        if (string == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(3);
        }
        return dialogStyle;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPanelComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    @Nullable
    protected String getHelpId() {
        return "jetbrains.nodejs.interpreters-dialog.helpId";
    }

    @NotNull
    private List<NodeJsInterpreterRef> getInterpreterRefs() {
        ArrayList<NodeJsInterpreterRef> interpreterRefs = new ArrayList<NodeJsInterpreterRef>();
        for (int i = 0; i < this.myListModel.size(); ++i) {
            NodeJsInterpreterRef interpreterRef = this.myListModel.elementAt(i);
            if (interpreterRef == null) continue;
            interpreterRefs.add(interpreterRef);
        }
        ArrayList<NodeJsInterpreterRef> arrayList = interpreterRefs;
        if (arrayList == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void performAddAction(@NotNull AnActionButton button) {
        if (button == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(5);
        }
        JBPopup popup = NodeJsInterpretersDialog.createAddPopup(this.myInterpreterField, button.getDataContext(), (Consumer<? super NodeJsInterpreter>)((Consumer)interpreter2 -> {
            NodeJsInterpreterRef interpreterRef = interpreter2.toRef();
            this.myChangesMap.put(interpreterRef, (NodeJsInterpreter)interpreter2);
            this.addIfNeededAndSelect(interpreterRef);
        }));
        RelativePoint point = button.getPreferredPopupPoint();
        popup.show(point);
    }

    @NotNull
    public static JBPopup createAddPopup(@NotNull NodeJsInterpreterField interpreterField, @NotNull DataContext dataContext, @NotNull Consumer<? super NodeJsInterpreter> callback) {
        if (interpreterField == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(8);
        }
        List<NodeJsInterpreterType<?>> types = interpreterField.getInterpreterTypes(false);
        DefaultActionGroup group = new DefaultActionGroup();
        for (NodeJsInterpreterType<?> type : types) {
            group.add((AnAction)new AddInterpreterTypeAction(interpreterField.getProject(), type, callback));
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, false, true, true, null, -1, null);
        if (listPopup == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(9);
        }
        return listPopup;
    }

    @Nullable
    public Ref<NodeJsInterpreterRef> showAndGetSelected(@Nullable NodeJsInterpreterRef interpreterToAddAndSelect) {
        if (interpreterToAddAndSelect != null && !interpreterToAddAndSelect.equals(NodeJsInterpreterField.NO_INTERPRETER_REF)) {
            this.addIfNeededAndSelect(interpreterToAddAndSelect);
        } else {
            this.myList.clearSelection();
        }
        if (this.showAndGet()) {
            MultiMap group = MultiMap.create();
            for (NodeJsInterpreterType<?> type : this.myInterpreterField.getInterpreterTypes(false)) {
                group.put(type, new ArrayList());
            }
            List<NodeJsInterpreterRef> shownInterpreterRefs = this.getInterpreterRefs();
            for (NodeJsInterpreterRef interpreterRef : shownInterpreterRefs) {
                if (!interpreterRef.isConstantRef()) continue;
                NodeJsInterpreter interpreter2 = this.myChangesMap.get(interpreterRef);
                if (interpreter2 == null) {
                    interpreter2 = interpreterRef.resolve(this.myProject);
                }
                if (interpreter2 == null) continue;
                group.putValue(interpreter2.getType(), (Object)interpreter2);
            }
            for (Map.Entry entry : group.entrySet()) {
                ((NodeJsInterpreterType)entry.getKey()).setInterpreters(new ArrayList((Collection)entry.getValue()));
            }
            return Ref.create((Object)((NodeJsInterpreterRef)this.myList.getSelectedValue()));
        }
        if (this.myPrevProjectInterpreterRef != null) {
            NodeJsInterpreterManager.getInstance(this.myProject).setInterpreterRef(this.myPrevProjectInterpreterRef);
        }
        return null;
    }

    private void addIfNeededAndSelect(@NotNull NodeJsInterpreterRef interpreterRef) {
        int index;
        if (interpreterRef == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(10);
        }
        if ((index = this.myListModel.indexOf(interpreterRef)) == -1) {
            this.myListModel.addElement(interpreterRef);
            index = this.myListModel.size() - 1;
        }
        this.myList.setSelectedIndex(index);
        int finalIndex = index;
        UiNotifyConnector.doWhenFirstShown(this.myList, () -> ScrollingUtil.ensureIndexIsVisible(this.myList, (int)finalIndex, (int)1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterField";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRefs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performAddAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAddPopup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addIfNeededAndSelect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 9 -> new IllegalStateException(string);
        };
    }

    private class SetAsProjectDefaultInterpreterAction
    extends DumbAwareAction {
        protected SetAsProjectDefaultInterpreterAction() {
            super(JavaScriptBundle.message("node.js.set.project.interpreter.action", new Object[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SetAsProjectDefaultInterpreterAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SetAsProjectDefaultInterpreterAction.$$$reportNull$$$0(1);
            }
            NodeJsInterpreterRef interpreterRef = NodeJsInterpretersDialog.this.getSingleSelectedInterpreterRef();
            e.getPresentation().setEnabledAndVisible(this.canUseAsProjectDefaultInterpreterRef(interpreterRef));
        }

        @Contract(value="null -> false")
        private boolean canUseAsProjectDefaultInterpreterRef(@Nullable NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null || interpreterRef.isProjectRef()) {
                return false;
            }
            NodeJsInterpreter interpreter2 = interpreterRef.resolve(NodeJsInterpretersDialog.this.myProject);
            return interpreter2 instanceof NodeJsLocalInterpreter;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            NodeJsInterpreterRef interpreterRef;
            if (e == null) {
                SetAsProjectDefaultInterpreterAction.$$$reportNull$$$0(2);
            }
            if (this.canUseAsProjectDefaultInterpreterRef(interpreterRef = NodeJsInterpretersDialog.this.getSingleSelectedInterpreterRef())) {
                NodeJsInterpreterManager.getInstance(NodeJsInterpretersDialog.this.myProject).setInterpreterRef(interpreterRef);
                NodeJsInterpretersDialog.this.myList.repaint();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$SetAsProjectDefaultInterpreterAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$SetAsProjectDefaultInterpreterAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AddInterpreterTypeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final NodeJsInterpreterType<?> myType;
        private final Consumer<? super NodeJsInterpreter> myCallback;

        AddInterpreterTypeAction(@NotNull Project project, @NotNull NodeJsInterpreterType<?> type, @NotNull Consumer<? super NodeJsInterpreter> callback) {
            if (project == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(0);
            }
            if (type == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(1);
            }
            if (callback == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(2);
            }
            super(JavaScriptBundle.message("node.js.add.interpreter.action", StringUtil.capitalize((String)type.getName())));
            this.myProject = project;
            this.myType = type;
            this.myCallback = callback;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object addedInterpreter;
            if (e == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(3);
            }
            if ((addedInterpreter = this.myType.showAddDialog(this.myProject)) != null) {
                this.myCallback.consume(addedInterpreter);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(4);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(5);
            }
            boolean available = this.myType.isAvailable();
            e.getPresentation().setEnabledAndVisible(available);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$AddInterpreterTypeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$AddInterpreterTypeAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

