/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.download;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.UnsupportedDownloadNodePlatformException;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.system.CpuArch;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/download/NodeDownloadUtil;", "", "<init>", "()V", "getVersionsFolder", "", "getDownloadLocation", "version", "Lcom/intellij/util/text/SemVer;", "getDownloadCacheArchiveFile", "Ljava/nio/file/Path;", "url", "getUrl", "downloadAndExtract", "Lcom/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter;", "downloadLocation", "guessTopLevelDirName", "isDownloaded", "", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeDownloadUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeDownloadUtil.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeDownloadUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,105:1\n24#2:106\n*S KotlinDebug\n*F\n+ 1 NodeDownloadUtil.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeDownloadUtil\n*L\n84#1:106\n*E\n"})
public final class NodeDownloadUtil {
    @NotNull
    public static final NodeDownloadUtil INSTANCE = new NodeDownloadUtil();

    private NodeDownloadUtil() {
    }

    @NotNull
    public final String getVersionsFolder() {
        return PathManager.getConfigPath() + "/node/versions";
    }

    @NotNull
    public final String getDownloadLocation(@NotNull SemVer version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return this.getVersionsFolder() + "/" + version2.getRawVersion();
    }

    private final Path getDownloadCacheArchiveFile(String url) throws IOException {
        Path path2;
        String pathString = PathManager.getConfigPath() + "/node/download_cache/" + PathUtil.getFileName((String)url);
        try {
            path2 = Path.of(pathString, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new IOException("Invalid download cache file: " + pathString, e);
        }
        return path2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String getUrl(@NotNull SemVer version2) throws UnsupportedDownloadNodePlatformException {
        String string;
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        if (SystemInfo.isMac && CpuArch.isIntel64()) {
            string = "darwin-x64";
        } else if (SystemInfo.isMac && CpuArch.isArm64()) {
            if (!version2.isGreaterOrEqualThan(16, 0, 0)) {
                Object[] objectArray = new Object[]{SystemInfo.OS_NAME, CpuArch.CURRENT, "16.0.0"};
                String string2 = JavaScriptBundle.message("node.download.supported_later.platform", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                throw new UnsupportedDownloadNodePlatformException(string2, version2);
            }
            string = "darwin-arm64";
        } else if (SystemInfo.isLinux && CpuArch.isIntel32()) {
            string = "linux-x86";
        } else if (SystemInfo.isLinux && CpuArch.isIntel64()) {
            string = "linux-x64";
        } else if (SystemInfo.isLinux && CpuArch.isArm64()) {
            string = "linux-arm64";
        } else if (SystemInfo.isWindows && CpuArch.isIntel32()) {
            string = "win-x86";
        } else if (SystemInfo.isWindows && CpuArch.isIntel64()) {
            string = "win-x64";
        } else if (SystemInfo.isWindows && CpuArch.isArm64()) {
            if (!version2.isGreaterOrEqualThan(19, 9, 0)) {
                Object[] objectArray = new Object[]{SystemInfo.OS_NAME, CpuArch.CURRENT, "19.9.0"};
                String string3 = JavaScriptBundle.message("node.download.supported_later.platform", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                throw new UnsupportedDownloadNodePlatformException(string3, version2);
            }
            string = "win-arm64";
        } else {
            Object[] objectArray = new Object[]{SystemInfo.OS_NAME, CpuArch.CURRENT};
            String string4 = JavaScriptBundle.message("node.download.unsupported.platform", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            throw new UnsupportedDownloadNodePlatformException(string4, version2);
        }
        String arch = string;
        String fileNameWithoutExtension = "node-v" + version2.getRawVersion() + "-" + arch;
        String extension = SystemInfo.isWindows ? "zip" : "tar.gz";
        return "https://nodejs.org/dist/v" + version2.getRawVersion() + "/" + fileNameWithoutExtension + "." + extension;
    }

    @NotNull
    public final NodeJsLocalInterpreter downloadAndExtract(@NotNull SemVer version2, @NotNull Path downloadLocation) throws UnsupportedDownloadNodePlatformException, IOException {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)downloadLocation, (String)"downloadLocation");
        String url = this.getUrl(version2);
        Path archiveFile = this.getDownloadCacheArchiveFile(url);
        DownloadUtil.downloadAtomically((ProgressIndicator)ProgressManager.getGlobalProgressIndicator(), (String)url, (File)archiveFile.toFile());
        Decompressor decompressor = StringsKt.endsWith$default((String)url, (String)".zip", (boolean)false, (int)2, null) ? (Decompressor)new Decompressor.Zip(archiveFile) : (Decompressor)new Decompressor.Tar(archiveFile);
        decompressor.removePrefixPath(this.guessTopLevelDirName(url)).extract(downloadLocation);
        Path binDir = SystemInfo.isWindows ? downloadLocation : downloadLocation.resolve("bin");
        String binFileName = SystemInfo.isWindows ? "node.exe" : "node";
        NodeJsLocalInterpreter interpreter2 = new NodeJsLocalInterpreter(((Object)binDir.resolve(binFileName)).toString());
        if (!interpreter2.isValid()) {
            NodeDownloadUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NodeDownloadUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Invalid executable: " + interpreter2.getInterpreterSystemDependentPath());
            throw new IOException(JavaScriptBundle.message("node.download.cannot_find_interpreter.error", new Object[0]));
        }
        return interpreter2;
    }

    private final String guessTopLevelDirName(String url) {
        String string = PathUtil.getFileName((String)url);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String fileName = string;
        String extension = SystemInfo.isWindows ? ".zip" : ".tar.gz";
        return StringsKt.removeSuffix((String)fileName, (CharSequence)extension);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isDownloaded(@NotNull NodeJsInterpreter $this$isDownloaded) {
        Intrinsics.checkNotNullParameter((Object)$this$isDownloaded, (String)"<this>");
        if (!($this$isDownloaded instanceof NodeJsLocalInterpreter)) return false;
        String string = ((NodeJsLocalInterpreter)$this$isDownloaded).getInterpreterSystemIndependentPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInterpreterSystemIndependentPath(...)");
        String string2 = FileUtil.toSystemIndependentName((String)this.getVersionsFolder());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) return false;
        return true;
    }
}

