/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeVmConnectionFactory;
import com.intellij.javascript.nodejs.execution.NodeRunConfigurationAccessor;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.library.core.NodeCoreModulesCatalog;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;

public class NodeCoreSourcesFetchSession {
    private static final Logger LOG = NodeCoreLibraryConfigurator.LOG;
    private static final String CONTENT_SUFFIX = "});";
    private static final String LOADER_PATH = "node-core-modules/node-core-modules-loader.js";
    private static final String EXPERIMENTAL_WORKER = "--experimental-worker";
    private static final String DOT_JS = ".js";
    private final Project myProject;
    private final NodeJsInterpreter myInterpreter;
    private final File myOutputDir;
    @NotNull
    private final NodeVmConnectionFactory myConnectionFactory;
    private File myWorkingDirectory;

    private NodeCoreSourcesFetchSession(@NotNull Project project, @NotNull NodeJsInterpreter interpreter2, @NotNull File outputDir, @NotNull NodeVmConnectionFactory connectionFactory) {
        if (project == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(0);
        }
        if (interpreter2 == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(1);
        }
        if (outputDir == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(2);
        }
        if (connectionFactory == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myInterpreter = interpreter2;
        this.myOutputDir = outputDir;
        this.myConnectionFactory = connectionFactory;
    }

    public static void fetchSourcesSync(@NotNull Project project, @NotNull NodeJsInterpreter interpreter2, @NotNull File outputDir) throws IOException, ExecutionException {
        NodeVmConnectionFactory connectionFactory;
        if (project == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(4);
        }
        if (interpreter2 == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(5);
        }
        if (outputDir == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(6);
        }
        if ((connectionFactory = (NodeVmConnectionFactory)ApplicationManager.getApplication().getService(NodeVmConnectionFactory.class)) == null) {
            LOG.warn(JavaScriptBundle.message("node.core.make.sure.javascript.debugger.plugin.enabled.dialog.message", new Object[0]));
            return;
        }
        NodeCoreSourcesFetchSession session = new NodeCoreSourcesFetchSession(project, interpreter2, outputDir, connectionFactory);
        session.fetchSourcesSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchSourcesSync() throws IOException, ExecutionException {
        long startNanoTime = System.nanoTime();
        int debugPort = NetUtils.findAvailableSocketPort();
        GeneralCommandLine commandLine = this.createCommandLine(debugPort);
        LOG.info("Running " + commandLine.getCommandLineString());
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine);
        try {
            MyProcessListener listener2 = new MyProcessListener();
            processHandler.addProcessListener((ProcessListener)listener2);
            processHandler.startNotify();
            listener2.awaitReady();
            this.attachDebuggerSync(debugPort);
        }
        finally {
            NodeCoreSourcesFetchSession.terminateSync((OSProcessHandler)processHandler);
        }
        FileUtil.delete((File)this.myWorkingDirectory);
        LOG.info("Done in " + TimeoutUtil.getDurationMillis((long)startNanoTime) + " ms, located in " + this.myOutputDir.getAbsolutePath());
    }

    private static void terminateSync(@NotNull OSProcessHandler processHandler) {
        if (processHandler == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(7);
        }
        if (!processHandler.isProcessTerminated()) {
            ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)2000L, null);
            LOG.info("Terminating " + processHandler.getCommandLine() + ", terminated: " + processHandler.isProcessTerminated());
        }
    }

    private void attachDebuggerSync(int debugPort) throws ExecutionException {
        List scripts;
        RemoteVmConnection connection = this.myConnectionFactory.createVmConnection();
        Object vm = NodeCommandLineUtil.initRemoteVmConnectionSync(connection, debugPort);
        try {
            Promise<List<Pair<Url, String>>> promise = NodeCoreSourcesFetchSession.fetchScripts(vm);
            scripts = Objects.requireNonNull((List)promise.blockingGet(120, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            throw new ExecutionException(JavaScriptBundle.message("node.core.failed_to_fetch_node_core_modules.dialog.message", new Object[0]), (Throwable)e);
        }
        finally {
            try {
                connection.detachAndClose().blockingGet(5, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("Cannot terminate " + vm.getClass() + " connected to " + connection.getAddress(), (Throwable)e);
            }
        }
        ArrayList<String> skippedScriptPaths = new ArrayList<String>();
        for (Pair script : scripts) {
            String urlPath = NodeCoreSourcesFetchSession.getFileNameToSave((Url)script.first, skippedScriptPaths);
            if (urlPath == null) continue;
            File outFile = new File(this.myOutputDir, urlPath);
            String content = NodeCoreSourcesFetchSession.refine((String)script.second);
            try {
                FileUtil.writeToFile((File)outFile, (String)content);
            }
            catch (IOException e) {
                LOG.error("Cannot write to " + outFile);
            }
        }
        if (!skippedScriptPaths.isEmpty()) {
            LOG.info("Skipped Node.js core scripts: " + skippedScriptPaths);
        }
    }

    @NotNull
    private static Promise<List<Pair<Url, String>>> fetchScripts(@NotNull Vm vm) {
        if (vm == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(8);
        }
        AsyncPromise promise = new AsyncPromise();
        NodeCoreSourcesFetchSession.doWhenScriptLoadingSettlesDown(vm, System.currentTimeMillis(), 0, () -> {
            List<Script> scripts = NodeCoreSourcesFetchSession.listLoadedScripts(vm);
            CopyOnWriteArrayList data = new CopyOnWriteArrayList();
            CountDownLatch contentsLatch = new CountDownLatch(scripts.size());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                for (Script script : scripts) {
                    vm.getScriptManager().getSource(script).onProcessed(content -> {
                        if (content == null) {
                            LOG.info("Cannot load content for " + script.getUrl());
                        } else {
                            data.add(Pair.create((Object)script.getUrl(), (Object)content));
                        }
                        contentsLatch.countDown();
                    });
                }
            });
            try {
                contentsLatch.await(110L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                promise.setError((Throwable)e);
            }
            LOG.info("Loaded " + data.size() + " scripts with content");
            promise.setResult(data);
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(9);
        }
        return asyncPromise;
    }

    /*
     * WARNING - void declaration
     */
    private static void doWhenScriptLoadingSettlesDown(@NotNull Vm vm, long startTimeMillis, int prevLoadedScriptCount, @NotNull Runnable runnable) {
        void onReady;
        if (vm == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(10);
        }
        if (runnable == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(11);
        }
        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> NodeCoreSourcesFetchSession.lambda$doWhenScriptLoadingSettlesDown$3(vm, prevLoadedScriptCount, (Runnable)onReady, startTimeMillis), prevLoadedScriptCount == 0 ? 200L : 700L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    private static List<Script> listLoadedScripts(@NotNull Vm vm) {
        if (vm == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(12);
        }
        ArrayList<Script> scripts = new ArrayList<Script>();
        vm.getScriptManager().forEachScript(script -> {
            scripts.add((Script)script);
            return true;
        });
        ArrayList<Script> arrayList = scripts;
        if (arrayList == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    private static String getFileNameToSave(@NotNull Url scriptUrl, List<String> skippedScriptPaths) {
        String publicModuleName;
        if (scriptUrl == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(14);
        }
        Object scriptPath = scriptUrl.getPath();
        if ("node".equals(scriptUrl.getScheme()) && !((String)scriptPath).endsWith(DOT_JS)) {
            scriptPath = (String)scriptPath + DOT_JS;
        }
        if ((publicModuleName = NodeCoreModulesCatalog.INSTANCE.getPublicReplacementName((String)scriptPath)) != null) {
            return publicModuleName;
        }
        if (OSAgnosticPathUtil.isAbsolute((String)scriptPath) || FileUtil.toSystemIndependentName((String)scriptPath).endsWith(LOADER_PATH)) {
            return null;
        }
        if (!((String)scriptPath).endsWith(DOT_JS)) {
            skippedScriptPaths.add((String)scriptPath);
            return null;
        }
        if (StringUtil.containsAnyChar((String)scriptPath, (String)"<>:\"|?*")) {
            skippedScriptPaths.add((String)scriptPath);
            return null;
        }
        return scriptPath;
    }

    private static String refine(@NotNull String source) {
        String prefix;
        if (source == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(15);
        }
        if ((prefix = NodeCoreSourcesFetchSession.findPrefixToRemove(source = source.trim())) != null && source.endsWith(CONTENT_SUFFIX)) {
            return source.substring(prefix.length(), source.length() - CONTENT_SUFFIX.length());
        }
        return source;
    }

    @Nullable
    private static String findPrefixToRemove(@NotNull String source) {
        char ch;
        int lastPrefixCharInd;
        String start;
        if (source == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(16);
        }
        if (!source.startsWith(start = "(function (")) {
            return null;
        }
        int paramsStartInd = start.length();
        int paramsEndInd = source.indexOf(")", paramsStartInd);
        if (paramsEndInd == -1) {
            return null;
        }
        String params = source.substring(paramsStartInd, paramsEndInd);
        if (!params.contains("require")) {
            return null;
        }
        int openBraceInd = source.indexOf(123, paramsEndInd + 1);
        if (openBraceInd == -1) {
            return null;
        }
        if (!source.substring(paramsEndInd + 1, openBraceInd).trim().isEmpty()) {
            return null;
        }
        for (lastPrefixCharInd = openBraceInd + 1; lastPrefixCharInd < source.length() && (ch = source.charAt(lastPrefixCharInd)) != '\n'; ++lastPrefixCharInd) {
            if (Character.isWhitespace(ch)) continue;
            --lastPrefixCharInd;
            break;
        }
        if (lastPrefixCharInd >= source.length()) {
            return null;
        }
        return source.substring(0, lastPrefixCharInd + 1);
    }

    @NotNull
    private GeneralCommandLine createCommandLine(int debugPort) throws IOException, ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        this.myWorkingDirectory = NodeCoreSourcesFetchSession.createWorkingDirectory();
        commandLine.setWorkDirectory(this.myWorkingDirectory.getAbsolutePath());
        commandLine.setCharset(StandardCharsets.UTF_8);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setRedirectErrorStream(true);
        NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, Collections.emptyList(), debugPort, false, this.myInterpreter, true);
        if (this.enableExperimentalWorker()) {
            commandLine.addParameters(new String[]{EXPERIMENTAL_WORKER});
        }
        File script = HelperFilesLocator.getFileRelativeToHelpersDir(LOADER_PATH);
        commandLine.addParameter(script.getAbsolutePath());
        commandLine.addParameters(NodeCoreModulesCatalog.INSTANCE.getPublicCoreModules());
        NodeCommandLineConfigurator.find(this.myInterpreter).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(17);
        }
        return generalCommandLine;
    }

    private boolean enableExperimentalWorker() {
        SemVer version2 = (SemVer)Ref.deref(this.myInterpreter.getCachedVersion());
        if (version2 != null && version2.isGreaterOrEqualThan(10, 5, 0)) {
            if (version2.getMajor() <= 11) {
                return true;
            }
            NodeRunConfigurationAccessor accessor = NodeRunConfigurationAccessor.getInstance(this.myProject);
            String nodeParameters = accessor != null ? accessor.getTemplateNodeParameters() : null;
            return nodeParameters != null && ParametersListUtil.parse((String)nodeParameters).contains(EXPERIMENTAL_WORKER);
        }
        return false;
    }

    @NotNull
    private static File createWorkingDirectory() throws IOException {
        File file = FileUtil.createTempDirectory((String)"intellij-node-core-modules-", null, (boolean)true);
        if (file == null) {
            NodeCoreSourcesFetchSession.$$$reportNull$$$0(18);
        }
        return file;
    }

    private static /* synthetic */ void lambda$doWhenScriptLoadingSettlesDown$3(Vm vm, int prevLoadedScriptCount, Runnable onReady, long startTimeMillis) {
        List<Script> scripts = NodeCoreSourcesFetchSession.listLoadedScripts(vm);
        int loadedScriptCount = scripts.size();
        LOG.info("Loaded " + loadedScriptCount + " scripts, previously " + prevLoadedScriptCount);
        if (loadedScriptCount > 0 && loadedScriptCount == prevLoadedScriptCount) {
            onReady.run();
            return;
        }
        if (System.currentTimeMillis() - startTimeMillis > TimeUnit.SECONDS.toMillis(10L)) {
            LOG.info("Stop waiting for new loaded scripts");
            onReady.run();
            return;
        }
        NodeCoreSourcesFetchSession.doWhenScriptLoadingSettlesDown(vm, startTimeMillis, loadedScriptCount, onReady);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 13, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionFactory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vm";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreSourcesFetchSession";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onReady";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptUrl";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreSourcesFetchSession";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchScripts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "listLoadedScripts";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fetchSourcesSync";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "terminateSync";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fetchScripts";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doWhenScriptLoadingSettlesDown";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "listLoadedScripts";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileNameToSave";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "refine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findPrefixToRemove";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 13, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static class MyProcessListener
    extends ProcessAdapter {
        private static final String READY_MESSAGE = "@debugger: core modules loaded, ready for communication";
        private final StringBuffer myStdOutBuffer = new StringBuffer();
        private final CountDownLatch myReadyLatch = new CountDownLatch(1);

        private MyProcessListener() {
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            String text;
            if (event == null) {
                MyProcessListener.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                MyProcessListener.$$$reportNull$$$0(1);
            }
            if ((text = StringUtil.notNullize((String)event.getText())).isEmpty() || outputType == ProcessOutputTypes.SYSTEM) {
                return;
            }
            String logPrefix = outputType == ProcessOutputTypes.STDERR ? "[stderr] " : "[stdout] ";
            LOG.info(logPrefix + StringUtil.trimEnd((String)text, (String)"\n"));
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myStdOutBuffer.append(text);
                if (this.isReady()) {
                    this.myReadyLatch.countDown();
                }
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                MyProcessListener.$$$reportNull$$$0(2);
            }
            LOG.info("Process terminated with exit code " + event.getExitCode());
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> this.myReadyLatch.countDown(), 2L, TimeUnit.SECONDS);
        }

        private boolean isReady() {
            return this.myStdOutBuffer.indexOf(READY_MESSAGE) >= 0;
        }

        public void awaitReady() throws ExecutionException {
            try {
                boolean ready = this.myReadyLatch.await(60L, TimeUnit.SECONDS);
                if (!ready) {
                    throw new ExecutionException(JavaScriptBundle.message("node.core.core_modules_fetch_timed_out.dialog.message", new Object[0]));
                }
                if (!this.isReady()) {
                    throw new ExecutionException(JavaScriptBundle.message("node.core.not_ready_for_core_modules_configuration.dialog.message", new Object[0]));
                }
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreSourcesFetchSession$MyProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

