/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class YarnPnpExcludePolicy
implements DirectoryIndexExcludePolicy {
    private final Project myProject;
    private YarnPnpManager myManager;

    public YarnPnpExcludePolicy(@NotNull Project project) {
        if (project == null) {
            YarnPnpExcludePolicy.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public String @NotNull [] getExcludeUrlsForProject() {
        if (YarnPnpManager.shouldUseWorkspaceModel()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                YarnPnpExcludePolicy.$$$reportNull$$$0(1);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        List<YarnPnpFile> pnpFiles = this.getManager().getPnpFiles();
        if (pnpFiles.isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                YarnPnpExcludePolicy.$$$reportNull$$$0(2);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (YarnPnpFile file : pnpFiles) {
            YarnPnpExcludePolicy.addExcludeFiles(file, result2);
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            YarnPnpExcludePolicy.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    private static void addExcludeFiles(@NotNull YarnPnpFile file, @NotNull List<String> result2) {
        VirtualFile parentDir;
        VirtualFile pnpJsFile;
        if (file == null) {
            YarnPnpExcludePolicy.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            YarnPnpExcludePolicy.$$$reportNull$$$0(5);
        }
        if ((pnpJsFile = file.getPnpFile()).isValid() && (parentDir = pnpJsFile.getParent()) != null) {
            result2.add(pnpJsFile.getUrl());
            YarnPnpExcludePolicy.addDirectoryIfExists(parentDir, ".yarn", result2);
            YarnPnpExcludePolicy.addDirectoryIfExists(parentDir, ".pnp", result2);
        }
    }

    private static void addDirectoryIfExists(@NotNull VirtualFile dir, @NotNull String childName, @NotNull List<String> resultUrls) {
        VirtualFile child;
        if (dir == null) {
            YarnPnpExcludePolicy.$$$reportNull$$$0(6);
        }
        if (childName == null) {
            YarnPnpExcludePolicy.$$$reportNull$$$0(7);
        }
        if (resultUrls == null) {
            YarnPnpExcludePolicy.$$$reportNull$$$0(8);
        }
        if ((child = dir.findChild(childName)) != null && child.isValid()) {
            resultUrls.add(child.getUrl());
        }
    }

    @NotNull
    private YarnPnpManager getManager() {
        YarnPnpManager manager = this.myManager;
        if (manager == null) {
            this.myManager = manager = YarnPnpManager.getInstance(this.myProject);
        }
        YarnPnpManager yarnPnpManager = manager;
        if (yarnPnpManager == null) {
            YarnPnpExcludePolicy.$$$reportNull$$$0(9);
        }
        return yarnPnpManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpExcludePolicy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpExcludePolicy";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeUrlsForProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addExcludeFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDirectoryIfExists";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 9 -> new IllegalStateException(string);
        };
    }
}

