/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageJsonScriptReferenceSupport {
    private static final Logger LOG = Logger.getInstance(PackageJsonScriptReferenceSupport.class);
    private static final String NPM = "npm";
    private static final String YARN = "yarn";
    private static final Set<String> NPM_SHORT_LIST = ContainerUtil.newHashSet((Object[])new String[]{"test", "start", "restart", "stop"});
    private static final String ENV_SCRIPT = "env";

    private PackageJsonScriptReferenceSupport() {
    }

    @NotNull
    static List<PsiReference> getReferences(final @NotNull JsonStringLiteral literal) {
        Chunk current;
        int i;
        if (literal == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(0);
        }
        List<Chunk> chunks = PackageJsonScriptReferenceSupport.createChunks(literal);
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        for (i = 1; i < chunks.size(); ++i) {
            boolean addRef;
            Chunk prev;
            current = chunks.get(i);
            boolean bl = PackageJsonScriptReferenceSupport.isScriptRefChunk(NPM, i >= 2 ? chunks.get(i - 2) : null, prev = chunks.get(i - 1), current) || PackageJsonScriptReferenceSupport.isScriptRefChunk(YARN, i >= 2 ? chunks.get(i - 2) : null, prev, current) ? true : (addRef = false);
            if (!addRef) continue;
            refs.add(new NpmScriptReference(literal, current.myRange, current.myText, prev.myText));
        }
        for (i = 0; i < chunks.size(); ++i) {
            FileReferenceSet set;
            boolean npmScript;
            boolean yarnScript;
            current = chunks.get(i);
            boolean bl = i >= 1 && PackageJsonScriptReferenceSupport.isScriptRefChunk(YARN, i >= 2 ? chunks.get(i - 2) : null, chunks.get(i - 1), current) ? true : (yarnScript = false);
            boolean bl2 = i >= 1 && PackageJsonScriptReferenceSupport.isScriptRefChunk(NPM, i >= 2 ? chunks.get(i - 2) : null, chunks.get(i - 1), current) ? true : (npmScript = false);
            if (npmScript) continue;
            boolean exePlace = PackageJsonScriptReferenceSupport.isExecutableChunk(current);
            if ((exePlace || yarnScript) && !current.myText.contains("/") && !current.myText.contains("\\")) {
                set = new FileReferenceSet(current.myText, (PsiElement)literal, current.myRange.getStartOffset(), null, true, false){

                    @NotNull
                    public Collection<PsiFileSystemItem> computeDefaultContexts() {
                        List list = ContainerUtil.createMaybeSingletonList((Object)PackageJsonScriptReferenceSupport.findNodeModulesBin(literal));
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return list;
                    }

                    protected boolean isSoft() {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/packageJson/PackageJsonScriptReferenceSupport$1", "computeDefaultContexts"));
                    }
                };
                refs.addAll(Arrays.asList(set.getAllReferences()));
            }
            set = new FileReferenceSet(current.myText, (PsiElement)literal, current.myRange.getStartOffset(), null, true, false){

                protected boolean isSoft() {
                    return true;
                }
            };
            refs.addAll(Arrays.asList(set.getAllReferences()));
        }
        ArrayList<PsiReference> arrayList = refs;
        if (arrayList == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static boolean isExecutableChunk(@NotNull Chunk chunk) {
        int i;
        if (chunk == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(2);
        }
        for (i = chunk.myRange.getStartOffset() - 1; i >= 0 && Character.isWhitespace(chunk.myWholeText.charAt(i)); --i) {
        }
        return i == 0 && chunk.myWholeText.charAt(i) == '\"' || i > 0 && StringUtil.containsChar((String)"&|;", (char)chunk.myWholeText.charAt(i));
    }

    private static boolean isScriptRefChunk(@NotNull String packageManager, @Nullable Chunk prevPrev, @NotNull Chunk prev, @NotNull Chunk current) {
        boolean addRef;
        if (packageManager == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(3);
        }
        if (prev == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(4);
        }
        if (current == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(5);
        }
        boolean bl = addRef = packageManager.equals(prev.myText) && PackageJsonScriptReferenceSupport.isWhitespacesBetween(prev, current);
        if (prevPrev != null && !addRef) {
            addRef = packageManager.equals(prevPrev.myText) && PackageJsonScriptReferenceSupport.isWhitespacesBetween(prevPrev, prev) && NpmCommand.RUN_SCRIPT.getCliOption().equals(prev.myText) && PackageJsonScriptReferenceSupport.isWhitespacesBetween(prev, current);
        }
        return addRef;
    }

    @Nullable
    private static PsiDirectory findNodeModulesBin(@NotNull JsonStringLiteral literal) {
        VirtualFile packageJson;
        if (literal == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(6);
        }
        VirtualFile nodeModules = (packageJson = literal.getContainingFile().getOriginalFile().getVirtualFile()) != null ? NodeModuleUtil.findNodeModulesByPackageJson(packageJson) : null;
        VirtualFile bin = nodeModules != null ? nodeModules.findChild(".bin") : null;
        return bin != null ? literal.getManager().findDirectory(bin) : null;
    }

    private static boolean isWhitespacesBetween(@NotNull Chunk left, @NotNull Chunk right) {
        if (left == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(7);
        }
        if (right == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(8);
        }
        assert (Strings.areSameInstance((String)left.myWholeText, (String)right.myWholeText));
        assert (left.myRange.getEndOffset() < right.myRange.getStartOffset());
        for (int i = left.myRange.getEndOffset(); i < right.myRange.getStartOffset(); ++i) {
            if (Character.isWhitespace(left.myWholeText.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    static List<Chunk> createChunks(@NotNull JsonStringLiteral literal) {
        String text;
        if (literal == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(9);
        }
        if (!StringUtil.isQuotedString((String)(text = literal.getText()))) {
            List<Chunk> list = Collections.emptyList();
            if (list == null) {
                PackageJsonScriptReferenceSupport.$$$reportNull$$$0(10);
            }
            return list;
        }
        List ranges = StringUtil.getWordIndicesIn((String)text, (Set)ContainerUtil.newHashSet((Object[])new Character[]{Character.valueOf(' '), Character.valueOf(';'), Character.valueOf('\t'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('\"'), Character.valueOf('\'')}));
        List list = ContainerUtil.map((Collection)ranges, range -> new Chunk((TextRange)range, range.substring(text), text));
        if (list == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static boolean isNpmOrYarn(@Nullable String str) {
        return NPM.equals(str) || YARN.equals(str);
    }

    public static void complete(CompletionParameters parameters, CompletionResultSet result2) {
        List<Chunk> chunks;
        Chunk chunkAtOffset;
        JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)parameters.getPosition().getParent(), JsonStringLiteral.class);
        if (literal == null) {
            return;
        }
        NpmScriptReference ref2 = PackageJsonScriptReferenceSupport.findNpmScriptReference(literal.findReferenceAt(parameters.getOffset() - literal.getTextRange().getStartOffset()));
        result2 = result2.withRelevanceSorter(PackageJsonScriptReferenceSupport.createSorter(parameters));
        if (ref2 != null) {
            ArrayList<String> strings = new ArrayList<String>(PackageJsonScriptReferenceSupport.listNpmScripts(ref2.myFile));
            if (!strings.contains(ENV_SCRIPT)) {
                strings.add(ENV_SCRIPT);
            }
            for (String scriptName : strings) {
                if (!ref2.canReference(scriptName)) continue;
                result2.addElement(LookupElementBuilder.create((String)scriptName).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
            }
        }
        if ((chunkAtOffset = PackageJsonScriptReferenceSupport.findChunk(chunks = PackageJsonScriptReferenceSupport.createChunks(literal), parameters.getOffset() - literal.getTextRange().getStartOffset())) != null) {
            int ind = chunks.indexOf(chunkAtOffset);
            assert (ind >= 0);
            if (ind > 0) {
                Chunk prev = chunks.get(ind - 1);
                if (PackageJsonScriptReferenceSupport.isNpmOrYarn(prev.myText) && PackageJsonScriptReferenceSupport.isWhitespacesBetween(prev, chunkAtOffset)) {
                    boolean yarn = YARN.equals(prev.myText);
                    for (NpmCommand command : NpmCommand.getCommands(yarn)) {
                        result2.addElement(LookupElementBuilder.create((String)command.getCliOption(yarn)).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
                    }
                }
            }
            if (PackageJsonScriptReferenceSupport.isExecutableChunk(chunkAtOffset)) {
                List binaries = List.of("node", NPM);
                if (NpmUtil.isYarnAlikePackageRef(NpmManager.getInstance(literal.getProject()).getPackageRef())) {
                    binaries = ContainerUtil.append(binaries, (Object[])new String[]{YARN});
                }
                for (String binary : binaries) {
                    result2.addElement(LookupElementBuilder.create((String)binary).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
                }
            }
        }
    }

    private static CompletionSorter createSorter(CompletionParameters parameters) {
        CompletionSorter sorter = CompletionSorter.emptySorter().weigh((LookupElementWeigher)new LiveTemplateWeigher()).weigh(new LookupElementWeigher("priority"){

            @NotNull
            public Double weigh(@NotNull LookupElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                Double d = 1.0;
                if (d == null) {
                    3.$$$reportNull$$$0(1);
                }
                return d;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonScriptReferenceSupport$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonScriptReferenceSupport$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }).weigh((LookupElementWeigher)new RealPrefixMatchingWeigher());
        if (sorter instanceof CompletionSorterImpl) {
            final CompletionLocation location = new CompletionLocation(parameters);
            sorter = ((CompletionSorterImpl)sorter).withClassifier((ClassifierFactory)new ClassifierFactory<LookupElement>("stat"){

                public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                    return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
                }
            });
        }
        return sorter;
    }

    @Nullable
    private static Chunk findChunk(List<Chunk> chunks, int offset) {
        return (Chunk)ContainerUtil.find(chunks, chunk -> chunk.myRange.contains(offset));
    }

    @Nullable
    private static NpmScriptReference findNpmScriptReference(@Nullable PsiReference ref2) {
        if (ref2 instanceof NpmScriptReference) {
            return (NpmScriptReference)ref2;
        }
        if (ref2 instanceof PsiMultiReference) {
            for (PsiReference reference : ((PsiMultiReference)ref2).getReferences()) {
                if (!(reference instanceof NpmScriptReference)) continue;
                return (NpmScriptReference)reference;
            }
        }
        return null;
    }

    @Nullable
    private static JsonProperty findNpmScript(@Nullable JsonFile file, @NotNull String scriptName) {
        JsonObject scriptsObj;
        JsonProperty scriptsProperty;
        if (scriptName == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(12);
        }
        if ((scriptsProperty = NpmScriptsUtil.findScriptsProperty(file)) != null && (scriptsObj = (JsonObject)ObjectUtils.tryCast((Object)scriptsProperty.getValue(), JsonObject.class)) != null) {
            return scriptsObj.findProperty(scriptName);
        }
        return null;
    }

    @NotNull
    private static List<String> listNpmScripts(@Nullable JsonFile file) {
        JsonObject scriptsObj;
        JsonProperty scriptsProperty = NpmScriptsUtil.findScriptsProperty(file);
        if (scriptsProperty != null && (scriptsObj = (JsonObject)ObjectUtils.tryCast((Object)scriptsProperty.getValue(), JsonObject.class)) != null) {
            ArrayList<String> result2 = new ArrayList<String>();
            for (JsonProperty property : scriptsObj.getPropertyList()) {
                result2.add(property.getName());
            }
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                PackageJsonScriptReferenceSupport.$$$reportNull$$$0(13);
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PackageJsonScriptReferenceSupport.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonScriptReferenceSupport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonScriptReferenceSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createChunks";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "listNpmScripts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isExecutableChunk";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isScriptRefChunk";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findNodeModulesBin";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isWhitespacesBetween";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createChunks";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findNpmScript";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10, 11, 13, 14 -> new IllegalStateException(string);
        };
    }

    private static final class Chunk {
        private final TextRange myRange;
        private final String myText;
        private final String myWholeText;

        private Chunk(@NotNull TextRange range, @NotNull String text, @NotNull String wholeText) {
            if (range == null) {
                Chunk.$$$reportNull$$$0(0);
            }
            if (text == null) {
                Chunk.$$$reportNull$$$0(1);
            }
            if (wholeText == null) {
                Chunk.$$$reportNull$$$0(2);
            }
            this.myRange = range;
            this.myText = text;
            this.myWholeText = wholeText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "wholeText";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonScriptReferenceSupport$Chunk";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class NpmScriptReference
    implements PsiReference {
        private final JsonStringLiteral myLiteral;
        private final TextRange myRange;
        private final String myRangeText;
        private final JsonFile myFile;
        private final String myPrevCommand;

        private NpmScriptReference(@NotNull JsonStringLiteral literal, @NotNull TextRange range, @NotNull String rangeText, @NotNull String prevCommand) {
            if (literal == null) {
                NpmScriptReference.$$$reportNull$$$0(0);
            }
            if (range == null) {
                NpmScriptReference.$$$reportNull$$$0(1);
            }
            if (rangeText == null) {
                NpmScriptReference.$$$reportNull$$$0(2);
            }
            if (prevCommand == null) {
                NpmScriptReference.$$$reportNull$$$0(3);
            }
            this.myLiteral = literal;
            this.myRange = range;
            this.myRangeText = rangeText;
            this.myFile = (JsonFile)literal.getContainingFile();
            this.myPrevCommand = prevCommand;
        }

        @NotNull
        public PsiElement getElement() {
            JsonStringLiteral jsonStringLiteral = this.myLiteral;
            if (jsonStringLiteral == null) {
                NpmScriptReference.$$$reportNull$$$0(4);
            }
            return jsonStringLiteral;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                NpmScriptReference.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        @Nullable
        public PsiElement resolve() {
            if (this.canReference(this.myRangeText)) {
                return PackageJsonScriptReferenceSupport.findNpmScript(this.myFile, this.myRangeText);
            }
            return null;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myRangeText;
            if (string == null) {
                NpmScriptReference.$$$reportNull$$$0(6);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newName) throws IncorrectOperationException {
            if (newName == null) {
                NpmScriptReference.$$$reportNull$$$0(7);
            }
            PsiElement element = this.getElement();
            try {
                return CachingReference.getManipulator((PsiElement)element).handleContentChange(element, this.myRange, newName);
            }
            catch (IncorrectOperationException e) {
                LOG.error("Cannot rename " + this.getClass() + " from " + this.myRangeText + " to " + newName, (Throwable)e);
                throw e;
            }
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                NpmScriptReference.$$$reportNull$$$0(8);
            }
            return null;
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                NpmScriptReference.$$$reportNull$$$0(9);
            }
            if (element instanceof JsonProperty) {
                JsonProperty property = (JsonProperty)element;
                return this.myRangeText.equals(property.getName()) && NpmScriptsUtil.isScriptProperty(property);
            }
            return false;
        }

        public boolean isSoft() {
            return true;
        }

        private boolean canReference(@NotNull String scriptName) {
            if (scriptName == null) {
                NpmScriptReference.$$$reportNull$$$0(10);
            }
            return !this.myPrevCommand.equals(PackageJsonScriptReferenceSupport.NPM) || NPM_SHORT_LIST.contains(scriptName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeText";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prevCommand";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonScriptReferenceSupport$NpmScriptReference";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonScriptReferenceSupport$NpmScriptReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "canReference";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

