/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.intellij.javascript.testFramework.jasmine.AbstractJasmineElement;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteStructure;
import com.intellij.javascript.testFramework.util.JSTestNamePattern;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JasmineSuiteNode {
    private final List<JasmineSuiteStructure> mySuiteChildren = new ArrayList<JasmineSuiteStructure>();
    private final List<JasmineSpecStructure> mySpecChildren = new ArrayList<JasmineSpecStructure>();
    private final Map<String, AbstractJasmineElement> myChildByNameMap = new HashMap<String, AbstractJasmineElement>();
    private final List<AbstractJasmineElement> myChildren = new ArrayList<AbstractJasmineElement>();
    private List<AbstractJasmineElement> myChildrenWithNonLiteralNamePattern;

    JasmineSuiteNode() {
    }

    void addChild(@NotNull AbstractJasmineElement child) {
        if (child == null) {
            JasmineSuiteNode.$$$reportNull$$$0(0);
        }
        if (child instanceof JasmineSuiteStructure) {
            this.mySuiteChildren.add((JasmineSuiteStructure)child);
        } else if (child instanceof JasmineSpecStructure) {
            this.mySpecChildren.add((JasmineSpecStructure)child);
        } else {
            throw new IllegalStateException("Unknown type: " + child.getClass());
        }
        this.myChildren.add(child);
    }

    @Nullable
    public JasmineSuiteStructure findChildSuiteByName(@NotNull String childSuiteName) {
        if (childSuiteName == null) {
            JasmineSuiteNode.$$$reportNull$$$0(1);
        }
        return (JasmineSuiteStructure)ObjectUtils.tryCast((Object)this.findChild(childSuiteName), JasmineSuiteStructure.class);
    }

    public JasmineSpecStructure findChildSpecByName(@NotNull String childSpecName) {
        if (childSpecName == null) {
            JasmineSuiteNode.$$$reportNull$$$0(2);
        }
        return (JasmineSpecStructure)ObjectUtils.tryCast((Object)this.findChild(childSpecName), JasmineSpecStructure.class);
    }

    @Nullable
    private AbstractJasmineElement findChild(@NotNull String childName) {
        AbstractJasmineElement element;
        if (childName == null) {
            JasmineSuiteNode.$$$reportNull$$$0(3);
        }
        if ((element = this.myChildByNameMap.get(childName)) != null) {
            return element;
        }
        for (AbstractJasmineElement value : this.getChildrenWithNonLiteralNamePattern()) {
            if (!value.getNamePattern().matches(childName)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    private List<AbstractJasmineElement> getChildrenWithNonLiteralNamePattern() {
        List children = this.myChildrenWithNonLiteralNamePattern;
        if (children == null) {
            this.myChildrenWithNonLiteralNamePattern = children = ContainerUtil.filter(this.myChildByNameMap.values(), child -> {
                JSTestNamePattern.Literal singleLiteralRange = child.getNamePattern().getSingleLiteralRange();
                return singleLiteralRange == null || !singleLiteralRange.getLiteral().equals(child.getName());
            });
        }
        List list = children;
        if (list == null) {
            JasmineSuiteNode.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<JasmineSpecStructure> getChildSpecs() {
        List<JasmineSpecStructure> list = this.mySpecChildren;
        if (list == null) {
            JasmineSuiteNode.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<JasmineSuiteStructure> getChildSuites() {
        List<JasmineSuiteStructure> list = this.mySuiteChildren;
        if (list == null) {
            JasmineSuiteNode.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<AbstractJasmineElement> getChildren() {
        List<AbstractJasmineElement> list = this.myChildren;
        if (list == null) {
            JasmineSuiteNode.$$$reportNull$$$0(7);
        }
        return list;
    }

    void fillNameMap() {
        for (AbstractJasmineElement jasmineElement : this.myChildren) {
            this.myChildByNameMap.put(jasmineElement.getName(), jasmineElement);
        }
    }

    void postProcess() {
        this.fillNameMap();
        this.iterateChildrenRecursively(structure -> structure.getNode().fillNameMap(), null);
    }

    public void iterateChildrenRecursively(@Nullable Consumer<JasmineSuiteStructure> suiteConsumer, @Nullable Consumer<JasmineSpecStructure> specConsumer) {
        for (JasmineSuiteStructure suite : this.mySuiteChildren) {
            suite.getNode().iterateChildrenRecursively(suiteConsumer, specConsumer);
        }
        if (suiteConsumer != null) {
            this.mySuiteChildren.forEach(suiteConsumer);
        }
        if (specConsumer != null) {
            this.mySpecChildren.forEach(specConsumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childSuiteName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childSpecName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/jasmine/JasmineSuiteNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/jasmine/JasmineSuiteNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenWithNonLiteralNamePattern";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildSpecs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildSuites";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findChildSuiteByName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findChildSpecByName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

