/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6FunctionParser<T extends JavaScriptParser>
extends FunctionParser<T> {
    public static final Key<Boolean> HAD_ASYNC_MODIFIER_KEY = Key.create((String)"js.asyncModifier");
    private static final JSModifiersStructure ARROW_FUNCTION_MODIFIERS = new JSModifiersStructureLeaf(JSTokenTypes.ASYNC_KEYWORD);

    public ES6FunctionParser(T parser2) {
        super(parser2);
    }

    @Override
    public boolean parseFunctionNoMarker(FunctionParser.Context context2, @NotNull PsiBuilder.Marker functionMarker) {
        if (functionMarker == null) {
            ES6FunctionParser.$$$reportNull$$$0(0);
        }
        boolean wasAsync = this.checkModifierAndSaveAsync();
        boolean result2 = super.parseFunctionNoMarker(context2, functionMarker);
        this.restoreAsync(wasAsync);
        return result2;
    }

    @Override
    public boolean hasSupportDecorators() {
        return true;
    }

    @Override
    public boolean isFunctionDeclarationStart() {
        IElementType tokenType = this.builder.getTokenType();
        return tokenType == JSTokenTypes.FUNCTION_KEYWORD || tokenType == JSTokenTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD;
    }

    @Override
    public boolean parseAttributesList() {
        if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
            return false;
        }
        PsiBuilder.Marker modifierList = this.builder.mark();
        boolean hadAttributes = this.tryParseES7Decorators();
        if (hadAttributes && ((StatementParser)this.myJavaScriptParser.getStatementParser()).isExportDefault()) {
            modifierList.done(this.getAttributeListElementType());
            return true;
        }
        boolean hadExport = false;
        if (this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD) {
            hadExport = true;
            this.builder.advanceLexer();
        }
        if (!hadAttributes) {
            this.tryParseES7Decorators();
        }
        if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD) {
            this.builder.advanceLexer();
            this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, (Object)Boolean.TRUE);
        }
        if (!hadExport && JSTokenTypes.GET_SET.contains(this.builder.getTokenType()) && ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).isPropertyNameStart(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
        modifierList.done(this.getAttributeListElementType());
        return true;
    }

    @Override
    public boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
        if (arrowFunction == null) {
            ES6FunctionParser.$$$reportNull$$$0(1);
        }
        EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiers = this.parseArrowFunctionAttributeList();
        EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext = JSParsingContextUtil.saveAndUpdateParsingContext(modifiers, this.builder);
        boolean result2 = super.parseArrowFunctionWithoutModifiers(arrowFunction);
        JSParsingContextUtil.restoreParsingContext(savedContext, this.builder);
        return result2;
    }

    @Override
    protected boolean isValidFirstParameterStart(IElementType next) {
        IElementType nextLookAhead;
        return super.isValidFirstParameterStart(next) && (next != JSTokenTypes.ASYNC_KEYWORD || (nextLookAhead = this.builder.lookAhead(2)) != JSTokenTypes.LPAR && nextLookAhead != JSTokenTypes.MULT);
    }

    @NotNull
    protected EnumSet<JSModifiersStructure.JSModifiersParseResult> parseArrowFunctionAttributeList() {
        EnumSet<JSModifiersStructure.JSModifiersParseResult> enumSet = this.myJavaScriptParser.parseModifiers(ARROW_FUNCTION_MODIFIERS, false, builder2 -> this.isAcceptableLambdaTokenAfterAsync(builder2.getTokenType()));
        if (enumSet == null) {
            ES6FunctionParser.$$$reportNull$$$0(2);
        }
        return enumSet;
    }

    protected boolean isAcceptableLambdaTokenAfterAsync(IElementType tokenType) {
        return tokenType == JSTokenTypes.LPAR || this.myJavaScriptParser.isIdentifierName(tokenType);
    }

    @Override
    public boolean allowLastCommaInParameterAndArgumentList() {
        return true;
    }

    private boolean checkModifierAndSaveAsync() {
        boolean hadAsyncModifier = Boolean.TRUE.equals(this.builder.getUserData(HAD_ASYNC_MODIFIER_KEY));
        this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, null);
        boolean wasAsync = JSParsingContextUtil.isAsyncContext(this.builder);
        this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)hadAsyncModifier);
        return wasAsync;
    }

    private void restoreAsync(@Nullable Boolean wasAsync) {
        this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)wasAsync);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionMarker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrowFunction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/parsing/ES6FunctionParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/parsing/ES6FunctionParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArrowFunctionAttributeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFunctionNoMarker";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseArrowFunctionWithoutModifiers";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

