/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXLanguageLevelAnnotator
implements Annotator {
    private static final String JSX_SWITCH_DISABLED = "jsx.switch.disabled";

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        VirtualFile virtualFile;
        JSFile file;
        if (element == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(1);
        }
        if ((file = (JSFile)ObjectUtils.tryCast((Object)element, JSFile.class)) == null) {
            return;
        }
        Project project = file.getProject();
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement(file);
        if (optionHolder == null || optionHolder.isJSX() || !optionHolder.isTypeScript) {
            return;
        }
        if (PropertiesComponent.getInstance((Project)project).getBoolean(JSX_SWITCH_DISABLED)) {
            return;
        }
        if (JSXLanguageLevelAnnotator.isJsxFile(file) && (virtualFile = file.getVirtualFile()) != null && virtualFile.isInLocalFileSystem()) {
            JSXLanguageLevelAnnotator.addTypeScriptNotification(holder, file);
        }
    }

    private static void addTypeScriptNotification(@NotNull AnnotationHolder holder, @NotNull JSFile file) {
        if (holder == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(3);
        }
        holder.newAnnotation(HighlightSeverity.WARNING, JavaScriptBundle.message("ts.switch.to.jsx.inspection.name", new Object[0])).range((PsiElement)file).fileLevel().gutterIconRenderer((GutterIconRenderer)new JSXGutterIconRenderer()).withFix((IntentionAction)new RenameFileFix(file.getName() + "x")).withFix(JSXLanguageLevelAnnotator.createDismissIntention()).create();
    }

    @NotNull
    private static IntentionAction createDismissIntention() {
        return new IntentionAction(){

            @NotNull
            public String getText() {
                String string = JavaScriptBundle.message("js.switch.to.jsx.inspection.dismiss", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = JavaScriptBundle.message("javascript.change.language.level.family", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                PropertiesComponent.getInstance((Project)project).setValue(JSXLanguageLevelAnnotator.JSX_SWITCH_DISABLED, "true");
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/JSXLanguageLevelAnnotator$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXLanguageLevelAnnotator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2, 3 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static boolean isJsxFile(@NotNull JSFile file) {
        if (file == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(4);
        }
        final Ref jsxRef = Ref.create((Object)false);
        new JSRecursiveWalkingElementVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                if (element instanceof LeafPsiElement) {
                    IElementType elementType = element.getNode().getElementType();
                    if (elementType == JSTokenTypes.XML_TAG_NAME) {
                        PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
                        PsiElement psiElement = prev = prev instanceof PsiWhiteSpace ? PsiTreeUtil.prevLeaf((PsiElement)prev) : prev;
                        if (prev == null || prev.getNode().getElementType() != JSTokenTypes.XML_START_TAG_START || !prev.textMatches((CharSequence)"<")) {
                            return;
                        }
                        PsiElement psiElement2 = prev = (prev = PsiTreeUtil.prevLeaf((PsiElement)prev)) instanceof PsiWhiteSpace ? PsiTreeUtil.prevLeaf((PsiElement)prev) : prev;
                        if (prev == null || !prev.textMatches((CharSequence)"<")) {
                            jsxRef.set((Object)true);
                            this.stopWalking();
                        }
                    } else if (elementType == JSTokenTypes.LT) {
                        PsiElement prev;
                        PsiElement next;
                        PsiElement startNext = PsiTreeUtil.nextLeaf((PsiElement)element);
                        PsiElement psiElement = next = startNext != null ? PsiTreeUtil.nextLeaf((PsiElement)startNext) : null;
                        if (JSXLanguageLevelAnnotator.isCloseTagExpression(startNext, next)) {
                            jsxRef.set((Object)true);
                            this.stopWalking();
                        }
                        PsiElement psiElement3 = prev = (prev = PsiTreeUtil.prevLeaf((PsiElement)element)) instanceof PsiWhiteSpace ? PsiTreeUtil.prevLeaf((PsiElement)prev) : prev;
                        if (JSXLanguageLevelAnnotator.isOpenTagExpression(next, prev)) {
                            jsxRef.set((Object)true);
                            this.stopWalking();
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/jsx/JSXLanguageLevelAnnotator$2", "visitElement"));
            }
        }.visitFile(file);
        return (Boolean)jsxRef.get();
    }

    private static boolean isOpenTagExpression(@Nullable PsiElement next, @Nullable PsiElement prev) {
        if ((next == null || next.getNode().getElementType() != JSTokenTypes.LT) && prev instanceof PsiErrorElement && JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]).equals(((PsiErrorElement)prev).getErrorDescription())) {
            PsiElement prevPrev = PsiTreeUtil.prevLeaf((PsiElement)prev);
            return prevPrev == null || prevPrev.getNode().getElementType() != JSTokenTypes.LT;
        }
        return false;
    }

    private static boolean isCloseTagExpression(@Nullable PsiElement startNext, @Nullable PsiElement next) {
        if (startNext == null || next == null) {
            return false;
        }
        if (startNext instanceof PsiErrorElement && next.getNode().getElementType() == JSTokenTypes.REGEXP_LITERAL && JSXLanguageLevelAnnotator.isNodeTextLikeCloseTag(next)) {
            return true;
        }
        return next instanceof PsiErrorElement && startNext.getNode().getElementType() == JSTokenTypes.REGEXP_LITERAL && JSXLanguageLevelAnnotator.isNodeTextLikeCloseTag(startNext);
    }

    private static boolean isNodeTextLikeCloseTag(@NotNull PsiElement next) {
        String text;
        if (next == null) {
            JSXLanguageLevelAnnotator.$$$reportNull$$$0(5);
        }
        return (text = next.getText()).startsWith("/") && text.contains(">");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/JSXLanguageLevelAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeScriptNotification";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isJsxFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isNodeTextLikeCloseTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JSXGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private JSXGutterIconRenderer() {
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = JavaScriptLanguageIcons.Logos.Jsx_16;
            if (icon == null) {
                JSXGutterIconRenderer.$$$reportNull$$$0(0);
            }
            return icon;
        }

        public boolean equals(Object obj) {
            return obj instanceof JSXGutterIconRenderer;
        }

        public int hashCode() {
            return System.identityHashCode(JavaScriptLanguageIcons.Logos.Jsx_16);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/jsx/JSXLanguageLevelAnnotator$JSXGutterIconRenderer", "getIcon"));
        }
    }
}

