/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPackageJsonMappingContributorBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005H\u0014J:\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/JSPackageJsonExportsMappingContributor;", "Lcom/intellij/lang/javascript/frameworks/modules/JSPackageJsonMappingContributorBase;", "<init>", "()V", "getModuleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "unquotedRefText", "", "host", "Lcom/intellij/psi/PsiElement;", "placeRoot", "isRefTextAcceptable", "", "isRootAcceptable", "buildReferenceForExternalPackage", "Lcom/intellij/psi/PsiReference;", "mappings", "", "matchedStar", "offset", "", "getSubstitutions", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappings;", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "packageJsonData", "Lcom/intellij/javascript/nodejs/PackageJsonData;", "getModuleDirectory", "dependencyName", "isPlaceAcceptableForImport", "moduleRoot", "intellij.javascript.impl"})
public class JSPackageJsonExportsMappingContributor
extends JSPackageJsonMappingContributorBase {
    @Override
    @Nullable
    protected VirtualFile getModuleRoot(@NotNull String unquotedRefText, @NotNull PsiElement host, @NotNull VirtualFile placeRoot) {
        Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)placeRoot, (String)"placeRoot");
        String string = NodeModuleSearchUtil.extractDependencyName(unquotedRefText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractDependencyName(...)");
        String dependencyName = string;
        if (((CharSequence)dependencyName).length() == 0) {
            return null;
        }
        return this.getModuleDirectory(host, dependencyName, placeRoot);
    }

    @Override
    protected boolean isRefTextAcceptable(@NotNull String unquotedRefText) {
        Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
        return !JSFileReferencesUtil.isRelative(unquotedRefText);
    }

    @Override
    protected boolean isRootAcceptable(@NotNull VirtualFile placeRoot) {
        Intrinsics.checkNotNullParameter((Object)placeRoot, (String)"placeRoot");
        return true;
    }

    @Override
    @Nullable
    protected PsiReference buildReferenceForExternalPackage(@NotNull List<String> mappings, @Nullable String matchedStar, @NotNull String unquotedRefText, @NotNull PsiElement host, int offset) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return null;
    }

    @Override
    @NotNull
    protected JSModulePathMappings<JSModulePathSubstitution> getSubstitutions(@NotNull PackageJsonData packageJsonData) {
        Intrinsics.checkNotNullParameter((Object)packageJsonData, (String)"packageJsonData");
        JSModulePathMappings<JSModulePathSubstitution> jSModulePathMappings = packageJsonData.getExports();
        Intrinsics.checkNotNullExpressionValue(jSModulePathMappings, (String)"getExports(...)");
        return jSModulePathMappings;
    }

    private final VirtualFile getModuleDirectory(PsiElement host, String dependencyName, VirtualFile placeRoot) {
        InstalledPackageVersion existingPackage = new NodeInstalledPackageFinder(host.getProject(), placeRoot).findInstalledPackage(dependencyName);
        InstalledPackageVersion installedPackageVersion = existingPackage;
        if (installedPackageVersion == null || (installedPackageVersion = installedPackageVersion.getPackageDir()) == null) {
            return null;
        }
        return installedPackageVersion;
    }

    @Override
    protected boolean isPlaceAcceptableForImport(@NotNull VirtualFile placeRoot, @NotNull VirtualFile moduleRoot) {
        Intrinsics.checkNotNullParameter((Object)placeRoot, (String)"placeRoot");
        Intrinsics.checkNotNullParameter((Object)moduleRoot, (String)"moduleRoot");
        return !Intrinsics.areEqual((Object)placeRoot, (Object)moduleRoot);
    }
}

