/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLexerUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.types.JSBlockStatementElementTypeFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class StatementParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    protected static final Logger LOG = Logger.getInstance(StatementParser.class);
    public static final Key<String> withinInterfaceKey = Key.create((String)"within.interface");
    public static final Key<Boolean> IS_BLOCK_BODY_CONTEXT = Key.create((String)"js.block.body.context");
    private static final TokenSet USING_DECLARATION_BINDING_ID_TOKENS_FOR_LOOP = TokenSet.andNot((TokenSet)JSKeywordSets.ES6_IDENTIFIER_TOKENS_SET, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.OF_KEYWORD}));
    protected static final TokenSet EXPORTABLE_ELEMENTS_KEYWORDS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.VAR_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.FUNCTION_KEYWORD, JSTokenTypes.CLASS_KEYWORD, JSTokenTypes.ASYNC_KEYWORD, JSTokenTypes.TYPE_KEYWORD, JSTokenTypes.OPAQUE_KEYWORD})});

    protected StatementParser(T parser2) {
        super(parser2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void parseStatement() {
        startOffset = this.builder.getCurrentOffset();
        firstToken = this.builder.getTokenType();
        if (firstToken == null) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.statement", new Object[0]));
            return;
        }
        if (firstToken == JSTokenTypes.LBRACE) {
            this.parseBlock();
            return;
        }
        if (firstToken == JSTokenTypes.SEMICOLON) {
            this.parseEmptyStatement();
            return;
        }
        if (firstToken == JSTokenTypes.IF_KEYWORD) {
            this.parseIfStatement();
            return;
        }
        if (firstToken == JSTokenTypes.DO_KEYWORD || firstToken == JSTokenTypes.WHILE_KEYWORD || firstToken == JSTokenTypes.FOR_KEYWORD) {
            this.parseIterationStatement();
            return;
        }
        if (firstToken == JSTokenTypes.CONTINUE_KEYWORD) {
            this.parseContinueStatement();
            return;
        }
        if (firstToken == JSTokenTypes.BREAK_KEYWORD) {
            this.parseBreakStatement();
            return;
        }
        if (firstToken == JSTokenTypes.RETURN_KEYWORD) {
            this.parseReturnStatement();
            return;
        }
        if (firstToken == JSTokenTypes.WITH_KEYWORD) {
            this.parseWithStatement();
            return;
        }
        if (firstToken == JSTokenTypes.YIELD_KEYWORD) {
            this.parseExpressionStatement();
            return;
        }
        if (firstToken == JSTokenTypes.SWITCH_KEYWORD) {
            this.parseSwitchStatement();
            return;
        }
        if (firstToken == JSTokenTypes.THROW_KEYWORD) {
            this.parseThrowStatement();
            return;
        }
        if (firstToken == JSTokenTypes.TRY_KEYWORD) {
            this.parseTryStatement();
            return;
        }
        if (firstToken == JSTokenTypes.DEBUGGER_KEYWORD) {
            stmt = this.builder.mark();
            this.builder.advanceLexer();
            this.forceCheckForSemicolon();
            stmt.done(JSElementTypes.DEBUGGER_STATEMENT);
            return;
        }
        functionParser = this.myJavaScriptParser.getFunctionParser();
        if (JSTokenTypes.IDENTIFIER == firstToken || this.isPossibleStartStatementModifier(firstToken) || JSTokenTypes.LBRACKET == firstToken && this.isECMAL4() || JSTokenTypes.AT == firstToken && functionParser.hasSupportDecorators()) {
            marker = this.builder.mark();
            methodEmptiness = (FunctionParser.MethodEmptiness)this.builder.getUserData(FunctionParser.methodsEmptinessKey);
            if (!functionParser.parseAttributesList()) {
                marker.rollbackTo();
            } else {
                try {
                    if (this.builder.eof()) {
                        marker.drop();
                        return;
                    }
                    tokenType = this.builder.getTokenType();
                    if (tokenType == JSTokenTypes.FUNCTION_KEYWORD) {
                        functionParser.parseFunctionNoMarker(FunctionParser.Context.SOURCE_ELEMENT, marker);
                        return;
                    }
                    if (this.isExportDefault()) {
                        this.parseES6ExportDefaultAssignmentNoMarker(marker);
                        return;
                    }
                    if (JSTokenTypes.VAR_MODIFIERS_WITHOUT_USING.contains(tokenType)) {
                        this.parseVarStatementNoMarker(false, marker);
                        return;
                    }
                    if (this.parseDialectSpecificSourceElements(marker)) {
                        return;
                    }
                    if (tokenType == JSTokenTypes.CLASS_KEYWORD || tokenType == JSTokenTypes.INTERFACE_KEYWORD) {
                        this.parseClassOrInterfaceNoMarker(marker);
                        return;
                    }
                    if (tokenType == JSTokenTypes.DECORATOR_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.AT) {
                        this.parseES6DecoratorDeclaration(marker);
                        return;
                    }
                    this.builder.putUserData(FunctionParser.methodsEmptinessKey, null);
                    if (firstToken == JSTokenTypes.IDENTIFIER) {
                        marker.rollbackTo();
                    }
                    if (JSTokenTypes.COLON_COLON == this.builder.getTokenType()) {
                        marker.rollbackTo();
                        if (!this.parseExpressionStatement()) ** GOTO lbl111
                        return;
                    }
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.declaration", new Object[0]));
                    marker.drop();
                }
                finally {
                    this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)methodEmptiness);
                }
            }
        } else {
            if (firstToken == JSTokenTypes.CLASS_KEYWORD || firstToken == JSTokenTypes.INTERFACE_KEYWORD) {
                marker = this.startAttributeListOwner();
                this.parseClassOrInterfaceNoMarker(marker);
                return;
            }
            if (firstToken == JSTokenTypes.DECORATOR_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.AT) {
                marker = this.startAttributeListOwner();
                this.parseES6DecoratorDeclaration(marker);
                return;
            }
            if (JSTokenTypes.VAR_MODIFIERS_WITHOUT_USING.contains(firstToken) || this.isUsingDeclaration(false)) {
                marker = this.startAttributeListOwner();
                this.parseVarStatementNoMarker(false, marker);
                return;
            }
            if (firstToken == JSTokenTypes.FUNCTION_KEYWORD && this.isECMAL4()) {
                marker = this.startAttributeListOwner();
                functionParser.parseFunctionNoMarker(FunctionParser.Context.SOURCE_ELEMENT, marker);
                return;
            }
        }
lbl111:
        // 6 sources

        if (functionParser.isFunctionDeclarationStart()) {
            functionParser.parseFunctionDeclaration();
            return;
        }
        if (this.isIdentifierToken(firstToken)) {
            labeledStatement = this.builder.mark();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.COLON) {
                this.builder.advanceLexer();
                this.parseStatement();
                labeledStatement.done(JSElementTypes.LABELED_STATEMENT);
                return;
            }
            labeledStatement.rollbackTo();
        }
        if (firstToken != JSTokenTypes.FUNCTION_KEYWORD && this.parseExpressionStatement()) {
            return;
        }
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.statement", new Object[0]));
        if (this.builder.getCurrentOffset() == startOffset && (this.builder.getTokenType() != JSTokenTypes.RBRACE || this.builder.getUserData(StatementParser.IS_BLOCK_BODY_CONTEXT) == null)) {
            this.builder.advanceLexer();
        }
    }

    private boolean isUsingDeclaration(boolean forLoop) {
        TokenSet bindingIdentifierToken = forLoop ? USING_DECLARATION_BINDING_ID_TOKENS_FOR_LOOP : JSKeywordSets.ES6_IDENTIFIER_TOKENS_SET;
        return this.builder.getTokenType() == JSTokenTypes.USING_KEYWORD && !StatementParser.hasLineTerminator(this.builder, 1) && bindingIdentifierToken.contains(this.builder.lookAhead(1)) || this.builder.getTokenType() == JSTokenTypes.AWAIT_KEYWORD && !StatementParser.hasLineTerminator(this.builder, 1) && this.builder.lookAhead(1) == JSTokenTypes.USING_KEYWORD && !StatementParser.hasLineTerminator(this.builder, 2) && bindingIdentifierToken.contains(this.builder.lookAhead(2));
    }

    protected boolean isPossibleStartStatementModifier(IElementType token) {
        return JSTokenTypes.MODIFIERS.contains(token);
    }

    public boolean isExportDefault() {
        return this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.DEFAULT_KEYWORD;
    }

    protected boolean parseDialectSpecificSourceElements(PsiBuilder.Marker marker) {
        return false;
    }

    public void parseClassNoMarker(PsiBuilder.Marker block, boolean mayOmitName, boolean isExpression) {
        if (!this.isJSorTS() && !this.isIdentifierToken(this.builder.lookAhead(1))) {
            block.drop();
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.statement", new Object[0]));
            this.builder.advanceLexer();
            return;
        }
        LOG.assertTrue(JSTokenTypes.CLASS_KEYWORD == this.builder.getTokenType());
        this.builder.advanceLexer();
        IElementType classStartToken = this.builder.getTokenType();
        if (this.isPossibleClassName(classStartToken, mayOmitName)) {
            this.myJavaScriptParser.builder.advanceLexer();
        } else if (!mayOmitName) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
            if (!this.canProceedClassParsing(classStartToken)) {
                block.done(isExpression ? this.getClassExpressionElementType() : this.getClassElementType());
                return;
            }
        }
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseTypeParameterList();
        this.parseReferencesList();
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
        } else {
            this.builder.advanceLexer();
            while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
                if (this.builder.eof()) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.rbrace", new Object[0]));
                    break;
                }
                this.parseClassMember();
            }
            this.builder.advanceLexer();
        }
        block.done(isExpression ? this.getClassExpressionElementType() : this.getClassElementType());
        block.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    public boolean canProceedClassParsing(IElementType elementType) {
        return elementType == JSTokenTypes.EXTENDS_KEYWORD || elementType == JSTokenTypes.LBRACE;
    }

    protected boolean isPossibleClassName(IElementType firstElement, boolean mayOmitName) {
        return this.isIdentifierToken(firstElement);
    }

    protected void parseReferencesList() {
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD) {
            this.parseReferenceList(this.getClassExtendListElementType());
        }
        if (this.builder.getTokenType() == JSTokenTypes.IMPLEMENTS_KEYWORD) {
            this.parseReferenceList((IElementType)JSStubElementTypes.IMPLEMENTS_LIST);
        }
    }

    protected IElementType getClassElementType() {
        return ES6StubElementTypes.CLASS;
    }

    protected IElementType getClassExpressionElementType() {
        return ES6StubElementTypes.CLASS_EXPRESSION;
    }

    protected IElementType getClassExtendListElementType() {
        return JSStubElementTypes.ES6_EXTENDS_LIST;
    }

    protected void parseClassMember() {
        ES6Parser es6Parser = new ES6Parser(this.builder);
        ((StatementParser)es6Parser.getStatementParser()).parseClassMember();
    }

    protected PsiBuilder.Marker startAttributeListOwner() {
        PsiBuilder.Marker marker = this.builder.mark();
        PsiBuilder.Marker modifierListMarker = this.builder.mark();
        modifierListMarker.done(((FunctionParser)this.myJavaScriptParser.getFunctionParser()).getAttributeListElementType());
        return marker;
    }

    public boolean parseExpressionStatement() {
        PsiBuilder.Marker exprStatement = this.builder.mark();
        if (((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpressionOptional()) {
            this.forceCheckForSemicolon();
            exprStatement.done(JSElementTypes.EXPRESSION_STATEMENT);
            exprStatement.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT_NO_EXTRA_LINEBREAK, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }
        exprStatement.drop();
        return false;
    }

    protected void parseClassOrInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        if (clazz == null) {
            StatementParser.$$$reportNull$$$0(0);
        }
        if (this.builder.getTokenType() == JSTokenTypes.CLASS_KEYWORD) {
            this.parseClassNoMarker(clazz, false, false);
        } else {
            assert (this.builder.getTokenType() == JSTokenTypes.INTERFACE_KEYWORD);
            this.parseInterfaceNoMarker(clazz);
        }
    }

    protected void parseES6DecoratorDeclaration(@NotNull PsiBuilder.Marker decoratorMark) {
        if (decoratorMark == null) {
            StatementParser.$$$reportNull$$$0(1);
        }
        decoratorMark.drop();
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.statement", new Object[0]));
        this.builder.advanceLexer();
    }

    protected void parseInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        if (clazz == null) {
            StatementParser.$$$reportNull$$$0(2);
        }
        clazz.drop();
        if (!this.parseExpressionStatement()) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.statement", new Object[0]));
            this.builder.advanceLexer();
        }
    }

    public void parseReferenceList(IElementType doneToken) {
        PsiBuilder.Marker referenceList = this.builder.mark();
        this.builder.advanceLexer();
        if (this.parseReferenceListMember()) {
            while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (!this.isIdentifierToken(this.builder.getTokenType())) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type.name", new Object[0]));
                } else if (this.parseReferenceListMember()) continue;
                break;
            }
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type.name", new Object[0]));
        }
        referenceList.done(doneToken);
    }

    protected boolean parseReferenceListMember() {
        PsiBuilder.Marker startRefMember = this.builder.mark();
        boolean result2 = ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).parseQualifiedTypeName();
        if (result2) {
            startRefMember.done((IElementType)JSStubElementTypes.EXTENDS_LIST_MEMBER);
        } else {
            startRefMember.drop();
        }
        return result2;
    }

    private void parseTryStatement() {
        boolean parseResources;
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.TRY_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        IElementType tokenType = this.builder.getTokenType();
        boolean bl = parseResources = tokenType == JSTokenTypes.LPAR;
        if (parseResources) {
            this.builder.advanceLexer();
            IElementType type = this.builder.getTokenType();
            if (type == JSTokenTypes.CONST_KEYWORD || type == JSTokenTypes.LET_KEYWORD) {
                this.parseVarStatementNoMarker(true, this.builder.mark());
            } else {
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
            }
            IElementType elementType = this.builder.getTokenType();
            if (elementType != JSTokenTypes.RPAR) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rparen", new Object[0]));
            } else {
                this.builder.advanceLexer();
            }
        }
        this.parseBlock();
        while (this.builder.getTokenType() == JSTokenTypes.CATCH_KEYWORD) {
            this.parseCatchBlock();
        }
        if (!parseResources && this.builder.getTokenType() == JSTokenTypes.FINALLY_KEYWORD) {
            this.builder.advanceLexer();
            this.parseBlock();
        }
        statement.done(JSElementTypes.TRY_STATEMENT);
    }

    private void parseCatchBlock() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.CATCH_KEYWORD);
        PsiBuilder.Marker block = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            this.builder.advanceLexer();
            IElementType identifierType = this.builder.getTokenType();
            IElementType parameterElementType = ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).getParameterType();
            if (((FunctionParser)this.myJavaScriptParser.getFunctionParser()).willParseDestructuringAssignment()) {
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseDestructuringElement(parameterElementType, false, false);
            } else if (this.isIdentifierToken(identifierType)) {
                PsiBuilder.Marker param = this.builder.mark();
                this.builder.advanceLexer();
                if (!((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType() && this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD) {
                    this.builder.advanceLexer();
                    StatementParser.checkMatches(this.builder, identifierType, "javascript.parser.message.expected.identifier");
                    StatementParser.checkMatches(this.builder, JSTokenTypes.INSTANCEOF_KEYWORD, "javascript.parser.message.expected.instanceof");
                    StatementParser.checkMatches(this.builder, JSTokenTypes.IDENTIFIER, "javascript.parser.message.expected.identifier");
                }
                param.done(parameterElementType);
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.parameter.name", new Object[0]));
            }
            StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        }
        this.parseBlock();
        block.done(JSElementTypes.CATCH_BLOCK);
    }

    private void parseThrowStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.THROW_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        if (!StatementParser.hasLineTerminatorBefore(this.builder)) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
            this.checkForSemicolon();
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
        statement.done(JSElementTypes.THROW_STATEMENT);
    }

    private void parseSwitchStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.SWITCH_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        if (this.checkLParBeforeBlock()) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
            StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        }
        boolean hadLBrace = StatementParser.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace");
        while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            if (this.builder.eof()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.unexpected.end.of.file", new Object[0]));
                statement.done(JSElementTypes.SWITCH_STATEMENT);
                return;
            }
            this.parseCaseOrDefaultClause();
        }
        if (hadLBrace) {
            this.builder.advanceLexer();
        }
        statement.done(JSElementTypes.SWITCH_STATEMENT);
    }

    private boolean checkLParBeforeBlock() {
        return StatementParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen") || this.builder.getTokenType() != JSTokenTypes.LBRACE;
    }

    private void parseCaseOrDefaultClause() {
        IElementType token;
        IElementType firstToken = this.builder.getTokenType();
        PsiBuilder.Marker clause = this.builder.mark();
        if (firstToken != JSTokenTypes.CASE_KEYWORD && firstToken != JSTokenTypes.DEFAULT_KEYWORD) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.case.or.default", new Object[0]));
        }
        this.builder.advanceLexer();
        if (firstToken == JSTokenTypes.CASE_KEYWORD) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        }
        StatementParser.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
        while ((token = this.builder.getTokenType()) != null && token != JSTokenTypes.CASE_KEYWORD && token != JSTokenTypes.DEFAULT_KEYWORD && token != JSTokenTypes.RBRACE) {
            this.parseStatement();
        }
        clause.done(JSElementTypes.CASE_CLAUSE);
    }

    private void parseWithStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.WITH_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        this.parseStatement();
        statement.done(JSElementTypes.WITH_STATEMENT);
    }

    private void parseReturnStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.RETURN_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        boolean hasNewLine = StatementParser.hasLineTerminatorBefore(this.builder);
        if (!hasNewLine) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpressionOptional();
        }
        this.forceCheckForSemicolon();
        statement.done(JSStubElementTypes.RETURN_STATEMENT);
    }

    private void parseBreakStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.BREAK_KEYWORD);
        this.parseBreakAndContinue(JSElementTypes.BREAK_STATEMENT);
    }

    private void parseContinueStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.CONTINUE_KEYWORD);
        this.parseBreakAndContinue(JSElementTypes.CONTINUE_STATEMENT);
    }

    private void parseBreakAndContinue(@NotNull IElementType elementType) {
        if (elementType == null) {
            StatementParser.$$$reportNull$$$0(3);
        }
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        if (!StatementParser.hasLineTerminatorBefore(this.builder) && this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        }
        this.forceCheckForSemicolon();
        statement.done(elementType);
    }

    private void parseIterationStatement() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.DO_KEYWORD) {
            this.parseDoWhileStatement();
        } else if (tokenType == JSTokenTypes.WHILE_KEYWORD) {
            this.parseWhileStatement();
        } else if (tokenType == JSTokenTypes.FOR_KEYWORD) {
            this.parseForStatement();
        } else {
            LOG.error("Unknown iteration statement");
        }
    }

    private void parseForStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        boolean forin = this.parseForLoopHeader();
        this.parseStatement();
        statement.done(forin ? JSElementTypes.FOR_IN_STATEMENT : JSElementTypes.FOR_STATEMENT);
    }

    public boolean parseForLoopHeader() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
        this.builder.advanceLexer();
        return this.parseForLoopHeaderCondition();
    }

    protected boolean parseForLoopHeaderCondition() {
        boolean empty2;
        if (!this.checkLParBeforeBlock()) {
            return false;
        }
        IElementType firstToken = this.builder.getTokenType();
        boolean isUsingDeclaration = this.isUsingDeclaration(true);
        if (JSTokenTypes.VAR_MODIFIERS_WITHOUT_USING.contains(firstToken) || isUsingDeclaration) {
            this.parseVarStatementNoMarker(true, this.startAttributeListOwner());
            empty2 = false;
        } else {
            empty2 = !((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpressionOptional(false);
        }
        boolean forInOrOf = false;
        if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
            this.builder.advanceLexer();
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpressionOptional();
            if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.semicolon", new Object[0]));
            }
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpressionOptional();
        } else if (this.builder.getTokenType() == JSTokenTypes.IN_KEYWORD || this.builder.getTokenType() == JSTokenTypes.OF_KEYWORD) {
            forInOrOf = true;
            if (empty2) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.forloop.left.hand.side.expression.or.variable.declaration", new Object[0]));
            }
            if (isUsingDeclaration && this.builder.getTokenType() == JSTokenTypes.IN_KEYWORD) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.forloop.using.not.allowed.in.for-in", new Object[0]));
            }
            this.builder.advanceLexer();
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.forloop.in.or.semicolon", new Object[0]));
        }
        StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        return forInOrOf;
    }

    private void parseWhileStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.WHILE_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        if (this.checkLParBeforeBlock()) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
            StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        }
        this.parseStatement();
        statement.done(JSElementTypes.WHILE_STATEMENT);
    }

    private void parseDoWhileStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DO_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        this.parseStatement();
        StatementParser.checkMatches(this.builder, JSTokenTypes.WHILE_KEYWORD, "javascript.parser.message.expected.while.keyword");
        StatementParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        this.checkForSemicolon();
        statement.done(JSElementTypes.DOWHILE_STATEMENT);
    }

    private void parseIfStatement() {
        PsiBuilder.Marker ifStatement;
        ArrayList<PsiBuilder.Marker> ifMarkers;
        block5: {
            ifMarkers = null;
            while (true) {
                LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD);
                ifStatement = this.builder.mark();
                this.parseIfStatementHeader();
                this.parseStatement();
                if (this.builder.getTokenType() != JSTokenTypes.ELSE_KEYWORD) break block5;
                this.builder.advanceLexer();
                if (this.builder.getTokenType() != JSTokenTypes.IF_KEYWORD) break;
                if (ifMarkers == null) {
                    ifMarkers = new ArrayList<PsiBuilder.Marker>();
                }
                if (ifMarkers.size() < MAX_TREE_DEPTH) {
                    ifMarkers.add(ifStatement);
                    continue;
                }
                ifStatement.drop();
            }
            this.parseStatement();
        }
        ifStatement.done(JSElementTypes.IF_STATEMENT);
        if (ifMarkers != null) {
            for (int i = ifMarkers.size() - 1; i >= 0; --i) {
                ((PsiBuilder.Marker)ifMarkers.get(i)).done(JSElementTypes.IF_STATEMENT);
            }
        }
    }

    public void parseIfStatementHeader() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD);
        this.builder.advanceLexer();
        if (!this.checkLParBeforeBlock()) {
            return;
        }
        ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        while (this.builder.getTokenType() == JSTokenTypes.OROR || this.builder.getTokenType() == JSTokenTypes.EQEQ) {
            this.builder.advanceLexer();
        }
        StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
    }

    protected void parseEmptyStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.SEMICOLON);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        statement.done(JSElementTypes.EMPTY_STATEMENT);
    }

    protected void parseVarStatementNoMarker(boolean inForInitializationContext, @NotNull PsiBuilder.Marker var) {
        if (var == null) {
            StatementParser.$$$reportNull$$$0(4);
        }
        boolean isAwait = JSTokenTypes.AWAIT_KEYWORD == this.builder.getTokenType();
        LOG.assertTrue(JSTokenTypes.VAR_MODIFIERS.contains(this.builder.getTokenType()) || isAwait && JSTokenTypes.USING_KEYWORD == this.builder.lookAhead(1));
        if (this.builder.getUserData(withinInterfaceKey) != null) {
            this.builder.error(JavaScriptBundle.message("interface.should.have.no.variable.declarations", new Object[0]));
        }
        this.builder.advanceLexer();
        if (isAwait && this.builder.getTokenType() == JSTokenTypes.USING_KEYWORD) {
            this.builder.advanceLexer();
        }
        this.parseVarList(inForInitializationContext);
        if (!inForInitializationContext) {
            this.forceCheckForSemicolon();
        }
        var.done(JSStubElementTypes.VAR_STATEMENT);
        var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected void parseVarList(boolean inForInitializationContext) {
        boolean first = true;
        do {
            if (first) {
                first = false;
            } else {
                StatementParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma");
            }
            this.parseVarDeclaration(this.getVariableElementType(), true, !inForInitializationContext);
        } while (this.builder.getTokenType() == JSTokenTypes.COMMA);
    }

    public boolean checkForSemicolon() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.SEMICOLON) {
            this.builder.advanceLexer();
            return true;
        }
        return false;
    }

    public void forceCheckForSemicolon() {
        boolean b = this.checkForSemicolon();
        if (!b && !StatementParser.hasLineTerminatorBefore(this.builder)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.newline.or.semicolon", new Object[0]));
        }
    }

    public void parseVarDeclaration(@NotNull IElementType varType, boolean allowTypeDeclaration, boolean allowIn) {
        if (varType == null) {
            StatementParser.$$$reportNull$$$0(5);
        }
        if (((FunctionParser)this.myJavaScriptParser.getFunctionParser()).willParseDestructuringAssignment()) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseDestructuringElement(varType, true, false);
            return;
        }
        PsiBuilder.Marker var = this.builder.mark();
        if (!this.parseVarName(var)) {
            return;
        }
        if (allowTypeDeclaration) {
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
        }
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.parseVariableInitializer(allowIn);
        }
        var.done(varType);
        var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    public IElementType getVariableElementType() {
        return JSStubElementTypes.VARIABLE;
    }

    protected boolean parseVarName(PsiBuilder.Marker var) {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.variable.name", new Object[0]));
            this.builder.advanceLexer();
            var.drop();
            return false;
        }
        this.builder.advanceLexer();
        return true;
    }

    protected boolean isBlockBodyContext() {
        return Boolean.TRUE.equals(this.builder.getUserData(IS_BLOCK_BODY_CONTEXT));
    }

    protected void parseVariableInitializer(boolean allowIn) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EQ);
        this.builder.advanceLexer();
        if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(allowIn)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
    }

    public boolean parseFunctionBody() {
        return this.parseBlock();
    }

    protected boolean checkIdentifier() {
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
            return true;
        }
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier", new Object[0]));
        return false;
    }

    protected boolean checkIdentifierName() {
        IElementType type = this.builder.getTokenType();
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(type)) {
            this.builder.advanceLexer();
            return true;
        }
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
        return false;
    }

    protected void parseES6FromDeclaration() {
        if (this.builder.getTokenType() != JSTokenTypes.FROM_KEYWORD) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.from", new Object[0]));
            return;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (!JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.string.literal", new Object[0]));
            marker.done((IElementType)ES6StubElementTypes.FROM_CLAUSE);
            return;
        }
        String literalError = ExpressionParser.validateLiteralText(this.builder.getTokenText());
        this.builder.advanceLexer();
        if (literalError != null) {
            this.builder.error(literalError);
        }
        marker.done((IElementType)ES6StubElementTypes.FROM_CLAUSE);
    }

    private void parseWithClause() {
        if (StatementParser.hasLineTerminatorBefore(this.builder)) {
            return;
        }
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken != JSTokenTypes.ASSERT_KEYWORD && firstToken != JSTokenTypes.WITH_KEYWORD) {
            return;
        }
        PsiBuilder.Marker withClause = this.builder.mark();
        this.builder.advanceLexer();
        if (!StatementParser.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace")) {
            withClause.done(ES6ElementTypes.WITH_CLAUSE);
            return;
        }
        while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            PsiBuilder.Marker withEntry = this.builder.mark();
            IElementType assertionKey = this.builder.getTokenType();
            if (assertionKey != JSTokenTypes.STRING_LITERAL && !this.myJavaScriptParser.isIdentifierName(assertionKey)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier.string.literal.or.rbrace", new Object[0]));
                withEntry.done(ES6ElementTypes.WITH_ENTRY);
                break;
            }
            this.builder.advanceLexer();
            if (!StatementParser.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon")) {
                withEntry.done(ES6ElementTypes.WITH_ENTRY);
                break;
            }
            if (!StatementParser.checkMatches(this.builder, JSTokenTypes.STRING_LITERAL, "javascript.parser.message.expected.string.literal")) {
                withEntry.done(ES6ElementTypes.WITH_ENTRY);
                break;
            }
            withEntry.done(ES6ElementTypes.WITH_ENTRY);
            if (this.builder.getTokenType() != JSTokenTypes.COMMA) break;
            this.builder.advanceLexer();
        }
        StatementParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
        withClause.done(ES6ElementTypes.WITH_CLAUSE);
    }

    protected boolean tryParseES6ExportStatement() {
        return this.tryParseES6ExportStatement(this.builder.mark());
    }

    protected boolean tryParseES6ExportStatement(PsiBuilder.Marker marker) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD);
        IElementType lookAhead = this.builder.lookAhead(1);
        boolean parseTypeExports = this.shouldParseTypeExports(lookAhead);
        if (parseTypeExports) {
            lookAhead = this.builder.lookAhead(2);
        }
        if (lookAhead == JSTokenTypes.MULT || lookAhead == JSTokenTypes.LBRACE || this.isExportDefaultBinding()) {
            this.builder.advanceLexer();
            if (parseTypeExports) {
                this.builder.advanceLexer();
            }
            this.parseES6ExportDeclarationBody(marker);
            return true;
        }
        if (lookAhead == JSTokenTypes.DEFAULT_KEYWORD) {
            this.parseES6ExportDefaultAssignmentNoMarker(marker);
            return true;
        }
        marker.drop();
        return false;
    }

    protected boolean isExportDefaultBinding() {
        IElementType identifier = this.builder.lookAhead(1);
        if (!this.isIdentifierToken(identifier) && identifier != JSTokenTypes.DEFAULT_KEYWORD) {
            return false;
        }
        IElementType lookAhead = this.builder.lookAhead(2);
        return lookAhead == JSTokenTypes.FROM_KEYWORD || lookAhead == JSTokenTypes.COMMA;
    }

    protected void parseES6ImportStatement() {
        boolean needError;
        PsiBuilder.Marker marker = this.builder.mark();
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.IMPORT_KEYWORD);
        this.builder.advanceLexer();
        if (JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            needError = false;
            String literalError = ExpressionParser.validateLiteralText(this.builder.getTokenText());
            this.builder.advanceLexer();
            if (literalError != null) {
                this.builder.error(literalError);
            }
            this.parseWithClause();
        } else {
            if (this.builder.getTokenType() != JSTokenTypes.FROM_KEYWORD || !JSTokenTypes.STRING_LITERALS.contains(this.builder.lookAhead(1))) {
                needError = !this.parseES6ImportClause();
            } else {
                needError = false;
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.import.value", new Object[0]));
            }
            this.parseES6FromDeclaration();
            this.parseWithClause();
        }
        if (needError) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier.string.literal.or.lbrace", new Object[0]));
        }
        this.forceCheckForSemicolon();
        marker.done((IElementType)ES6StubElementTypes.IMPORT_DECLARATION);
    }

    protected boolean shouldParseTypeExports(IElementType type) {
        return false;
    }

    protected boolean shouldParseTypeImports(IElementType type) {
        return false;
    }

    protected boolean parseES6ImportClause() {
        IElementType secondToken;
        if (this.shouldParseTypeImports(this.builder.getTokenType()) && ((secondToken = this.builder.lookAhead(1)) == JSTokenTypes.FROM_KEYWORD ? this.builder.lookAhead(2) != JSTokenTypes.STRING_LITERAL : secondToken == JSTokenTypes.MULT || secondToken == JSTokenTypes.LBRACE || this.isIdentifierToken(secondToken))) {
            this.builder.advanceLexer();
        }
        boolean parsedAnything = false;
        boolean expectedComma = false;
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            parsedAnything = true;
            PsiBuilder.Marker importedBinding = this.builder.mark();
            this.builder.advanceLexer();
            importedBinding.done((IElementType)ES6StubElementTypes.IMPORTED_BINDING);
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
            } else {
                expectedComma = true;
            }
        }
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE || this.builder.getTokenType() == JSTokenTypes.MULT) {
            parsedAnything = true;
            if (expectedComma) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.comma", new Object[0]));
            }
            if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                PsiBuilder.Marker list = this.builder.mark();
                this.parseES6ImportOrExportNamedList(true);
                list.done((IElementType)ES6StubElementTypes.NAMED_IMPORTS);
            } else {
                this.parseES6NamespaceImport();
            }
        }
        return parsedAnything;
    }

    protected void parseES6NamespaceImport() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.MULT);
        PsiBuilder.Marker importedBinding = this.builder.mark();
        this.builder.advanceLexer();
        if (StatementParser.checkMatches(this.builder, JSTokenTypes.AS_KEYWORD, "javascript.parser.message.expected.as") && this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        }
        importedBinding.done((IElementType)ES6StubElementTypes.IMPORTED_BINDING);
    }

    protected void parseES6ImportOrExportNamedList(boolean isImportClause) {
        PsiBuilder.Marker marker = this.builder.mark();
        if (!this.tryParseES6ImportOrExportNamedList(isImportClause, false)) {
            marker.rollbackTo();
            this.tryParseES6ImportOrExportNamedList(isImportClause, true);
        } else {
            marker.drop();
        }
    }

    private boolean tryParseES6ImportOrExportNamedList(boolean isImportClause, boolean stopOnFirstError) {
        assert (this.builder.getTokenType() == JSTokenTypes.LBRACE);
        this.builder.advanceLexer();
        while (true) {
            if (this.builder.getTokenType() == JSTokenTypes.RBRACE) {
                this.builder.advanceLexer();
                break;
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.import.specifier", new Object[0]));
                this.builder.advanceLexer();
                continue;
            }
            this.advanceIfAt();
            if (!this.parseES6ImportOrExportSpecifier(isImportClause, this.builder.mark(), stopOnFirstError)) {
                return false;
            }
            IElementType nextToken = this.builder.getTokenType();
            if (nextToken == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                continue;
            }
            if (nextToken == JSTokenTypes.RBRACE) continue;
            if (stopOnFirstError) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.comma.or.rbrace", new Object[0]));
                break;
            }
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.comma", new Object[0]));
        }
        return true;
    }

    protected boolean parseES6ImportOrExportSpecifier(boolean isImport, @NotNull PsiBuilder.Marker marker, boolean stopOnFirstError) {
        IElementType firstToken;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(6);
        }
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(firstToken = this.builder.getTokenType())) {
            boolean aliasRequired;
            boolean bl = aliasRequired = !this.isIdentifierToken(firstToken) && firstToken != JSTokenTypes.DEFAULT_KEYWORD;
            if (stopOnFirstError && aliasRequired && this.builder.lookAhead(1) != JSTokenTypes.AS_KEYWORD) {
                marker.drop();
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
                return false;
            }
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.AS_KEYWORD) {
                PsiBuilder.Marker alias = this.builder.mark();
                this.builder.advanceLexer();
                this.advanceIfAt();
                if (isImport) {
                    this.checkIdentifier();
                } else {
                    this.checkIdentifierName();
                }
                alias.done((IElementType)(isImport ? ES6StubElementTypes.IMPORT_SPECIFIER_ALIAS : ES6StubElementTypes.EXPORT_SPECIFIER_ALIAS));
            } else if (aliasRequired) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.as", new Object[0]));
            }
            marker.done((IElementType)(isImport ? ES6StubElementTypes.IMPORT_SPECIFIER : ES6StubElementTypes.EXPORT_SPECIFIER));
            marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }
        marker.drop();
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
        return false;
    }

    private void advanceIfAt() {
        if (this.builder.getTokenType() == JSTokenTypes.AT && JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
    }

    protected void parseES6ExportDeclarationBody(PsiBuilder.Marker exportDeclaration) {
        boolean isFromRequired = false;
        boolean isNextElementRequired = true;
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType())) {
            PsiBuilder.Marker exportedDefaultBinding = this.builder.mark();
            this.builder.advanceLexer();
            exportedDefaultBinding.done((IElementType)ES6StubElementTypes.EXPORTED_DEFAULT_BINDING);
            isFromRequired = true;
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
            } else {
                isNextElementRequired = false;
            }
        }
        if (this.builder.getTokenType() == JSTokenTypes.MULT) {
            isFromRequired = true;
            if (this.isNamespaceExport()) {
                PsiBuilder.Marker namespaceExport = this.builder.mark();
                this.builder.advanceLexer();
                this.builder.advanceLexer();
                this.checkIdentifierName();
                namespaceExport.done((IElementType)ES6StubElementTypes.NAMESPACE_EXPORT);
            } else {
                this.builder.advanceLexer();
            }
        } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            this.parseES6ImportOrExportNamedList(false);
        } else if (isNextElementRequired) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.mult.or.lbrace", new Object[0]));
        }
        if (isFromRequired || this.builder.getTokenType() == JSTokenTypes.FROM_KEYWORD) {
            this.parseES6FromDeclaration();
            this.parseWithClause();
        }
        this.forceCheckForSemicolon();
        exportDeclaration.done((IElementType)ES6StubElementTypes.EXPORT_DECLARATION);
    }

    protected boolean isNamespaceExport() {
        return this.builder.lookAhead(1) == JSTokenTypes.AS_KEYWORD;
    }

    private void parseES6ExportDefaultAssignmentNoMarker(PsiBuilder.Marker marker) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD);
        this.builder.advanceLexer();
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DEFAULT_KEYWORD);
        this.builder.advanceLexer();
        this.parseES6ExportDefaultAssignmentBody();
        this.forceCheckForSemicolon();
        marker.done((IElementType)ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected void parseES6ExportDefaultAssignmentBody() {
        if (this.builder.getTokenType() == JSTokenTypes.CLASS_KEYWORD) {
            PsiBuilder.Marker classMarker = this.builder.mark();
            PsiBuilder.Marker modifierList = this.builder.mark();
            modifierList.done(((FunctionParser)this.myJavaScriptParser.getFunctionParser()).getAttributeListElementType());
            this.parseClassNoMarker(classMarker, true, true);
        } else if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD) {
            ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseFunctionExpression();
        } else {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(false);
        }
    }

    protected void parseBlockAndAttachStatementsDirectly() {
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
            return;
        }
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            if (this.builder.eof()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.rbrace", new Object[0]));
                return;
            }
            this.parseStatement();
        }
        this.builder.advanceLexer();
    }

    public boolean parseBlock() {
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
            return false;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull PsiBuilder.Marker block = this.builder.mark();
        Pair<Integer, Boolean> result2 = this.findParserPosToParseBlockUntil();
        int pos = (Integer)result2.first;
        boolean completeBlocks = (Boolean)result2.second;
        this.builder.rawAdvanceLexer(pos);
        if (!completeBlocks) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.rbrace", new Object[0]));
        }
        IElementType blockElementType = JSBlockStatementElementTypeFactory.INSTANCE.getBlockStatementElementType(this.myJavaScriptParser.getLanguage(), JSParsingContextUtil.isAsyncContext(this.builder), JSParsingContextUtil.isGeneratorContext(this.builder));
        block.collapse(blockElementType);
        return completeBlocks;
    }

    public final void parseBlockBodyDeeply(boolean stopAfterFirstRBrace) {
        int stopAfterOffset;
        int n = stopAfterOffset = stopAfterFirstRBrace ? 0 : Integer.MAX_VALUE;
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
        }
        this.builder.advanceLexer();
        Boolean prevIsBlockBodyContext = (Boolean)this.builder.getUserData(IS_BLOCK_BODY_CONTEXT);
        this.builder.putUserData(IS_BLOCK_BODY_CONTEXT, (Object)Boolean.TRUE);
        boolean rBraceFound = false;
        while (!this.builder.eof()) {
            if (this.builder.getTokenType() == JSTokenTypes.RBRACE) {
                this.builder.advanceLexer();
                rBraceFound = true;
                if (this.builder.getCurrentOffset() <= stopAfterOffset) continue;
                break;
            }
            this.parseStatement();
        }
        this.builder.putUserData(IS_BLOCK_BODY_CONTEXT, (Object)prevIsBlockBodyContext);
        if (!rBraceFound) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.rbrace", new Object[0]));
        }
    }

    private Pair<Integer, Boolean> findParserPosToParseBlockUntil() {
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            return Pair.pair((Object)0, (Object)true);
        }
        var iterator = new Iterator<IElementType>(){
            public int pos = 0;
            private IElementType next;
            {
                this.next = StatementParser.this.builder.rawLookup(this.pos);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public IElementType next() {
                IElementType result2 = this.next;
                ++this.pos;
                this.next = StatementParser.this.builder.rawLookup(this.pos);
                return result2;
            }
        };
        boolean completeBlocks = JSLexerUtil.advanceBlockStatement(iterator);
        return Pair.pair((Object)iterator.pos, (Object)completeBlocks);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorMark";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/parsing/StatementParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseClassOrInterfaceNoMarker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseES6DecoratorDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseInterfaceNoMarker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseBreakAndContinue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseVarStatementNoMarker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseVarDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parseES6ImportOrExportSpecifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

