/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JSStringLiteralTypeImpl
extends JSStringType
implements JSPrimitiveLiteralType<String> {
    @NotNull
    protected final String myUnquotedValue;
    protected final boolean myAllowWidening;

    public JSStringLiteralTypeImpl(@NotNull String unquotedValue, boolean allowWidening, @NotNull JSTypeSource source) {
        if (unquotedValue == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myUnquotedValue = unquotedValue;
        this.myAllowWidening = allowWidening;
    }

    public JSStringLiteralTypeImpl(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        super(typeSource, inputStream);
        this.myUnquotedValue = JSTypeSerializer.readString(inputStream);
        this.myAllowWidening = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeString(this.myUnquotedValue, outputStream);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, outputStream);
    }

    @Override
    @NotNull
    public String getLiteral() {
        String string = this.myUnquotedValue;
        if (string == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        if (processingContext == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        if (elementType instanceof JSStringLiteralTypeImpl && this.isSourceStrict() && (!this.myAllowWidening || processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) == Boolean.TRUE)) {
            return this.myUnquotedValue.equals(((JSStringLiteralTypeImpl)elementType).myUnquotedValue);
        }
        if (elementType instanceof JSStringType) {
            if (this.isJavaScript()) {
                return true;
            }
            if (!this.myAllowWidening) {
                return false;
            }
        }
        if (!this.myAllowWidening && elementType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType.isEnumLiteral()) {
                TypeScriptEnumField field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                if (field == null) {
                    return false;
                }
                EnumConstantValue value = field.getConstantValue();
                String stringValue = value.getStringValue();
                return Objects.equals(stringValue, this.myUnquotedValue);
            }
            if (resolvedType.isEnum()) {
                return false;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        return this.myUnquotedValue.equals(((JSStringLiteralTypeImpl)type).myUnquotedValue) && super.isEquivalentToWithSameClass(type, processingContext, allowResolve);
    }

    @Override
    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    @Override
    @NotNull
    protected JSStringLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        return new JSStringLiteralTypeImpl(this.getLiteral(), this.myAllowWidening, source);
    }

    @Override
    @NotNull
    public JSLiteralType copyWithAllowWidening(boolean allowWidening) {
        if (this.myAllowWidening == allowWidening) {
            JSStringLiteralTypeImpl jSStringLiteralTypeImpl = this;
            if (jSStringLiteralTypeImpl == null) {
                JSStringLiteralTypeImpl.$$$reportNull$$$0(10);
            }
            return jSStringLiteralTypeImpl;
        }
        return new JSStringLiteralTypeImpl(this.myUnquotedValue, allowWidening, this.getSource());
    }

    @Override
    @NotNull
    public String getValueAsString() {
        String string = this.getDefaultValue();
        if (string == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        StringBuilder builder2 = new StringBuilder();
        JSStringUtil.escapeSimpleStringChars(this.myUnquotedValue, '\"', true, true, false, builder2);
        String string = StringUtil.wrapWithDoubleQuote((String)builder2.toString());
        if (string == null) {
            JSStringLiteralTypeImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedValue";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSStringLiteralTypeImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAsString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

