/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassBase;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitPrototypeElement;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.recordImpl.CallSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.IndexSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerResolvedType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptTypeParser {
    private static final ParameterizedCachedValueProvider<JSRecordType, JSClass> BUILD_CLASS_PROVIDER = currentClass -> {
        JSRecordType result2 = (JSRecordType)RecursionManager.doPreventingRecursion((Object)currentClass, (boolean)false, () -> TypeScriptTypeParser.buildTypeFromClass(currentClass, false, true));
        if (result2 == null) {
            result2 = new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource(currentClass, false), ContainerUtil.emptyList());
        }
        Object dependency = TypeScriptTypeParser.isSimpleClass(currentClass) ? currentClass : JSTypeUtils.getTypeInvalidationDependency();
        return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{currentClass, dependency});
    };
    private static final Key<ParameterizedCachedValue<JSRecordType, JSClass>> BUILD_CLASS_CACHE_KEY = Key.create((String)"ts.create.record.cl");
    private static final Key<CachedValue<JSFunctionType>> TS_FULL_FUNCTION_CACHE_KEY = Key.create((String)"ts.fn.full.type.cache");

    private static boolean isSimpleClass(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(0);
        }
        return jsClass instanceof TypeScriptInterface && jsClass.getExtendsList() == null && jsClass.getImplementsList() == null;
    }

    @NotNull
    public static JSType buildTypeForFunctionItem(@NotNull JSFunctionItem type, JSTypeSource source) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(1);
        }
        JSFunctionType jsType = TypeScriptTypeParser.buildFunctionType(type);
        if (((JSFunction)type).isConstructor() && jsType instanceof JSFunctionTypeImpl) {
            SmartList typeMembers = new SmartList((Object)new CallSignatureImpl(true, jsType));
            return new JSRecordTypeImpl(source, (List<? extends JSRecordType.TypeMember>)typeMembers);
        }
        JSFunctionType jSFunctionType = jsType;
        if (jSFunctionType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(2);
        }
        return jSFunctionType;
    }

    @NotNull
    public static JSFunctionType buildFunctionType(@NotNull JSFunctionItem function) {
        if (function == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(3);
        }
        if (function instanceof JSImplicitElement && function.getContext() == null) {
            return TypeScriptTypeParser.buildFunctionTypeImpl(function);
        }
        JSFunctionType jSFunctionType = (JSFunctionType)CachedValuesManager.getCachedValue((PsiElement)function, TS_FULL_FUNCTION_CACHE_KEY, () -> CachedValueProvider.Result.create((Object)TypeScriptTypeParser.buildFunctionTypeImpl(function), (Object[])new Object[]{function}));
        if (jSFunctionType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(4);
        }
        return jSFunctionType;
    }

    @Nullable
    public static JSFunctionType asFunctionType(@Nullable PsiElement element, @Nullable JSCallItem callItem) {
        JSType type;
        if (element instanceof JSClass && callItem != null && callItem.isNewExpression()) {
            List<JSType> collect = JSTypeUtils.getFunctionType(((JSClass)element).getStaticJSType(), true, element).toList();
            return collect.size() == 1 ? (JSFunctionType)ObjectUtils.tryCast((Object)collect.get(0), JSFunctionType.class) : null;
        }
        if (element instanceof JSVariable && callItem != null && (type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(((JSVariable)element).getJSType(), element)) instanceof JSFunctionType) {
            return (JSFunctionType)type;
        }
        if (!(element instanceof JSFunctionItem)) {
            return null;
        }
        return TypeScriptTypeParser.buildFunctionType((JSFunctionItem)element);
    }

    @NotNull
    public static JSFunctionType buildFunctionTypeWithCustomReturnType(@NotNull JSFunctionItem function, @Nullable JSType returnType) {
        if (function == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(5);
        }
        return TypeScriptTypeParser.buildFunctionTypeImpl(function, returnType);
    }

    @NotNull
    private static JSFunctionType buildFunctionTypeImpl(@NotNull JSFunctionItem function) {
        if (function == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(6);
        }
        return TypeScriptTypeParser.buildFunctionTypeImpl(function, function.getReturnType());
    }

    @NotNull
    static TypeScriptJSFunctionTypeImpl buildFunctionTypeImpl(@NotNull JSFunctionItem type, @Nullable JSType returnType) {
        JSClass jsClass;
        JSParameterItem[] parameters;
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(7);
        }
        SmartList decorators = new SmartList();
        for (JSParameterItem p : parameters = type.getParameters()) {
            decorators.add(p.getTypeDecorator());
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)type, true);
        JSType thisType = type instanceof TypeScriptFunction ? ((TypeScriptFunction)type).getExplicitThisType() : null;
        TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)type);
        if (typeParameters.length == 0 && type instanceof JSFunction && ((JSFunction)type).isConstructor() && (jsClass = JSUtils.getMemberContainingClass((PsiElement)type)) != null && !jsClass.isInterface()) {
            typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(jsClass);
            if (returnType instanceof JSVoidType || returnType == null) {
                returnType = jsClass instanceof TypeScriptTypeParameterListOwner ? JSTypeUtils.createNotSubstitutedGenericType((TypeScriptTypeParameterListOwner)((Object)jsClass), jsClass.getJSType()) : jsClass.getJSType();
            }
        }
        List<TypeScriptGenericDeclarationTypeImpl> generics = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclarations(typeParameters);
        return new TypeScriptJSFunctionTypeImpl(source, generics, (List<? extends JSParameterTypeDecorator>)decorators, thisType, returnType);
    }

    public static void addObjectTypeProperties(@NotNull List<JSRecordType.TypeMember> typeMembers, @Nullable TypeScriptObjectType type, @Nullable JSTypeSubstitutor typeSubstitutor, boolean skipNewSignatures) {
        if (typeMembers == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(8);
        }
        if (type == null) {
            return;
        }
        TypeScriptTypeMember[] candidates = type.getTypeMembers();
        if (candidates.length == 0) {
            return;
        }
        Function<JSType, JSType> applier = TypeScriptTypeMemberParser.createApplier(typeSubstitutor, (PsiElement)type);
        for (TypeScriptTypeMember el : candidates) {
            JSRecordType.TypeMember member = TypeScriptTypeMemberParser.buildTypeMember(el, applier);
            if (member == null || !TypeScriptTypeParser.isAcceptableMember(member, skipNewSignatures)) continue;
            typeMembers.add(member);
        }
    }

    private static void filterAndFillTypeMembers(@NotNull List<JSRecordType.TypeMember> candidates, @NotNull List<JSRecordType.TypeMember> result2, boolean skipNewSignatures) {
        if (candidates == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(10);
        }
        candidates.stream().filter(typeMember -> TypeScriptTypeParser.isAcceptableMember(typeMember, skipNewSignatures)).forEach(result2::add);
    }

    private static boolean isAcceptableMember(@NotNull JSRecordType.TypeMember typeMember, boolean skipNewSignatures) {
        if (typeMember == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(11);
        }
        return !skipNewSignatures || !(typeMember instanceof JSRecordType.CallSignature) || !((JSRecordType.CallSignature)typeMember).hasNew();
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(@NotNull JSClass clazz, boolean isStatic) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(12);
        }
        if (!isStatic) {
            JSRecordType jSRecordType = (JSRecordType)CachedValuesManager.getManager((Project)clazz.getProject()).getParameterizedCachedValue((UserDataHolder)clazz, BUILD_CLASS_CACHE_KEY, BUILD_CLASS_PROVIDER, false, (Object)clazz);
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(13);
            }
            return jSRecordType;
        }
        return TypeScriptTypeParser.buildTypeFromClass(clazz, true, true);
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(@NotNull JSClass clazz, boolean isStatic, boolean includeSupers) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(14);
        }
        JSRecordType type = TypeScriptTypeParser.buildTypeFromClass(clazz, isStatic, includeSupers, true, !(clazz instanceof TypeScriptClass));
        return TypeScriptTypeParser.overrideSourceForLibrarySymbols(clazz, type);
    }

    @NotNull
    public static JSRecordType buildTypeFromClass(final @NotNull JSClass clazz, final boolean isStatic, boolean includeSupers, final boolean includeAbstractMembers, final boolean includeInterfaceMembers) {
        JSType declaration;
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(15);
        }
        if (clazz instanceof TypeScriptTypeAlias && (declaration = ((TypeScriptTypeAlias)clazz).getParsedTypeDeclaration()) != null) {
            JSRecordType jSRecordType = declaration.asRecordType();
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(16);
            }
            return jSRecordType;
        }
        final JSTypeSource source = JSTypeSourceFactory.createTypeSource(clazz, true);
        final ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        if (clazz instanceof TypeScriptEnum) {
            typeMembers.add(new IndexSignatureImpl((JSType)JSNamedTypeFactory.createNumberPrimitiveType(source), (JSType)JSNamedTypeFactory.createStringPrimitiveType(source), clazz, false));
        }
        JSClassUtils.JSClassHierarchyProcessor processor = new JSClassUtils.JSClassHierarchyProcessor(){
            private boolean isFunctionProcessed = false;
            private boolean hadConstructor = false;
            @Nullable
            private final Set<String> myOverridingMemberNames = clazz instanceof TypeScriptClass && !includeInterfaceMembers ? new HashSet() : null;
            private final List<JSRecordType.IndexSignature> myIndexSignatures = new SmartList();

            @Override
            public boolean process(@NotNull JSClass currentClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements, boolean fromStaticContext, int depth) {
                if (currentClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (fromStaticContext && !isStatic) {
                    return true;
                }
                ArrayList<JSRecordType.TypeMember> currentClassMembers = new ArrayList<JSRecordType.TypeMember>();
                if (currentClass != clazz && TypeScriptTypeParser.isFunctionClass(currentClass)) {
                    if (!this.isFunctionProcessed) {
                        JSRecordType recordFunction = TypeScriptUtil.getFunctionTypeMembers(clazz);
                        if (recordFunction != null) {
                            currentClassMembers.addAll(recordFunction.getTypeMembers());
                        }
                        this.isFunctionProcessed = true;
                    }
                    this.transferCurrentClassMembers(currentClassMembers, currentClass instanceof TypeScriptClass);
                    return true;
                }
                if (currentClass instanceof TypeScriptTypeAlias) {
                    JSRecordType recordType;
                    if ((!isStatic || fromStaticContext) && (recordType = TypeScriptUtil.getTypeAliasRecordTypeForSubstitutor((TypeScriptTypeAlias)currentClass, typeSubstitutor)) != null) {
                        TypeScriptTypeParser.filterAndFillTypeMembers(recordType.getTypeMembers(), currentClassMembers, fromStaticContext);
                    }
                } else if (currentClass instanceof TypeScriptInterface) {
                    if (!isStatic || fromStaticContext) {
                        TypeScriptObjectType body2 = ((TypeScriptInterface)currentClass).getBody();
                        TypeScriptTypeParser.addObjectTypeProperties(currentClassMembers, body2, typeSubstitutor, fromStaticContext);
                    }
                } else {
                    for (JSElement jSElement : currentClass.getMembers()) {
                        JSRecordType.TypeMember typeMember;
                        if (jSElement instanceof JSAttributeListOwner) {
                            JSAttributeList list;
                            JSAttributeListOwner function = (JSAttributeListOwner)jSElement;
                            if (!includeAbstractMembers && (list = function.getAttributeList()) != null && list.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) continue;
                        }
                        if ((typeMember = TypeScriptTypeMemberParser.buildTypeMemberFromElement(clazz, (PsiElement)jSElement, isStatic, source, typeSubstitutor)) == null) continue;
                        currentClassMembers.add(typeMember);
                    }
                    List<JSDefinitionExpression> fieldDefinitions = 1.findClassFieldDefinitions(currentClass);
                    for (JSDefinitionExpression fieldDefinition : fieldDefinitions) {
                        String name = fieldDefinition.getName();
                        if (name == null) continue;
                        PropertySignatureImpl propertySignature = new PropertySignatureImpl(name, fieldDefinition.getJSType(), false, false, (PsiElement)fieldDefinition);
                        currentClassMembers.add(propertySignature);
                    }
                }
                this.transferCurrentClassMembers(currentClassMembers, currentClass instanceof TypeScriptClass);
                return true;
            }

            @NotNull
            private static List<JSDefinitionExpression> findClassFieldDefinitions(@NotNull JSClass clazz2) {
                if (clazz2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!DialectDetector.isJavaScript(clazz2)) {
                    List<JSDefinitionExpression> list = Collections.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return list;
                }
                String classQName = clazz2.getQualifiedName();
                if (classQName == null) {
                    List<JSDefinitionExpression> list = Collections.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return list;
                }
                ArrayList<JSDefinitionExpression> result2 = new ArrayList<JSDefinitionExpression>();
                JSClassResolver.getInstance().processNamespaceMembers(classQName, clazz2.getContainingFile(), (Processor<? super JSPsiElementBase>)((Processor)e -> {
                    if (e instanceof JSDefinitionExpression && e.getName() != null) {
                        result2.add((JSDefinitionExpression)e);
                    }
                    return true;
                }));
                ArrayList<JSDefinitionExpression> arrayList = result2;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(5);
                }
                return arrayList;
            }

            private void transferCurrentClassMembers(@NotNull List<JSRecordType.TypeMember> currentClassMembers, boolean isTypeScriptClass) {
                if (currentClassMembers == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (currentClassMembers.isEmpty()) {
                    return;
                }
                ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(clazz);
                ArrayList<JSRecordType.TypeMember> newMembers = new ArrayList<JSRecordType.TypeMember>();
                ArrayList<JSRecordType.IndexSignature> newIndexSignatures = new ArrayList<JSRecordType.IndexSignature>();
                ArrayList<JSRecordType.CallSignature> newNewCallSignatures = new ArrayList<JSRecordType.CallSignature>();
                HashSet<String> newPropertyNames = new HashSet<String>();
                for (JSRecordType.TypeMember member : currentClassMembers) {
                    JSRecordType.CallSignature callSignature;
                    if (member instanceof JSRecordType.PropertySignature) {
                        String name = ((JSRecordType.PropertySignature)member).getMemberName();
                        if (this.myOverridingMemberNames != null) {
                            newPropertyNames.add(name);
                            if (this.myOverridingMemberNames.contains(name) && !((JSRecordType.PropertySignature)member).isPrivateName()) {
                                continue;
                            }
                        }
                    } else if (member instanceof JSRecordType.IndexSignature) {
                        JSRecordType.IndexSignature indexSignature = (JSRecordType.IndexSignature)member;
                        JSType parameterType = indexSignature.getMemberParameterType();
                        boolean isIndexerOverridden = ContainerUtil.exists(this.myIndexSignatures, existingSignature -> existingSignature.getMemberParameterType().isEquivalentTo(parameterType, processingContext, true));
                        if (isIndexerOverridden) continue;
                        newIndexSignatures.add(indexSignature);
                    } else if (member instanceof JSRecordType.CallSignature && (callSignature = (JSRecordType.CallSignature)member).hasNew()) {
                        newNewCallSignatures.add(callSignature);
                        continue;
                    }
                    newMembers.add(member);
                }
                typeMembers.addAll(newMembers);
                if (!(newNewCallSignatures.isEmpty() || isTypeScriptClass && this.hadConstructor)) {
                    if (isTypeScriptClass) {
                        this.hadConstructor = true;
                    }
                    typeMembers.addAll(newNewCallSignatures);
                }
                this.myIndexSignatures.addAll(newIndexSignatures);
                if (this.myOverridingMemberNames != null) {
                    this.myOverridingMemberNames.addAll(newPropertyNames);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeSubstitutor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$1";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentClassMembers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$1";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findClassFieldDefinitions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "process";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "findClassFieldDefinitions";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "transferCurrentClassMembers";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4, 5 -> new IllegalStateException(string);
                };
            }
        };
        if (includeSupers) {
            if (JSClassUtils.processClassesInHierarchy(clazz, includeInterfaceMembers, processor) && !isStatic) {
                TypeScriptTypeParser.addNonClassExtendsMembers(clazz, typeMembers);
            }
        } else {
            processor.process(clazz, JSTypeSubstitutor.EMPTY, false, false, 0);
        }
        if (!(clazz instanceof TypeScriptCompileTimeType) && isStatic) {
            JSImplicitPrototypeElement property;
            String name;
            boolean hasConstructor = false;
            boolean hasPrototype = false;
            for (JSRecordType.TypeMember member : typeMembers) {
                if (member instanceof JSRecordType.CallSignature && ((JSRecordType.CallSignature)member).hasNew()) {
                    hasConstructor = true;
                }
                if (!(member instanceof JSRecordType.PropertySignature) || !"prototype".equals(((JSRecordType.PropertySignature)member).getMemberName())) continue;
                hasPrototype = true;
            }
            if (!hasConstructor && !(clazz instanceof TypeScriptEnum)) {
                JSFunctionTypeImpl functionType = TypeScriptTypeParser.createConstructorType(clazz, source);
                typeMembers.add(new CallSignatureImpl(true, functionType));
            }
            if (!hasPrototype && JSClassUtils.canHavePrototypeProperty(clazz) && (name = (property = JSClassUtils.getImplicitPrototypeProperty(clazz)).getName()) != null) {
                typeMembers.add(new PropertySignatureImpl(name, property.getJSType(), false, false, (PsiElement)property));
            }
        }
        return clazz.getName() == null && !isStatic ? new JSSimpleRecordTypeImpl(source, typeMembers) : new JSRecordTypeImpl(source, typeMembers);
    }

    private static void addNonClassExtendsMembers(@NotNull JSClass clazz, final @NotNull ArrayList<JSRecordType.TypeMember> typeMembers) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(17);
        }
        if (typeMembers == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(18);
        }
        if (!(clazz instanceof TypeScriptInterfaceClass)) {
            return;
        }
        TypeScriptClassBase.processNonClassExtendsItem((TypeScriptInterfaceClass)clazz, new JSResolveProcessor(){

            @Override
            @Nullable
            public String getName() {
                return null;
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                JSRecordType.TypeMember member;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((member = TypeScriptTypeMemberParser.buildTypeMemberFromElement(null, element, false, JSTypeSourceFactory.createTypeSource(element, true), null)) != null) {
                    typeMembers.add(member);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ResolveState.initial());
    }

    @NotNull
    public static JSFunctionTypeImpl createConstructorType(@NotNull JSClass clazz, @NotNull JSTypeSource source) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(19);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(20);
        }
        JSType returnType = TypeScriptTypeParser.createConstructorReturnType(clazz, source);
        TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(clazz);
        if (typeParameters.length > 0) {
            List<TypeScriptGenericDeclarationTypeImpl> generics = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclarations(typeParameters);
            return new TypeScriptJSFunctionTypeImpl(source, generics, ContainerUtil.emptyList(), null, returnType);
        }
        return new JSFunctionTypeImpl(source, ContainerUtil.emptyList(), returnType);
    }

    @NotNull
    static JSType createConstructorReturnType(@NotNull JSClass clazz, @NotNull JSTypeSource source) {
        JSType rawConstructorType;
        String name;
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(21);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(22);
        }
        if (StringUtil.isEmpty((String)(name = clazz.getQualifiedName()))) {
            rawConstructorType = TypeScriptTypeParser.buildTypeFromClass(clazz, false, true);
        } else {
            rawConstructorType = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromNamepath(name), source, JSTypeContext.INSTANCE, clazz.getJSNamespace().isLocal());
            TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(clazz);
            if (typeParameters.length > 0) {
                List<JSType> types = TypeScriptGenericTypesEvaluator.buildGenericParameters(typeParameters);
                rawConstructorType = new JSGenericTypeImpl(source, rawConstructorType, types);
            }
        }
        JSType mixinType = TypeScriptTypeParser.getMixinInstanceType(clazz, source);
        if (mixinType == null) {
            JSType jSType = rawConstructorType;
            if (jSType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(23);
            }
            return jSType;
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType(Arrays.asList(rawConstructorType, mixinType), source);
        if (jSType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(24);
        }
        return jSType;
    }

    @Nullable
    private static JSType getMixinInstanceType(@NotNull JSClass clazz, @NotNull JSTypeSource source) {
        if (clazz == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(25);
        }
        if (source == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(26);
        }
        if (!(clazz instanceof TypeScriptClass) || !ES6PsiUtil.isLocalClass(clazz)) {
            return null;
        }
        JSReferenceList list = clazz.getExtendsList();
        if (!(list instanceof ES6ReferenceList)) {
            return null;
        }
        Object[] members = list.getMembers();
        JSReferenceListMember member = (JSReferenceListMember)ArrayUtil.getFirstElement((Object[])members);
        if (member == null) {
            return null;
        }
        ES6ReferenceListImpl.ClassExpressionResolve resolve2 = ES6ReferenceListImpl.resolveReferenceListMember(member);
        JSType type = resolve2.constructorType;
        if (type == null || !JSTypeUtils.hasForeignGenericParameter(type)) {
            return null;
        }
        return type instanceof JSFunctionType ? JSTypeUtils.getNewOrReturnType(type) : new JSApplyNewType(type, source);
    }

    private static boolean isFunctionClass(JSClass currentClass) {
        String fileName = currentClass.getContainingFile().getName();
        String className = currentClass.getName();
        return className != null && JSCommonTypeNames.FUNCTION_CLASS_NAMES.contains(className) && TypeScriptLibraryProvider.getService(currentClass.getProject()).isLibraryFileName(fileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static JSType buildTypeFromClassMember(PsiElement element) {
        if (element instanceof JSFunction) {
            if (((JSFunction)element).isGetProperty()) {
                return ((JSFunction)element).getReturnType();
            }
            if (!((JSFunction)element).isSetProperty()) return TypeScriptTypeParser.buildFunctionType((JSFunction)element);
            JSParameterListElement[] parameters = ((JSFunction)element).getParameters();
            if (parameters.length != 1) return null;
            return parameters[0].getSimpleType();
        }
        if (!(element instanceof JSTypeOwner)) return null;
        return ((JSTypeOwner)element).getJSType();
    }

    public static JSRecordType buildResolvedType(@NotNull Collection<? extends PsiElement> elements, @NotNull JSType type) {
        if (elements == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(27);
        }
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(28);
        }
        return TypeScriptTypeParser.buildResolvedType(elements, type, new HashSet<PsiElement>());
    }

    @NotNull
    private static JSRecordType buildResolvedType(@NotNull Collection<? extends PsiElement> elements, @NotNull JSType type, @NotNull Set<PsiElement> visited) {
        if (elements == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(29);
        }
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(30);
        }
        if (visited == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(31);
        }
        boolean isStatic = type instanceof JSNamespace && ((JSNamespace)type).getJSContext() == JSContext.STATIC;
        ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>();
        for (PsiElement psiElement : TypeScriptTypeParser.sortElements(elements)) {
            JSRecordType recordType = TypeScriptTypeParser.buildTypeMembersFromResolvedElement(type, isStatic, psiElement, visited);
            if (elements.size() == 1) {
                JSRecordType jSRecordType = (JSRecordType)recordType.withNewSource(type.getSource());
                if (jSRecordType == null) {
                    TypeScriptTypeParser.$$$reportNull$$$0(32);
                }
                return jSRecordType;
            }
            members.addAll(recordType.getTypeMembers());
        }
        return new JSRecordTypeImpl(type.getSource(), members);
    }

    @NotNull
    private static Collection<? extends PsiElement> sortElements(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(33);
        }
        if (elements.size() <= 1) {
            Collection<? extends PsiElement> collection = elements;
            if (collection == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(34);
            }
            return collection;
        }
        ArrayList result2 = new ArrayList(elements.size());
        SmartList restElements = new SmartList();
        for (PsiElement psiElement : elements) {
            SmartList toAdd = psiElement instanceof JSClass && ((JSClass)psiElement).getSupers().length == 0 ? result2 : restElements;
            toAdd.add(psiElement);
        }
        result2.addAll(restElements);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @NotNull
    private static JSRecordType overrideSourceForLibrarySymbols(@NotNull PsiElement context2, @NotNull JSRecordType resultType) {
        if (context2 == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(36);
        }
        if (resultType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(37);
        }
        Set<VirtualFile> libraries = TypeScriptLibraryProvider.getAllLibraries(context2.getProject());
        boolean hasSourceFromLibrary = false;
        block0: for (JSRecordType.TypeMember member : resultType.getTypeMembers()) {
            List<PsiElement> sourceElements = member.getMemberSource().getAllSourceElements();
            for (PsiElement element : sourceElements) {
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
                if (virtualFile == null || !libraries.contains(virtualFile)) continue;
                hasSourceFromLibrary = true;
                continue block0;
            }
        }
        if (!hasSourceFromLibrary) {
            JSRecordType jSRecordType = resultType;
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(38);
            }
            return jSRecordType;
        }
        JSTypeSource resultTypeSource = resultType.getSource();
        JSType candidate = JSTypeBaseImpl.replaceSourceRecursive(resultType, (Function<? super JSTypeBaseImpl, JSTypeSource>)((Function)el -> {
            JSTypeSource currentSource = el.getSource();
            if (!(el instanceof JSNamedType) && !(el instanceof JSGenericTypeImpl)) {
                return currentSource;
            }
            if (el.getSource() == resultTypeSource) {
                return currentSource;
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)el.getSource().getSourceElement());
            if (virtualFile != null && libraries.contains(virtualFile)) {
                return resultTypeSource;
            }
            return currentSource;
        }), false);
        JSRecordType jSRecordType = candidate instanceof JSRecordType ? (JSRecordType)candidate : resultType;
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(39);
        }
        return jSRecordType;
    }

    @NotNull
    public static JSRecordType buildResolvedType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(40);
        }
        if (type instanceof TypeScriptCompilerResolvedType) {
            JSRecordType jSRecordType = type.asRecordType();
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(41);
            }
            return jSRecordType;
        }
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(elements, type);
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(42);
        }
        return jSRecordType;
    }

    @NotNull
    public static Collection<? extends PsiElement> resolveElementsByType(@Nullable JSType type) {
        PsiElement originSourceElement;
        if (type == null) {
            List list = Collections.emptyList();
            if (list == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(43);
            }
            return list;
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        if (sourceElement == null) {
            List list = Collections.emptyList();
            if (list == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(44);
            }
            return list;
        }
        if (type instanceof JSFunctionTypeImpl && sourceElement instanceof JSFunction) {
            List list = ContainerUtil.createMaybeSingletonList((Object)sourceElement);
            if (list == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(45);
            }
            return list;
        }
        if (type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getType() instanceof JSFunctionTypeImpl && (originSourceElement = ((JSGenericTypeImpl)type).getType().getSource().getSourceElement()) instanceof JSFunction) {
            List list = ContainerUtil.createMaybeSingletonList((Object)originSourceElement);
            if (list == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(46);
            }
            return list;
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type, sourceElement);
        if (collection == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(47);
        }
        return collection;
    }

    @NotNull
    private static JSRecordType buildTypeMembersFromResolvedElement(@NotNull JSType type, boolean isStatic, @NotNull PsiElement resolvedElement, @NotNull Set<PsiElement> visited) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(48);
        }
        if (resolvedElement == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(49);
        }
        if (visited == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(50);
        }
        if (!visited.add(resolvedElement)) {
            JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(51);
            }
            return jSRecordType;
        }
        if (resolvedElement instanceof TypeScriptEnumField) {
            resolvedElement = ((TypeScriptEnumField)resolvedElement).getOwner();
        }
        if (resolvedElement instanceof JSClass) {
            return TypeScriptTypeParser.buildTypeMembersForClass(type, isStatic, (JSClass)resolvedElement, visited);
        }
        if (resolvedElement instanceof JSFunction) {
            return TypeScriptTypeParser.buildTypeMembersForFunction(type, (JSFunction)resolvedElement);
        }
        if (resolvedElement instanceof TypeScriptModule && isStatic) {
            JSRecordType recordType = TypeScriptTypeParser.buildTypeForModule((TypeScriptModule)resolvedElement);
            JSRecordType jSRecordType = recordType == null ? JSTypeCastUtil.NO_RECORD_TYPE : recordType;
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(52);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(53);
        }
        return jSRecordType;
    }

    @NotNull
    private static JSRecordTypeImpl buildTypeMembersForFunction(@NotNull JSType type, @NotNull JSFunction resolvedElement) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(54);
        }
        if (resolvedElement == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(55);
        }
        SmartList signatures2 = new SmartList();
        if (resolvedElement instanceof TypeScriptFunction) {
            for (JSFunctionItem jSFunctionItem : TypeScriptPsiUtil.getAllOverloadSignatures(resolvedElement)) {
                signatures2.add((Object)TypeScriptTypeParser.createCallSignatureForFunction(jSFunctionItem));
            }
        }
        signatures2.add((Object)TypeScriptTypeParser.createCallSignatureForFunction(resolvedElement));
        return new JSRecordTypeImpl(type.getSource(), (List<? extends JSRecordType.TypeMember>)signatures2);
    }

    @NotNull
    private static JSRecordType buildTypeMembersForClass(@NotNull JSType type, boolean isStatic, @NotNull JSClass jsClass, @NotNull Set<PsiElement> visited) {
        if (type == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(56);
        }
        if (jsClass == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(57);
        }
        if (visited == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(58);
        }
        if (type instanceof JSArrayType && !((JSArrayType)type).isPrimitive()) {
            type = ((JSArrayType)type).asGenericType();
        }
        boolean hasOuters = false;
        if (type instanceof JSTypeWithOuterGenerics) {
            type = ((JSTypeWithOuterGenerics)type).getType();
            hasOuters = true;
        }
        if (type instanceof JSGenericTypeImpl) {
            JSRecordType recordType = JSTypeCastUtil.buildWithAppliedGenericArguments(jsClass, (JSGenericTypeImpl)type, hasOuters);
            JSRecordType jSRecordType = recordType == null ? JSTypeCastUtil.NO_RECORD_TYPE : recordType;
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(59);
            }
            return jSRecordType;
        }
        if (jsClass instanceof TypeScriptEnum) {
            return TypeScriptTypeParser.buildTypeFromClass(jsClass, isStatic);
        }
        JSRecordType fromService = TypeScriptTypeParser.asRecordTypeUsingService(jsClass, isStatic);
        if (fromService != null) {
            JSRecordType jSRecordType = fromService;
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(60);
            }
            return jSRecordType;
        }
        if (!(jsClass instanceof TypeScriptTypeAlias)) {
            return TypeScriptTypeParser.buildTypeFromClass(jsClass, isStatic);
        }
        JSType declaration = ((TypeScriptTypeAlias)jsClass).getParsedTypeDeclaration();
        if (declaration instanceof JSRecordType) {
            JSRecordType jSRecordType = (JSRecordType)declaration;
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(61);
            }
            return jSRecordType;
        }
        if (declaration instanceof JSFunctionTypeImpl) {
            JSRecordType jSRecordType = declaration.asRecordType();
            if (jSRecordType == null) {
                TypeScriptTypeParser.$$$reportNull$$$0(62);
            }
            return jSRecordType;
        }
        if (declaration != null) {
            return TypeScriptTypeParser.buildResolvedType(TypeScriptTypeParser.resolveElementsByType(declaration), declaration, visited);
        }
        JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(63);
        }
        return jSRecordType;
    }

    @NotNull
    private static CallSignatureImpl createCallSignatureForFunction(@NotNull JSFunctionItem resolvedElement) {
        if (resolvedElement == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(64);
        }
        return new CallSignatureImpl(false, new JSFunctionTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)resolvedElement, true), ContainerUtil.map((Object[])resolvedElement.getParameterVariables(), JSParameterItem::getTypeDecorator), resolvedElement.getReturnType()));
    }

    @Nullable
    public static JSRecordType buildTypeForModule(@NotNull TypeScriptModule element) {
        if (element == null) {
            TypeScriptTypeParser.$$$reportNull$$$0(65);
        }
        if (!element.isInstantiated()) {
            return null;
        }
        JSSourceElement[] elements = JSResolveUtil.getSourceElements(element);
        ArrayList<PropertySignatureImpl> typeMembers = new ArrayList<PropertySignatureImpl>();
        for (JSSourceElement sourceElement : elements) {
            if (!(sourceElement instanceof JSVarStatement) && (!(sourceElement instanceof JSElementBase) || ((JSElementBase)((Object)sourceElement)).getAccessType() != JSAttributeList.AccessType.PUBLIC)) continue;
            if (sourceElement instanceof JSVarStatement) {
                for (JSVariable variable : ((JSVarStatement)sourceElement).getStubSafeVariables()) {
                    String name;
                    if (variable.getAccessType() != JSAttributeList.AccessType.PUBLIC || (name = variable.getName()) == null) continue;
                    typeMembers.add(new PropertySignatureImpl(name, variable.getJSType(), false, false, (PsiElement)variable));
                }
                continue;
            }
            if (sourceElement instanceof JSFunction) {
                JSFunction function = (JSFunction)sourceElement;
                String name = function.getName();
                if (name == null) continue;
                typeMembers.add(new PropertySignatureImpl(name, (JSType)TypeScriptTypeParser.buildFunctionType(function), false, false, function));
                continue;
            }
            if (!(sourceElement instanceof JSClass)) continue;
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)sourceElement, true);
            String name = sourceElement.getName();
            if (name == null) continue;
            JSType type = JSNamedTypeFactory.createType(name, source, JSContext.STATIC);
            typeMembers.add(new PropertySignatureImpl(name, type, false, false, (PsiElement)sourceElement));
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(element, true);
        return new JSRecordTypeImpl(source, typeMembers);
    }

    @Nullable
    private static JSRecordType asRecordTypeUsingService(JSClass jsClass, boolean isStatic) {
        if (isStatic) {
            return null;
        }
        TypeScriptCompilerEvaluationFacade facade = (TypeScriptCompilerEvaluationFacade)jsClass.getProject().getService(TypeScriptCompilerEvaluationFacade.class);
        if (facade.isAnyEnabled()) {
            JSType value;
            PsiElement nameIdentifier = jsClass.getNameIdentifier();
            JSType jSType = value = nameIdentifier != null ? facade.getTypeFromService(nameIdentifier) : null;
            if (value != null) {
                return value.asRecordType();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 13, 16, 23, 24, 32, 34, 35, 38, 39, 41, 42, 43, 44, 45, 46, 47, 51, 52, 53, 59, 60, 61, 62, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 1: 
            case 7: 
            case 28: 
            case 30: 
            case 40: 
            case 48: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 16: 
            case 23: 
            case 24: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMembers";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 20: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 27: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 31: 
            case 50: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 49: 
            case 55: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeForFunctionItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunctionType";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeFromClass";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorReturnType";
                break;
            }
            case 32: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "buildResolvedType";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "sortElements";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideSourceForLibrarySymbols";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsByType";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeMembersFromResolvedElement";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeMembersForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeForFunctionItem";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 16: 
            case 23: 
            case 24: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionTypeWithCustomReturnType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionTypeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addObjectTypeProperties";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterAndFillTypeMembers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableMember";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addNonClassExtendsMembers";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorReturnType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMixinInstanceType";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "buildResolvedType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "sortElements";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "overrideSourceForLibrarySymbols";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeMembersFromResolvedElement";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeMembersForFunction";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeMembersForClass";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createCallSignatureForFunction";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeForModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 13, 16, 23, 24, 32, 34, 35, 38, 39, 41, 42, 43, 44, 45, 46, 47, 51, 52, 53, 59, 60, 61, 62, 63 -> new IllegalStateException(string);
        };
    }
}

