/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.recordImpl;

import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeNumericKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureCommonImpl;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComputedPropertySignatureImpl
implements JSRecordType.PropertySignature,
JSRecordType.ComputedMember {
    @NotNull
    private final String nameRef;
    @Nullable
    private final JSType type;
    private final boolean optional;
    private final boolean isReadonly;
    @NotNull
    private final JSRecordType.MemberSource mySource;
    private static final String INVALID_NAME = "[unknown]";

    public ComputedPropertySignatureImpl(@NotNull String propertyNameRef, @Nullable JSType type, boolean optional, boolean isReadonly, @NotNull JSRecordType.MemberSource source) {
        if (propertyNameRef == null) {
            ComputedPropertySignatureImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            ComputedPropertySignatureImpl.$$$reportNull$$$0(1);
        }
        this.nameRef = propertyNameRef;
        this.type = type;
        this.optional = optional;
        this.isReadonly = isReadonly;
        this.mySource = source;
    }

    @Override
    @NotNull
    public String getMemberName() {
        return this.computeValue(this.mySource.getSingleElement());
    }

    @Override
    public boolean isConst() {
        return this.isReadonly;
    }

    @Override
    public boolean hasValidName() {
        return !Strings.areSameInstance((String)this.getMemberName(), (String)INVALID_NAME);
    }

    @NotNull
    private String computeValue(@Nullable PsiElement context2) {
        JSType type = this.computeTypeForComputedName(context2);
        if (type == null) {
            return INVALID_NAME;
        }
        String string = (String)ObjectUtils.coalesce((Object)TypeScriptTypeMemberParser.getComputedPropNameFromType(type), (Object)INVALID_NAME);
        if (string == null) {
            ComputedPropertySignatureImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public JSType getTypeForComputedName() {
        return this.computeTypeForComputedName(this.mySource.getSingleElement());
    }

    @Nullable
    private JSType computeTypeForComputedName(@Nullable PsiElement context2) {
        if (context2 == null || !context2.isValid()) {
            return null;
        }
        return TypeScriptLiteralKeyUtil.getTypeForComputedName(context2, this.nameRef);
    }

    @Override
    @Nullable
    public JSType getJSType() {
        return this.type;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    @NotNull
    public JSRecordType.MemberSource getMemberSource() {
        JSRecordType.MemberSource memberSource = this.mySource;
        if (memberSource == null) {
            ComputedPropertySignatureImpl.$$$reportNull$$$0(3);
        }
        return memberSource;
    }

    public String toString() {
        return "ComputedPropertySignatureImpl@" + this.nameRef;
    }

    @Override
    @NotNull
    public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
        if (childTransform == null) {
            ComputedPropertySignatureImpl.$$$reportNull$$$0(4);
        }
        JSType oldType = this.getJSType();
        JSType type = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        JSRecordType.MemberSource oldMemberSource = this.getMemberSource();
        JSRecordType.MemberSource memberSource = JSRecordTypeImpl.getUpdatedTypeMemberSource(oldMemberSource, childTransform);
        if (oldType == type && oldMemberSource == memberSource) {
            ComputedPropertySignatureImpl computedPropertySignatureImpl = this;
            if (computedPropertySignatureImpl == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(5);
            }
            return computedPropertySignatureImpl;
        }
        return new ComputedPropertySignatureImpl(this.nameRef, type, this.isOptional(), this.isConst(), memberSource);
    }

    @Override
    public int getMemberHashCode() {
        return Objects.hash(this.getClass(), this.nameRef, JSTypeHashCodeUtil.getHashCodeSafe(this.getJSType()), this.isOptional());
    }

    @Override
    @NotNull
    public JSType getKeyType() {
        JSType name = this.getTypeForComputedName();
        JSRecordType.MemberSource memberSource = this.getMemberSource();
        if (name instanceof JSNumberLiteralTypeImpl) {
            JSNumberLiteralTypeImpl numberType = (JSNumberLiteralTypeImpl)name;
            String memberName = this.getMemberName();
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(memberSource.getSingleElement(), true);
            return new JSTypeNumericKeyTypeImpl(memberName, numberType.getLiteral(), false, source, numberType.getValueAsString());
        }
        String memberName = this.getMemberName();
        return new JSTypeKeyTypeImpl(memberName, this, JSTypeSourceFactory.createTypeSource(memberSource.getSingleElement(), true));
    }

    @Override
    public boolean isEquivalentTo(@Nullable JSRecordType.TypeMember other, @Nullable ProcessingContext context2, boolean allowResolve) {
        return ComputedPropertySignatureImpl.arePropertySignaturesEqual(this, other, context2, allowResolve);
    }

    static boolean arePropertySignaturesEqual(@NotNull ComputedPropertySignatureImpl first, @Nullable JSRecordType.TypeMember otherRaw, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (first == null) {
            ComputedPropertySignatureImpl.$$$reportNull$$$0(6);
        }
        if (otherRaw == first) {
            return true;
        }
        if (!(otherRaw instanceof ComputedPropertySignatureImpl)) {
            return false;
        }
        ComputedPropertySignatureImpl other = (ComputedPropertySignatureImpl)otherRaw;
        PsiElement firstSource = first.getMemberSource().getSingleElement();
        PsiElement otherSource = otherRaw.getMemberSource().getSingleElement();
        if (!Objects.equals(firstSource, otherSource)) {
            return false;
        }
        JSType firstType = first.getJSType();
        JSType otherType = other.getJSType();
        return Objects.equals(first.nameRef, other.nameRef) && (firstType != null ? firstType.isEquivalentTo(otherType, processingContext, allowResolve) : otherType == null) && first.isOptional() == other.isOptional();
    }

    @Override
    public void appendMemberPresentation(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2, @NotNull String typeSeparator, char quote) {
        if (format == null) {
            ComputedPropertySignatureImpl.$$$reportNull$$$0(7);
        }
        if (builder2 == null) {
            ComputedPropertySignatureImpl.$$$reportNull$$$0(8);
        }
        if (typeSeparator == null) {
            ComputedPropertySignatureImpl.$$$reportNull$$$0(9);
        }
        PropertySignatureCommonImpl.appendPresentation(this, format, builder2, typeSeparator, quote, (String)(format == JSType.TypeTextFormat.PRESENTABLE ? this.getMemberName() : "[" + this.nameRef + "]"));
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        JSType type;
        if (visitor == null) {
            ComputedPropertySignatureImpl.$$$reportNull$$$0(10);
        }
        if ((type = this.getJSType()) != null) {
            type.accept(visitor);
        }
    }

    @Override
    @NotNull
    public String getNameRef() {
        String string = this.nameRef;
        if (string == null) {
            ComputedPropertySignatureImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNameRef";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/recordImpl/ComputedPropertySignatureImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSeparator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/recordImpl/ComputedPropertySignatureImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberSource";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "arePropertySignaturesEqual";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendMemberPresentation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 11 -> new IllegalStateException(string);
        };
    }
}

