/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.syntaxSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaScriptCommentSelectioner
extends AbstractWordSelectioner {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            JavaScriptCommentSelectioner.$$$reportNull$$$0(0);
        }
        return e instanceof PsiComment && e.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) || e instanceof JSNamedElement || e instanceof JSVarStatement;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (e == null) {
            JavaScriptCommentSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            JavaScriptCommentSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JavaScriptCommentSelectioner.$$$reportNull$$$0(3);
        }
        if (e instanceof JSNamedElement || e instanceof JSVarStatement) {
            PsiComment comment = JSDocumentationUtils.findDocComment(e);
            if (comment == null || JSDocumentationUtils.findAssociatedElement(comment) != e) {
                return Collections.emptyList();
            }
            ASTNode child = comment.getNextSibling().getNode();
            if (child.getElementType() == JSTokenTypes.WHITE_SPACE) {
                child = child.getTreeNext();
            }
            return ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(child.getTextRange().getStartOffset(), e.getTextRange().getEndOffset()));
        }
        List ranges = super.select(e, editorText, cursorOffset, editor);
        if (e instanceof PsiComment) {
            PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)e);
            if (next instanceof PsiWhiteSpace) {
                next = next.getNextSibling();
            }
            if ((next instanceof JSNamedElement || next instanceof JSVarStatement) && ranges.size() > 0) {
                ranges.addAll(ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(((TextRange)ranges.get(0)).getStartOffset(), next.getTextRange().getEndOffset())));
            }
        }
        return ranges;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/syntaxSelection/JavaScriptCommentSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

