/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileWithConfigAction
extends TypeScriptCompileAllAction {
    public TypeScriptCompileWithConfigAction() {
        super(JavaScriptBundle.messagePointer("typescript.compiler.action.compile.simple", new Object[0]), JavaScriptBundle.messagePointer("typescript.compiler.action.compile.description", new Object[0]), JavaScriptLanguageIcons.Typescript.CompileTypeScript);
    }

    public TypeScriptCompileWithConfigAction(@Nullable @NlsActions.ActionText String text, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    @Nullable
    public static VirtualFile getCurrentFile(DataContext dataContext) {
        if (dataContext == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            return psiFile != null ? psiFile.getVirtualFile() : null;
        }
        return null;
    }

    @Override
    @Nullable
    protected Consumer<ProgressIndicator> getBackgroundProcess(@Nullable Project project, @Nullable DataContext context2) {
        if (project == null) {
            return null;
        }
        VirtualFile configFile = this.getConfigFile(context2);
        if (configFile != null) {
            return this.compileForConfig(project, configFile);
        }
        return this.compileWithoutConfig(project, context2);
    }

    @Nullable
    protected Consumer<ProgressIndicator> compileWithoutConfig(@NotNull Project project, @Nullable DataContext context2) {
        if (project == null) {
            TypeScriptCompileWithConfigAction.$$$reportNull$$$0(0);
        }
        return super.getBackgroundProcess(project, context2);
    }

    @NotNull
    private Consumer<ProgressIndicator> compileForConfig(@NotNull Project project, VirtualFile configFile) {
        if (project == null) {
            TypeScriptCompileWithConfigAction.$$$reportNull$$$0(1);
        }
        Consumer consumer = indicator -> {
            TypeScriptConfig config = (TypeScriptConfig)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> TypeScriptConfigService.Provider.parseConfigFile(project, configFile));
            if (config == null) {
                return;
            }
            TypeScriptCompilerService compilerService = this.getServiceForConfig(project, configFile);
            if (compilerService == null) {
                return;
            }
            LinkedHashSet<JSAnnotationError> infos = new LinkedHashSet<JSAnnotationError>();
            this.runBeforeStartingCompile((ProgressIndicator)indicator, compilerService);
            TypeScriptServiceCommandClean command = new TypeScriptServiceCommandClean(TypeScriptCompilerConfigUtil.getConfigIdByConfig(config));
            compilerService.sendCleanCommandToCompiler(command);
            this.compileConfig((ProgressIndicator)indicator, compilerService, configFile, (Collection<JSAnnotationError>)infos);
            this.logErrors(project, infos);
        };
        if (consumer == null) {
            TypeScriptCompileWithConfigAction.$$$reportNull$$$0(2);
        }
        return consumer;
    }

    @Override
    protected void iterateFilesForCompile(Project project, ProgressIndicator indicator, Processor<? super VirtualFile> processor, VirtualFile @Nullable [] files) {
        if (project == null) {
            return;
        }
        if (files == null) {
            return;
        }
        for (VirtualFile file : files) {
            if (file.isDirectory()) {
                ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
                index.iterateContentUnderDirectory(file, descendant -> {
                    if (!descendant.isDirectory() && TypeScriptCompilerSettings.acceptFileType(descendant.getFileType())) {
                        return processor.process((Object)descendant);
                    }
                    return true;
                });
                continue;
            }
            if (!processor.process((Object)file)) break;
        }
    }

    protected VirtualFile @Nullable [] getFiles(Project project, DataContext dataContext) {
        return this.getFilesFromContext(dataContext);
    }

    protected VirtualFile @Nullable [] getFilesFromContext(DataContext dataContext) {
        VirtualFile file = TypeScriptCompileWithConfigAction.getCurrentFile(dataContext);
        if (file != null) {
            return new VirtualFile[]{file};
        }
        return (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
    }

    @Nullable
    public static VirtualFile getTypeScriptConfigVirtualFile(@Nullable DataContext context2) {
        if (context2 == null) {
            return null;
        }
        VirtualFile file = (VirtualFile)context2.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file == null) {
            return null;
        }
        return "tsconfig.json".equals(file.getName()) ? file : null;
    }

    @Nullable
    protected VirtualFile getConfigFile(@Nullable DataContext context2) {
        VirtualFile candidate = TypeScriptCompileWithConfigAction.getTypeScriptConfigVirtualFile(context2);
        if (candidate != null) {
            return candidate;
        }
        if (context2 == null) {
            return null;
        }
        Project project = (Project)context2.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDisposed() || DumbService.isDumb((Project)project)) {
            return null;
        }
        VirtualFile file = TypeScriptCompileWithConfigAction.getCurrentTypeScriptFile(context2);
        if (file == null) {
            return null;
        }
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForFile(project, file);
        return config == null ? null : config.getConfigFile();
    }

    @Nullable
    protected static VirtualFile getCurrentTypeScriptFile(@NotNull DataContext context2) {
        VirtualFile file;
        if (context2 == null) {
            TypeScriptCompileWithConfigAction.$$$reportNull$$$0(3);
        }
        if ((file = TypeScriptCompileWithConfigAction.getCurrentFile(context2)) == null) {
            return null;
        }
        CharSequence name = file.getNameSequence();
        if (TypeScriptUtil.isDefinitionFile(name)) {
            return null;
        }
        String extension = JSFileReferencesUtil.findExtension(name, TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
        return extension != null ? file : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/action/TypeScriptCompileWithConfigAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/action/TypeScriptCompileWithConfigAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "compileForConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compileWithoutConfig";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compileForConfig";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentTypeScriptFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

