/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ecmascript6.psi.impl.ES6FieldStatementImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.initialization.JSSplitDeclarationAndInitializationIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSReplaceConditionalWithIfIntention
extends JSMutablyNamedIntention {
    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("conditional.replace-conditional-with-if.family-name", new Object[0]);
        if (string == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = element -> {
            PsiElement context;
            if (!(element instanceof JSConditionalExpression)) {
                return false;
            }
            JSConditionalExpression condExpr = (JSConditionalExpression)element;
            JSSourceElement statementCandidate = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)condExpr, (Class[])new Class[]{JSStatement.class, JSFunction.class});
            if (!(statementCandidate instanceof JSStatement) || statementCandidate instanceof ES6FieldStatementImpl) {
                return false;
            }
            PsiFile file = statementCandidate.getContainingFile();
            PsiElement psiElement = context = file == null ? null : file.getContext();
            if (context instanceof XmlElement) {
                return false;
            }
            return condExpr.getCondition() != null && condExpr.getThenBranch() != null && condExpr.getElseBranch() != null;
        };
        if (jSElementPredicate == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(1);
        }
        return jSElementPredicate;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(3);
        }
        conditional = (JSConditionalExpression)element;
        statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        topExpression = JSReplaceConditionalWithIfIntention.getTopExpressionInStatement(conditional);
        if (!JSReplaceConditionalWithIfIntention.$assertionsDisabled && statement == null) {
            throw new AssertionError();
        }
        var9_7 = topExpression.getParent();
        if (!(var9_7 instanceof JSInitializerOwner)) ** GOTO lbl-1000
        declaration = (JSInitializerOwner)var9_7;
        if (topExpression.getParent().getParent() == statement && statement instanceof JSVarStatement) {
            varStatement = (JSVarStatement)statement;
            initializer = declaration.getInitializer();
            if (initializer == null) {
                return;
            }
            postfix = JSCodeStyleSettings.getSemicolon((PsiElement)declaration);
            if (declaration instanceof JSDestructuringElement) {
                target = ((JSDestructuringElement)declaration).getTarget();
                if (target instanceof JSDestructuringObject) {
                    prefix = "(" + target.getText();
                    postfix = ")" + (String)postfix;
                } else {
                    prefix = target.getText();
                }
            } else {
                prefix = declaration.getName();
            }
            allVars = declaration instanceof JSVariable != false ? Collections.singletonList((JSVariable)declaration) : SyntaxTraverser.psiTraverser((PsiElement)declaration).filter(JSVariable.class).toList();
            varNames = ContainerUtil.map2Set((Collection)allVars, (Function)(Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processIntention$1(com.intellij.lang.javascript.psi.JSVariable ), (Lcom/intellij/lang/javascript/psi/JSVariable;)Ljava/lang/String;)());
            after = new LinkedList<JSInitializerOwner>();
            occurred = false;
            isConst = varStatement.getVarKeyword() == JSVarStatement.VarKeyword.CONST;
            for (JSInitializerOwner statementDeclaration : varStatement.getDeclarations()) {
                if (statementDeclaration == declaration) {
                    occurred = true;
                    continue;
                }
                if (!occurred) continue;
                expression = statementDeclaration.getInitializer();
                if (!isConst && !SyntaxTraverser.psiTraverser((PsiElement)expression).filter(JSReferenceExpression.class).filter((Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processIntention$2(java.util.List java.util.Set com.intellij.lang.javascript.psi.JSReferenceExpression ), (Lcom/intellij/lang/javascript/psi/JSReferenceExpression;)Z)((List)allVars, (Set)varNames)).isNotEmpty()) continue;
                after.add(statementDeclaration);
            }
            if (!after.isEmpty()) {
                statementText = Objects.requireNonNull(varStatement.getVarKeyword()).getText() + " " + StringUtil.join(after, (Function)(Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processIntention$3(com.intellij.lang.javascript.psi.JSInitializerOwner ), (Lcom/intellij/lang/javascript/psi/JSInitializerOwner;)Ljava/lang/String;)(), (String)", ") + JSCodeStyleSettings.getSemicolon((PsiElement)varStatement);
                varStatement.getParent().addAfter((PsiElement)JSPsiElementFactory.createJSStatement((String)statementText, (PsiElement)statement), (PsiElement)varStatement);
                for (JSInitializerOwner owner : after) {
                    owner.delete();
                }
            }
            assignmentText = JSReplaceConditionalWithIfIntention.getReplacementText((String)prefix + " = ", (String)postfix, conditional, (JSElement)initializer);
            declarationText = JSSplitDeclarationAndInitializationIntention.getDeclarationStatementText(varStatement, (Condition<? super JSVariable>)(Condition)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processIntention$4(com.intellij.lang.javascript.psi.JSInitializerOwner com.intellij.lang.javascript.psi.JSVariable ), (Lcom/intellij/lang/javascript/psi/JSVariable;)Z)((JSInitializerOwner)declaration));
            declarationStatement = JSPsiElementFactory.createJSStatement((String)declarationText, (PsiElement)varStatement);
            assignmentStatement = JSPsiElementFactory.createJSStatement((String)assignmentText, (PsiElement)declaration);
            declarationStatement = varStatement.replace(declarationStatement);
            JSChangeUtil.doAddAfter((PsiElement)declarationStatement.getParent(), (PsiElement)assignmentStatement, (PsiElement)declarationStatement);
        } else lbl-1000:
        // 2 sources

        {
            JSRefactoringUtil.replaceStatementAndReformat((JSStatement)statement, (String)JSReplaceConditionalWithIfIntention.getReplacementText("", "", conditional, (JSElement)statement));
        }
    }

    private static boolean isSuitableReference(List<JSVariable> allVars, Set<String> varNames, JSReferenceExpression e) {
        return e.getQualifier() == null && varNames.contains(e.getReferenceName()) && allVars.contains(e.resolve());
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        JSSourceElement statementCandidate = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSStatement.class, JSFunction.class});
        if (statementCandidate instanceof JSVarStatement && ((JSVarStatement)statementCandidate).getVarKeyword() == JSVarStatement.VarKeyword.CONST) {
            return JSIntentionBundle.message("conditional.replace-conditional-with-if.let.display-name", new Object[0]);
        }
        return JSIntentionBundle.message("conditional.replace-conditional-with-if.display-name", new Object[0]);
    }

    @NotNull
    private static JSExpression getTopExpressionInStatement(@NotNull JSConditionalExpression conditional) {
        if (conditional == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(4);
        }
        JSConditionalExpression result = conditional;
        while (true) {
            JSExpression next;
            if ((next = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)result, JSExpression.class, (boolean)true, (Class[])new Class[]{JSSourceElement.class})) == null) {
                JSConditionalExpression jSConditionalExpression = result;
                if (jSConditionalExpression == null) {
                    JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(5);
                }
                return jSConditionalExpression;
            }
            result = next;
        }
    }

    @NotNull
    private static String getReplacementText(@NotNull String prefix, String postfix, @NotNull JSConditionalExpression conditional, @NotNull JSElement toReplace) {
        if (prefix == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(6);
        }
        if (conditional == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(7);
        }
        if (toReplace == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(8);
        }
        String statementText = toReplace.getText();
        String conditionalText = JSUtils.getTopmostParenthesizedOrSelf((JSExpression)conditional).getText();
        int conditionalIndex = statementText.indexOf(conditionalText);
        String statementStart = statementText.substring(0, conditionalIndex);
        String statementEnd = statementText.substring(conditionalIndex + conditionalText.length());
        String condition = JSReplaceConditionalWithIfIntention.getNonNullExpression(conditional.getCondition());
        String thenExpression = JSReplaceConditionalWithIfIntention.getNonNullExpression((JSExpression)conditional.getThenBranch());
        String elseExpression = JSReplaceConditionalWithIfIntention.getNonNullExpression((JSExpression)conditional.getElseBranch());
        String string = "if (" + condition + ") {" + prefix + statementStart + thenExpression + statementEnd + postfix + "} else {" + prefix + statementStart + elseExpression + statementEnd + postfix + "}";
        if (string == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String getNonNullExpression(@Nullable JSExpression condition) {
        JSExpression expression = JSParenthesesUtils.stripParentheses((JSExpression)condition);
        return expression != null ? expression.getText() : "";
    }

    private static /* synthetic */ boolean lambda$processIntention$4(JSInitializerOwner declaration, JSVariable variable) {
        return PsiTreeUtil.isAncestor((PsiElement)declaration, (PsiElement)variable, (boolean)false);
    }

    private static /* synthetic */ String lambda$processIntention$3(JSInitializerOwner e) {
        return e.getText();
    }

    private static /* synthetic */ boolean lambda$processIntention$2(List allVars, Set varNames, JSReferenceExpression e) {
        return JSReplaceConditionalWithIfIntention.isSuitableReference(allVars, varNames, e);
    }

    private static /* synthetic */ String lambda$processIntention$1(JSVariable v) {
        return v.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/conditional/JSReplaceConditionalWithIfIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditional";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/conditional/JSReplaceConditionalWithIfIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopExpressionInStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTopExpressionInStatement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

