/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.diff.util;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.jupyter.diff.util.JupyterDiffDividerDrawUtil;
import com.intellij.jupyter.diff.util.JupyterDiffDrawUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.EditorEx;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterSimpleDiffChangeUi;", "Lcom/intellij/diff/tools/simple/SimpleDiffChangeUi;", "viewer", "Lcom/intellij/diff/tools/simple/SimpleDiffViewer;", "change", "Lcom/intellij/diff/tools/simple/SimpleDiffChange;", "<init>", "(Lcom/intellij/diff/tools/simple/SimpleDiffViewer;Lcom/intellij/diff/tools/simple/SimpleDiffChange;)V", "createHighlighter", "", "side", "Lcom/intellij/diff/util/Side;", "createOperation", "Lcom/intellij/diff/util/DiffGutterOperation;", "builder", "Lcom/intellij/diff/util/DiffGutterOperation$ModifiersRendererBuilder;", "drawDivider", "", "handler", "Lcom/intellij/jupyter/diff/util/JupyterDiffDividerDrawUtil$JupyterDividerPaintable$Handler;", "intellij.jupyter.diff"})
public final class JupyterSimpleDiffChangeUi
extends SimpleDiffChangeUi {
    public JupyterSimpleDiffChangeUi(@NotNull SimpleDiffViewer viewer, @NotNull SimpleDiffChange change) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        super(viewer, change);
    }

    protected void createHighlighter(@NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        EditorEx editorEx = this.myViewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        TextDiffType textDiffType = this.myChange.getDiffType();
        Intrinsics.checkNotNullExpressionValue((Object)textDiffType, (String)"<get-diffType>(...)");
        TextDiffType type = textDiffType;
        int startLine = this.myChange.getStartLine(side);
        int endLine = this.myChange.getEndLine(side);
        boolean ignored = this.myChange.getFragment().getInnerFragments() != null;
        boolean alignedSides = this.myViewer.needAlignChanges();
        this.myHighlighters.addAll((Collection)new JupyterDiffDrawUtil.JupyterLineHighlighterBuilder((Editor)editor, startLine, endLine, type).withIgnored(ignored).withExcludedInEditor(this.myChange.isSkipped()).withExcludedInGutter(this.myChange.isExcluded()).withAlignedSides(alignedSides).done());
    }

    @NotNull
    protected DiffGutterOperation createOperation(@NotNull Side side, @NotNull DiffGutterOperation.ModifiersRendererBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        int startOffset = side.getStartOffset((DiffFragment)this.myChange.getFragment());
        int endOffset = side.getEndOffset((DiffFragment)this.myChange.getFragment());
        EditorEx editorEx = this.myViewer.getEditor(side);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        EditorEx editor = editorEx;
        FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        if (foldRegion != null) {
            int foldStart = foldRegion.getStartOffset();
            int foldEnd = foldRegion.getEndOffset();
            startOffset = endOffset > foldEnd ? foldEnd : Math.max(0, foldStart - 1);
        }
        return (DiffGutterOperation)new DiffGutterOperation.WithModifiers((Editor)editor, startOffset, this.myViewer.getModifierProvider(), builder);
    }

    public final boolean drawDivider(@NotNull JupyterDiffDividerDrawUtil.JupyterDividerPaintable.Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        int startLine1 = this.myChange.getStartLine(Side.LEFT);
        int endLine1 = this.myChange.getEndLine(Side.LEFT);
        int startLine2 = this.myChange.getStartLine(Side.RIGHT);
        int endLine2 = this.myChange.getEndLine(Side.RIGHT);
        TextDiffType textDiffType = this.myChange.getDiffType();
        Intrinsics.checkNotNullExpressionValue((Object)textDiffType, (String)"<get-diffType>(...)");
        TextDiffType type = textDiffType;
        return this.myViewer.needAlignChanges() ? handler.processAligned(startLine1, endLine1, startLine2, endLine2, type) : handler.processExcludable(startLine1, endLine1, startLine2, endLine2, type, this.myChange.isExcluded(), this.myChange.isSkipped());
    }
}

