/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util.core;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigReferenceDescriptor;
import org.editorconfig.language.util.EditorConfigTextMatchingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tJ\"\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a8\u0006\f"}, d2={"Lorg/editorconfig/language/util/core/EditorConfigIdentifierUtilCore;", "", "<init>", "()V", "matchesDeclaration", "", "element", "Lorg/editorconfig/language/psi/interfaces/EditorConfigDescribableElement;", "id", "", "text", "matchesReference", "intellij.editorconfig"})
public final class EditorConfigIdentifierUtilCore {
    @NotNull
    public static final EditorConfigIdentifierUtilCore INSTANCE = new EditorConfigIdentifierUtilCore();

    private EditorConfigIdentifierUtilCore() {
    }

    public final boolean matchesDeclaration(@NotNull EditorConfigDescribableElement element, @Nullable String id, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        EditorConfigDescriptor editorConfigDescriptor = element.getDescriptor(false);
        EditorConfigDeclarationDescriptor editorConfigDeclarationDescriptor = editorConfigDescriptor instanceof EditorConfigDeclarationDescriptor ? (EditorConfigDeclarationDescriptor)editorConfigDescriptor : null;
        if (editorConfigDeclarationDescriptor == null) {
            return false;
        }
        EditorConfigDeclarationDescriptor descriptor = editorConfigDeclarationDescriptor;
        if (id != null && !Intrinsics.areEqual((Object)descriptor.getId(), (Object)id)) {
            return false;
        }
        return text == null || EditorConfigTextMatchingUtil.INSTANCE.textMatchesToIgnoreCase((PsiElement)element, (CharSequence)text);
    }

    public final boolean matchesReference(@NotNull EditorConfigDescribableElement element, @Nullable String id, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        EditorConfigDescriptor editorConfigDescriptor = element.getDescriptor(false);
        EditorConfigReferenceDescriptor editorConfigReferenceDescriptor = editorConfigDescriptor instanceof EditorConfigReferenceDescriptor ? (EditorConfigReferenceDescriptor)editorConfigDescriptor : null;
        if (editorConfigReferenceDescriptor == null) {
            return false;
        }
        EditorConfigReferenceDescriptor descriptor = editorConfigReferenceDescriptor;
        if (id != null && !Intrinsics.areEqual((Object)descriptor.getId(), (Object)id)) {
            return false;
        }
        return text == null || EditorConfigTextMatchingUtil.INSTANCE.textMatchesToIgnoreCase((PsiElement)element, (CharSequence)text);
    }
}

