/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.lsWidget;

import com.intellij.lang.LangBundle;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.platform.lang.lsWidget.impl.fus.LanguageServiceWidgetActionKind;
import com.intellij.platform.lang.lsWidget.impl.fus.LanguageServiceWidgetUsagesCollector;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.lsWidget.LspWidgetInternalService;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.lsWidget.OpenLspErrorOutputAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/lsp/impl/lsWidget/LspWidgetInternalServiceImpl;", "Lcom/intellij/platform/lsp/api/lsWidget/LspWidgetInternalService;", "LspWidgetInternalServiceImpl", "()V", "createShowErrorOutputAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "restartLspServer", "", "stopLspServer", "intellij.platform.lsp.impl"})
final class LspWidgetInternalServiceImpl
extends LspWidgetInternalService {
    @Override
    @Nullable
    public AnAction createShowErrorOutputAction(@NotNull LspServer lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        if (((LspServerImpl)lspServer).getErrorOutput$intellij_platform_lsp_impl() == null) {
            return null;
        }
        return new OpenLspErrorOutputAction((LspServerImpl)lspServer);
    }

    @Override
    public void restartLspServer(@NotNull LspServer lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        LanguageServiceWidgetUsagesCollector.INSTANCE.actionInvoked(lspServer.getProject(), LanguageServiceWidgetActionKind.RestartService, lspServer.getDescriptor().getClass());
        LspServerManagerImpl lspServerManagerImpl = LspServerManagerImpl.Companion.getInstanceImpl(lspServer.getProject());
        lspServerManagerImpl.stopRunningServer$intellij_platform_lsp_impl((LspServerImpl)lspServer);
        lspServerManagerImpl.startServersIfNeeded(((LspServerImpl)lspServer).getProviderClass());
        Object[] objectArray = new Object[]{((LspServerImpl)lspServer).getDescriptor().getPresentableName()};
        String string = LangBundle.message((String)"language.services.0.server.restarted.notification.title", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        NotificationGroupManager.getInstance().getNotificationGroup("language.service.stopped.or.restarted").createNotification(string2, "", NotificationType.INFORMATION).notify(((LspServerImpl)lspServer).getProject());
    }

    @Override
    public void stopLspServer(@NotNull LspServer lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        LanguageServiceWidgetUsagesCollector.INSTANCE.actionInvoked(lspServer.getProject(), LanguageServiceWidgetActionKind.StopService, lspServer.getDescriptor().getClass());
        LspServerManagerImpl.Companion.getInstanceImpl(lspServer.getProject()).stopRunningServer$intellij_platform_lsp_impl((LspServerImpl)lspServer);
        Object[] objectArray = new Object[]{((LspServerImpl)lspServer).getDescriptor().getPresentableName()};
        String string = LangBundle.message((String)"language.services.0.server.stopped.notification.title", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        String string3 = LangBundle.message((String)"language.services.server.stopped.notification.content", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String string4 = string3;
        NotificationGroupManager.getInstance().getNotificationGroup("language.service.stopped.or.restarted").createNotification(string2, string4, NotificationType.INFORMATION).notify(((LspServerImpl)lspServer).getProject());
    }
}

