/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ProcessingContext;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.WebSymbolsScope;
import com.intellij.webSymbols.completion.WebSymbolCodeCompletionItem;
import com.intellij.webSymbols.completion.WebSymbolCodeCompletionItemCustomizer;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u0017*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0017\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u0002H$\u00a2\u0006\u0002\u0010\u0010J=\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/webSymbols/completion/WebSymbolsCompletionProviderBase;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "getContext", "position", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "", "name", "", "queryExecutor", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lcom/intellij/codeInsight/completion/CompletionResultSet;ILjava/lang/String;Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;Lcom/intellij/psi/PsiElement;)V", "Companion", "intellij.platform.webSymbols"})
public abstract class WebSymbolsCompletionProviderBase<T extends PsiElement>
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected final void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement = parameters.getPosition().getOriginalElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOriginalElement(...)");
        T t = this.getContext(psiElement);
        if (t == null) {
            return;
        }
        T psiContext = t;
        WebSymbolsQueryExecutor queryExecutor = WebSymbolsQueryExecutorFactory.Companion.create$default(WebSymbolsQueryExecutorFactory.Companion, psiContext, false, 2, null);
        PsiElement psiElement2 = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPosition(...)");
        int elementOffset = PsiTreeUtilKt.getStartOffset((PsiElement)psiElement2);
        int position = 0;
        String name = null;
        if (parameters.getOffset() > elementOffset) {
            position = parameters.getOffset() - elementOffset;
            Document it = parameters.getEditor().getDocument();
            boolean bl = false;
            Document document = it instanceof DocumentWindow && !InjectedLanguageManager.getInstance((Project)psiContext.getProject()).isInjectedFragment(parameters.getOriginalFile()) ? ((DocumentWindow)it).getDelegate() : it;
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"let(...)");
            Document document2 = document;
            name = document2.getText(new TextRange(elementOffset, parameters.getOffset()));
        } else {
            position = 0;
            name = "";
        }
        this.addCompletions(parameters, result2, position, name, queryExecutor, psiContext);
    }

    @Nullable
    protected abstract T getContext(@NotNull PsiElement var1);

    protected abstract void addCompletions(@NotNull CompletionParameters var1, @NotNull CompletionResultSet var2, int var3, @NotNull String var4, @NotNull WebSymbolsQueryExecutor var5, @NotNull T var6);

    @JvmStatic
    public static final void processCompletionQueryResults(@NotNull WebSymbolsQueryExecutor queryExecutor, @NotNull CompletionResultSet result2, @NotNull WebSymbolQualifiedKind qualifiedKind, @NotNull String name, int position, @NotNull PsiElement location, @NotNull List<? extends WebSymbolsScope> queryContext, @Nullable Set<String> providedNames, @Nullable Function1<? super WebSymbolCodeCompletionItem, Boolean> filter, @NotNull Function1<? super WebSymbolCodeCompletionItem, Unit> consumer) {
        Companion.processCompletionQueryResults(queryExecutor, result2, qualifiedKind, name, position, location, queryContext, providedNames, filter, consumer);
    }

    @JvmStatic
    public static final void processWebSymbolCodeCompletionItems(@NotNull List<? extends WebSymbolCodeCompletionItem> symbols, @NotNull CompletionResultSet result2, @NotNull WebSymbolQualifiedKind qualifiedKind, @NotNull String name, @Nullable String framework, @NotNull PsiElement location, @Nullable Set<String> providedNames, @Nullable Function1<? super WebSymbolCodeCompletionItem, Boolean> filter, @NotNull Function1<? super WebSymbolCodeCompletionItem, Unit> consumer) {
        Companion.processWebSymbolCodeCompletionItems(symbols, result2, qualifiedKind, name, framework, location, providedNames, filter, consumer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0086\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00162\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00182\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00050\u0018H\u0007J\u0084\u0001\u0010\u001c\u001a\u00020\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u001e\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00162\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00182\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00050\u0018H\u0007\u00a8\u0006 "}, d2={"Lcom/intellij/webSymbols/completion/WebSymbolsCompletionProviderBase$Companion;", "", "<init>", "()V", "processCompletionQueryResults", "", "queryExecutor", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "qualifiedKind", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "name", "", "position", "", "location", "Lcom/intellij/psi/PsiElement;", "queryContext", "", "Lcom/intellij/webSymbols/WebSymbolsScope;", "providedNames", "", "filter", "Lkotlin/Function1;", "Lcom/intellij/webSymbols/completion/WebSymbolCodeCompletionItem;", "", "consumer", "processWebSymbolCodeCompletionItems", "symbols", "framework", "Lcom/intellij/webSymbols/FrameworkId;", "intellij.platform.webSymbols"})
    @SourceDebugExtension(value={"SMAP\nWebSymbolsCompletionProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsCompletionProviderBase.kt\ncom/intellij/webSymbols/completion/WebSymbolsCompletionProviderBase$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1317#2,2:108\n1557#3:110\n1628#3,3:111\n*S KotlinDebug\n*F\n+ 1 WebSymbolsCompletionProviderBase.kt\ncom/intellij/webSymbols/completion/WebSymbolsCompletionProviderBase$Companion\n*L\n102#1:108,2\n99#1:110\n99#1:111,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void processCompletionQueryResults(@NotNull WebSymbolsQueryExecutor queryExecutor, @NotNull CompletionResultSet result2, @NotNull WebSymbolQualifiedKind qualifiedKind, @NotNull String name, int position, @NotNull PsiElement location, @NotNull List<? extends WebSymbolsScope> queryContext, @Nullable Set<String> providedNames, @Nullable Function1<? super WebSymbolCodeCompletionItem, Boolean> filter, @NotNull Function1<? super WebSymbolCodeCompletionItem, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter(queryContext, (String)"queryContext");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.processWebSymbolCodeCompletionItems(WebSymbolsQueryExecutor.runCodeCompletionQuery$default(queryExecutor, qualifiedKind, name, position, false, queryContext, 8, null), result2, qualifiedKind, name, queryExecutor.getFramework(), location, providedNames, filter, consumer);
        }

        public static /* synthetic */ void processCompletionQueryResults$default(Companion companion, WebSymbolsQueryExecutor webSymbolsQueryExecutor, CompletionResultSet completionResultSet, WebSymbolQualifiedKind webSymbolQualifiedKind, String string, int n, PsiElement psiElement, List list2, Set set, Function1 function1, Function1 function12, int n2, Object object) {
            if ((n2 & 0x40) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n2 & 0x80) != 0) {
                set = null;
            }
            if ((n2 & 0x100) != 0) {
                function1 = null;
            }
            companion.processCompletionQueryResults(webSymbolsQueryExecutor, completionResultSet, webSymbolQualifiedKind, string, n, psiElement, list2, set, (Function1<? super WebSymbolCodeCompletionItem, Boolean>)function1, (Function1<? super WebSymbolCodeCompletionItem, Unit>)function12);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void processWebSymbolCodeCompletionItems(@NotNull List<? extends WebSymbolCodeCompletionItem> symbols, @NotNull CompletionResultSet result2, @NotNull WebSymbolQualifiedKind qualifiedKind, @NotNull String name, @Nullable String framework, @NotNull PsiElement location, @Nullable Set<String> providedNames, @Nullable Function1<? super WebSymbolCodeCompletionItem, Boolean> filter, @NotNull Function1<? super WebSymbolCodeCompletionItem, Unit> consumer) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            int prefixLength = name.length();
            Set prefixes = new LinkedHashSet();
            Sequence sequence = SequencesKt.onEach((Sequence)SequencesKt.filter(WebSymbolCodeCompletionItemCustomizer.Companion.customizeItems$intellij_platform_webSymbols((Sequence<? extends WebSymbolCodeCompletionItem>)SequencesKt.distinctBy((Sequence)CollectionsKt.asSequence((Iterable)symbols), Companion::processWebSymbolCodeCompletionItems$lambda$0), framework, qualifiedKind, location), arg_0 -> Companion.processWebSymbolCodeCompletionItems$lambda$1(filter, prefixLength, providedNames, name, arg_0)), arg_0 -> Companion.processWebSymbolCodeCompletionItems$lambda$3(name, prefixes, arg_0));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                consumer.invoke(element$iv);
            }
            result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().oneOf((Collection)prefixes));
        }

        public static /* synthetic */ void processWebSymbolCodeCompletionItems$default(Companion companion, List list2, CompletionResultSet completionResultSet, WebSymbolQualifiedKind webSymbolQualifiedKind, String string, String string2, PsiElement psiElement, Set set, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 0x40) != 0) {
                set = null;
            }
            if ((n & 0x80) != 0) {
                function1 = null;
            }
            companion.processWebSymbolCodeCompletionItems(list2, completionResultSet, webSymbolQualifiedKind, string, string2, psiElement, set, (Function1<? super WebSymbolCodeCompletionItem, Boolean>)function1, (Function1<? super WebSymbolCodeCompletionItem, Unit>)function12);
        }

        private static final Triple processWebSymbolCodeCompletionItems$lambda$0(WebSymbolCodeCompletionItem it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new Triple((Object)it.getOffset(), (Object)it.getName(), (Object)it.isCompleteAfterInsert());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean processWebSymbolCodeCompletionItems$lambda$1(Function1 $filter, int $prefixLength, Set $providedNames, String $name, WebSymbolCodeCompletionItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if ($filter != null) {
                if ((Boolean)$filter.invoke((Object)item) == false) return false;
            }
            if (item.getOffset() > $prefixLength) return false;
            if ($providedNames == null) return true;
            String string = $name.substring(0, item.getOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (!$providedNames.add(string + item.getName())) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit processWebSymbolCodeCompletionItems$lambda$3(String $name, Set $prefixes, WebSymbolCodeCompletionItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (item.isCompleteAfterInsert()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String string = $name.substring(0, item.getOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String namePrefix = string;
                $prefixes.add(namePrefix + item.getName());
                Iterable iterable = item.getAliases();
                Set set = $prefixes;
                boolean $i$f$map = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(namePrefix + (String)it);
                }
                set.addAll((List)destination$iv$iv);
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

