/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagnostic.Checks;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import java.awt.Color;
import java.awt.Shape;
import java.util.Objects;
import java.util.Optional;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class DiagramRelationshipInfoAdapter
implements DiagramRelationshipInfo {
    @NotNull
    private final String myName;
    @NotNull
    private final DiagramLineType myLineType;
    private final int myWidth;
    @Nullable
    private final Shape mySourceArrow;
    @Nullable
    private final Shape myTargetArrow;
    @Nullable
    private final DiagramRelationshipInfo.Label myUpperSourceLabel;
    @Nullable
    private final DiagramRelationshipInfo.Label myBottomSourceLabel;
    @Nullable
    private final DiagramRelationshipInfo.Label myUpperCenterLabel;
    @Nullable
    private final DiagramRelationshipInfo.Label myBottomCenterLabel;
    @Nullable
    private final DiagramRelationshipInfo.Label myUpperTargetLabel;
    @Nullable
    private final DiagramRelationshipInfo.Label myBottomTargetLabel;

    public DiagramRelationshipInfoAdapter(@Nullable String name, @Nullable DiagramLineType lineType, int width, @Nullable Shape sourceArrow, @Nullable Shape targetArrow, @Nullable DiagramRelationshipInfo.Label upperCenterLabel, @Nullable DiagramRelationshipInfo.Label bottomCenterLabel, @Nullable DiagramRelationshipInfo.Label upperSourceLabel, @Nullable DiagramRelationshipInfo.Label bottomSourceLabel, @Nullable DiagramRelationshipInfo.Label upperTargetLabel, @Nullable DiagramRelationshipInfo.Label bottomTargetLabel) {
        this.myName = name == null ? "UNDEFINED" : name;
        this.myLineType = lineType == null ? DiagramLineType.SOLID : lineType;
        this.myWidth = width;
        this.mySourceArrow = sourceArrow;
        this.myTargetArrow = targetArrow;
        this.myUpperCenterLabel = upperCenterLabel;
        this.myBottomCenterLabel = bottomCenterLabel;
        this.myUpperSourceLabel = upperSourceLabel;
        this.myBottomSourceLabel = bottomSourceLabel;
        this.myUpperTargetLabel = upperTargetLabel;
        this.myBottomTargetLabel = bottomTargetLabel;
    }

    public DiagramRelationshipInfoAdapter(@Nullable String name, @Nullable DiagramLineType lineType, int width, @Nullable Shape sourceArrow, @Nullable Shape targetArrow, @Nullable String upperCenterLabel, @Nullable String bottomCenterLabel, @Nullable String upperSourceLabel, @Nullable String bottomSourceLabel, @Nullable String upperTargetLabel, @Nullable String bottomTargetLabel) {
        this(name, lineType, width, sourceArrow, targetArrow, upperCenterLabel != null ? new ColoredLabel(upperCenterLabel) : null, bottomCenterLabel != null ? new ColoredLabel(bottomCenterLabel) : null, upperSourceLabel != null ? new ColoredLabel(upperSourceLabel) : null, bottomSourceLabel != null ? new ColoredLabel(bottomSourceLabel) : null, upperTargetLabel != null ? new ColoredLabel(upperTargetLabel) : null, bottomTargetLabel != null ? new ColoredLabel(bottomTargetLabel) : null);
    }

    public DiagramRelationshipInfoAdapter(String name, DiagramLineType lineType, @Nullable String label, @Nullable String fromLabel, @Nullable String toLabel, int width) {
        this(name, lineType, width, null, null, label, null, fromLabel, null, toLabel, null);
    }

    public DiagramRelationshipInfoAdapter(@Nullable String name, @Nullable DiagramLineType lineType, @Nullable String upperCenterLabel) {
        this(name, lineType, 1, null, null, upperCenterLabel, null, null, null, null, null);
    }

    public DiagramRelationshipInfoAdapter(@Nullable String name, @Nullable DiagramLineType lineType, @Nullable String upperTargetLabel, @Nullable String upperSourceLabel) {
        this(name, lineType, 1, null, null, null, null, upperSourceLabel, null, upperTargetLabel, null);
    }

    public DiagramRelationshipInfoAdapter(String name, DiagramLineType lineType) {
        this(name, lineType, null);
    }

    public DiagramRelationshipInfoAdapter(String name) {
        this(name, null, null);
    }

    @Override
    @NotNull
    public DiagramLineType getLineType() {
        DiagramLineType diagramLineType = this.myLineType;
        if (diagramLineType == null) {
            DiagramRelationshipInfoAdapter.$$$reportNull$$$0(0);
        }
        return diagramLineType;
    }

    @Override
    @Nullable
    public Shape getStartArrow() {
        return this.mySourceArrow;
    }

    @Override
    @Nullable
    public Shape getEndArrow() {
        return this.myTargetArrow;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DiagramRelationshipInfoAdapter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    @Nullable
    public DiagramRelationshipInfo.Label getUpperCenterLabel() {
        return this.myUpperCenterLabel;
    }

    @Override
    @Nullable
    public DiagramRelationshipInfo.Label getBottomCenterLabel() {
        return this.myBottomCenterLabel;
    }

    @Override
    @Nullable
    public DiagramRelationshipInfo.Label getUpperSourceLabel() {
        return this.myUpperSourceLabel;
    }

    @Override
    @Nullable
    public DiagramRelationshipInfo.Label getBottomSourceLabel() {
        return this.myBottomSourceLabel;
    }

    @Override
    @Nullable
    public DiagramRelationshipInfo.Label getUpperTargetLabel() {
        return this.myUpperTargetLabel;
    }

    @Override
    @Nullable
    public DiagramRelationshipInfo.Label getBottomTargetLabel() {
        return this.myBottomTargetLabel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagramRelationshipInfoAdapter adapter = (DiagramRelationshipInfoAdapter)o;
        return this.myWidth == adapter.myWidth && this.myName.equals(adapter.myName) && this.myLineType == adapter.myLineType && Objects.equals(this.myUpperCenterLabel, adapter.myUpperCenterLabel) && Objects.equals(this.myBottomCenterLabel, adapter.myBottomCenterLabel) && Objects.equals(this.myUpperSourceLabel, adapter.myUpperSourceLabel) && Objects.equals(this.myBottomSourceLabel, adapter.myBottomSourceLabel) && Objects.equals(this.myUpperTargetLabel, adapter.myUpperTargetLabel) && Objects.equals(this.myBottomTargetLabel, adapter.myBottomTargetLabel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myName, this.myLineType, this.myWidth, this.myUpperCenterLabel, this.myBottomCenterLabel, this.myUpperSourceLabel, this.myBottomSourceLabel, this.myUpperTargetLabel, this.myBottomTargetLabel});
    }

    public String toString() {
        return this.myName;
    }

    public static boolean equalsByName(@Nullable DiagramRelationshipInfo a, @Nullable DiagramRelationshipInfo b) {
        return a == null && b == null || a instanceof DiagramRelationshipInfoAdapter && b instanceof DiagramRelationshipInfoAdapter && Objects.equals(((DiagramRelationshipInfoAdapter)a).myName, ((DiagramRelationshipInfoAdapter)b).myName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/diagram/DiagramRelationshipInfoAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class ColoredLabel
    implements DiagramRelationshipInfo.Label {
        @NotNull
        private final String myText;
        @Nullable
        private final Color myColor;
        @Nullable
        private final ColorKey myColorKey;

        public ColoredLabel(@NotNull String text, @Nullable Color color) {
            if (text == null) {
                ColoredLabel.$$$reportNull$$$0(0);
            }
            this.myText = text;
            this.myColor = color;
            this.myColorKey = null;
        }

        public ColoredLabel(@NotNull String text, @Nullable ColorKey colorKey) {
            if (text == null) {
                ColoredLabel.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myColor = null;
            this.myColorKey = colorKey;
        }

        public ColoredLabel(@NotNull String text) {
            if (text == null) {
                ColoredLabel.$$$reportNull$$$0(2);
            }
            this(text, (ColorKey)null);
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ColoredLabel.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Color getColor() {
            return this.myColorKey != null ? EditorColorsManager.getInstance().getGlobalScheme().getColor(this.myColorKey) : this.myColor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColoredLabel label = (ColoredLabel)o;
            return this.myText.equals(label.myText) && Objects.equals(this.myColor, label.myColor);
        }

        public int hashCode() {
            return Objects.hash(this.myText, this.myColor);
        }

        public String toString() {
            return "ColoredLabel{myText='" + this.myText + "', myColor=" + this.myColor + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/DiagramRelationshipInfoAdapter$ColoredLabel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/DiagramRelationshipInfoAdapter$ColoredLabel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class Builder {
        @NotNull
        private String myName;
        @NotNull
        private DiagramLineType myLineType;
        private int myWidth;
        @Nullable
        private Shape mySourceArrow;
        @Nullable
        private Shape myTargetArrow;
        @Nullable
        private DiagramRelationshipInfo.Label myUpperCenterLabel;
        @Nullable
        private DiagramRelationshipInfo.Label myBottomCenterLabel;
        @Nullable
        private DiagramRelationshipInfo.Label myUpperSourceLabel;
        @Nullable
        private DiagramRelationshipInfo.Label myBottomSourceLabel;
        @Nullable
        private DiagramRelationshipInfo.Label myUpperTargetLabel;
        @Nullable
        private DiagramRelationshipInfo.Label myBottomTargetLabel;

        public Builder() {
            this.myName = "UNDEFINED";
            this.myLineType = DiagramLineType.SOLID;
            this.myWidth = 1;
        }

        public Builder(@NotNull DiagramRelationshipInfo copyTarget) {
            if (copyTarget == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myName = "UNDEFINED";
            this.myLineType = DiagramLineType.SOLID;
            this.myWidth = 1;
            this.setName(copyTarget instanceof DiagramRelationshipInfoAdapter ? ((DiagramRelationshipInfoAdapter)copyTarget).getName() : "UNDEFINED").setLineType(Optional.ofNullable(copyTarget.getLineType()).orElse(DiagramLineType.SOLID)).setWidth(copyTarget.getWidth()).setSourceArrow(copyTarget.getSourceArrow()).setTargetArrow(copyTarget.getTargetArrow()).setUpperCenterLabel(copyTarget.getUpperCenterLabel()).setBottomCenterLabel(copyTarget.getBottomCenterLabel()).setUpperSourceLabel(copyTarget.getUpperSourceLabel()).setBottomSourceLabel(copyTarget.getBottomSourceLabel()).setUpperTargetLabel(copyTarget.getUpperTargetLabel()).setBottomTargetLabel(copyTarget.getBottomTargetLabel());
        }

        public Builder setName(@NotNull String name) {
            if (name == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myName = name;
            return this;
        }

        public Builder setLineType(@NotNull DiagramLineType type) {
            if (type == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myLineType = type;
            return this;
        }

        public Builder setWidth(int width) {
            Checks.require((width > 0 ? 1 : 0) != 0);
            this.myWidth = width;
            return this;
        }

        public Builder setSourceArrow(@Nullable Shape arrow) {
            this.mySourceArrow = arrow;
            return this;
        }

        public Builder setTargetArrow(@Nullable Shape arrow) {
            this.myTargetArrow = arrow;
            return this;
        }

        public Builder setUpperCenterLabel(@Nullable DiagramRelationshipInfo.Label label) {
            this.myUpperCenterLabel = label;
            return this;
        }

        public Builder setBottomCenterLabel(@Nullable DiagramRelationshipInfo.Label label) {
            this.myBottomCenterLabel = label;
            return this;
        }

        public Builder setUpperSourceLabel(@Nullable DiagramRelationshipInfo.Label label) {
            this.myUpperSourceLabel = label;
            return this;
        }

        public Builder setBottomSourceLabel(@Nullable DiagramRelationshipInfo.Label label) {
            this.myBottomSourceLabel = label;
            return this;
        }

        public Builder setUpperTargetLabel(@Nullable DiagramRelationshipInfo.Label label) {
            this.myUpperTargetLabel = label;
            return this;
        }

        public Builder setBottomTargetLabel(@Nullable DiagramRelationshipInfo.Label label) {
            this.myBottomTargetLabel = label;
            return this;
        }

        public Builder setUpperCenterLabel(@Nullable String label) {
            this.myUpperCenterLabel = label != null ? new ColoredLabel(label) : null;
            return this;
        }

        public Builder setBottomCenterLabel(@Nullable String label) {
            this.myBottomCenterLabel = label != null ? new ColoredLabel(label) : null;
            return this;
        }

        public Builder setUpperSourceLabel(@Nullable String label) {
            this.myUpperSourceLabel = label != null ? new ColoredLabel(label) : null;
            return this;
        }

        public Builder setBottomSourceLabel(@Nullable String label) {
            this.myBottomSourceLabel = label != null ? new ColoredLabel(label) : null;
            return this;
        }

        public Builder setUpperTargetLabel(@Nullable String label) {
            this.myUpperTargetLabel = label != null ? new ColoredLabel(label) : null;
            return this;
        }

        public Builder setBottomTargetLabel(@Nullable String label) {
            this.myBottomTargetLabel = label != null ? new ColoredLabel(label) : null;
            return this;
        }

        public DiagramRelationshipInfoAdapter create() {
            return new DiagramRelationshipInfoAdapter(this.myName, this.myLineType, this.myWidth, this.mySourceArrow, this.myTargetArrow, this.myUpperCenterLabel, this.myBottomCenterLabel, this.myUpperSourceLabel, this.myBottomSourceLabel, this.myUpperTargetLabel, this.myBottomTargetLabel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copyTarget";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diagram/DiagramRelationshipInfoAdapter$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLineType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class MutableColoredLabel
    implements DiagramRelationshipInfo.Label {
        @NotNull
        private volatile String myText;
        @Nullable
        private volatile Color myColor;

        public MutableColoredLabel(@NotNull String text, @Nullable Color color) {
            if (text == null) {
                MutableColoredLabel.$$$reportNull$$$0(0);
            }
            this.myText = text;
            this.myColor = color;
        }

        public MutableColoredLabel(@NotNull String text) {
            if (text == null) {
                MutableColoredLabel.$$$reportNull$$$0(1);
            }
            this(text, null);
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                MutableColoredLabel.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        public Color getColor() {
            return this.myColor;
        }

        public void setText(@NotNull String text) {
            if (text == null) {
                MutableColoredLabel.$$$reportNull$$$0(3);
            }
            this.myText = text;
        }

        public void appendText(@NotNull String textToAppend) {
            if (textToAppend == null) {
                MutableColoredLabel.$$$reportNull$$$0(4);
            }
            this.myText = this.myText + textToAppend;
        }

        public void setColor(@NotNull Color color) {
            if (color == null) {
                MutableColoredLabel.$$$reportNull$$$0(5);
            }
            this.myColor = color;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MutableColoredLabel label = (MutableColoredLabel)o;
            return this.myText.equals(label.myText) && Objects.equals(this.myColor, label.myColor);
        }

        public int hashCode() {
            return Objects.hash(this.myText, this.myColor);
        }

        public String toString() {
            return "MutableColoredLabel{myText='" + this.myText + "', myColor=" + this.myColor + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/DiagramRelationshipInfoAdapter$MutableColoredLabel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textToAppend";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/DiagramRelationshipInfoAdapter$MutableColoredLabel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "appendText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setColor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

