/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.Checks;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.core.actions.DiagramDisposableService;
import com.intellij.uml.core.actions.ShowDiagramUtilKt;
import com.intellij.uml.statistics.DiagramUsagesCollector;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.uml.utils.DiagramProgressUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class ShowDiagramBase
extends DumbAwareAction {
    private final boolean isAlwaysAvailable;
    private boolean myIsCalledFromList = false;

    public ShowDiagramBase() {
        this(false);
    }

    public ShowDiagramBase(boolean isAlwaysAvailable) {
        this.isAlwaysAvailable = isAlwaysAvailable;
        this.setInjectedContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowDiagramBase.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @NotNull
    @NonNls
    public String getFeatureId() {
        return "diagram.show";
    }

    public boolean isCalledFromJList() {
        return this.myIsCalledFromList;
    }

    protected abstract boolean isPopup();

    protected boolean isUnderProgress() {
        return true;
    }

    @Nullable
    protected Object findInDataContext(@NotNull DiagramProvider<?> provider, @NotNull DataContext context) {
        if (provider == null) {
            ShowDiagramBase.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ShowDiagramBase.$$$reportNull$$$0(2);
        }
        return provider.getElementManager().findInDataContext(context);
    }

    @NotNull
    protected RelativePoint getLocation(@NotNull DataContext context, @NotNull AnActionEvent e) {
        if (context == null) {
            ShowDiagramBase.$$$reportNull$$$0(3);
        }
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(4);
        }
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(context);
        if (relativePoint == null) {
            ShowDiagramBase.$$$reportNull$$$0(5);
        }
        return relativePoint;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(6);
        }
        Presentation presentation = e.getPresentation();
        if (e.getProject() == null) {
            presentation.setEnabled(false);
            return;
        }
        if (LightEdit.owns((Project)e.getProject())) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (this.isAlwaysAvailable && this.getForcedProvider(e.getDataContext()) == null) {
            presentation.setEnabledAndVisible(DiagramProvider.DIAGRAM_PROVIDER.hasAnyExtensions());
            return;
        }
        DiagramProvider provider = this.findAppropriateProvidersForThisAction(e.getDataContext()).findFirst().orElse(null);
        boolean isEnabled = provider != null;
        boolean isPopup = this.isPopup();
        presentation.setEnabledAndVisible(isEnabled);
        if (isEnabled) {
            presentation.setIcon(provider.getActionIcon(isPopup));
            presentation.setText(DiagramBundle.message("action.text.show.0.1", provider.getActionName(isPopup), isPopup ? " Popup" : ""));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowDiagramBase.$$$reportNull$$$0(7);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Component component = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        AbstractPopup.MyContentPanel panel = component != null ? (AbstractPopup.MyContentPanel)ComponentUtil.getParentOfType(AbstractPopup.MyContentPanel.class, (Component)component) : null;
        DataContext context = e.getDataContext();
        RelativePoint point = this.getLocation(context, e);
        this.myIsCalledFromList = panel != null;
        ShowDiagramUtilKt.invokeShowDiagramAction(this, e, point);
    }

    @NotNull
    List<DiagramSeed> getSeeds(DataContext context, Project project) {
        List<DiagramProvider<?>> providers = this.findAppropriateProvidersForThisAction(context).toList();
        if (providers.isEmpty()) {
            List<DiagramSeed> list = Collections.emptyList();
            if (list == null) {
                ShowDiagramBase.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = ContainerUtil.map(providers, provider -> {
            Pair<Object, Collection<Object>> seedElements = this.getSeedElements((DiagramProvider<?>)provider, context);
            return ShowDiagramBase.createSeed(project, provider, seedElements.getFirst(), (Collection)seedElements.getSecond());
        });
        if (list == null) {
            ShowDiagramBase.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    protected static <T> DiagramSeed createSeed(Project project, DiagramProvider<T> provider, Object first, Collection<Object> second) {
        return new DiagramSeed(project, provider, first, second);
    }

    @NotNull
    private Pair<Object, Collection<Object>> getSeedElements(@NotNull DiagramProvider<?> provider, @NotNull DataContext context) {
        if (provider == null) {
            ShowDiagramBase.$$$reportNull$$$0(10);
        }
        if (context == null) {
            ShowDiagramBase.$$$reportNull$$$0(11);
        }
        ArrayList additionalElements = new ArrayList(provider.getElementManager().findElementsInDataContext(context));
        Object originalElement = Optional.ofNullable(this.findInDataContext(provider, context)).orElseGet(() -> additionalElements.isEmpty() ? null : additionalElements.remove(additionalElements.size() - 1));
        Pair pair = Pair.create((Object)originalElement, additionalElements);
        if (pair == null) {
            ShowDiagramBase.$$$reportNull$$$0(12);
        }
        return pair;
    }

    void askUserAndOpenDiagram(List<DiagramSeed> seeds2, DataContext context, RelativePoint point) {
        this.askUserToChooseDiagramType(seeds2, context).thenApplyAsync(ThreadContext.captureThreadContext(seed -> {
            this.logStatistics((DiagramSeed)seed);
            return this.showUnderProgress((DiagramSeed)seed, point).whenComplete(Futures.logIfFailed(ShowDiagramBase.class, it -> this.makeErrorReport("Can't show diagram", (Throwable)it, (DiagramSeed)seed)));
        }));
    }

    @NotNull
    protected CompletionStage<DiagramSeed> askUserToChooseDiagramType(@NotNull List<DiagramSeed> seeds2, @NotNull DataContext context) {
        if (seeds2 == null) {
            ShowDiagramBase.$$$reportNull$$$0(13);
        }
        if (context == null) {
            ShowDiagramBase.$$$reportNull$$$0(14);
        }
        Checks.require((!seeds2.isEmpty() ? 1 : 0) != 0);
        if (seeds2.size() == 1) {
            CompletableFuture<DiagramSeed> completableFuture = CompletableFuture.completedFuture(seeds2.get(0));
            if (completableFuture == null) {
                ShowDiagramBase.$$$reportNull$$$0(15);
            }
            return completableFuture;
        }
        CompletableFuture<DiagramSeed> providerChosen = new CompletableFuture<DiagramSeed>();
        JBPopupFactory.getInstance().createPopupChooserBuilder(seeds2).setTitle(DiagramBundle.message("select.uml.provider", new Object[0])).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, seed, index) -> {
            DiagramProvider<Object> provider = seed.getChosenProvider();
            label.setText(provider.getRefinedPresentableName(seed.getOriginalElement(), seed.getAdditionalElements()));
            label.setIcon(provider.getActionIcon(this.isPopup()));
        })).setResizable(false).setMovable(false).setItemChosenCallback(it -> providerChosen.complete((DiagramSeed)it)).createPopup().showInBestPositionFor(context);
        CompletableFuture<DiagramSeed> completableFuture = providerChosen;
        if (completableFuture == null) {
            ShowDiagramBase.$$$reportNull$$$0(16);
        }
        return completableFuture;
    }

    protected void logStatistics(@NotNull DiagramSeed seed) {
        if (seed == null) {
            ShowDiagramBase.$$$reportNull$$$0(17);
        }
        DiagramUsagesCollector.logShowDiagram(seed.getProject(), seed.getChosenProvider(), seed.getOriginalElement(), seed.getAdditionalElements());
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureId());
    }

    @NotNull
    protected RuntimeExceptionWithAttachments makeErrorReport(@NotNull String userMessage, @Nullable Throwable cause, @NotNull DiagramSeed seed) {
        if (userMessage == null) {
            ShowDiagramBase.$$$reportNull$$$0(18);
        }
        if (seed == null) {
            ShowDiagramBase.$$$reportNull$$$0(19);
        }
        ArrayList<Object> allElements = new ArrayList<Object>();
        allElements.add(seed.getOriginalElement());
        allElements.addAll(seed.getAdditionalElements());
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (int i = 0; i < allElements.size(); ++i) {
            Object curr = allElements.get(i);
            attachments.add(curr instanceof PsiElement ? CoreAttachmentFactory.createAttachment((VirtualFile)((PsiElement)curr).getContainingFile().getVirtualFile()) : new Attachment("element" + i + ".txt", Objects.toString(curr)));
        }
        return new RuntimeExceptionWithAttachments(userMessage + "\n---------------\nProvider: " + seed.getChosenProvider().getClass().getCanonicalName(), cause, (Attachment[])attachments.toArray(Attachment[]::new));
    }

    @NotNull
    protected CompletionStage<Void> showUnderProgress(@NotNull DiagramSeed seed, @NotNull RelativePoint point) {
        Object element;
        if (seed == null) {
            ShowDiagramBase.$$$reportNull$$$0(20);
        }
        if (point == null) {
            ShowDiagramBase.$$$reportNull$$$0(21);
        }
        Object obj = (element = seed.getOriginalElement()) != null ? element : ContainerUtil.getFirstItem(seed.getAdditionalElements());
        seed.getAdditionalElements().remove(obj);
        if (this.isUnderProgress() && !this.isCalledFromJList() && !this.isPopup()) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            ReadAction.nonBlocking(() -> ShowDiagramBase.getRefinedPresentableName(seed, element)).expireWith((Disposable)seed.myProject.getService(DiagramDisposableService.class)).finishOnUiThread(ModalityState.nonModal(), presentableName -> {
                String message = DiagramBundle.message("building.diagram", presentableName);
                Futures.runAsyncProgressInBackground((CompletableFuture)future, (Project)seed.getProject(), (String)message, (boolean)true, indicator -> {
                    indicator.setIndeterminate(true);
                    return this.show(seed, point, (ProgressIndicator)indicator);
                });
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
            CompletableFuture<Void> completableFuture = future;
            if (completableFuture == null) {
                ShowDiagramBase.$$$reportNull$$$0(22);
            }
            return completableFuture;
        }
        CompletableFuture<Void> completableFuture = this.show(seed, point, null);
        if (completableFuture == null) {
            ShowDiagramBase.$$$reportNull$$$0(23);
        }
        return completableFuture;
    }

    @NotNull
    private static String getRefinedPresentableName(@NotNull DiagramSeed seed, Object element) {
        if (seed == null) {
            ShowDiagramBase.$$$reportNull$$$0(24);
        }
        String string = seed.getChosenProvider().getRefinedPresentableName(element, seed.getAdditionalElements());
        if (string == null) {
            ShowDiagramBase.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Deprecated
    @Nullable
    protected Runnable show(@NotNull Project project, @NotNull DiagramProvider<Object> provider, @Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull RelativePoint popupLocation) {
        if (project == null) {
            ShowDiagramBase.$$$reportNull$$$0(26);
        }
        if (provider == null) {
            ShowDiagramBase.$$$reportNull$$$0(27);
        }
        if (additionalElements == null) {
            ShowDiagramBase.$$$reportNull$$$0(28);
        }
        if (popupLocation == null) {
            ShowDiagramBase.$$$reportNull$$$0(29);
        }
        return null;
    }

    @NotNull
    protected CompletableFuture<Void> show(@NotNull DiagramSeed seed, @NotNull RelativePoint popupLocation, @Nullable ProgressIndicator indicator) {
        Runnable oldCallback;
        if (seed == null) {
            ShowDiagramBase.$$$reportNull$$$0(30);
        }
        if (popupLocation == null) {
            ShowDiagramBase.$$$reportNull$$$0(31);
        }
        if ((oldCallback = this.show(seed.getProject(), seed.getChosenProvider(), seed.getOriginalElement(), seed.getAdditionalElements(), popupLocation)) != null) {
            DiagramProgressUtil.checkAndSetText(indicator, DiagramBundle.message("diagram.build.progress.building.data.model", new Object[0]));
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(ThreadContext.captureThreadContext((Runnable)oldCallback));
            if (completableFuture == null) {
                ShowDiagramBase.$$$reportNull$$$0(32);
            }
            return completableFuture;
        }
        CompletionStage completionStage = CompletableFuture.supplyAsync(() -> {
            DiagramProgressUtil.checkAndSetText(indicator, DiagramBundle.message("diagram.build.progress.preparing.data", new Object[0]));
            UmlVirtualFileSystem.UmlVirtualFile file = this.initializeDiagramVirtualFile(seed);
            DiagramBuilder builder = this.initializeDiagramBuilder(seed, file);
            DiagramProgressUtil.checkAndSetText(indicator, DiagramBundle.message("diagram.build.progress.starting.data.model.build", new Object[0]));
            DiagramDataModel<Object> dataModel = builder.getDataModel();
            this.fillDataModel(dataModel, seed.getAdditionalElements());
            dataModel.setupScopeManager(seed.getOriginalElement(), false);
            return Trinity.create((Object)((Object)file), (Object)builder, dataModel);
        }, command -> AppUIUtil.invokeLaterIfProjectAlive((Project)seed.getProject(), () -> ApplicationManager.getApplication().runWriteAction(command))).thenComposeAsync(ThreadContext.captureThreadContext(initializedHolders -> {
            UmlVirtualFileSystem.UmlVirtualFile file = (UmlVirtualFileSystem.UmlVirtualFile)((Object)((Object)initializedHolders.first));
            DiagramBuilder builder = (DiagramBuilder)initializedHolders.second;
            DiagramDataModel dataModel = (DiagramDataModel)initializedHolders.third;
            DiagramProgressUtil.checkAndSetText(indicator, DiagramBundle.message("diagram.build.progress.building.data.model", new Object[0]));
            CompletionStage<Void> modelInitializedFuture = this.initializeDataModelAsync(dataModel, indicator);
            return modelInitializedFuture.thenComposeAsync(ThreadContext.captureThreadContext(__ -> {
                DiagramProgressUtil.checkAndSetText(indicator, DiagramBundle.message("diagram.build.progress.opening.diagram", new Object[0]));
                return this.showReadyDiagram(seed.getOriginalElement(), seed.getAdditionalElements(), builder, file, popupLocation);
            })).thenComposeAsync(ThreadContext.captureThreadContext(__ -> {
                DiagramProgressUtil.checkAndSetText(indicator, DiagramBundle.message("diagram.build.progress.finishing.diagram.build", new Object[0]));
                try {
                    return this.afterDiagramIsShown(seed.getOriginalElement(), seed.getAdditionalElements(), builder, file, popupLocation);
                }
                catch (CancellationException e) {
                    return CompletableFuture.completedFuture(null);
                }
            }));
        }));
        if (completionStage == null) {
            ShowDiagramBase.$$$reportNull$$$0(33);
        }
        return completionStage;
    }

    @RequiresReadLock
    @NotNull
    protected UmlVirtualFileSystem.UmlVirtualFile initializeDiagramVirtualFile(@NotNull DiagramSeed seed) {
        if (seed == null) {
            ShowDiagramBase.$$$reportNull$$$0(34);
        }
        ThreadingAssertions.softAssertReadAccess();
        DiagramProvider<Object> provider = seed.getChosenProvider();
        Object element = seed.getOriginalElement();
        String url = "uml://" + provider.getID() + "/" + provider.getVfsResolver().getQualifiedName(element);
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(url);
        Checks.check((boolean)(virtualFile instanceof UmlVirtualFileSystem.UmlVirtualFile));
        UmlVirtualFileSystem.UmlVirtualFile file = (UmlVirtualFileSystem.UmlVirtualFile)virtualFile;
        String text = provider.getElementManager().getEditorTitle(element, seed.getAdditionalElements());
        if (text != null) {
            file.setPresentableName(text);
        }
        if (file.getProject() == null) {
            file.setProject(seed.getProject());
        }
        file.putUserData(DiagramDataKeys.ORIGINAL_ELEMENT, element);
        UmlVirtualFileSystem.UmlVirtualFile umlVirtualFile = file;
        if (umlVirtualFile == null) {
            ShowDiagramBase.$$$reportNull$$$0(35);
        }
        return umlVirtualFile;
    }

    @RequiresWriteLock
    @NotNull
    protected DiagramBuilder initializeDiagramBuilder(@NotNull DiagramSeed seed, @NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        if (seed == null) {
            ShowDiagramBase.$$$reportNull$$$0(36);
        }
        if (file == null) {
            ShowDiagramBase.$$$reportNull$$$0(37);
        }
        ThreadingAssertions.assertWriteAccess();
        UmlGraphBuilder builder = (UmlGraphBuilder)DiagramBuilderFactory.getInstance().create(seed.getProject(), seed.getChosenProvider(), seed.getOriginalElement(), file);
        builder.setPopupMode(this.isPopup());
        builder.getPresentationModel().registerActions();
        UmlGraphBuilder umlGraphBuilder = builder;
        if (umlGraphBuilder == null) {
            ShowDiagramBase.$$$reportNull$$$0(38);
        }
        return umlGraphBuilder;
    }

    @RequiresWriteLock
    protected void fillDataModel(@NotNull DiagramDataModel<Object> dataModel, @NotNull Collection<Object> additionalElements) {
        if (dataModel == null) {
            ShowDiagramBase.$$$reportNull$$$0(39);
        }
        if (additionalElements == null) {
            ShowDiagramBase.$$$reportNull$$$0(40);
        }
        ThreadingAssertions.assertWriteAccess();
        for (Object additionalElement : additionalElements) {
            dataModel.addElement(additionalElement);
        }
    }

    @NotNull
    protected CompletionStage<Void> initializeDataModelAsync(@NotNull DiagramDataModel<?> dataModel, @Nullable ProgressIndicator indicator) {
        if (dataModel == null) {
            ShowDiagramBase.$$$reportNull$$$0(41);
        }
        Project project = dataModel.getProject();
        CompletionStage completionStage = dataModel.refreshDataModelAsync(Objects.requireNonNullElseGet(indicator, () -> new EmptyProgressIndicator())).thenAccept(o -> DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            if (!project.isDisposed()) {
                dataModel.setModelInitializationFinished();
            }
        }));
        if (completionStage == null) {
            ShowDiagramBase.$$$reportNull$$$0(42);
        }
        return completionStage;
    }

    @NotNull
    public CompletionStage<Void> showReadyDiagram(@Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull DiagramBuilder builder, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @NotNull RelativePoint popupLocation) {
        if (additionalElements == null) {
            ShowDiagramBase.$$$reportNull$$$0(43);
        }
        if (builder == null) {
            ShowDiagramBase.$$$reportNull$$$0(44);
        }
        if (file == null) {
            ShowDiagramBase.$$$reportNull$$$0(45);
        }
        if (popupLocation == null) {
            ShowDiagramBase.$$$reportNull$$$0(46);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            ShowDiagramBase.$$$reportNull$$$0(47);
        }
        return completableFuture;
    }

    @NotNull
    public CompletionStage<Void> afterDiagramIsShown(@Nullable Object element, @NotNull Collection<Object> additionalElements, @NotNull DiagramBuilder builder, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @NotNull RelativePoint popupLocation) {
        if (additionalElements == null) {
            ShowDiagramBase.$$$reportNull$$$0(48);
        }
        if (builder == null) {
            ShowDiagramBase.$$$reportNull$$$0(49);
        }
        if (file == null) {
            ShowDiagramBase.$$$reportNull$$$0(50);
        }
        if (popupLocation == null) {
            ShowDiagramBase.$$$reportNull$$$0(51);
        }
        CompletionStage completionStage = builder.queryUpdate().withDataReload().withRelayout().withPresentationUpdate().runAsync().thenRunAsync(() -> {
            DiagramFileEditor editor = builder.getEditor();
            if (editor != null && editor.isOpenedForTheFirstTime()) {
                builder.getGraphBuilder().fitContent(false);
            }
            Graph2DView view = builder.getView();
            view.adjustScrollBarVisibility();
            view.adjustScrollBarVisibility();
        }, command -> AppUIUtil.invokeLaterIfProjectAlive((Project)builder.getProject(), () -> ApplicationManager.getApplication().runWriteAction(command)));
        if (completionStage == null) {
            ShowDiagramBase.$$$reportNull$$$0(52);
        }
        return completionStage;
    }

    @Nullable
    public DiagramProvider<?> getForcedProvider() {
        return null;
    }

    @Nullable
    public DiagramProvider<?> getForcedProvider(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShowDiagramBase.$$$reportNull$$$0(53);
        }
        return this.getForcedProvider();
    }

    @NotNull
    private Stream<? extends DiagramProvider<?>> findAppropriateProvidersForThisAction(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShowDiagramBase.$$$reportNull$$$0(54);
        }
        return ShowDiagramBase.findProviders(this.getForcedProvider(dataContext), this::findInDataContext, dataContext);
    }

    @VisibleForTesting
    @NotNull
    public static Stream<? extends DiagramProvider<?>> findProviders(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShowDiagramBase.$$$reportNull$$$0(55);
        }
        return ShowDiagramBase.findProviders(null, null, dataContext);
    }

    @VisibleForTesting
    @NotNull
    public static Stream<? extends DiagramProvider<?>> findProviders(@Nullable DiagramProvider<?> forcedProvider, @Nullable BiFunction<? super DiagramProvider<?>, ? super DataContext, Object> findInDataContext, @NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            ShowDiagramBase.$$$reportNull$$$0(56);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            Stream stream = Stream.empty();
            if (stream == null) {
                ShowDiagramBase.$$$reportNull$$$0(57);
            }
            return stream;
        }
        Stream<DiagramProvider<Object>> providers = forcedProvider != null ? Stream.of(forcedProvider) : DiagramProvider.DIAGRAM_PROVIDER.getExtensionList().stream();
        Stream<DiagramProvider> stream = providers.filter(provider -> {
            if (!DumbService.getInstance((Project)project).isUsableInCurrentContext(provider)) {
                return false;
            }
            DiagramElementManager manager = provider.getElementManager();
            Object originalElement = findInDataContext != null ? findInDataContext.apply((DiagramProvider<?>)provider, (DataContext)dataContext) : manager.findInDataContext(dataContext);
            return Optional.ofNullable(originalElement).or(() -> manager.findElementsInDataContext(dataContext).stream().findFirst()).map(manager::canBeBuiltFrom).orElse(false);
        });
        if (stream == null) {
            ShowDiagramBase.$$$reportNull$$$0(58);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 10, 11, 13, 14, 17, 18, 19, 20, 21, 24, 26, 27, 28, 29, 30, 31, 34, 36, 37, 39, 40, 41, 43, 44, 45, 46, 48, 49, 50, 51, 53, 54, 55, 56 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/ShowDiagramBase";
                break;
            }
            case 1: 
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seeds";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seed";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userMessage";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: 
            case 40: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
            case 29: 
            case 31: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupLocation";
                break;
            }
            case 37: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/ShowDiagramBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeeds";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeedElements";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "askUserToChooseDiagramType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "showUnderProgress";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefinedPresentableName";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "show";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeDiagramVirtualFile";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeDiagramBuilder";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeDataModelAsync";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "showReadyDiagram";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "afterDiagramIsShown";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "findProviders";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSeedElements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "askUserToChooseDiagramType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "logStatistics";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeErrorReport";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showUnderProgress";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRefinedPresentableName";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "initializeDiagramVirtualFile";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "initializeDiagramBuilder";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "fillDataModel";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "initializeDataModelAsync";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "showReadyDiagram";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "afterDiagramIsShown";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getForcedProvider";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findAppropriateProvidersForThisAction";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findProviders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 10, 11, 13, 14, 17, 18, 19, 20, 21, 24, 26, 27, 28, 29, 30, 31, 34, 36, 37, 39, 40, 41, 43, 44, 45, 46, 48, 49, 50, 51, 53, 54, 55, 56 -> new IllegalArgumentException(string);
        };
    }

    protected static final class DiagramSeed {
        @NotNull
        private final Project myProject;
        @NotNull
        private final DiagramProvider<Object> myChosenProvider;
        @Nullable
        private final Object myElement;
        @NotNull
        private final Collection<Object> myAdditionalElements;

        public DiagramSeed(@NotNull Project project, @NotNull DiagramProvider<Object> chosenProvider, @Nullable Object element, @NotNull Collection<Object> additionalElements) {
            if (project == null) {
                DiagramSeed.$$$reportNull$$$0(0);
            }
            if (chosenProvider == null) {
                DiagramSeed.$$$reportNull$$$0(1);
            }
            if (additionalElements == null) {
                DiagramSeed.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myChosenProvider = chosenProvider;
            this.myElement = element;
            this.myAdditionalElements = additionalElements;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                DiagramSeed.$$$reportNull$$$0(3);
            }
            return project;
        }

        @NotNull
        public DiagramProvider<Object> getChosenProvider() {
            DiagramProvider<Object> diagramProvider = this.myChosenProvider;
            if (diagramProvider == null) {
                DiagramSeed.$$$reportNull$$$0(4);
            }
            return diagramProvider;
        }

        @Nullable
        public Object getOriginalElement() {
            return this.myElement;
        }

        @NotNull
        public Collection<Object> getAdditionalElements() {
            Collection<Object> collection = this.myAdditionalElements;
            if (collection == null) {
                DiagramSeed.$$$reportNull$$$0(5);
            }
            return collection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiagramSeed seed = (DiagramSeed)o;
            return this.myProject.equals(seed.myProject) && this.myChosenProvider.equals(seed.myChosenProvider) && Objects.equals(this.myElement, seed.myElement) && this.myAdditionalElements.equals(seed.myAdditionalElements);
        }

        public int hashCode() {
            return Objects.hash(this.myProject, this.myChosenProvider, this.myElement, this.myAdditionalElements);
        }

        public String toString() {
            return "DiagramSeed{myProject=" + this.myProject + ", myChosenProvider=" + this.myChosenProvider + ", myElement=" + this.myElement + ", myAdditionalElements=" + this.myAdditionalElements + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chosenProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalElements";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/core/actions/ShowDiagramBase$DiagramSeed";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/core/actions/ShowDiagramBase$DiagramSeed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChosenProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

