/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.lsp;

import com.google.gson.JsonObject;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.lsp.ExternalDefinitionsNodePackageKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.customization.LspCodeActionsSupport;
import com.intellij.platform.lsp.api.customization.LspCompletionSupport;
import com.intellij.platform.lsp.api.customization.LspFindReferencesSupport;
import com.intellij.platform.lsp.api.customization.LspFormattingSupport;
import com.intellij.platform.lsp.api.customization.LspSemanticTokensSupport;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.tailwind.settings.TailwindSettings;
import com.intellij.tailwind.util.TailwindUtil;
import com.intellij.xml.util.ColorIconCache;
import icons.TailwindcssIcons;
import java.awt.Color;
import java.util.Objects;
import javax.swing.Icon;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TailwindLspServerDescriptor
extends LspServerDescriptor {
    private static final LspCompletionSupport COMPLETION_SUPPORT = new LspCompletionSupport(){

        @NotNull
        public LookupElement createLookupElement(@NotNull CompletionParameters parameters, @NotNull CompletionItem item) {
            if (parameters == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            LookupElement element = Objects.requireNonNull(super.createLookupElement(parameters, item));
            LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)element, (double)21.0);
            if (lookupElement == null) {
                1.$$$reportNull$$$0(2);
            }
            return lookupElement;
        }

        @NotNull
        protected Icon getIcon(@NotNull CompletionItem item) {
            if (item == null) {
                1.$$$reportNull$$$0(3);
            }
            Icon icon = TailwindLspServerDescriptor.getCompletionIcon(item);
            if (icon == null) {
                1.$$$reportNull$$$0(4);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tailwind/lsp/TailwindLspServerDescriptor$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tailwind/lsp/TailwindLspServerDescriptor$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupElement";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    };
    private static final LspCodeActionsSupport CODE_ACTIONS_SUPPORT = new LspCodeActionsSupport(){

        public boolean getIntentionActionsSupport() {
            return false;
        }
    };
    private NodeTargetRun myNodeTargetRun;

    TailwindLspServerDescriptor(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(0);
        }
        if (root == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(1);
        }
        super(project, "Tailwind CSS", new VirtualFile[]{root});
    }

    public boolean isSupportedFile(@NotNull VirtualFile file) {
        if (file == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(2);
        }
        return TailwindUtil.isSupportedFile(this.getProject(), file);
    }

    @NotNull
    public GeneralCommandLine createCommandLine() {
        throw new RuntimeException("Not expected to be called because startServerProcess() is overridden");
    }

    @NotNull
    public OSProcessHandler startServerProcess() throws ExecutionException {
        NodeJsInterpreter node = NodeJsInterpreterManager.getInstance((Project)this.getProject()).getInterpreterOrThrow();
        this.myNodeTargetRun = new NodeTargetRun(node, this.getProject(), null, NodeTargetRunOptions.of((Boolean)false));
        TargetedCommandLineBuilder builder = this.myNodeTargetRun.getCommandLineBuilder();
        builder.addParameter(this.myNodeTargetRun.path(this.getLspServerPath()));
        builder.setWorkingDirectory(this.myNodeTargetRun.path(this.getRoots()[0].toNioPath()));
        LOG.info("Starting Tailwind LSP server. Node.js version " + node.getCachedVersion() + ", path: " + node.getPresentableName());
        ProcessWithCmdLine processWithCmdLine = this.myNodeTargetRun.startProcessEx();
        LOG.debug("Tailwind LSP server started:\n" + processWithCmdLine.getCommandLinePresentation());
        KillableProcessHandler killableProcessHandler = processWithCmdLine.getProcessHandler();
        if (killableProcessHandler == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(3);
        }
        return killableProcessHandler;
    }

    @NotNull
    private String getLspServerPath() {
        String packagePath = ExternalDefinitionsNodePackageKt.extractRefText((NodePackageRef)TailwindSettings.getInstance(this.getProject()).getLspServerPackageRef());
        Object object = packagePath.equals("Default") ? JSLanguageServiceUtil.getPluginDirectory(((Object)((Object)this)).getClass(), (String)"server/tailwindcss-language-server").getPath() : packagePath + "/bin/tailwindcss-language-server";
        if (object == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(4);
        }
        return object;
    }

    @NotNull
    public String getFilePath(@NotNull VirtualFile file) {
        String string;
        if (file == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(5);
        }
        try {
            string = this.myNodeTargetRun.convertLocalPathToTargetPath(file.getPath());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            String string2 = super.getFilePath(file);
            if (string2 == null) {
                TailwindLspServerDescriptor.$$$reportNull$$$0(7);
            }
            return string2;
        }
        if (string == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    protected VirtualFile findLocalFileByPath(@NotNull String path) {
        if (path == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(8);
        }
        try {
            return super.findLocalFileByPath(this.myNodeTargetRun.convertTargetPathToLocalPath(path));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return super.findLocalFileByPath(path);
        }
    }

    @Nullable
    public Object getWorkspaceConfiguration(@NotNull ConfigurationItem item) {
        if (item == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(9);
        }
        if ("editor".equals(item.getSection())) {
            JsonObject result = new JsonObject();
            result.addProperty("tabSize", (Number)4);
            return result;
        }
        if ("tailwindCSS".equals(item.getSection())) {
            return TailwindSettings.getParsedLspConfigurationGson(this.getProject());
        }
        return super.getWorkspaceConfiguration(item);
    }

    @Nullable
    public LspSemanticTokensSupport getLspSemanticTokensSupport() {
        return null;
    }

    @Nullable
    public LspCodeActionsSupport getLspCodeActionsSupport() {
        return CODE_ACTIONS_SUPPORT;
    }

    public boolean getLspGoToDefinitionSupport() {
        return false;
    }

    public boolean getLspGoToTypeDefinitionSupport() {
        return false;
    }

    @Nullable
    public LspFormattingSupport getLspFormattingSupport() {
        return null;
    }

    @Nullable
    public LspFindReferencesSupport getLspFindReferencesSupport() {
        return null;
    }

    @Nullable
    public LspCompletionSupport getLspCompletionSupport() {
        return COMPLETION_SUPPORT;
    }

    @NotNull
    private static Icon getCompletionIcon(@NotNull CompletionItem completionItem) {
        if (completionItem == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(10);
        }
        if (completionItem.getKind() == CompletionItemKind.Color) {
            String doc;
            Either docEither = completionItem.getDocumentation();
            String string = doc = docEither != null ? (String)docEither.getLeft() : null;
            if (doc != null) {
                Color color = null;
                if (doc.startsWith("rgb(") && doc.endsWith(")")) {
                    String args = doc.substring("rgb(".length(), doc.length() - 1);
                    color = CssPsiColorUtil.getColorInRGBsFunctions((String)args);
                } else if (doc.startsWith("#") && doc.length() == 7) {
                    try {
                        color = Color.decode(doc);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (color != null) {
                    Icon icon = ColorIconCache.getIconCache().getIcon(color, 16);
                    if (icon == null) {
                        TailwindLspServerDescriptor.$$$reportNull$$$0(11);
                    }
                    return icon;
                }
            }
        }
        Icon icon = TailwindcssIcons.Tailwind_16;
        if (icon == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(12);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tailwind/lsp/TailwindLspServerDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tailwind/lsp/TailwindLspServerDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startServerProcess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLspServerPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFile";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findLocalFileByPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWorkspaceConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 11, 12 -> new IllegalStateException(string);
        };
    }
}

