/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.charts.core.utils.GroupingResult;
import com.intellij.charts.core.utils.GroupingUtils;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.columns.ArrayColumn;
import com.intellij.charts.dataframe.columns.ArrayColumnType;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.charts.settings.data.type.ScatterSeriesType;
import com.intellij.charts.style.ChartsConfig;
import com.intellij.charts.utils.ChartJsonUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.geom.geomPoint;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.intern.layer.geom.PointMapping;
import org.jetbrains.letsPlot.label.LabsKt;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001BC\b\u0016\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\b\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\u0013\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/intellij/charts/settings/data/ScatterSeriesSettings;", "Lcom/intellij/charts/settings/data/SeriesSettings;", "keys", "", "Lcom/intellij/charts/settings/data/ColumnSettings;", "groups", "values", "showLegend", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Z)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "type", "Lcom/intellij/charts/settings/data/type/ScatterSeriesType;", "getType", "()Lcom/intellij/charts/settings/data/type/ScatterSeriesType;", "getKeys", "()Ljava/util/List;", "getGroups", "getValues", "getShowLegend", "()Z", "setShowLegend", "(Z)V", "toJson", "isEmpty", "equals", "other", "", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "getLetsPlotLayer", "Lorg/jetbrains/letsPlot/intern/Feature;", "chartIndex", "", "hashCode", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nScatterSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScatterSeriesSettings.kt\ncom/intellij/charts/settings/data/ScatterSeriesSettings\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n24#2:146\n1863#3:147\n1872#3,3:148\n1864#3:151\n*S KotlinDebug\n*F\n+ 1 ScatterSeriesSettings.kt\ncom/intellij/charts/settings/data/ScatterSeriesSettings\n*L\n77#1:146\n94#1:147\n101#1:148,3\n94#1:151\n*E\n"})
public final class ScatterSeriesSettings
extends SeriesSettings {
    @NotNull
    private final ScatterSeriesType type;
    @NotNull
    private final List<ColumnSettings> keys;
    @NotNull
    private final List<ColumnSettings> groups;
    @NotNull
    private final List<ColumnSettings> values;
    private boolean showLegend;

    @Override
    @NotNull
    public ScatterSeriesType getType() {
        return this.type;
    }

    @NotNull
    public final List<ColumnSettings> getKeys() {
        return this.keys;
    }

    @NotNull
    public final List<ColumnSettings> getGroups() {
        return this.groups;
    }

    @NotNull
    public final List<ColumnSettings> getValues() {
        return this.values;
    }

    public final boolean getShowLegend() {
        return this.showLegend;
    }

    public final void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public ScatterSeriesSettings(@NotNull List<ColumnSettings> keys, @NotNull List<ColumnSettings> groups2, @NotNull List<ColumnSettings> values2, boolean showLegend) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.type = ScatterSeriesType.Companion.getInstance();
        this.keys = keys;
        this.groups = groups2;
        this.values = values2;
        this.showLegend = showLegend;
    }

    public /* synthetic */ ScatterSeriesSettings(List list2, List list3, List list4, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(list2, list3, list4, bl);
    }

    public ScatterSeriesSettings(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.type = ScatterSeriesType.Companion.getInstance();
        this.keys = ChartJsonUtilsKt.optColumnSettingsList(json, "keys");
        this.groups = ChartJsonUtilsKt.optColumnSettingsList(json, "groups");
        this.values = ChartJsonUtilsKt.optColumnSettingsList(json, "values");
        this.showLegend = ChartJsonUtilsKt.optBoolean(json, "showLegend");
    }

    @Override
    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("type", this.getType().getId());
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "keys", this.keys);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "groups", this.groups);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "values", this.values);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showLegend", this.showLegend);
        return jsonObject;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty() && this.groups.isEmpty() && this.values.isEmpty();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof ScatterSeriesSettings && Intrinsics.areEqual(((ScatterSeriesSettings)other).keys, this.keys) && Intrinsics.areEqual(((ScatterSeriesSettings)other).groups, this.groups) && Intrinsics.areEqual(((ScatterSeriesSettings)other).values, this.values) && ((ScatterSeriesSettings)other).showLegend == this.showLegend;
    }

    @Override
    @NotNull
    public ScatterSeriesSettings filterByNewDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return new ScatterSeriesSettings(SeriesSettings.Companion.filterByDataFrame(this.keys, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.groups, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.values, dataFrame), this.showLegend);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @NotNull
    public List<Feature> getLetsPlotLayer(@NotNull DataFrame dataFrame, int chartIndex) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (this.keys.isEmpty() || this.values.isEmpty()) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            v0 = Logger.getInstance(ScatterSeriesSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
            v0.warn("Scatter series should have at least one X and one Y axis.");
            return CollectionsKt.emptyList();
        }
        $this$thisLogger$iv = new List[]{this.keys, this.groups, this.values};
        if (!SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, $this$thisLogger$iv)) {
            return CollectionsKt.emptyList();
        }
        v1 = GroupingUtils.INSTANCE.get(dataFrame, this.keys, this.groups, this.values);
        if (v1 == null) {
            return CollectionsKt.emptyList();
        }
        res = v1;
        rangeMin = 0.0;
        rangeMin = 1.7976931348623157E308;
        rangeMax = 0.0;
        rangeMax = 4.9E-324;
        result = new ArrayList<E>();
        $this$forEach$iv = res.getYColumns();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (Column)element$iv;
            $i$a$-forEach-ScatterSeriesSettings$getLetsPlotLayer$1 = false;
            if (!it.getType().isArray()) ** GOTO lbl-1000
            v2 = it.getType();
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type com.intellij.charts.dataframe.columns.ArrayColumnType<*>");
            if (((ArrayColumnType)v2).isNumericArray()) {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.charts.dataframe.columns.ArrayColumn<kotlin.Number>");
                yDataArray = (ArrayColumn)it;
                $this$forEachIndexed$iv = yDataArray;
                $i$f$forEachIndexed = false;
                index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    if ((var18_23 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    var19_24 = (List)item$iv;
                    index = var18_23;
                    $i$a$-forEachIndexed-ScatterSeriesSettings$getLetsPlotLayer$1$1 = false;
                    if (mutableList == null) continue;
                    var23_28 = mutableList.size();
                    for (i = 0; i < var23_28; ++i) {
                        if (!yDataArray.hasDoubleValue(index, i)) continue;
                        v3 = yDataArray.getDoubleValue(index, i);
                        if (v3 == null) {
                            continue;
                        }
                        value = v3;
                        rangeMin = Math.min(rangeMin, value);
                        rangeMax = Math.max(rangeMax, value);
                    }
                }
            } else lbl-1000:
            // 2 sources

            {
                rangeMin = Math.min(rangeMin, ((Number)it.getRange().getStart()).doubleValue());
                rangeMax = Math.max(rangeMax, ((Number)it.getRange().getEndInclusive()).doubleValue());
            }
            color = ChartsConfig.Companion.getInstance().getSettings().getPaletteColor(chartIndex + result.size());
            var13_16 = result;
            var15_19 /* !! */  = new Pair[]{TuplesKt.to((Object)res.getXColumn().getName(), res.getXColumn().toList()), TuplesKt.to((Object)it.getName(), it.toList())};
            var14_17 = MapsKt.mapOf((Pair[])var15_19 /* !! */ );
            var15_19 /* !! */  = SeriesSettings.Companion.getSampling(res);
            var16_21 = new layerTooltips(new String[0]).line(res.getXColumn().getName() + "|@{" + res.getXColumn().getName() + "}").line(it.getName() + "|@{" + it.getName() + "}");
            var13_16.add(new geomPoint(var14_17, null, null, false, null, (SamplingOptions)var15_19 /* !! */ , var16_21, null, null, null, null, null, null, null, color, null, null, null, null, null, null, null, null, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLetsPlotLayer$lambda$3$lambda$2(com.intellij.charts.core.utils.GroupingResult com.intellij.charts.dataframe.columns.Column org.jetbrains.letsPlot.intern.layer.geom.PointMapping ), (Lorg/jetbrains/letsPlot/intern/layer/geom/PointMapping;)Lkotlin/Unit;)((GroupingResult)res, (Column)it), 8372118, null));
        }
        return CollectionsKt.plus((Collection)result, (Object)LabsKt.ylab(SeriesSettings.Companion.getPresentableAxisText$default(SeriesSettings.Companion, this.values, null, 2, null)));
    }

    public int hashCode() {
        int result2 = this.getType().hashCode();
        result2 = 31 * result2 + ((Object)this.keys).hashCode();
        result2 = 31 * result2 + ((Object)this.groups).hashCode();
        result2 = 31 * result2 + ((Object)this.values).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.showLegend);
        return result2;
    }

    private static final Unit getLetsPlotLayer$lambda$3$lambda$2(GroupingResult $res, Column $it, PointMapping $this$geomPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$geomPoint, (String)"$this$geomPoint");
        $this$geomPoint.setX($res.getXColumn().getName());
        $this$geomPoint.setY($it.getName());
        return Unit.INSTANCE;
    }
}

